/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.tiandy;

import com.zkteco.zkbiosecurity.cuserver.contants.TianDyConstants;
import com.zkteco.zkbiosecurity.cuserver.contants.TianDyMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.AlarmDealRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.AlarmSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.PageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmSearch.AlarmSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.websocket.SubscriptionRequest;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmLevelEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.AlarmService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.impl.tiandy.EventTianDyGetThread;
import com.zkteco.zkbiosecurity.cuserver.utils.DateUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlarmTIANDYServiceImpl
implements AlarmService<IServerType.Tiandy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmTIANDYServiceImpl.class);
    @Autowired
    private SubscriptionHelp subscriptionHelp;

    public boolean subscribe(ParamBean<SubscriptionRequest> obj) {
        if (this.subscriptionHelp.get(((SubscriptionRequest)obj.getRequestBody()).getDomainCode()) == null) {
            this.subscriptionHelp.add(((SubscriptionRequest)obj.getRequestBody()).getDomainCode(), obj.getVcmInfo(), null);
            EventTianDyGetThread eventTianDyGetThread = new EventTianDyGetThread(((SubscriptionRequest)obj.getRequestBody()).getDomainCode(), obj.getVcmInfo().getVcmIp());
            eventTianDyGetThread.start();
            SubscriptionHelp.updateTianDyThread((String)((SubscriptionRequest)obj.getRequestBody()).getDomainCode(), (EventTianDyGetThread)eventTianDyGetThread);
        } else {
            this.subscriptionHelp.add(((SubscriptionRequest)obj.getRequestBody()).getDomainCode(), obj.getVcmInfo(), null);
        }
        return true;
    }

    public boolean delSubscribe(ParamBean<SubscriptionRequest> obj) {
        this.subscriptionHelp.remove(((SubscriptionRequest)obj.getRequestBody()).getDomainCode());
        SubscriptionHelp.removeTianDyThread((String)((SubscriptionRequest)obj.getRequestBody()).getDomainCode());
        return true;
    }

    public boolean confirm(ParamBean<AlarmDealRequest> obj) {
        return false;
    }

    public boolean cancel(ParamBean<AlarmDealRequest> obj) {
        return false;
    }

    public PageRespond<AlarmSearchRespond> search(ParamBean<AlarmSearchRequest> obj) {
        try {
            String xmlStr = this.buildLogSearchReq((AlarmSearchRequest)obj.getRequestBody(), false);
            String rsp = (String)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new TianDyMsgType(HttpMethodEnum.HTTP_METHOD_POST, TianDyMsgType.LOG_SEARCH.getUri()), null, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)xmlStr, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            Document document = DocumentHelper.parseText((String)rsp);
            Element message = document.getRootElement();
            String numOfMatches = message.elementText("numOfMatches");
            xmlStr = this.buildLogSearchReq((AlarmSearchRequest)obj.getRequestBody(), true);
            rsp = (String)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new TianDyMsgType(HttpMethodEnum.HTTP_METHOD_POST, TianDyMsgType.LOG_SEARCH.getUri()), null, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)xmlStr, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            return this.buildLogSearchResult((AlarmSearchRequest)obj.getRequestBody(), rsp, numOfMatches);
        }
        catch (Exception e) {
            LOGGER.error("TianDY Nvr Log Search Fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    private PageRespond<AlarmSearchRespond> buildLogSearchResult(AlarmSearchRequest requestBody, String rsp, String numOfMatches) throws DocumentException {
        PageRespond result = new PageRespond();
        Document document = DocumentHelper.parseText((String)rsp);
        Element message = document.getRootElement();
        if (Objects.nonNull(message)) {
            result.setTotal(Integer.valueOf(numOfMatches).intValue());
            result.setPage(requestBody.getPage());
            result.setPageSize(requestBody.getPageSize());
            ArrayList<AlarmSearchRespond> alarmSearchResponds = new ArrayList<AlarmSearchRespond>();
            List matchList = message.element("matchList").elements();
            for (Element element : matchList) {
                AlarmSearchRespond alarmSearchRespond = new AlarmSearchRespond();
                alarmSearchRespond.setName(element.elementText("content"));
                alarmSearchRespond.setTime(element.elementText("Time").substring(0, 19).replace("T", " "));
                alarmSearchRespond.setChannelCode(element.elementText("chanNo"));
                alarmSearchRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
                alarmSearchResponds.add(alarmSearchRespond);
            }
            result.setData(alarmSearchResponds);
        }
        return result;
    }

    private String buildLogSearchReq(AlarmSearchRequest requestBody, boolean addPage) {
        Document document = DocumentHelper.createDocument();
        Element cmSearchDescription = document.addElement("CMSearchDescription");
        cmSearchDescription.addElement("searchID").setText("1");
        cmSearchDescription.addElement("languageID").setText((String)TianDyConstants.TIANDY_LANGUAGE_MAP.get(StringUtils.isBlank((CharSequence)requestBody.getLanguage()) ? "" : requestBody.getLanguage()));
        cmSearchDescription.addElement("channelID").setText("0");
        if (addPage) {
            cmSearchDescription.addElement("searchResultPostion").setText(String.valueOf(requestBody.getPage() * requestBody.getPageSize()));
            cmSearchDescription.addElement("maxResults").setText(String.valueOf(requestBody.getPageSize()));
        } else {
            cmSearchDescription.addElement("searchResultPostion").setText("0");
            cmSearchDescription.addElement("maxResults").setText("0");
        }
        Element logTypeList = cmSearchDescription.addElement("LogTypeList");
        logTypeList.addElement("logType").setText("Alarm");
        Element timeSpan = cmSearchDescription.addElement("timeSpan");
        timeSpan.addElement("startTime").setText(DateUtil.dateToString((Date)DateUtil.stringToDate((String)requestBody.getStartTime(), (String)"yyyyMMddHHmmss"), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS Z"));
        timeSpan.addElement("endTime").setText(DateUtil.dateToString((Date)DateUtil.stringToDate((String)requestBody.getEndTime(), (String)"yyyyMMddHHmmss"), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS Z"));
        return document.asXML();
    }

    public boolean register(VcmReqBaseInfo vcmReqBaseInfo, String url) {
        return false;
    }

    public String getRegisterUrlList(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

