/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.sdk;

import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChangePasswordRequest;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.LoginRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.PasswordChangeRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.LoginRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.HWPuSDK;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.SdkInstance;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.SessionService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.UserManageService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SessionCheck;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.help.SdcMetaCallback;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.help.SubscribeStore;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.session.SdcSessionStoreService;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userManageServiceSdcSdkStrategy")
@SdcServiceType
public class UserManageServiceSdcSdkStrategy
implements UserManageService<IServerType.SDC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserManageServiceSdcSdkStrategy.class);
    @Autowired
    private SessionService sessionService;
    @Autowired
    private SdcSessionStoreService sdcSessionStoreService;
    @Autowired
    private SubscribeStore subscribeStore;

    public boolean firstLogin(ParamBean<EmptyRequest> obj) {
        return false;
    }

    public String getModel(VcmReqBaseInfo vcmReqBaseInfo) {
        return null;
    }

    public com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.user.LoginRespond login(ParamBean<com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.LoginRequest> obj) {
        String session = this.sdcSessionStoreService.getByVcmInfo(obj.getVcmInfo());
        if (StringUtils.isNotEmpty((CharSequence)session)) {
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setSession(session);
            try {
                this.sessionService.logout(deviceRequest);
            }
            catch (IpcException e) {
                LOGGER.debug("Logout first before login");
            }
            this.subscribeStore.remove(session);
            LOGGER.info("Remove subscribe info, session id is {}, ip is {}", (Object)session, (Object)obj.getVcmInfo().getVcmIp());
            this.subscribeStore.removeAlarmInfo(session);
            LOGGER.info("Remove alarm subscribe info, session id is {}, ip is {}", (Object)session, (Object)obj.getVcmInfo().getVcmIp());
            SdcMetaCallback.removeDensityMapBySession((String)session);
        }
        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setIp(obj.getVcmInfo().getVcmIp());
        loginRequest.setPort(obj.getVcmInfo().getVcmPort());
        loginRequest.setUserName(((com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.LoginRequest)obj.getRequestBody()).getUserName());
        loginRequest.setPassWord(((com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.LoginRequest)obj.getRequestBody()).getPassword());
        DeviceRequest deviceRequest = new DeviceRequest();
        deviceRequest.setRequest((Object)loginRequest);
        try {
            LoginRespond respond = this.sessionService.login(deviceRequest);
            LOGGER.info("Login success, ip is {}, port is {}", (Object)((LoginRequest)deviceRequest.getRequest()).getIp(), (Object)((LoginRequest)deviceRequest.getRequest()).getPort());
            com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.user.LoginRespond loginRespond = new com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.user.LoginRespond();
            loginRespond.setVmSession(respond.getSession());
            this.sdcSessionStoreService.put(respond.getSession(), obj.getVcmInfo());
            return loginRespond;
        }
        catch (IpcException e) {
            LOGGER.error("Login fail, ip is {}, port is {}", (Object)((LoginRequest)deviceRequest.getRequest()).getIp(), (Object)((LoginRequest)deviceRequest.getRequest()).getPort());
            throw new InvokeException("500", e.getMessage());
        }
        catch (NullPointerException e) {
            HWPuSDK hwPuSDK = SdkInstance.getInstance();
            if (Objects.isNull(hwPuSDK)) {
                LOGGER.error("SdkInstance init failed");
                throw new InvokeException("4", "{'error code' : 4, 'error message' : 'The SDK is not initialized.'}");
            }
            LOGGER.error("Login fail, ip is {}, port is {}", (Object)((LoginRequest)deviceRequest.getRequest()).getIp(), (Object)((LoginRequest)deviceRequest.getRequest()).getPort());
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public boolean logout(VcmReqBaseInfo vcmReqBaseInfo) {
        DeviceRequest deviceRequest = new DeviceRequest();
        deviceRequest.setSession(vcmReqBaseInfo.getVcmSession());
        try {
            this.sessionService.logout(deviceRequest);
            boolean bl = true;
            return bl;
        }
        catch (IpcException e) {
            LOGGER.error("Logout fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        finally {
            this.sdcSessionStoreService.remove(vcmReqBaseInfo.getVcmSession());
            LOGGER.info("Remove session, session id is {}, ip is {}", (Object)vcmReqBaseInfo.getVcmSession(), (Object)vcmReqBaseInfo.getVcmIp());
            this.subscribeStore.remove(vcmReqBaseInfo.getVcmSession());
            LOGGER.info("Remove subscribe info, session id is {}, ip is {}", (Object)vcmReqBaseInfo.getVcmSession(), (Object)vcmReqBaseInfo.getVcmIp());
            this.subscribeStore.removeAlarmInfo(vcmReqBaseInfo.getVcmSession());
            LOGGER.info("Remove alarm subscribe info, session id is {}, ip is {}", (Object)vcmReqBaseInfo.getVcmSession(), (Object)vcmReqBaseInfo.getVcmIp());
        }
    }

    public boolean keepAlive(ParamBean<EmptyRequest> obj) {
        return false;
    }

    @SessionCheck
    public boolean firstChange(ParamBean<ChangePasswordRequest> obj) {
        try {
            DeviceRequest passwordRequest = new DeviceRequest();
            PasswordChangeRequest request = new PasswordChangeRequest();
            passwordRequest.setSession(obj.getVcmInfo().getVcmSession());
            request.setUserName(((ChangePasswordRequest)obj.getRequestBody()).getUserName());
            request.setOldPassword(((ChangePasswordRequest)obj.getRequestBody()).getOldPassword());
            request.setNewPassword(((ChangePasswordRequest)obj.getRequestBody()).getNewPassword());
            passwordRequest.setRequest((Object)request);
            this.sessionService.changeSDKPassword(passwordRequest);
            LOGGER.debug("modify device sdk success");
            return true;
        }
        catch (IpcException e) {
            LOGGER.error("modify device sdk fail, {}", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return null;
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return null;
    }
}

