/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.sdk;

import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.SystemConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.TimeConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.TimeConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.SystemConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.TimeZoneRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.TimeZoneRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SystemConfigService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SessionCheck;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="systemConfigServiceSdcSdkStrategy")
@SdcServiceType
public class SystemConfigServiceSdcSdkStrategy
implements SystemConfigService<IServerType.SDC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemConfigServiceSdcSdkStrategy.class);
    @Autowired
    private com.zkteco.zkbiosecurity.cuserver.ipc.service.SystemConfigService systemConfigService;

    @SessionCheck
    public boolean setTimeConfig(ParamBean<TimeConfigRequest> obj) {
        try {
            TimeConfigRequest timeConfigRequest = (TimeConfigRequest)obj.getRequestBody();
            DeviceRequest deviceRequest = new DeviceRequest();
            TimeZoneRequest timeZoneRequest = new TimeZoneRequest();
            timeZoneRequest.setTime(timeConfigRequest.getTime());
            String timezone = timeConfigRequest.getTimezone();
            String[] ts = timezone.split("T");
            String[] split = ts[1].split(":");
            String timeZone = split[0];
            timeZoneRequest.setTimeZone(Integer.parseInt(timeZone));
            timeZoneRequest.setDotTimeZone(Integer.parseInt(split[1]));
            deviceRequest.setRequest((Object)timeZoneRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            this.systemConfigService.setDeviceTime(deviceRequest);
            return true;
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public TimeConfigRespond getDateConfig(ParamBean<EmptyRequest> obj) {
        try {
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            TimeZoneRespond timeZoneRespond = this.systemConfigService.getDeviceTime(deviceRequest);
            LOGGER.debug("Time config from sdk is end.");
            TimeConfigRespond timeConfigRespond = new TimeConfigRespond();
            timeConfigRespond.setTime(timeZoneRespond.getTime());
            timeConfigRespond.setTimezone(String.valueOf(timeZoneRespond.getTimeZone()));
            return timeConfigRespond;
        }
        catch (IpcException e) {
            LOGGER.error("Get time zone exception ", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public boolean setSystemConfig(ParamBean<SystemConfigRequest> obj) {
        return false;
    }

    public SystemConfigRespond getSystemConfig(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return null;
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return null;
    }
}

