/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.sdk;

import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.SnapshotRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.SnapshotRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.CaptureImageRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.FaceLibraryService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SnapshotService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SessionCheck;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="snapshotServiceSdcSdkStrategy")
@SdcServiceType
public class SnapshotServiceSdcSdkStrategy
implements SnapshotService<IServerType.SDC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotServiceSdcSdkStrategy.class);
    @Autowired
    private FaceLibraryService faceLibraryService;

    @SessionCheck
    public SnapshotRespond createSnapshot(VcmReqBaseInfo vcmInfo, SnapshotRequest req) {
        try {
            CaptureImageRequest captureImageRequest = new CaptureImageRequest();
            String tmpFilePath = System.getProperty("jna.library.path") + File.separator;
            captureImageRequest.setImagePath(tmpFilePath);
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)captureImageRequest);
            deviceRequest.setSession(vcmInfo.getVcmSession());
            String base64 = this.faceLibraryService.saveBase64ManualSnapshot(deviceRequest);
            LOGGER.debug("Save snapshot picture success");
            SnapshotRespond snapshotRespond = new SnapshotRespond();
            snapshotRespond.setImgBase64Str(base64);
            return snapshotRespond;
        }
        catch (IpcException e) {
            LOGGER.error("Save snapshot occurs error ", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return null;
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return null;
    }
}

