/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.sdk;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.SdcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorAreaItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.HeatMapConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.MotionConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.NormalIntelligentRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.OcclusionConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.QueueDetectionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.RepeatVisitorRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.SoundDetectionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.VideoCoverRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.PointItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraModeRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.BehaviorAlarmPlanItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.FaceCaptureRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.MaskAlarmItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.MotionChannelConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.MotionConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.OcclusionChannelConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.OcclusionConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.Point;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.Rect;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.RepeatVisitorGetRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.SituationalConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.SoundDetectionConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.VideoCoverRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.ZoneInfo;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.AlarmTime;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.BaseAreaParam;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.IgaArea;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.IgtPoint;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.MaskParam;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.Time;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.HideAlarmParamRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.ITGEModeRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.IpcEmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.MotionDetectionParamRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.PrivacyMaskArrayRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.CrowdDensityDetectParamRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.HideAlarmParamRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.ITGEModeRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.MotionDetectionParamRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.PrivacyMaskArrayRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.util.DateUtil;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.CrowdDensityService;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.OrdinaryIntelligenceService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.NormalIntelligentService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.AbstractSdcService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SessionCheck;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.sdk.BehaviorAnalysisServiceSdcSdkStrategy;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.SdcReasonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="normalIntelligentServiceSdcSdkStrategy")
@SdcServiceType
public class NormalIntelligentServiceSdcSdkStrategy
extends AbstractSdcService
implements NormalIntelligentService<IServerType.SDC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BehaviorAnalysisServiceSdcSdkStrategy.class);
    @Autowired
    private OrdinaryIntelligenceService ordinaryIntelligenceService;
    @Autowired
    private CrowdDensityService crowdDensityService;

    @SessionCheck
    public MotionConfigRespond getMotionConfig(ParamBean<MotionConfigRequest> obj) {
        try {
            IpcEmptyRequest ipcEmptyRequest = new IpcEmptyRequest();
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)ipcEmptyRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            MotionDetectionParamRespond motionDetectionAlarmParam = this.ordinaryIntelligenceService.getMotionDetectionAlarmParam(deviceRequest);
            LOGGER.info("get Motion Config from sdk is end.");
            LOGGER.info("get Motion Config end..");
            return this.getMotionConfigRespond(motionDetectionAlarmParam);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    private MotionConfigRespond getMotionConfigRespond(MotionDetectionParamRespond respond) {
        MotionConfigRespond configRespond = new MotionConfigRespond();
        configRespond.setChannelCode(respond.getChannelId());
        MotionChannelConfig channelConfig = new MotionChannelConfig();
        channelConfig.setEnable(Boolean.valueOf(respond.getEnable() == 1L));
        channelConfig.setIntervals(Integer.parseInt(String.valueOf(respond.getDeteInterval())));
        channelConfig.setMaxRect(respond.getDetectionArea().area.length);
        channelConfig.setSensitivity(Integer.parseInt(String.valueOf(respond.getSensitivity())));
        ArrayList<Rect> rects = new ArrayList<Rect>();
        int i = 0;
        while ((long)i < respond.getDetectionArea().areaNum) {
            Rect rect = new Rect();
            rect.setHeight(Integer.parseInt(String.valueOf(respond.getDetectionArea().area[i].getHeight())));
            rect.setWidth(Integer.parseInt(String.valueOf(respond.getDetectionArea().area[i].getWidth())));
            rect.setLeft(Integer.parseInt(String.valueOf(respond.getDetectionArea().area[i].getStartX())));
            rect.setTop(Integer.parseInt(String.valueOf(respond.getDetectionArea().area[i].getStartY())));
            rects.add(rect);
            ++i;
        }
        channelConfig.setRects(rects);
        configRespond.setChannelConfig(channelConfig);
        ArrayList<BehaviorAlarmPlanItemRespond> alarmPlans = new ArrayList<BehaviorAlarmPlanItemRespond>();
        int j = 0;
        while ((long)j < respond.getAlarmTimeList().num) {
            BehaviorAlarmPlanItemRespond alarmPlan = new BehaviorAlarmPlanItemRespond();
            alarmPlan.setCycleType(Integer.parseInt(String.valueOf(respond.getAlarmTimeList().alarmTimes[j].getCycleType())));
            alarmPlan.setPeriod(Integer.parseInt(String.valueOf(respond.getAlarmTimeList().alarmTimes[j].getPeriod())));
            String startDate = respond.getAlarmTimeList().alarmTimes[j].getStart().szYear + "-" + respond.getAlarmTimeList().alarmTimes[j].getStart().szMonth + "-" + respond.getAlarmTimeList().alarmTimes[j].getStart().szDay;
            String startTime = respond.getAlarmTimeList().alarmTimes[j].getStart().szHour + ":" + respond.getAlarmTimeList().alarmTimes[j].getStart().szMinute + ":" + respond.getAlarmTimeList().alarmTimes[j].getStart().szSecond;
            String endTime = respond.getAlarmTimeList().alarmTimes[j].getEnd().szHour + ":" + respond.getAlarmTimeList().alarmTimes[j].getEnd().szMinute + ":" + respond.getAlarmTimeList().alarmTimes[j].getEnd().szSecond;
            alarmPlan.setStartDate(startDate);
            alarmPlan.setStartTime(startTime);
            alarmPlan.setEndTime(endTime);
            alarmPlans.add(alarmPlan);
            ++j;
        }
        configRespond.setAlarmPlanList(alarmPlans);
        return configRespond;
    }

    @SessionCheck
    public boolean setMotionConfig(ParamBean<MotionConfigRequest> obj) {
        try {
            MotionDetectionParamRequest paramRequest = this.converMotionParamRequest(obj);
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)paramRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            return this.ordinaryIntelligenceService.setMotionDetectionAlarmParam(deviceRequest);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    private MotionDetectionParamRequest converMotionParamRequest(ParamBean<MotionConfigRequest> obj) {
        return null;
    }

    private Time coverTime(String date) {
        Time timeReturn = new Time();
        timeReturn.setSzYear(String.valueOf(DateUtil.getYear((String)date)));
        timeReturn.setSzMonth(String.valueOf(DateUtil.getMonth((String)date)).length() > 1 ? String.valueOf(DateUtil.getMonth((String)date) + 1) : "0" + (DateUtil.getMonth((String)date) + 1));
        timeReturn.setSzDay(String.valueOf(DateUtil.getDay((String)date)).length() > 1 ? String.valueOf(DateUtil.getDay((String)date)) : "0" + DateUtil.getDay((String)date));
        timeReturn.setSzHour(String.valueOf(DateUtil.getHour((String)date)).length() > 1 ? String.valueOf(DateUtil.getHour((String)date)) : "0" + DateUtil.getHour((String)date));
        timeReturn.setSzMinute(String.valueOf(DateUtil.getMinute((String)date)).length() > 1 ? String.valueOf(DateUtil.getMinute((String)date)) : "0" + DateUtil.getMinute((String)date));
        timeReturn.setSzSecond(String.valueOf(DateUtil.getSecond((String)date)).length() > 1 ? String.valueOf(DateUtil.getSecond((String)date)) : "0" + DateUtil.getSecond((String)date));
        return timeReturn;
    }

    @SessionCheck
    public VideoCoverRespond getVideoCoverConfig(ParamBean<VideoCoverRequest> obj) {
        try {
            IpcEmptyRequest ipcEmptyRequest = new IpcEmptyRequest();
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)ipcEmptyRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            PrivacyMaskArrayRespond privacyMaskArrayRepond = this.ordinaryIntelligenceService.getPrivacyMaskParam(deviceRequest);
            LOGGER.info("get Privacy Mask from sdk is end.");
            LOGGER.info("get Privacy Mask end..");
            return this.getPrivacyMaskRespond(privacyMaskArrayRepond);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    private VideoCoverRespond getPrivacyMaskRespond(PrivacyMaskArrayRespond respond) {
        VideoCoverRespond coverRespond = new VideoCoverRespond();
        coverRespond.setEnable(respond.getEnable());
        coverRespond.setCurNum(Integer.parseInt(String.valueOf(respond.getNum())));
        coverRespond.setMaxNum(respond.getMaskPara().length);
        ArrayList<ZoneInfo> zones = new ArrayList<ZoneInfo>();
        for (int i = 0; i < respond.getMaskPara().length; ++i) {
            ZoneInfo zoneInfo = new ZoneInfo();
            zoneInfo.setNo(i);
            ArrayList<Point> points = new ArrayList<Point>();
            Point leftPoint = new Point();
            leftPoint.setLeft(Integer.parseInt(String.valueOf(respond.getMaskPara()[i].getStartX())));
            leftPoint.setTop(Integer.parseInt(String.valueOf(respond.getMaskPara()[i].getStartY())));
            Point rightPoint = new Point();
            rightPoint.setLeft(Integer.parseInt(String.valueOf(respond.getMaskPara()[i].getStartX() + respond.getMaskPara()[i].getWidth())));
            rightPoint.setTop(Integer.parseInt(String.valueOf(respond.getMaskPara()[i].getStartY())));
            Point leftDownPoint = new Point();
            leftDownPoint.setLeft(Integer.parseInt(String.valueOf(respond.getMaskPara()[i].getStartX())));
            leftDownPoint.setTop(Integer.parseInt(String.valueOf(respond.getMaskPara()[i].getStartY() + respond.getMaskPara()[i].getHeight())));
            Point rightDownPoint = new Point();
            rightDownPoint.setLeft(Integer.parseInt(String.valueOf(respond.getMaskPara()[i].getStartX() + respond.getMaskPara()[i].getWidth())));
            rightDownPoint.setTop(Integer.parseInt(String.valueOf(respond.getMaskPara()[i].getStartY() + respond.getMaskPara()[i].getHeight())));
            points.add(leftPoint);
            points.add(rightPoint);
            points.add(leftDownPoint);
            points.add(rightDownPoint);
            zoneInfo.setPoints(points);
            zones.add(zoneInfo);
        }
        coverRespond.setZones(zones);
        return coverRespond;
    }

    @SessionCheck
    public boolean setVideoCoverConfig(ParamBean<VideoCoverRequest> obj) {
        try {
            VideoCoverRequest coverRequest = (VideoCoverRequest)obj.getRequestBody();
            PrivacyMaskArrayRequest paramRequest = this.converPrivacyMaskRequest(coverRequest);
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)paramRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            return this.ordinaryIntelligenceService.setPrivacyMaskParam(deviceRequest);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    private PrivacyMaskArrayRequest converPrivacyMaskRequest(VideoCoverRequest request) {
        PrivacyMaskArrayRequest arrayRequest = new PrivacyMaskArrayRequest();
        arrayRequest.setChannelID("101");
        arrayRequest.setEnable(request.getConfig().getEnable());
        arrayRequest.setNum((long)request.getConfig().getCurNum());
        MaskParam[] maskParams = new MaskParam[request.getConfig().getZones().size()];
        List zones = request.getConfig().getZones();
        for (int i = 0; i < zones.size(); ++i) {
            MaskParam maskParam = new MaskParam();
            maskParam.setStartX((long)((Point)((ZoneInfo)zones.get(i)).getPoints().get(0)).getLeft());
            maskParam.setStartY((long)((Point)((ZoneInfo)zones.get(i)).getPoints().get(0)).getTop());
            maskParam.setHeight((long)(((Point)((ZoneInfo)zones.get(i)).getPoints().get(3)).getTop() - ((Point)((ZoneInfo)zones.get(i)).getPoints().get(0)).getTop()));
            maskParam.setWidth((long)(((Point)((ZoneInfo)zones.get(i)).getPoints().get(2)).getLeft() - ((Point)((ZoneInfo)zones.get(i)).getPoints().get(0)).getLeft()));
            maskParams[i] = maskParam;
        }
        arrayRequest.setMaskPara(maskParams);
        return arrayRequest;
    }

    @SessionCheck
    public OcclusionConfigRespond getOcclusionConfig(ParamBean<OcclusionConfigRequest> obj) {
        try {
            IpcEmptyRequest ipcEmptyRequest = new IpcEmptyRequest();
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)ipcEmptyRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            HideAlarmParamRespond hideAlarmParam = this.ordinaryIntelligenceService.getHideAlarmParam(deviceRequest);
            LOGGER.info("get Occlusion Config from sdk is end.");
            LOGGER.info("get Occlusion Config end..");
            return this.getOcclusionConfigRespond(hideAlarmParam);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    private OcclusionConfigRespond getOcclusionConfigRespond(HideAlarmParamRespond respond) {
        OcclusionConfigRespond configRespond = new OcclusionConfigRespond();
        configRespond.setChannelCode(respond.getChannelId());
        OcclusionChannelConfig config = new OcclusionChannelConfig();
        config.setEnable(Boolean.valueOf(respond.getEnable() == 1L));
        config.setIntervals(Integer.parseInt(String.valueOf(respond.getDeteInterval())));
        config.setSensitivity(Integer.parseInt(String.valueOf(respond.getSensitivity())));
        ArrayList<BehaviorAlarmPlanItemRespond> alarmPlans = new ArrayList<BehaviorAlarmPlanItemRespond>();
        int j = 0;
        while ((long)j < respond.getAlarmTimeList().num) {
            BehaviorAlarmPlanItemRespond alarmPlan = new BehaviorAlarmPlanItemRespond();
            alarmPlan.setCycleType(Integer.parseInt(String.valueOf(respond.getAlarmTimeList().alarmTimes[j].getCycleType())));
            alarmPlan.setPeriod(Integer.parseInt(String.valueOf(respond.getAlarmTimeList().alarmTimes[j].getPeriod())));
            String startDate = respond.getAlarmTimeList().alarmTimes[j].getStart().szYear + "-" + respond.getAlarmTimeList().alarmTimes[j].getStart().szMonth + "-" + respond.getAlarmTimeList().alarmTimes[j].getStart().szDay;
            String startTime = respond.getAlarmTimeList().alarmTimes[j].getStart().szHour + ":" + respond.getAlarmTimeList().alarmTimes[j].getStart().szMinute + ":" + respond.getAlarmTimeList().alarmTimes[j].getStart().szSecond;
            String endTime = respond.getAlarmTimeList().alarmTimes[j].getEnd().szHour + ":" + respond.getAlarmTimeList().alarmTimes[j].getEnd().szMinute + ":" + respond.getAlarmTimeList().alarmTimes[j].getEnd().szSecond;
            alarmPlan.setStartDate(startDate);
            alarmPlan.setStartTime(startTime);
            alarmPlan.setEndTime(endTime);
            alarmPlans.add(alarmPlan);
            ++j;
        }
        config.setAlarmPlanList(alarmPlans);
        configRespond.setChannelConfig(config);
        configRespond.setRange(JSONObject.parseObject((String)JSONObject.toJSON((Object)respond.getDetectionArea()).toString()));
        return configRespond;
    }

    @SessionCheck
    public boolean setOcclusionConfig(ParamBean<OcclusionConfigRequest> obj) {
        try {
            HideAlarmParamRequest paramRequest = this.converOcclusionRequest(obj);
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)paramRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            return this.ordinaryIntelligenceService.setHideAlarmParam(deviceRequest);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    private HideAlarmParamRequest converOcclusionRequest(ParamBean<OcclusionConfigRequest> requestParamBean) {
        OcclusionConfigRequest request = (OcclusionConfigRequest)requestParamBean.getRequestBody();
        IpcEmptyRequest ipcEmptyRequest = new IpcEmptyRequest();
        DeviceRequest deviceRequest = new DeviceRequest();
        deviceRequest.setRequest((Object)ipcEmptyRequest);
        deviceRequest.setSession(requestParamBean.getVcmInfo().getVcmSession());
        HideAlarmParamRespond respond = this.ordinaryIntelligenceService.getHideAlarmParam(deviceRequest);
        HideAlarmParamRequest hideRequest = new HideAlarmParamRequest();
        hideRequest.setChannelId("101");
        hideRequest.setEnable(request.getChannelConfig().getEnable() != false ? 1L : 0L);
        hideRequest.setDeteInterval((long)request.getChannelConfig().getIntervals());
        hideRequest.setSensitivity((long)request.getChannelConfig().getSensitivity());
        hideRequest.setDetectionArea(respond.getDetectionArea());
        BaseAreaParam.AlarmTimeList alarmTimeList = new BaseAreaParam.AlarmTimeList();
        if (CollectionUtils.isEmpty((Collection)request.getChannelConfig().getAlarmPlanList())) {
            hideRequest.setAlarmTimeList(respond.getAlarmTimeList());
        } else {
            List alarmTimes = request.getChannelConfig().getAlarmPlanList();
            alarmTimeList.num = alarmTimes.size();
            AlarmTime[] alarmTimesArray = new AlarmTime[alarmTimes.size()];
            for (int j = 0; j < alarmTimes.size(); ++j) {
                AlarmTime alarmTime = new AlarmTime();
                alarmTime.setPeriod((long)((BehaviorAlarmPlanItemRespond)alarmTimes.get(j)).getPeriod());
                alarmTime.setCycleType((long)((BehaviorAlarmPlanItemRespond)alarmTimes.get(j)).getCycleType());
                Time startTime = this.coverTime(((BehaviorAlarmPlanItemRespond)alarmTimes.get(j)).getStartDate() + " " + ((BehaviorAlarmPlanItemRespond)alarmTimes.get(j)).getStartTime());
                Time endTime = this.coverTime(((BehaviorAlarmPlanItemRespond)alarmTimes.get(j)).getStartDate() + " " + ((BehaviorAlarmPlanItemRespond)alarmTimes.get(j)).getEndTime());
                alarmTime.setStart(startTime);
                alarmTime.setEnd(endTime);
                alarmTimesArray[j] = alarmTime;
            }
            alarmTimeList.alarmTimes = alarmTimesArray;
            hideRequest.setAlarmTimeList(alarmTimeList);
        }
        return hideRequest;
    }

    public FaceCaptureRespond getPerimeterFaceConfig(ParamBean<NormalIntelligentRequest> obj) {
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)SdcMsgType.FACE_PERIMETER_CONFIG_GET, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(result);
            return null;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public JSONObject setPerimeterFaceConfig(ParamBean<NormalIntelligentRequest> obj) {
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)SdcMsgType.FACE_PERIMETER_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)((NormalIntelligentRequest)obj.getRequestBody()).getConfig(), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(result);
            return result;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    @SessionCheck
    public CameraModeRespond getCameraModeConfig(ParamBean<NormalIntelligentRequest> obj) {
        try {
            IpcEmptyRequest ipcEmptyRequest = new IpcEmptyRequest();
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)ipcEmptyRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            ITGEModeRespond itgeMode = this.ordinaryIntelligenceService.getITGEMode(deviceRequest);
            LOGGER.info("get Camera Mode Config from sdk is end.");
            LOGGER.info("get Camera Mode Config end..");
            return null;
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public boolean setCameraModeConfig(ParamBean<NormalIntelligentRequest> obj) {
        try {
            NormalIntelligentRequest coverRequest = (NormalIntelligentRequest)obj.getRequestBody();
            ITGEModeRequest paramRequest = new ITGEModeRequest();
            paramRequest.setChannelId("101");
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)paramRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            return this.ordinaryIntelligenceService.setITGEMode(deviceRequest);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    public MaskAlarmItemRespond getMaskAlarmConfig(ParamBean<NormalIntelligentRequest> obj) {
        return null;
    }

    public boolean setMaskAlarmConfig(ParamBean<NormalIntelligentRequest> obj) {
        return false;
    }

    public JSONObject getFaceRecognitionConfig(ParamBean<NormalIntelligentRequest> obj) {
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)SdcMsgType.FACE_RECOGNITION_CONFIG_GET, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(result);
            return result;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public boolean setFaceRecognitionConfig(ParamBean<NormalIntelligentRequest> obj) {
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)SdcMsgType.FACE_RECOGNITION_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)((NormalIntelligentRequest)obj.getRequestBody()).getConfig(), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(result);
            return true;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public SoundDetectionConfig get(VcmReqBaseInfo vcmInfo, SoundDetectionRequest soundDetectionRequest) {
        return null;
    }

    public Boolean set(ParamBean<SoundDetectionRequest> obj) {
        return null;
    }

    public SituationalConfigRespond getQueueDetect(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        return null;
    }

    public Boolean setQueueDetect(ParamBean<QueueDetectionRequest> obj) {
        return null;
    }

    @SessionCheck
    public SituationalConfigRespond getCrowdDensity(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        try {
            IpcEmptyRequest ipcEmptyRequest = new IpcEmptyRequest();
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)ipcEmptyRequest);
            deviceRequest.setSession(vcmInfo.getVcmSession());
            CrowdDensityDetectParamRespond crowdDensityDetectParam = this.crowdDensityService.getCrowdDensityDetectParam(deviceRequest);
            SituationalConfigRespond situationalConfigRespond = this.dealCrowdDensityDetectParam(crowdDensityDetectParam);
            return situationalConfigRespond;
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    public Boolean setCrowdDensity(ParamBean<QueueDetectionRequest> obj) {
        return null;
    }

    public JSONObject getThirdPartyAlgorithm(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        return null;
    }

    public Boolean setThirdPartyAlgorithm(ParamBean<QueueDetectionRequest> obj) {
        return null;
    }

    public SituationalConfigRespond getCrossCounting(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)SdcMsgType.CROWD_SITUATION_CROSS_COUNTING_GET, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(result);
            return null;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public Boolean setCrossCounting(ParamBean<QueueDetectionRequest> obj) {
        return true;
    }

    public JSONObject clearCrossCounting(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        return null;
    }

    public HeatMapConfigRespond getHeatMapConfig(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        return null;
    }

    public RepeatVisitorGetRespond getRepeatVisitor(ParamBean<RepeatVisitorRequest> obj) {
        return null;
    }

    public Boolean setRepeatVisitor(ParamBean<RepeatVisitorRequest> obj) {
        return null;
    }

    public SituationalConfigRespond getLeaveDetect(VcmReqBaseInfo vcmInfo, QueueDetectionRequest requestBody) {
        return null;
    }

    public Boolean setLeaveDetect(ParamBean<QueueDetectionRequest> obj) {
        return null;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    private SituationalConfigRespond dealCrowdDensityDetectParam(CrowdDensityDetectParamRespond crowdDensityDetectParam) {
        SituationalConfigRespond situationalConfigRespond = new SituationalConfigRespond();
        BehaviorAreaItemRespond behaviorAreaItemRespond = new BehaviorAreaItemRespond();
        ArrayList<BehaviorAreaItemRespond> behaviorAreaItemResponds = new ArrayList<BehaviorAreaItemRespond>();
        BaseAreaParam.AreaList areaList = crowdDensityDetectParam.getAreaList();
        int i = 0;
        while ((long)i < areaList.getAreaNum()) {
            ArrayList<PointItem> pointItems = new ArrayList<PointItem>();
            IgaArea[] stArea = areaList.getStArea();
            IgaArea igaArea = stArea[i];
            for (int j = 0; j < igaArea.getPointNum(); ++j) {
                PointItem pointItem = new PointItem();
                IgtPoint[] point = igaArea.getPoint();
                pointItem.setPointX((int)point[j].getPointPosX());
                pointItem.setPointY((int)point[j].getPointPosY());
                pointItems.add(pointItem);
            }
            behaviorAreaItemRespond.setEnable(Boolean.valueOf(stArea[i].isEnable()));
            behaviorAreaItemRespond.setPointList(pointItems);
            behaviorAreaItemResponds.add(behaviorAreaItemRespond);
            ++i;
        }
        situationalConfigRespond.setAreaList(behaviorAreaItemResponds);
        return situationalConfigRespond;
    }
}

