/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.sdk;

import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.PeopleRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepository;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.People;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.PeopleSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.FaceLibraryParaRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.FaceRecordParaRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.FaceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.FaceLibraryParaRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.FaceRecordParaRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.FaceLibraryService;
import com.zkteco.zkbiosecurity.cuserver.service.FaceRepositoryManagementService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.AbstractSdcService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SessionCheck;
import com.zkteco.zkbiosecurity.cuserver.utils.FileUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.SdcReasonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="faceRepositoryServiceSdcSdkSdcStrategy")
@SdcServiceType
public class FaceRepositoryServiceSdcSdkSdcStrategy
extends AbstractSdcService
implements FaceRepositoryManagementService<IServerType.SDC> {
    @Autowired
    private FaceLibraryService faceLibraryService;

    @SessionCheck
    public boolean add(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        List faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepository);
        if (!CollectionUtils.isEmpty((Collection)faceRepositoryList)) {
            this.updateFaceRepository(vcmReqBaseInfo, faceRepository, ((FaceRepository)faceRepositoryList.get(0)).getGroupId());
            return true;
        }
        DeviceRequest request = new DeviceRequest();
        request.setSession(vcmReqBaseInfo.getVcmSession());
        FaceLibraryParaRequest faceLibraryParaRequest = new FaceLibraryParaRequest();
        faceLibraryParaRequest.setOnControl(faceRepository.getEnabled());
        faceLibraryParaRequest.setThreshold(faceRepository.getThreshold() == null ? 80 : faceRepository.getThreshold());
        faceLibraryParaRequest.setFaceListName(faceRepository.getName());
        this.setFaceLibraryType(faceRepository, request, faceLibraryParaRequest);
        try {
            return this.faceLibraryService.addFaceLibrary(request);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public boolean update(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        List faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepository);
        if (CollectionUtils.isEmpty((Collection)faceRepositoryList)) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_REPOSITORY_NOT_EXIST);
        }
        if (StringUtils.isNotBlank((CharSequence)faceRepository.getNewName()) && this.isExistFaceRepository(vcmReqBaseInfo, faceRepository) && !faceRepository.getNewName().equals(faceRepository.getName())) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_REPOSITORY_EXIST);
        }
        return this.updateFaceRepository(vcmReqBaseInfo, faceRepository, ((FaceRepository)faceRepositoryList.get(0)).getGroupId());
    }

    private void setFaceLibraryType(FaceRepositoryRequest faceRepository, DeviceRequest<FaceLibraryParaRequest> request, FaceLibraryParaRequest faceLibraryParaRequest) {
        if (Objects.nonNull(faceRepository.getType())) {
            if ("2".equals(faceRepository.getType())) {
                faceLibraryParaRequest.setFaceListType(1);
            } else if ("3".equals(faceRepository.getType())) {
                faceLibraryParaRequest.setFaceListType(2);
            } else {
                faceLibraryParaRequest.setFaceListType(0);
            }
        } else {
            faceLibraryParaRequest.setFaceListType(0);
        }
        request.setRequest((Object)faceLibraryParaRequest);
    }

    @SessionCheck
    public boolean delete(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        FaceLibraryParaRequest faceLibraryParaRequest = new FaceLibraryParaRequest();
        if (StringUtils.isBlank((CharSequence)faceRepository.getRepositoryId())) {
            List faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepository);
            if (CollectionUtils.isEmpty((Collection)faceRepositoryList)) {
                return true;
            }
            faceLibraryParaRequest.setId(((FaceRepository)faceRepositoryList.get(0)).getGroupId());
        } else {
            faceLibraryParaRequest.setId(faceRepository.getRepositoryId());
        }
        DeviceRequest request = new DeviceRequest();
        request.setSession(vcmReqBaseInfo.getVcmSession());
        faceLibraryParaRequest.setFaceListName(faceRepository.getName());
        request.setRequest((Object)faceLibraryParaRequest);
        try {
            return this.faceLibraryService.deleteFaceLibrary(request);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public FaceRepositorySearchRespond search(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        DeviceRequest request = new DeviceRequest();
        request.setSession(vcmReqBaseInfo.getVcmSession());
        try {
            FaceRepositorySearchRespond faceRepositoryRespond = new FaceRepositorySearchRespond();
            List faceLibraryParaResponds = this.faceLibraryService.getFaceLibraryList(request);
            List faceRepositories = this.copyList(faceLibraryParaResponds);
            faceRepositoryRespond.setTotal(String.valueOf(faceLibraryParaResponds.size()));
            faceRepositoryRespond.setRepositories(faceRepositories);
            return faceRepositoryRespond;
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    private List<FaceRepository> copyList(List<FaceLibraryParaRespond> copiedList) {
        ArrayList<FaceRepository> faceRepositories = new ArrayList<FaceRepository>();
        for (int i = 0; i < copiedList.size(); ++i) {
            FaceRepository faceRepository = new FaceRepository();
            String type = "";
            switch (copiedList.get(i).getFaceListType()) {
                case 0: 
                case 1: {
                    type = "2";
                    break;
                }
                case 2: {
                    type = "3";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + copiedList.get(i).getFaceListType());
                }
            }
            faceRepository.setType(type);
            faceRepository.setName(copiedList.get(i).getFaceListName());
            faceRepository.setEnabled(copiedList.get(i).getOnControl());
            faceRepository.setGroupId(copiedList.get(i).getId());
            faceRepository.setThreshold(copiedList.get(i).getThreshold());
            faceRepositories.add(faceRepository);
        }
        return faceRepositories;
    }

    @SessionCheck
    public boolean addPeople(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        List pictures = people.getPictures();
        String fileName = System.currentTimeMillis() + ".jpg";
        String property = System.getProperty("jna.library.path");
        FileUtil.setSystemFilePath((String)(property + File.separator));
        FileUtil.saveFile((String)"", (String)fileName, (String)((String)pictures.get(0)));
        String fullPath = property + File.separator + fileName;
        if (CollectionUtils.isEmpty((Collection)pictures)) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_NOT_PICTURE);
        }
        FaceRepositoryRequest faceRepositoryInfo = people.getFaceRepositoryInfo();
        List faceRepositoryList = new ArrayList();
        if (StringUtils.isBlank((CharSequence)faceRepositoryInfo.getRepositoryId())) {
            faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepositoryInfo);
            if (CollectionUtils.isEmpty(faceRepositoryList)) {
                throw new InvokeException("500", SdcReasonUtil.CU_FACE_REPOSITORY_NOT_EXIST);
            }
            faceRepositoryInfo.setGroupStrId(((FaceRepository)faceRepositoryList.get(0)).getGroupId());
        } else {
            faceRepositoryInfo.setGroupStrId(faceRepositoryInfo.getRepositoryId());
        }
        people.setCredentialNumber(people.getId());
        people.setFaceRepositoryInfo(faceRepositoryInfo);
        DeviceRequest request = new DeviceRequest();
        request.setSession(vcmReqBaseInfo.getVcmSession());
        FaceRequest faceRequest = this.toFaceRequest(people);
        faceRequest.getFaceRecordPara().setPicPath(fullPath);
        request.setRequest((Object)faceRequest);
        try {
            boolean success = this.faceLibraryService.addOneFace(request);
            if (success && faceRepositoryInfo.getEnabled() == 0) {
                faceRepositoryInfo.setEnabled(1);
                this.updateFaceRepositoryBack(vcmReqBaseInfo, faceRepositoryInfo);
            }
            boolean bl = success;
            return bl;
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
        finally {
            FileUtil.deleteFile((String)fullPath);
        }
    }

    private boolean updateFaceRepositoryBack(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        return this.updateFaceRepository(vcmReqBaseInfo, faceRepository, faceRepository.getGroupStrId());
    }

    private boolean updateFaceRepository(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository, String groupStrId) {
        DeviceRequest request = new DeviceRequest();
        request.setSession(vcmReqBaseInfo.getVcmSession());
        FaceLibraryParaRequest faceLibraryParaRequest = new FaceLibraryParaRequest();
        faceLibraryParaRequest.setId(groupStrId);
        faceLibraryParaRequest.setOnControl(faceRepository.getEnabled());
        faceLibraryParaRequest.setThreshold(faceRepository.getThreshold() == null ? 80 : faceRepository.getThreshold());
        if (Objects.nonNull(faceRepository.getNewName())) {
            faceLibraryParaRequest.setFaceListName(faceRepository.getNewName());
        } else {
            faceLibraryParaRequest.setFaceListName(faceRepository.getName());
        }
        this.setFaceLibraryType(faceRepository, request, faceLibraryParaRequest);
        try {
            return this.faceLibraryService.updateFaceLibrary(request);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public boolean deletePeople(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest peopleRequest) {
        FaceRepositoryRequest faceRepositoryInfo = peopleRequest.getFaceRepositoryInfo();
        FaceLibraryParaRequest faceLibraryPara = new FaceLibraryParaRequest();
        if (StringUtils.isBlank((CharSequence)peopleRequest.getFaceRepositoryInfo().getRepositoryId())) {
            List faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepositoryInfo);
            if (CollectionUtils.isEmpty((Collection)faceRepositoryList)) {
                throw new InvokeException("500", SdcReasonUtil.CU_FACE_REPOSITORY_NOT_EXIST);
            }
            faceLibraryPara.setId(((FaceRepository)faceRepositoryList.get(0)).getGroupId());
        } else {
            faceLibraryPara.setId(peopleRequest.getFaceRepositoryInfo().getRepositoryId());
        }
        List peopleCommon = null;
        if (Objects.nonNull(peopleRequest.getFaceRepositoryInfo().getRepositoryId())) {
            peopleCommon = this.searchPeopleById(vcmReqBaseInfo, peopleRequest);
        }
        if (CollectionUtils.isEmpty(peopleCommon)) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_NOT_EXIST);
        }
        DeviceRequest deviceRequest = new DeviceRequest();
        deviceRequest.setSession(vcmReqBaseInfo.getVcmSession());
        FaceRequest faceRequest = new FaceRequest();
        ArrayList<FaceRecordParaRequest> faceParaList = new ArrayList<FaceRecordParaRequest>();
        for (int i = 0; i < peopleCommon.size(); ++i) {
            FaceRecordParaRequest request = new FaceRecordParaRequest();
            request.setId(((People)peopleCommon.get(i)).getId());
            faceParaList.add(request);
        }
        faceRequest.setFaceLibraryPara(faceLibraryPara);
        faceRequest.setFaceRecordList(faceParaList);
        deviceRequest.setRequest((Object)faceRequest);
        try {
            return this.faceLibraryService.deleteFaceInfo(deviceRequest);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public PeopleSearchRespond searchPeople(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest peopleRequest) {
        FaceRepositoryRequest faceRepositoryInfo = peopleRequest.getFaceRepositoryInfo();
        FaceLibraryParaRequest faceLibraryPara = new FaceLibraryParaRequest();
        if (StringUtils.isBlank((CharSequence)faceRepositoryInfo.getRepositoryId())) {
            List faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepositoryInfo);
            if (CollectionUtils.isEmpty((Collection)faceRepositoryList)) {
                throw new InvokeException("500", SdcReasonUtil.CU_FACE_REPOSITORY_NOT_EXIST);
            }
            faceLibraryPara.setId(((FaceRepository)faceRepositoryList.get(0)).getGroupId());
        } else {
            faceLibraryPara.setId(faceRepositoryInfo.getRepositoryId());
        }
        DeviceRequest request = new DeviceRequest();
        request.setSession(vcmReqBaseInfo.getVcmSession());
        FaceRecordParaRequest faceRecordPara = new FaceRecordParaRequest();
        FaceRequest faceRequest = new FaceRequest();
        faceRequest.setFaceLibraryPara(faceLibraryPara);
        faceRequest.setFaceRecordPara(faceRecordPara);
        request.setRequest((Object)faceRequest);
        try {
            List faceRecordParaResponds = this.faceLibraryService.findFaceList(request);
            return this.toPeopleSearchRespond(faceRecordParaResponds);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    private PeopleSearchRespond toPeopleSearchRespond(List<FaceRecordParaRespond> params) {
        PeopleSearchRespond respond = new PeopleSearchRespond();
        respond.setTotal(String.valueOf(params.size()));
        ArrayList<People> peopleList = new ArrayList<People>();
        for (int i = 0; i < params.size(); ++i) {
            People people = new People();
            people.setId(params.get(i).getId());
            people.setName(params.get(i).getName());
            people.setGender(params.get(i).getGender() == 0 ? "0" : (params.get(i).getGender() == 1 ? "1" : "-1"));
            switch (params.get(i).getCardType()) {
                case 0: {
                    people.setCredentialType("0");
                    break;
                }
                case 1: {
                    people.setCredentialType("1");
                    break;
                }
                case 2: {
                    people.setCredentialType("3");
                    break;
                }
                case 3: {
                    people.setCredentialType("4");
                    break;
                }
                default: {
                    people.setCredentialType("5");
                }
            }
            people.setCredentialNumber(params.get(i).getCardId());
            people.setBornTime(params.get(i).getBirthDay());
            people.setFeatureStatus(params.get(i).getFeatureStatus());
            peopleList.add(people);
        }
        respond.setPeopleList(peopleList);
        return respond;
    }

    @SessionCheck
    public boolean updatePeople(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        FaceRepositoryRequest faceRepositoryInfo = people.getFaceRepositoryInfo();
        List faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepositoryInfo);
        if (CollectionUtils.isEmpty((Collection)faceRepositoryList)) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_REPOSITORY_NOT_EXIST);
        }
        List peopleCommon = this.searchPeopleByCredentialNumber(vcmReqBaseInfo, people);
        if (CollectionUtils.isEmpty((Collection)peopleCommon)) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_NOT_EXIST);
        }
        faceRepositoryInfo.setGroupStrId(((FaceRepository)faceRepositoryList.get(0)).getGroupId());
        people.setFaceRepositoryInfo(faceRepositoryInfo);
        people.setCredentialNumber(people.getId());
        people.setId(((People)peopleCommon.get(0)).getId());
        return this.updatePeopleInfo(vcmReqBaseInfo, people);
    }

    @SessionCheck
    public boolean getFaceImage(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest peopelRequest) {
        DeviceRequest request = new DeviceRequest();
        request.setSession(vcmReqBaseInfo.getVcmSession());
        FaceRequest faceRequest = this.toFaceRequest(peopelRequest);
        faceRequest.getFaceLibraryPara().setId(peopelRequest.getFaceRepositoryInfo().getRepositoryId());
        request.setRequest((Object)faceRequest);
        return this.faceLibraryService.getFaceImage(request);
    }

    @SessionCheck
    public boolean replicateLibrary(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest peopelRequest) {
        DeviceRequest request = new DeviceRequest();
        request.setSession(vcmReqBaseInfo.getVcmSession());
        FaceRequest faceRequest = new FaceRequest();
        FaceLibraryParaRequest faceLibraryParaRequest = new FaceLibraryParaRequest();
        faceLibraryParaRequest.setId(StringUtils.isBlank((CharSequence)peopelRequest.getFaceRepositoryInfo().getRepositoryId()) ? "0" : peopelRequest.getFaceRepositoryInfo().getRepositoryId());
        faceLibraryParaRequest.setFaceListName(peopelRequest.getFaceRepositoryInfo().getName());
        faceLibraryParaRequest.setOnControl(peopelRequest.getFaceRepositoryInfo().getEnabled());
        faceLibraryParaRequest.setThreshold(peopelRequest.getFaceRepositoryInfo().getThreshold().intValue());
        faceLibraryParaRequest.setFaceListType(StringUtils.isBlank((CharSequence)peopelRequest.getFaceRepositoryInfo().getType()) ? 0 : Integer.parseInt(peopelRequest.getFaceRepositoryInfo().getType()) - 1);
        faceRequest.setFaceLibraryPara(faceLibraryParaRequest);
        faceRequest.setFaceFile(peopelRequest.getFaceFile());
        request.setRequest((Object)faceRequest);
        boolean flag = this.faceLibraryService.importFaceLibrary(request);
        if (flag && peopelRequest.getFaceRepositoryInfo().getEnabled() == 0) {
            peopelRequest.getFaceRepositoryInfo().setEnabled(1);
            peopelRequest.getFaceRepositoryInfo().setGroupStrId(peopelRequest.getFaceRepositoryInfo().getRepositoryId());
            this.updateFaceRepositoryBack(vcmReqBaseInfo, peopelRequest.getFaceRepositoryInfo());
        }
        return flag;
    }

    public boolean personRepeat(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        FaceRepositoryRequest faceRepositoryInfo = people.getFaceRepositoryInfo();
        faceRepositoryInfo.setGroupStrId(people.getFaceRepositoryInfo().getGroupStrId());
        people.setFaceRepositoryInfo(faceRepositoryInfo);
        people.setId(people.getId());
        return this.updatePeopleInfo(vcmReqBaseInfo, people);
    }

    private boolean updatePeopleInfo(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        DeviceRequest request = new DeviceRequest();
        request.setSession(vcmReqBaseInfo.getVcmSession());
        FaceRequest faceRequest = this.toFaceRequest(people);
        request.setRequest((Object)faceRequest);
        try {
            return this.faceLibraryService.modifyFaceInfo(request);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    private FaceRequest toFaceRequest(PeopleRequest people) {
        FaceRequest faceRequest = new FaceRequest();
        FaceLibraryParaRequest faceLibraryPara = new FaceLibraryParaRequest();
        faceLibraryPara.setId(people.getFaceRepositoryInfo().getGroupStrId());
        faceLibraryPara.setFaceListName(people.getFaceRepositoryInfo().getName());
        FaceRecordParaRequest faceRecordPara = new FaceRecordParaRequest();
        faceRecordPara.setFaceId(people.getId());
        faceRecordPara.setName(Objects.nonNull(people.getName()) ? people.getName() : "");
        switch (people.getGender()) {
            case "0": {
                faceRecordPara.setGender(0);
                break;
            }
            case "1": {
                faceRecordPara.setGender(1);
                break;
            }
            case "-1": {
                faceRecordPara.setGender(2);
                break;
            }
        }
        faceRecordPara.setBirthDay(Objects.nonNull(people.getBornTime()) ? people.getBornTime() : "");
        faceRecordPara.setProvince(Objects.nonNull(people.getProvince()) ? people.getProvince() : "");
        faceRecordPara.setCity(Objects.nonNull(people.getCity()) ? people.getCity() : "");
        if (Objects.nonNull(people.getCredentialType())) {
            if ("0".equals(people.getCredentialType())) {
                faceRecordPara.setCardType(0);
            } else if ("1".equals(people.getCredentialType())) {
                faceRecordPara.setCardType(1);
            } else if ("3".equals(people.getCredentialType())) {
                faceRecordPara.setCardType(2);
            } else if ("4".equals(people.getCredentialType())) {
                faceRecordPara.setCardType(3);
            } else {
                faceRecordPara.setCardType(4);
            }
        } else {
            faceRecordPara.setCardType(4);
        }
        if (StringUtils.isNotBlank((CharSequence)people.getImagePath())) {
            faceRecordPara.setPicPath(people.getImagePath());
        }
        faceRecordPara.setCardId(people.getCredentialNumber());
        faceRequest.setFaceLibraryPara(faceLibraryPara);
        faceRequest.setFaceRecordPara(faceRecordPara);
        return faceRequest;
    }

    @SessionCheck
    public boolean repositoryUpdatePeopleBatch(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        return false;
    }

    public List<FaceRepository> searchCommon(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        List<Object> faceRepositoryList = new ArrayList<FaceRepository>();
        FaceRepositorySearchRespond searchRespond = this.search(vcmReqBaseInfo, faceRepository);
        if (!CollectionUtils.isEmpty((Collection)searchRespond.getRepositories())) {
            faceRepositoryList = searchRespond.getRepositories();
            if (StringUtils.isNotBlank((CharSequence)faceRepository.getRepositoryId())) {
                faceRepositoryList.removeIf(item -> !faceRepository.getRepositoryId().equals(item.getGroupId()));
            } else if (StringUtils.isNotBlank((CharSequence)faceRepository.getName())) {
                faceRepositoryList.removeIf(item -> !faceRepository.getName().equals(item.getName()));
            } else {
                faceRepositoryList.clear();
            }
        }
        return faceRepositoryList;
    }

    public boolean isExistFaceRepository(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        FaceRepositorySearchRespond searchRespond = this.search(vcmReqBaseInfo, faceRepository);
        if (!CollectionUtils.isEmpty((Collection)searchRespond.getRepositories())) {
            for (FaceRepository repository : searchRespond.getRepositories()) {
                if (!faceRepository.getNewName().equals(repository.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public List<People> searchPeopleByCredentialNumber(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest peopleRequest) {
        PeopleRequest people = new PeopleRequest();
        people.setFaceRepositoryInfo(peopleRequest.getFaceRepositoryInfo());
        PeopleSearchRespond peopleSearchRespond = this.searchPeople(vcmReqBaseInfo, people);
        List peopleList = peopleSearchRespond.getPeopleList();
        if (!CollectionUtils.isEmpty((Collection)peopleList)) {
            peopleList.removeIf(item -> !peopleRequest.getId().equals(item.getCredentialNumber()));
        }
        return peopleList;
    }

    public List<People> searchPeopleById(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest peopleRequest) {
        PeopleRequest people = new PeopleRequest();
        people.setFaceRepositoryInfo(peopleRequest.getFaceRepositoryInfo());
        PeopleSearchRespond peopleSearchRespond = this.searchPeople(vcmReqBaseInfo, people);
        List peopleList = peopleSearchRespond.getPeopleList();
        if (!CollectionUtils.isEmpty((Collection)peopleList)) {
            peopleList = peopleList.stream().filter(item -> peopleRequest.getIds().contains(item.getId())).collect(Collectors.toList());
        }
        return peopleList;
    }

    public List<People> searchPeopleByName(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest peopleRequest) {
        PeopleRequest people = new PeopleRequest();
        people.setFaceRepositoryInfo(peopleRequest.getFaceRepositoryInfo());
        PeopleSearchRespond peopleSearchRespond = this.searchPeople(vcmReqBaseInfo, people);
        List peopleList = peopleSearchRespond.getPeopleList();
        if (!CollectionUtils.isEmpty((Collection)peopleList)) {
            peopleList.removeIf(item -> !peopleRequest.getName().equals(item.getName()));
        }
        return peopleList;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E eTemplate, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(eTemplate);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

