/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.sdk;

import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraAddRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRebootRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRemoveRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.PasswordUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraAddRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.sdc.SdcDeviceRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.ChannelStatusEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.DiscoveryDeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.DeviceInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.DiscoveryDeviceRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.DeviceService;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceManageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SessionCheck;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="deviceManageServiceSdcSdkStrategy")
@SdcServiceType
public class DeviceManageServiceSdcSdkStrategy
implements DeviceManageService<IServerType.SDC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManageServiceSdcSdkStrategy.class);
    @Autowired
    private DeviceService deviceService;

    public List<CameraRespond> listCamera(VcmReqBaseInfo vcmReqBaseInfo) {
        return null;
    }

    public List<ChannelRespond> listChannel(VcmReqBaseInfo vcmReqBaseInfo) {
        return null;
    }

    public ChannelRespond getChannel(ParamBean<ChannelRequest> obj) {
        return null;
    }

    public List<String> getEmptyChannel(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public boolean updateChannel(ParamBean<ChannelUpdateRequest> obj) {
        return false;
    }

    public List<ChannelRespond> listChannelsByCamera(VcmReqBaseInfo vcmReqBaseInfo, String cameraCode) {
        return null;
    }

    @SessionCheck
    public CameraAddRespond addCamera(ParamBean<CameraAddRequest> obj) {
        SdcDeviceRespond sdcDeviceRespond = this.getSdcDevice(obj.getVcmInfo());
        CameraAddRespond cameraAddRespond = new CameraAddRespond();
        cameraAddRespond.setSdcDeviceRespond(sdcDeviceRespond);
        cameraAddRespond.setCameraCode(sdcDeviceRespond.getBarCode());
        cameraAddRespond.setModel(sdcDeviceRespond.getDevType());
        cameraAddRespond.setStatus(ChannelStatusEnum.ONLINE);
        cameraAddRespond.setImgType(0);
        cameraAddRespond.setName(((CameraAddRequest)obj.getRequestBody()).getName());
        int model = DeviceUtil.getModelType((String)sdcDeviceRespond.getDevType());
        cameraAddRespond.setCameraType(Ivs1800Utils.getCameraType((int)model));
        cameraAddRespond.setSerialNumber(sdcDeviceRespond.getDrvCode());
        cameraAddRespond.setChannelResponds(this.buildChannels(cameraAddRespond));
        return cameraAddRespond;
    }

    private List<ChannelRespond> buildChannels(CameraAddRespond cameraAddRespond) {
        ArrayList<ChannelRespond> channelResponds = new ArrayList<ChannelRespond>();
        ChannelRespond channelRespond = new ChannelRespond();
        channelRespond.setCategory(DeviceTypeEnum.CLOUD.val());
        channelRespond.setChannel(1);
        channelRespond.setChannelCode(cameraAddRespond.getCameraCode());
        channelRespond.setType(4);
        channelRespond.setVendor("HUAWEI");
        channelRespond.setCameraType(cameraAddRespond.getCameraType());
        channelRespond.setCameraName(cameraAddRespond.getName());
        channelRespond.setParentCode(cameraAddRespond.getCameraCode());
        channelRespond.setModel(cameraAddRespond.getModel());
        channelRespond.setProtocolType("HWSDK");
        channelRespond.setStatus(cameraAddRespond.getStatus());
        channelRespond.setFormType(1);
        channelResponds.add(channelRespond);
        return channelResponds;
    }

    public boolean removeCamera(ParamBean<CameraRemoveRequest> obj) {
        return false;
    }

    public boolean updatePassword(ParamBean<PasswordUpdateRequest> obj) {
        return false;
    }

    @SessionCheck
    public boolean rebootCamera(ParamBean<CameraRebootRequest> obj) {
        try {
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            this.deviceService.reboot(deviceRequest);
            LOGGER.debug("Reboot success");
            return true;
        }
        catch (IpcException e) {
            LOGGER.error("Reboot fail, {}", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public SdcDeviceRespond getSdcDevice(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setSession(vcmReqBaseInfo.getVcmSession());
            DeviceInfoRespond deviceInfo = this.deviceService.getDeviceInfo(deviceRequest);
            LOGGER.debug("Get device info from sdk is end.");
            SdcDeviceRespond sdcDeviceRespond = new SdcDeviceRespond();
            sdcDeviceRespond.setBomCode(deviceInfo.getBom());
            sdcDeviceRespond.setDevType(deviceInfo.getDeviceType());
            sdcDeviceRespond.setBarCode(deviceInfo.getDeviceSn());
            sdcDeviceRespond.setFirstDNSAddress(deviceInfo.getFirstDNSAddress());
            sdcDeviceRespond.setKernelVersion(deviceInfo.getKernelVersion());
            sdcDeviceRespond.setUBootVersion(deviceInfo.getUBootVersion());
            sdcDeviceRespond.setMacAddress(deviceInfo.getMacAddress());
            sdcDeviceRespond.setHardwareVersion(deviceInfo.getHardwareVersion());
            sdcDeviceRespond.setSoftwareVersion(deviceInfo.getSoftwareVersion());
            sdcDeviceRespond.setDeviceGateway(deviceInfo.getDeviceGateway());
            sdcDeviceRespond.setIpAddress(deviceInfo.getIpAddress());
            return sdcDeviceRespond;
        }
        catch (IpcException e) {
            LOGGER.error("get device info happen exception ", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public List<CameraSearchRespond> searchCamera(VcmReqBaseInfo vcmReqBaseInfo, CameraSearchRequest request) {
        try {
            ArrayList<CameraSearchRespond> cameraSearchResponds = new ArrayList<CameraSearchRespond>();
            DeviceRequest deviceRequest = new DeviceRequest();
            DiscoveryDeviceRequest discoveryDeviceRequest = new DiscoveryDeviceRequest();
            discoveryDeviceRequest.setStartIp(((CameraSearchRequest.IpInfo)request.getIpList().get(0)).getStartIp());
            discoveryDeviceRequest.setEndIp(((CameraSearchRequest.IpInfo)request.getIpList().get(0)).getEndIp());
            discoveryDeviceRequest.setSearchNum(request.getSearchNum());
            deviceRequest.setRequest((Object)discoveryDeviceRequest);
            DiscoveryDeviceRespond discoveryDeviceRespond = this.deviceService.discoveryDevice(deviceRequest);
            List deviceBaseInfos = discoveryDeviceRespond.getDeviceBaseInfoList();
            if (!CollectionUtils.isEmpty((Collection)deviceBaseInfos)) {
                for (DeviceBaseInfo deviceBaseInfo : deviceBaseInfos) {
                    CameraSearchRespond cameraSearchRespond = new CameraSearchRespond();
                    cameraSearchRespond.setIp(deviceBaseInfo.getIpAddress());
                    cameraSearchRespond.setPort(deviceBaseInfo.getPort() == null ? "6061" : String.valueOf(deviceBaseInfo.getPort()));
                    cameraSearchRespond.setVendor(deviceBaseInfo.getDeviceFac());
                    cameraSearchRespond.setDeviceType(deviceBaseInfo.getDeviceType());
                    cameraSearchRespond.setProtocol(deviceBaseInfo.getFirstDNSAddress());
                    cameraSearchResponds.add(cameraSearchRespond);
                }
            }
            return cameraSearchResponds;
        }
        catch (IpcException e) {
            LOGGER.error("get device info happen exception ", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return null;
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return null;
    }
}

