/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.sdk;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorGetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.IgtAlarmConfigSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.VehicleParameterSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.Nvr800AlarmPlanItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.Nvr800AreaItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.Nvr800LineItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.PointItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.ThirdAlgorithm;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.ThirdAlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.VehicleParameterRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.BehaviorLineItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.BehaviorRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.IgtAlarmConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.AlarmTime;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.BaseAreaParam;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.IgaArea;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.IgtLine;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.IgtPoint;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.PTZCurrentLocation;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.Time;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.AreaDetectRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.IpcEmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.SmartAlarmParamRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.TripwireAlarmParaRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.AreaDetectRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.SmartAlarmParamRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.TripwireAlarmParaRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.util.DateUtil;
import com.zkteco.zkbiosecurity.cuserver.service.BehaviorAnalysisService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.AbstractSdcService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SessionCheck;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="behaviorAnalysisServiceSdcSdkStrategy")
@SdcServiceType
public class BehaviorAnalysisServiceSdcSdkStrategy
extends AbstractSdcService
implements BehaviorAnalysisService<IServerType.SDC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BehaviorAnalysisServiceSdcSdkStrategy.class);
    @Autowired
    private com.zkteco.zkbiosecurity.cuserver.ipc.service.BehaviorAnalysisService behaviorAnalysisService;

    @SessionCheck
    public BehaviorRespond getPerimeterZone(ParamBean<BehaviorGetRequest> obj) {
        try {
            IpcEmptyRequest ipcEmptyRequest = new IpcEmptyRequest();
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)ipcEmptyRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            AreaDetectRespond areaDetectRespond = this.behaviorAnalysisService.getAreaIntrusionParam(deviceRequest);
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSON((Object)areaDetectRespond).toString());
            return null;
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public BehaviorRespond getPerimeterLine(ParamBean<BehaviorGetRequest> obj) {
        try {
            IpcEmptyRequest ipcEmptyRequest = new IpcEmptyRequest();
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)ipcEmptyRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            TripwireAlarmParaRespond areaDetectRespond = this.behaviorAnalysisService.getTripwireParam(deviceRequest);
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSON((Object)areaDetectRespond).toString());
            BehaviorRespond behaviorRespond = this.perimeterLineConverToRespond(jsonObject);
            return behaviorRespond;
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    public BehaviorRespond getItemLeave(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public boolean setItemLeave(ParamBean<BehaviorSetRequest> obj) {
        return false;
    }

    public BehaviorRespond getItemMove(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public boolean setItemMove(ParamBean<BehaviorSetRequest> obj) {
        return false;
    }

    @SessionCheck
    public BehaviorRespond getAreaEnter(ParamBean<BehaviorGetRequest> obj) {
        try {
            IpcEmptyRequest ipcEmptyRequest = new IpcEmptyRequest();
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)ipcEmptyRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            AreaDetectRespond areaDetectRespond = this.behaviorAnalysisService.getAreaEnterParam(deviceRequest);
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSON((Object)areaDetectRespond).toString());
            LOGGER.info("get area enter param from sdk is end.");
            this.checkJsonRespond(jsonObject);
            LOGGER.info("get area enter param end..");
            return null;
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public BehaviorRespond getAreaExit(ParamBean<BehaviorGetRequest> obj) {
        try {
            IpcEmptyRequest ipcEmptyRequest = new IpcEmptyRequest();
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)ipcEmptyRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            AreaDetectRespond areaDetectRespond = this.behaviorAnalysisService.getAreaExitParam(deviceRequest);
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSON((Object)areaDetectRespond).toString());
            LOGGER.info("get area exit param from sdk is end.");
            LOGGER.info("get area exit param end..");
            return null;
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public BehaviorRespond getLoitering(ParamBean<BehaviorGetRequest> obj) {
        try {
            IpcEmptyRequest ipcEmptyRequest = new IpcEmptyRequest();
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)ipcEmptyRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            AreaDetectRespond areaDetectRespond = this.behaviorAnalysisService.getAreaHoverParam(deviceRequest);
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSON((Object)areaDetectRespond).toString());
            LOGGER.info("get loitering param from sdk is end.");
            LOGGER.info("get loitering param end..");
            return null;
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public BehaviorRespond getFastMovement(ParamBean<BehaviorGetRequest> obj) {
        try {
            IpcEmptyRequest ipcEmptyRequest = new IpcEmptyRequest();
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)ipcEmptyRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            AreaDetectRespond areaDetectRespond = this.behaviorAnalysisService.getAreaFastMoveParam(deviceRequest);
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSON((Object)areaDetectRespond).toString());
            LOGGER.info("get fast movement param from sdk is end.");
            LOGGER.info("get fast movement param end..");
            return null;
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public IgtAlarmConfigRespond getIgtAlarmConfig(ParamBean<BehaviorGetRequest> obj) {
        try {
            IpcEmptyRequest ipcEmptyRequest = new IpcEmptyRequest();
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)ipcEmptyRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            SmartAlarmParamRespond smartAlarmParamRespond = this.behaviorAnalysisService.getGlobalBehavioralAnalysisParam(deviceRequest);
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSON((Object)smartAlarmParamRespond).toString());
            LOGGER.info("get behavior from sdk is end.");
            LOGGER.info("get behavior end..");
            return null;
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public boolean setPerimeterZone(ParamBean<BehaviorSetRequest> obj) {
        try {
            BehaviorSetRequest request = (BehaviorSetRequest)obj.getRequestBody();
            AreaDetectRequest areaDetectRequest = this.converToAreaDetectRequest(request);
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)areaDetectRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            return this.behaviorAnalysisService.setAreaIntrusionParam(deviceRequest);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public boolean setPerimeterLine(ParamBean<BehaviorSetRequest> obj) {
        try {
            BehaviorSetRequest request = (BehaviorSetRequest)obj.getRequestBody();
            TripwireAlarmParaRequest tripwireAlarmParaRequest = this.converToTripwireParaRequest(request);
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)tripwireAlarmParaRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            return this.behaviorAnalysisService.setTripwireParam(deviceRequest);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public boolean setAreaEnter(ParamBean<BehaviorSetRequest> obj) {
        try {
            BehaviorSetRequest request = (BehaviorSetRequest)obj.getRequestBody();
            AreaDetectRequest areaDetectRequest = this.converToAreaDetectRequest(request);
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)areaDetectRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            return this.behaviorAnalysisService.setAreaEnterParam(deviceRequest);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public boolean setAreaExit(ParamBean<BehaviorSetRequest> obj) {
        try {
            BehaviorSetRequest request = (BehaviorSetRequest)obj.getRequestBody();
            AreaDetectRequest areaDetectRequest = this.converToAreaDetectRequest(request);
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)areaDetectRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            return this.behaviorAnalysisService.setAreaExitParam(deviceRequest);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public boolean setLoitering(ParamBean<BehaviorSetRequest> obj) {
        try {
            BehaviorSetRequest request = (BehaviorSetRequest)obj.getRequestBody();
            AreaDetectRequest areaDetectRequest = this.converToAreaDetectRequest(request);
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)areaDetectRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            return this.behaviorAnalysisService.setAreaHoverParam(deviceRequest);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public boolean setFastMovement(ParamBean<BehaviorSetRequest> obj) {
        try {
            BehaviorSetRequest request = (BehaviorSetRequest)obj.getRequestBody();
            AreaDetectRequest areaDetectRequest = this.converToAreaDetectRequest(request);
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)areaDetectRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            return this.behaviorAnalysisService.setAreaFastMoveParam(deviceRequest);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public boolean setIgtAlarmConfig(ParamBean<IgtAlarmConfigSetRequest> obj) {
        try {
            IgtAlarmConfigSetRequest request = (IgtAlarmConfigSetRequest)obj.getRequestBody();
            SmartAlarmParamRequest tripwireAlarmParaRequest = this.converToSmartParamRequest(request);
            DeviceRequest deviceRequest = new DeviceRequest();
            deviceRequest.setRequest((Object)tripwireAlarmParaRequest);
            deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
            return this.behaviorAnalysisService.setGlobalBehavioralAnalysisParam(deviceRequest);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    public boolean setVehicleIllegal(ParamBean<VehicleParameterSetRequest> obj) {
        return false;
    }

    public BehaviorRespond getElectroMobile(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public boolean setElectroMobile(ParamBean<BehaviorSetRequest> obj) {
        return false;
    }

    public boolean setVehicleDetect(ParamBean<VehicleParameterSetRequest> obj) {
        return false;
    }

    public boolean setVehicleParameter(ParamBean<VehicleParameterSetRequest> obj) {
        return false;
    }

    public VehicleParameterRespond getVehicleIllegal(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public VehicleParameterRespond getVehicleParameter(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public VehicleParameterRespond getVehicleDetect(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public ThirdAlgorithmRespond thirdAlgorithm(VcmReqBaseInfo vcmInfo) {
        return null;
    }

    public ThirdAlgorithmRespond thirdalgorithmParam(VcmReqBaseInfo vcmInfo, ThirdAlgorithm request) {
        return null;
    }

    public Boolean updateThirdalgorithmParam(VcmReqBaseInfo vcmInfo, ThirdAlgorithm request) {
        return null;
    }

    private SmartAlarmParamRequest converToSmartParamRequest(IgtAlarmConfigSetRequest request) {
        SmartAlarmParamRequest smartRequest = new SmartAlarmParamRequest();
        smartRequest.setChannelId("101");
        smartRequest.setIgtEnable(Boolean.valueOf(Objects.nonNull(request.getEnable()) ? request.getEnable() : true));
        smartRequest.setTrackEnable(Boolean.valueOf(request.getTrackEnable() == 1));
        smartRequest.setEnFieldType(request.getFieldType());
        if (Objects.nonNull(request.getMinTargetSize())) {
            if (request.getMinTargetSize().getHeight() == 10 && request.getMinTargetSize().getWidth() == 10) {
                smartRequest.setEnMinTargetSize(0);
            } else if (request.getMinTargetSize().getHeight() == 20 && request.getMinTargetSize().getWidth() == 20) {
                smartRequest.setEnMinTargetSize(1);
            } else if (request.getMinTargetSize().getHeight() == 30 && request.getMinTargetSize().getWidth() == 30) {
                smartRequest.setEnMinTargetSize(2);
            } else {
                smartRequest.setEnMinTargetSize(3);
            }
        } else {
            smartRequest.setEnMinTargetSize(0);
        }
        if (Objects.nonNull(request.getShadowMode())) {
            if ("WeakShadow".equals(request.getShadowMode())) {
                smartRequest.setEnShadowMode(0);
            } else if ("NormalShadow".equals(request.getShadowMode())) {
                smartRequest.setEnShadowMode(1);
            } else if ("StrongShadow".equals(request.getShadowMode())) {
                smartRequest.setEnShadowMode(2);
            } else {
                smartRequest.setEnShadowMode(3);
            }
        }
        if ("LowSensitivity".equals(request.getDetectionSensitivity())) {
            smartRequest.setEnDetectSens(0);
        } else if ("MiddleSensitivity".equals(request.getDetectionSensitivity())) {
            smartRequest.setEnDetectSens(1);
        } else if ("HighSensitivity".equals(request.getDetectionSensitivity())) {
            smartRequest.setEnDetectSens(2);
        } else if ("LowerSensitivity".equals(request.getDetectionSensitivity())) {
            smartRequest.setEnDetectSens(3);
        } else {
            smartRequest.setEnDetectSens(4);
        }
        smartRequest.setInsensitiveObject(Boolean.valueOf(request.getInsensitiveObject() == 1));
        return smartRequest;
    }

    private TripwireAlarmParaRequest converToTripwireParaRequest(BehaviorSetRequest request) {
        TripwireAlarmParaRequest tripwireRequest = new TripwireAlarmParaRequest();
        if (Objects.nonNull(request)) {
            tripwireRequest.setChannelId("101");
            tripwireRequest.setEnable(Boolean.valueOf(Objects.nonNull(request.getEnable()) ? request.getEnable() : true));
            if (Objects.nonNull(request.getRecognizeMode())) {
                if ("Center".equals(request.getRecognizeMode())) {
                    tripwireRequest.setTargetDetecMode(0);
                }
                if ("Top".equals(request.getRecognizeMode())) {
                    tripwireRequest.setTargetDetecMode(2);
                }
                if ("Bottom".equals(request.getRecognizeMode())) {
                    tripwireRequest.setTargetDetecMode(1);
                }
            }
            tripwireRequest.setAlarmInterval(Objects.nonNull(request.getAlarmInterval()) ? (long)request.getAlarmInterval().intValue() : 5L);
            tripwireRequest.setSensitivity(Objects.nonNull(request.getSensitivity()) ? (long)request.getSensitivity().intValue() : 0L);
            List lineList = request.getLineList();
            if (!CollectionUtils.isEmpty((Collection)lineList)) {
                BaseAreaParam.TripLineList tripLineList = new BaseAreaParam.TripLineList();
                tripLineList.lineNum = lineList.size();
                tripLineList.lineList = new IgtLine[lineList.size()];
                for (int i = 0; i < lineList.size(); ++i) {
                    IgtLine igtLine = new IgtLine();
                    igtLine.setEnable(Boolean.valueOf(Objects.nonNull(((Nvr800LineItem)lineList.get(i)).getEnable()) ? ((Nvr800LineItem)lineList.get(i)).getEnable() : true));
                    igtLine.setLineName(Objects.nonNull(((Nvr800LineItem)lineList.get(i)).getLineName()) ? ((Nvr800LineItem)lineList.get(i)).getLineName() : "default Line");
                    if (Objects.nonNull(((Nvr800LineItem)lineList.get(i)).getRuleType())) {
                        if ("A<->B".equals(((Nvr800LineItem)lineList.get(i)).getRuleType())) {
                            igtLine.setDirection(0);
                        }
                        if ("A->B".equals(((Nvr800LineItem)lineList.get(i)).getRuleType())) {
                            igtLine.setDirection(1);
                        }
                        if ("B->A".equals(((Nvr800LineItem)lineList.get(i)).getRuleType())) {
                            igtLine.setDirection(2);
                        }
                    }
                    igtLine.setLineIndex(Objects.nonNull(((Nvr800LineItem)lineList.get(i)).getIndex()) ? (long)((Nvr800LineItem)lineList.get(i)).getIndex().intValue() : 0L);
                    IgtPoint startPoint = new IgtPoint();
                    startPoint.setPointPosX((short)((Nvr800LineItem)lineList.get(i)).getX1());
                    startPoint.setPointPosY((short)((Nvr800LineItem)lineList.get(i)).getY1());
                    IgtPoint endPoint = new IgtPoint();
                    endPoint.setPointPosX((short)((Nvr800LineItem)lineList.get(i)).getX2());
                    endPoint.setPointPosY((short)((Nvr800LineItem)lineList.get(i)).getY2());
                    igtLine.setStartPoint(startPoint);
                    igtLine.setEndPoint(endPoint);
                    tripLineList.lineList[i] = igtLine;
                }
                tripwireRequest.setLineList(tripLineList);
            }
        }
        return tripwireRequest;
    }

    private AreaDetectRequest converToAreaDetectRequest(BehaviorSetRequest request) {
        AreaDetectRequest areaRequest = new AreaDetectRequest();
        if (Objects.nonNull(request)) {
            areaRequest.setChannelId("101");
            areaRequest.setEnable(Boolean.valueOf(Objects.nonNull(request.getEnable()) ? request.getEnable() : true));
            areaRequest.setAlarmInterval(Objects.nonNull(request.getAlarmInterval()) ? (long)request.getAlarmInterval().intValue() : 5L);
            if (Objects.nonNull(request.getRecognizeMode())) {
                if ("Center".equals(request.getRecognizeMode())) {
                    areaRequest.setTargetDetecMode(0);
                }
                if ("Top".equals(request.getRecognizeMode())) {
                    areaRequest.setTargetDetecMode(2);
                }
                if ("Bottom".equals(request.getRecognizeMode())) {
                    areaRequest.setTargetDetecMode(1);
                }
            }
            areaRequest.setRemainTime(Objects.nonNull(request.getToleranceTime()) ? (long)request.getToleranceTime().intValue() : 0L);
            List areaItems = request.getAreaList();
            if (!CollectionUtils.isEmpty((Collection)areaItems)) {
                BaseAreaParam.AreaList areaList = new BaseAreaParam.AreaList();
                areaList.setAreaNum((long)areaItems.size());
                areaList.setStArea(new IgaArea[areaItems.size()]);
                for (int i = 0; i < areaItems.size(); ++i) {
                    IgaArea areaItem = new IgaArea();
                    areaItem.setAreaIndex((long)((Nvr800AreaItem)areaItems.get(i)).getIndex());
                    if (Objects.nonNull(((Nvr800AreaItem)areaItems.get(i)).getEnable())) {
                        areaItem.setEnable(((Nvr800AreaItem)areaItems.get(i)).getEnable().booleanValue());
                    }
                    areaItem.setAreaName(Objects.nonNull(((Nvr800AreaItem)areaItems.get(i)).getAreaName()) ? ((Nvr800AreaItem)areaItems.get(i)).getAreaName() : "default area");
                    Nvr800AreaItem.Location location = ((Nvr800AreaItem)areaItems.get(i)).getLocation();
                    PTZCurrentLocation ptzCurrentLocation = new PTZCurrentLocation();
                    if (Objects.nonNull(location)) {
                        ptzCurrentLocation.setLPTZHorDegree(Objects.nonNull(location.getXDegree()) ? location.getXDegree() : 0);
                        ptzCurrentLocation.setLPTZVerDegree(Objects.nonNull(location.getYDegree()) ? location.getYDegree() : 0);
                        ptzCurrentLocation.setUlLenMultiple(Objects.nonNull(location.getPos()) ? (long)location.getPos().intValue() : 0L);
                        ptzCurrentLocation.setUlZoomRatio(Objects.nonNull(location.getDZoomRatio()) ? (long)location.getDZoomRatio().intValue() : 0L);
                    } else {
                        ptzCurrentLocation.setLPTZHorDegree(0);
                        ptzCurrentLocation.setLPTZVerDegree(0);
                        ptzCurrentLocation.setUlLenMultiple(0L);
                        ptzCurrentLocation.setUlZoomRatio(0L);
                    }
                    areaItem.setLocation(ptzCurrentLocation);
                    List pointList = ((Nvr800AreaItem)areaItems.get(i)).getPointList();
                    areaItem.setPointNum(pointList.size());
                    if (!CollectionUtils.isEmpty((Collection)pointList)) {
                        areaItem.setPoint(new IgtPoint[pointList.size()]);
                        for (int j = 0; j < pointList.size(); ++j) {
                            IgtPoint igtPoint = new IgtPoint();
                            igtPoint.setPointPosX((short)((PointItem)pointList.get(j)).getPointX());
                            igtPoint.setPointPosY((short)((PointItem)pointList.get(j)).getPointY());
                            areaItem.getPoint()[j] = igtPoint;
                        }
                    }
                    areaList.stArea[i] = areaItem;
                }
                areaRequest.setAreaDtcList(areaList);
            }
            List alarmPlanList = request.getAlarmPlanList();
            BaseAreaParam.AlarmTimeList alarmTimeList = new BaseAreaParam.AlarmTimeList();
            if (!CollectionUtils.isEmpty((Collection)alarmPlanList)) {
                alarmTimeList.num = alarmPlanList.size();
                alarmTimeList.alarmTimes = new AlarmTime[alarmPlanList.size()];
                for (int i = 0; i < alarmPlanList.size(); ++i) {
                    AlarmTime alarmTime = new AlarmTime();
                    alarmTime.setCycleType((long)((Nvr800AlarmPlanItem)alarmPlanList.get(i)).getCycleType());
                    alarmTime.setPeriod((long)((Nvr800AlarmPlanItem)alarmPlanList.get(i)).getPeriod());
                    Time startTime = new Time();
                    startTime.szYear = String.valueOf(DateUtil.getYear((Date)DateUtil.stringToDate((String)((Nvr800AlarmPlanItem)alarmPlanList.get(i)).getStartDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD)));
                    startTime.szMonth = String.valueOf(DateUtil.getMonth((Date)DateUtil.stringToDate((String)((Nvr800AlarmPlanItem)alarmPlanList.get(i)).getStartDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD)) + 1);
                    startTime.szDay = String.valueOf(DateUtil.getDay((Date)DateUtil.stringToDate((String)((Nvr800AlarmPlanItem)alarmPlanList.get(i)).getStartDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD)));
                    startTime.szHour = String.valueOf(DateUtil.getHour((Date)DateUtil.stringToDate((String)((Nvr800AlarmPlanItem)alarmPlanList.get(i)).getStartTime(), (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM_SS)));
                    startTime.szMinute = String.valueOf(DateUtil.getMinute((Date)DateUtil.stringToDate((String)((Nvr800AlarmPlanItem)alarmPlanList.get(i)).getStartTime(), (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM_SS)));
                    startTime.szSecond = String.valueOf(DateUtil.getSecond((Date)DateUtil.stringToDate((String)((Nvr800AlarmPlanItem)alarmPlanList.get(i)).getStartTime(), (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM_SS)));
                    Time endTime = new Time();
                    endTime.szYear = String.valueOf(DateUtil.getYear((Date)DateUtil.stringToDate((String)((Nvr800AlarmPlanItem)alarmPlanList.get(i)).getStartDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD)));
                    endTime.szMonth = String.valueOf(DateUtil.getMonth((Date)DateUtil.stringToDate((String)((Nvr800AlarmPlanItem)alarmPlanList.get(i)).getStartDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD)) + 1);
                    endTime.szDay = String.valueOf(DateUtil.getDay((Date)DateUtil.stringToDate((String)((Nvr800AlarmPlanItem)alarmPlanList.get(i)).getStartDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD)));
                    endTime.szHour = String.valueOf(DateUtil.getHour((Date)DateUtil.stringToDate((String)((Nvr800AlarmPlanItem)alarmPlanList.get(i)).getEndTime(), (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM_SS)));
                    endTime.szMinute = String.valueOf(DateUtil.getMinute((Date)DateUtil.stringToDate((String)((Nvr800AlarmPlanItem)alarmPlanList.get(i)).getEndTime(), (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM_SS)));
                    endTime.szSecond = String.valueOf(DateUtil.getSecond((Date)DateUtil.stringToDate((String)((Nvr800AlarmPlanItem)alarmPlanList.get(i)).getEndTime(), (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM_SS)));
                    startTime.szMonth = startTime.szMonth.length() == 1 ? "0" + startTime.szMonth : startTime.szMonth;
                    startTime.szDay = startTime.szDay.length() == 1 ? "0" + startTime.szDay : startTime.szDay;
                    startTime.szHour = startTime.szHour.length() == 1 ? "0" + startTime.szHour : startTime.szHour;
                    startTime.szMinute = startTime.szMinute.length() == 1 ? "0" + startTime.szMinute : startTime.szMinute;
                    startTime.szSecond = startTime.szSecond.length() == 1 ? "0" + startTime.szSecond : startTime.szSecond;
                    endTime.szMonth = endTime.szMonth.length() == 1 ? "0" + endTime.szMonth : endTime.szMonth;
                    endTime.szDay = endTime.szDay.length() == 1 ? "0" + endTime.szDay : endTime.szDay;
                    endTime.szHour = endTime.szHour.length() == 1 ? "0" + endTime.szHour : endTime.szHour;
                    endTime.szMinute = endTime.szMinute.length() == 1 ? "0" + endTime.szMinute : endTime.szMinute;
                    endTime.szSecond = endTime.szSecond.length() == 1 ? "0" + endTime.szSecond : endTime.szSecond;
                    alarmTime.setStart(startTime);
                    alarmTime.setEnd(endTime);
                    alarmTimeList.alarmTimes[i] = alarmTime;
                }
                areaRequest.setAreaGuardPlan(alarmTimeList);
            }
        }
        return areaRequest;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    private BehaviorRespond perimeterLineConverToRespond(JSONObject jsonObject) {
        BehaviorRespond behaviorRespond = new BehaviorRespond();
        ArrayList<BehaviorLineItemRespond> itemList = new ArrayList<BehaviorLineItemRespond>();
        int lineNum = jsonObject.getJSONObject("lineList").getInteger("lineNum");
        JSONArray lineList = jsonObject.getJSONObject("lineList").getJSONArray("lineList");
        for (int i = 0; i < lineNum; ++i) {
            BehaviorLineItemRespond behaviorLineItem = new BehaviorLineItemRespond();
            JSONObject line = (JSONObject)lineList.get(i);
            int x1 = line.getJSONObject("startPoint").getInteger("pointPosX");
            int y1 = line.getJSONObject("startPoint").getInteger("pointPosY");
            int x2 = line.getJSONObject("endPoint").getInteger("pointPosX");
            int y2 = line.getJSONObject("endPoint").getInteger("pointPosY");
            String lineName = line.getString("lineName");
            behaviorLineItem.setX1(x1);
            behaviorLineItem.setY1(y1);
            behaviorLineItem.setX2(x2);
            behaviorLineItem.setY2(y2);
            behaviorLineItem.setLineName(lineName);
            behaviorLineItem.setEnable(line.getBoolean("enable"));
            itemList.add(behaviorLineItem);
            behaviorRespond.setLineList(itemList);
        }
        return behaviorRespond;
    }
}

