/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.sdk;

import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.AlarmDealRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.AlarmSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.PageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmSearch.AlarmSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.websocket.SubscriptionRequest;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.ipc.callback.AlarmCallback;
import com.zkteco.zkbiosecurity.cuserver.ipc.callback.MetadataCallback;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.MetadataCancelRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.DeviceInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.DeviceService;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.SubscribeService;
import com.zkteco.zkbiosecurity.cuserver.service.AlarmService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SessionCheck;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.help.SubscribeInfo;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.help.SubscribeStore;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="alarmServiceSdcSdkStrategy")
@SdcServiceType
public class AlarmServiceSdcSdkStrategy
implements AlarmService<IServerType.SDC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmServiceSdcSdkStrategy.class);
    @Autowired
    private SubscribeService subscribeService;
    @Autowired
    private AlarmCallback alarmCallback;
    @Autowired
    private MetadataCallback metadataCallback;
    @Autowired
    private SubscribeStore subscribeStore;
    @Autowired
    private SubscriptionHelp subscriptionHelp;
    @Autowired
    private DeviceService deviceService;

    @SessionCheck
    public boolean subscribe(ParamBean<SubscriptionRequest> obj) {
        if (this.subscribeStore.get(obj.getVcmInfo().getVcmSession()) == null) {
            LOGGER.info("Device begin subscribe, session is {}, ip is {}", (Object)obj.getVcmInfo().getVcmSession(), (Object)obj.getVcmInfo().getVcmIp());
            try {
                DeviceRequest deviceInfoRequest = new DeviceRequest();
                deviceInfoRequest.setSession(obj.getVcmInfo().getVcmSession());
                DeviceInfoRespond deviceInfoRespond = this.deviceService.getDeviceInfo(deviceInfoRequest);
                String deviceSn = deviceInfoRespond.getDeviceSn();
                if (this.subscribeStore.getAlarmSubInfo(obj.getVcmInfo().getVcmSession()) == null) {
                    DeviceRequest deviceRequest = new DeviceRequest();
                    deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
                    deviceRequest.setRequest((Object)this.alarmCallback);
                    this.subscribeService.subscribeAlarm(deviceRequest);
                    this.subscribeStore.addAlarmInfo(obj.getVcmInfo().getVcmSession(), obj.getVcmInfo());
                    LOGGER.info("Subscribe alarm success, session is {}, ip is {}", (Object)obj.getVcmInfo().getVcmSession(), (Object)obj.getVcmInfo().getVcmIp());
                }
                DeviceRequest request = new DeviceRequest();
                request.setSession(obj.getVcmInfo().getVcmSession());
                request.setRequest((Object)this.metadataCallback);
                long handle = this.subscribeService.subscribeMetadata(request);
                this.subscribeStore.add(obj.getVcmInfo().getVcmSession(), new SubscribeInfo(obj.getVcmInfo(), handle, deviceSn, ((SubscriptionRequest)obj.getRequestBody()).getDomainCode()));
                LOGGER.info("Subscribe metadata success, session is {}, ip is {}", (Object)obj.getVcmInfo().getVcmSession(), (Object)obj.getVcmInfo().getVcmIp());
                this.subscriptionHelp.add(((SubscriptionRequest)obj.getRequestBody()).getDomainCode(), obj.getVcmInfo(), null);
            }
            catch (IpcException e) {
                throw new InvokeException("500", e.getMessage());
            }
        }
        return true;
    }

    @SessionCheck
    public boolean delSubscribe(ParamBean<SubscriptionRequest> obj) {
        SubscribeInfo subscribeInfo = this.subscribeStore.get(obj.getVcmInfo().getVcmSession());
        if (subscribeInfo != null) {
            DeviceRequest request = new DeviceRequest();
            request.setSession(obj.getVcmInfo().getVcmSession());
            MetadataCancelRequest metadataCancelRequest = new MetadataCancelRequest();
            metadataCancelRequest.setPlayHandle(String.valueOf(subscribeInfo.getHandle()));
            request.setRequest((Object)metadataCancelRequest);
            this.subscribeService.cancelMetadata(request);
        }
        this.subscribeStore.remove(obj.getVcmInfo().getVcmSession());
        return true;
    }

    public boolean confirm(ParamBean<AlarmDealRequest> obj) {
        return false;
    }

    public boolean cancel(ParamBean<AlarmDealRequest> obj) {
        return false;
    }

    public PageRespond<AlarmSearchRespond> search(ParamBean<AlarmSearchRequest> obj) {
        return null;
    }

    public boolean register(VcmReqBaseInfo vcmReqBaseInfo, String url) {
        return false;
    }

    public String getRegisterUrlList(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return null;
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return null;
    }
}

