/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.sdk;

import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.DeviceAbilityRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.DeviceService;
import com.zkteco.zkbiosecurity.cuserver.service.AbilityService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SessionCheck;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="abilityServiceSdcSdkStrategy")
@SdcServiceType
public class AbilityServiceSdkSdcStrategy
implements AbilityService<IServerType.SDC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbilityServiceSdkSdcStrategy.class);
    @Autowired(required=false)
    private DeviceService deviceService;

    @SessionCheck
    public Map<String, Boolean> getAbility(ParamBean<ChannelRequest> obj) {
        DeviceRequest deviceRequest = new DeviceRequest();
        deviceRequest.setSession(obj.getVcmInfo().getVcmSession());
        try {
            DeviceAbilityRespond deviceAbility = this.deviceService.getDeviceAbility(deviceRequest);
            HashMap<String, Boolean> conditionMap = new HashMap<String, Boolean>();
            return conditionMap;
        }
        catch (IpcException e) {
            LOGGER.error("Get sdc ability fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E eTemplate, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(eTemplate);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

