/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.rest;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.SdcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.StreamingRequestSdc;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.StreamingService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.AbstractSdcService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.SdcReasonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="streamingServiceSdcRestStrategy")
@SdcServiceType(value=1)
public class StreamingServiceSdcRestStrategy
extends AbstractSdcService
implements StreamingService<IServerType.SDC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingServiceSdcRestStrategy.class);

    public JSONObject getCnsInfo(VcmReqBaseInfo vcmInfo) {
        try {
            JSONObject jsonObject = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)SdcMsgType.CNS_PAAS_GET, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(jsonObject);
            return jsonObject;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public JSONObject createSession(VcmReqBaseInfo vcmInfo, StreamingRequestSdc streamingRequestSdc) {
        try {
            JSONObject cnsInfo = this.getCnsInfo(vcmInfo);
            JSONObject cnsChnObj = cnsInfo.getJSONArray("CnsChnParam").getJSONObject(0);
            String uuid = cnsChnObj.getString("uuid");
            MsgType msgType = new MsgType(SdcMsgType.STREAMING_CREATE.getMethod(), SdcMsgType.STREAMING_CREATE.getUri() + "?Uuid=" + uuid);
            JSONObject jsonObject = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)msgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)streamingRequestSdc, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(jsonObject);
            return jsonObject;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public boolean deleteSession(VcmReqBaseInfo vcmInfo, StreamingRequestSdc streamingRequestSdc) {
        try {
            JSONObject cnsInfo = this.getCnsInfo(vcmInfo);
            JSONObject cnsChnObj = cnsInfo.getJSONArray("CnsChnParam").getJSONObject(0);
            String uuid = cnsChnObj.getString("uuid");
            MsgType msgType = new MsgType(SdcMsgType.STREAMING_DELETE.getMethod(), SdcMsgType.STREAMING_DELETE.getUri() + "?Uuid=" + uuid + "&SessionId=" + streamingRequestSdc.getSessionId());
            JSONObject jsonObject = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)msgType, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(jsonObject);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public boolean requestStreaming(VcmReqBaseInfo vcmInfo, StreamingRequestSdc streamingRequestSdc) {
        try {
            JSONObject cnsInfo = this.getCnsInfo(vcmInfo);
            JSONObject cnsChnObj = cnsInfo.getJSONArray("CnsChnParam").getJSONObject(0);
            String uuid = cnsChnObj.getString("uuid");
            MsgType msgType = new MsgType(SdcMsgType.STREAMING_PUT.getMethod(), SdcMsgType.STREAMING_PUT.getUri() + "?Uuid=" + uuid + "&SessionId=" + streamingRequestSdc.getSessionId());
            JSONObject jsonObject = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)msgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)streamingRequestSdc, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(jsonObject);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public JSONObject getCapability(VcmReqBaseInfo vcmInfo) {
        try {
            JSONObject jsonObject = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)SdcMsgType.STREAMING_CAPABILITY, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(jsonObject);
            return jsonObject;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

