/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.SdcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PresetPositionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PresetPositionRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.PresetPositionService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.AbstractSdcService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.SdcReasonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="presetPositionServiceSdcRestStrategy")
@SdcServiceType(value=1)
public class PresetPositionServiceSdcRestStrategy
extends AbstractSdcService
implements PresetPositionService<IServerType.SDC> {
    public PresetPositionRespond add(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        PresetPositionRespond positionRespond = new PresetPositionRespond();
        JSONObject requestJson = new JSONObject();
        requestJson.put("index", (Object)req.getPresetIndex());
        requestJson.put("name", (Object)req.getPresetName());
        requestJson.put("enableFocusInfo", (Object)req.getFocusSwitch());
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)SdcMsgType.PTZ_ADD_PRESET_POSITION_SDC_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(result);
            return positionRespond;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public PresetPositionRespond del(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        PresetPositionRespond positionRespond = new PresetPositionRespond();
        JSONObject requestJson = new JSONObject();
        requestJson.put("index", (Object)req.getPresetIndex());
        requestJson.put("name", (Object)req.getPresetName());
        requestJson.put("enableFocusInfo", (Object)req.getFocusSwitch());
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)SdcMsgType.PTZ_DEL_PRESET_POSITION_SDC_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(result);
            return positionRespond;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public PresetPositionRespond upt(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        PresetPositionRespond positionRespond = new PresetPositionRespond();
        JSONObject requestJson = new JSONObject();
        requestJson.put("index", (Object)req.getPresetIndex());
        requestJson.put("name", (Object)req.getPresetName());
        requestJson.put("enableFocusInfo", (Object)req.getFocusSwitch());
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)SdcMsgType.PTZ_UPT_PRESET_POSITION_SDC_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(result);
            return positionRespond;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public List<PresetPositionRespond> list(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        ArrayList<PresetPositionRespond> respondList = new ArrayList<PresetPositionRespond>();
        try {
            String result = (String)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)SdcMsgType.PTZ_GET_PRESET_POSITION_SDC_URI, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmInfo));
            JSONObject resultJson = JSON.parseObject((String)result);
            this.checkJsonRespond(resultJson);
            JSONArray presetList = resultJson.getJSONArray("presetList");
            if (!CollectionUtils.isEmpty((Collection)presetList)) {
                for (Object preset : presetList) {
                    PresetPositionRespond positionRespond = new PresetPositionRespond();
                    positionRespond.setPresetIndex(((JSONObject)preset).getIntValue("index"));
                    respondList.add(positionRespond);
                }
            }
            return respondList;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

