/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.rest;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.SdcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.bean.PTZCmdEnum;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.GuardPointSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PTZControlRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.PTZControlRequestSdc;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.bean.PTZCmdInfoSdc;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.GuardPointRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PTZControlRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.PTZService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.AbstractSdcService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.SdcReasonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="ptzServiceSdcRestStrategy")
@SdcServiceType(value=1)
public class PTZServiceSdcRestStrategy
extends AbstractSdcService
implements PTZService<IServerType.SDC> {
    public PTZControlRespond control(VcmReqBaseInfo vcmInfo, PTZControlRequest request) {
        PTZControlRequestSdc ptzControlRequestSdc = new PTZControlRequestSdc();
        if (PTZCmdEnum.PTZ_FAST_LOCATE.equals((Object)request.getPtzCmdEnum())) {
            JSONObject requestJson = new JSONObject();
            requestJson.put("opCode", (Object)33);
            requestJson.put("param1", (Object)(request.getX1() + "," + request.getY1()));
            requestJson.put("param2", (Object)(request.getX2() + "," + request.getY2()));
            return this.sendControl(vcmInfo, requestJson);
        }
        ptzControlRequestSdc = this.requestToSdc(request);
        return this.sendControl(vcmInfo, ptzControlRequestSdc);
    }

    public boolean setGuardPoint(ParamBean<GuardPointSetRequest> obj) {
        return false;
    }

    public GuardPointRespond getGuardPoint(ParamBean<ChannelRequest> obj) {
        return null;
    }

    private PTZControlRespond sendControl(VcmReqBaseInfo vcmInfo, JSONObject requestJson) {
        PTZControlRespond ptzControlRespond = new PTZControlRespond();
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)SdcMsgType.PTZ_CONTROL_SDC_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(result);
            ptzControlRespond.setResult("success");
            return ptzControlRespond;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    private PTZControlRespond sendControl(VcmReqBaseInfo vcmInfo, PTZControlRequestSdc ptzControlRequestSdc) {
        PTZControlRespond ptzControlRespond = new PTZControlRespond();
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)SdcMsgType.PTZ_CONTROL_SDC_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)ptzControlRequestSdc, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(result);
            ptzControlRespond.setResult("success");
            return ptzControlRespond;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    private PTZControlRequestSdc requestToSdc(PTZControlRequest request) {
        PTZControlRequestSdc ptzControlRequestSdc = new PTZControlRequestSdc();
        PTZCmdInfoSdc ptzCmdInfoSdc = new PTZCmdInfoSdc();
        Map cmdInfo = ptzCmdInfoSdc.getCmdInfoMap(request.getPtzCmdEnum().toString());
        if (StringUtils.isNotBlank((CharSequence)request.getMoveMode())) {
            cmdInfo.put("param1", Integer.parseInt(request.getMoveMode()));
        }
        if (null != request.getSpeed()) {
            cmdInfo.put("param2", request.getSpeed());
        }
        if (null != request.getPresetIndex()) {
            cmdInfo.put("param1", request.getPresetIndex());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getCruiseNo())) {
            cmdInfo.put("param1", Integer.parseInt(request.getCruiseNo()));
        }
        ptzControlRequestSdc.setParam1((Integer)cmdInfo.get("param1"));
        ptzControlRequestSdc.setParam2((Integer)cmdInfo.get("param2"));
        ptzControlRequestSdc.setOpCode((Integer)cmdInfo.get("opCode"));
        return ptzControlRequestSdc;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

