/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.SdcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.PeopleRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.SdcFaceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepository;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.People;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.PeopleSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.FaceRepositoryManagementService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.AbstractSdcService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import com.zkteco.zkbiosecurity.cuserver.utils.FileUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.SdcReasonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="faceRepositoryServiceSdcRestStrategy")
@SdcServiceType(value=1)
public class FaceRepositoryServiceSdcRestStrategy
extends AbstractSdcService
implements FaceRepositoryManagementService<IServerType.SDC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaceRepositoryServiceSdcRestStrategy.class);

    public boolean add(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        List faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepository);
        if (!CollectionUtils.isEmpty((Collection)faceRepositoryList)) {
            return true;
        }
        JSONObject requestJson = new JSONObject();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("libType", (Object)(Integer.parseInt(faceRepository.getType()) == 3 ? 2 : 1));
        jsonObject.put("threshold", (Object)(faceRepository.getThreshold() != null ? faceRepository.getThreshold() : 85));
        jsonObject.put("libName", (Object)faceRepository.getName());
        jsonObject.put("control", (Object)faceRepository.getControl());
        requestJson.put("facelib", (Object)jsonObject);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)SdcMsgType.ADD_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(result);
            return true;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public boolean update(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        List faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepository);
        if (CollectionUtils.isEmpty((Collection)faceRepositoryList)) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_REPOSITORY_NOT_EXIST);
        }
        if (StringUtils.isNotBlank((CharSequence)faceRepository.getNewName()) && this.isExistFaceRepository(vcmReqBaseInfo, faceRepository) && !faceRepository.getNewName().equals(faceRepository.getName())) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_REPOSITORY_EXIST);
        }
        FaceRepository repository = (FaceRepository)faceRepositoryList.get(0);
        JSONObject requestJson = new JSONObject();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("faceLibId", (Object)Integer.parseInt(repository.getGroupId()));
        jsonObject.put("libType", (Object)(Integer.parseInt(faceRepository.getType()) == 3 ? 2 : 1));
        jsonObject.put("threshold", (Object)(faceRepository.getThreshold() != null ? faceRepository.getThreshold() : 85));
        jsonObject.put("libName", (Object)faceRepository.getNewName());
        jsonObject.put("control", (Object)(faceRepository.getControl() != null ? faceRepository.getControl() : (short)0));
        requestJson.put("facelib", (Object)jsonObject);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)SdcMsgType.UPDATE_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(result);
            return true;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public boolean delete(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        List faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepository);
        if (CollectionUtils.isEmpty((Collection)faceRepositoryList)) {
            return true;
        }
        for (FaceRepository repository : faceRepositoryList) {
            JSONObject requestJson = new JSONObject();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("libName", (Object)repository.getName());
            requestJson.put("facelib", (Object)jsonObject);
            try {
                JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)SdcMsgType.DELETE_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
                this.checkJsonRespond(result);
            }
            catch (SDKException e) {
                throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
            }
        }
        return true;
    }

    public FaceRepositorySearchRespond search(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        FaceRepositorySearchRespond faceRepositorySearchRespond = new FaceRepositorySearchRespond();
        try {
            String result = (String)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)SdcMsgType.SEARCH_FACE_REPOSITORY_URI, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            JSONObject jsonObject = JSON.parseObject((String)result);
            this.checkJsonRespond(jsonObject);
            JSONArray jsonArray = jsonObject.getJSONArray("FaceListsArry");
            if (!CollectionUtils.isEmpty((Collection)jsonArray)) {
                for (Object object : jsonArray) {
                    FaceRepository face = new FaceRepository();
                    face.setName(((JSONObject)object).getString("FaceListName"));
                    face.setType(((JSONObject)object).getIntValue("FaceListType") == 2 ? "3" : "2");
                    face.setGroupId(((JSONObject)object).getString("ID"));
                    faceRepositorySearchRespond.getRepositories().add(face);
                }
                faceRepositorySearchRespond.setTotal(String.valueOf(faceRepositorySearchRespond.getRepositories().size()));
            }
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
        return faceRepositorySearchRespond;
    }

    public boolean addPeople(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        List pictures = people.getPictures();
        if (CollectionUtils.isEmpty((Collection)pictures)) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_NOT_PICTURE);
        }
        FaceRepositoryRequest faceRepositoryInfo = people.getFaceRepositoryInfo();
        List faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepositoryInfo);
        if (CollectionUtils.isEmpty((Collection)faceRepositoryList)) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_REPOSITORY_NOT_EXIST);
        }
        List peopleCommon = this.searchPeopleCommon(vcmReqBaseInfo, people);
        if (!CollectionUtils.isEmpty((Collection)peopleCommon)) {
            people.setId(((People)peopleCommon.get(0)).getId());
            return this.updatePeople(vcmReqBaseInfo, people);
        }
        JSONObject requestJson = new JSONObject();
        JSONObject jsonObject = new JSONObject();
        SdcFaceRequest faceRequest = people.toSdcFaceRequest();
        if (StringUtils.isBlank((CharSequence)faceRequest.getPicName())) {
            faceRequest.setPicName(System.currentTimeMillis() + ".jpg");
        }
        jsonObject.put("faceLibId", (Object)Integer.parseInt(((FaceRepository)faceRepositoryList.get(0)).getGroupId()));
        requestJson.put("facelib", (Object)jsonObject);
        requestJson.put("record", JSON.parse((String)JSON.toJSONString((Object)faceRequest)));
        String picture = (String)pictures.get(0);
        File file = FileUtil.base64ToImage((String)picture);
        try {
            String result = (String)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)SdcMsgType.ADD_PEOPLE_URI, (File)file, (String)requestJson.toJSONString(), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            JSONObject resultJson = JSON.parseObject((String)result);
            this.checkJsonRespond(resultJson);
            boolean bl = true;
            return bl;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
        finally {
            FileUtil.deleteFile((File)file);
        }
    }

    public boolean deletePeople(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest peopleRequest) {
        FaceRepositoryRequest faceRepositoryInfo = peopleRequest.getFaceRepositoryInfo();
        List faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepositoryInfo);
        if (CollectionUtils.isEmpty((Collection)faceRepositoryList)) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_REPOSITORY_NOT_EXIST);
        }
        if (StringUtils.isBlank((CharSequence)peopleRequest.getName())) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_NOT_NAME);
        }
        List peopleCommon = this.searchPeopleByName(vcmReqBaseInfo, peopleRequest);
        if (CollectionUtils.isEmpty((Collection)peopleCommon)) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_NOT_EXIST);
        }
        JSONObject requestJson = new JSONObject();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("faceLibId", (Object)Integer.parseInt(((FaceRepository)faceRepositoryList.get(0)).getGroupId()));
        requestJson.put("facelib", (Object)jsonObject);
        ArrayList<Integer> faceIds = new ArrayList<Integer>();
        for (People people : peopleCommon) {
            faceIds.add(Integer.parseInt(people.getId()));
        }
        requestJson.put("faceId", faceIds);
        requestJson.put("faceNum", (Object)faceIds.size());
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)SdcMsgType.DELETE_PEOPLE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(result);
            return true;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public PeopleSearchRespond searchPeople(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest peopleRequest) {
        FaceRepositoryRequest faceRepositoryInfo = peopleRequest.getFaceRepositoryInfo();
        List faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepositoryInfo);
        if (CollectionUtils.isEmpty((Collection)faceRepositoryList)) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_REPOSITORY_NOT_EXIST);
        }
        JSONObject requestJson = new JSONObject();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("faceLibId", (Object)Integer.parseInt(((FaceRepository)faceRepositoryList.get(0)).getGroupId()));
        requestJson.put("faceLib", (Object)jsonObject);
        SdcFaceRequest faceRequest = peopleRequest.toSdcFaceRequest();
        requestJson.put("condition", JSON.parse((String)JSON.toJSONString((Object)faceRequest)));
        requestJson.put("findNum", (Object)5000);
        requestJson.put("startIndex", (Object)0);
        PeopleSearchRespond peopleSearchRespond = new PeopleSearchRespond();
        try {
            String result = (String)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)SdcMsgType.SEARCH_PEOPLE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            JSONObject resultJson = JSON.parseObject((String)result);
            this.checkJsonRespond(resultJson);
            JSONArray faceRecordArry = resultJson.getJSONArray("faceRecordArry");
            for (Object object : faceRecordArry) {
                People people = new People();
                people.setId(((JSONObject)object).getString("id"));
                people.setName(((JSONObject)object).getString("name"));
                int gender = ((JSONObject)object).getIntValue("gender");
                people.setGender(gender == 2 ? "-1" : String.valueOf(gender));
                people.setBornTime(((JSONObject)object).getString("birthday"));
                int cardType = ((JSONObject)object).getIntValue("cardType");
                people.setCredentialType(cardType > 1 ? String.valueOf(cardType + 1) : String.valueOf(cardType));
                people.setCredentialNumber(((JSONObject)object).getString("cardId"));
                peopleSearchRespond.getPeopleList().add(people);
            }
            peopleSearchRespond.setTotal(String.valueOf(peopleSearchRespond.getPeopleList().size()));
            return peopleSearchRespond;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public boolean updatePeople(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        FaceRepositoryRequest faceRepositoryInfo = people.getFaceRepositoryInfo();
        List faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepositoryInfo);
        if (CollectionUtils.isEmpty((Collection)faceRepositoryList)) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_REPOSITORY_NOT_EXIST);
        }
        JSONObject requestJson = new JSONObject();
        JSONObject jsonObject = new JSONObject();
        SdcFaceRequest faceRequest = people.toSdcFaceRequest();
        jsonObject.put("faceLibId", (Object)Integer.parseInt(((FaceRepository)faceRepositoryList.get(0)).getGroupId()));
        requestJson.put("facelib", (Object)jsonObject);
        requestJson.put("record", JSON.parse((String)JSON.toJSONString((Object)faceRequest)));
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)SdcMsgType.UPDATE_PEOPLE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(result);
            return true;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public boolean repositoryUpdatePeopleBatch(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        return false;
    }

    public boolean getFaceImage(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest request) {
        return false;
    }

    public boolean replicateLibrary(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest request) {
        return false;
    }

    public List<FaceRepository> searchCommon(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        List<Object> faceRepositoryList = new ArrayList<FaceRepository>();
        FaceRepositorySearchRespond searchRespond = this.search(vcmReqBaseInfo, faceRepository);
        if (!CollectionUtils.isEmpty((Collection)searchRespond.getRepositories())) {
            faceRepositoryList = searchRespond.getRepositories();
            faceRepositoryList.removeIf(item -> !faceRepository.getName().equals(item.getName()));
        }
        return faceRepositoryList;
    }

    public boolean isExistFaceRepository(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        FaceRepositorySearchRespond searchRespond = this.search(vcmReqBaseInfo, faceRepository);
        if (!CollectionUtils.isEmpty((Collection)searchRespond.getRepositories())) {
            for (FaceRepository repository : searchRespond.getRepositories()) {
                if (!faceRepository.getNewName().equals(repository.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public List<People> searchPeopleCommon(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest peopleRequest) {
        List<Object> peopleList = new ArrayList<People>();
        PeopleSearchRespond peopleSearchRespond = this.searchPeople(vcmReqBaseInfo, peopleRequest);
        if (!CollectionUtils.isEmpty((Collection)peopleSearchRespond.getPeopleList())) {
            peopleList = peopleSearchRespond.getPeopleList();
        }
        return peopleList;
    }

    public List<People> searchPeopleByName(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest peopleRequest) {
        PeopleRequest people = new PeopleRequest();
        people.setName(peopleRequest.getName());
        people.setFaceRepositoryInfo(peopleRequest.getFaceRepositoryInfo());
        List<Object> peopleList = new ArrayList<People>();
        PeopleSearchRespond peopleSearchRespond = this.searchPeople(vcmReqBaseInfo, people);
        if (!CollectionUtils.isEmpty((Collection)peopleSearchRespond.getPeopleList())) {
            peopleList = peopleSearchRespond.getPeopleList();
        }
        return peopleList;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E eTemplate, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(eTemplate);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

