/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.rest;

import com.zkteco.zkbiosecurity.cuserver.contants.SdcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraAddRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRebootRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRemoveRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.PasswordUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraAddRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.sdc.SdcDeviceRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.ChannelStatusEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceManageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.SdcReasonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="deviceManageServiceSdcRestStrategy")
@SdcServiceType(value=1)
public class DeviceManageServiceSdcRestStrategy
implements DeviceManageService<IServerType.SDC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManageServiceSdcRestStrategy.class);

    public List<CameraRespond> listCamera(VcmReqBaseInfo vcmReqBaseInfo) {
        return null;
    }

    public List<ChannelRespond> listChannel(VcmReqBaseInfo vcmReqBaseInfo) {
        return null;
    }

    public ChannelRespond getChannel(ParamBean<ChannelRequest> obj) {
        return null;
    }

    public List<String> getEmptyChannel(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public boolean updateChannel(ParamBean<ChannelUpdateRequest> obj) {
        return false;
    }

    public List<ChannelRespond> listChannelsByCamera(VcmReqBaseInfo vcmReqBaseInfo, String cameraCode) {
        return null;
    }

    public CameraAddRespond addCamera(ParamBean<CameraAddRequest> obj) {
        SdcDeviceRespond sdcDeviceRespond = this.getSdcDevice(obj.getVcmInfo());
        CameraAddRespond cameraAddRespond = new CameraAddRespond();
        cameraAddRespond.setSdcDeviceRespond(sdcDeviceRespond);
        cameraAddRespond.setCameraCode(sdcDeviceRespond.getBarCode());
        cameraAddRespond.setModel(sdcDeviceRespond.getDevType());
        cameraAddRespond.setStatus(ChannelStatusEnum.ONLINE);
        cameraAddRespond.setImgType(0);
        cameraAddRespond.setName(((CameraAddRequest)obj.getRequestBody()).getName());
        int model = DeviceUtil.getModelType((String)sdcDeviceRespond.getDevType());
        cameraAddRespond.setCameraType(Ivs1800Utils.getCameraType((int)model));
        cameraAddRespond.setSerialNumber(sdcDeviceRespond.getDrvCode());
        cameraAddRespond.setChannelResponds(this.buildChannels(cameraAddRespond));
        return cameraAddRespond;
    }

    public boolean removeCamera(ParamBean<CameraRemoveRequest> obj) {
        return false;
    }

    public boolean updatePassword(ParamBean<PasswordUpdateRequest> obj) {
        return false;
    }

    public boolean rebootCamera(ParamBean<CameraRebootRequest> obj) {
        return false;
    }

    public SdcDeviceRespond getSdcDevice(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            SdcDeviceRespond sdcDeviceRespond = (SdcDeviceRespond)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)SdcMsgType.MISCLAAS_SYSTEM, (MsgToObjectConvertor)this.msgToObjectConvertor(null, SdcDeviceRespond.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)2);
            return sdcDeviceRespond;
        }
        catch (SDKException e) {
            LOGGER.error("get systemConfig happen exception ", (Throwable)e);
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    private List<ChannelRespond> buildChannels(CameraAddRespond cameraAddRespond) {
        ArrayList<ChannelRespond> channelResponds = new ArrayList<ChannelRespond>();
        ChannelRespond channelRespond = new ChannelRespond();
        channelRespond.setCategory(DeviceTypeEnum.CLOUD.val());
        channelRespond.setChannel(1);
        channelRespond.setChannelCode(cameraAddRespond.getCameraCode());
        channelRespond.setType(4);
        channelRespond.setVendor("HUAWEI");
        channelRespond.setCameraType(cameraAddRespond.getCameraType());
        channelRespond.setCameraName(cameraAddRespond.getName());
        channelRespond.setParentCode(cameraAddRespond.getCameraCode());
        channelRespond.setModel(cameraAddRespond.getModel());
        channelRespond.setProtocolType("HWSDK");
        channelRespond.setStatus(cameraAddRespond.getStatus());
        channelRespond.setFormType(1);
        channelResponds.add(channelRespond);
        return channelResponds;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

