/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.SdcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.CruiseRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseDetailRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseListRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.bean.CruisePoint;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.bean.CruiseTrack;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.CruiseService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.AbstractSdcService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.SdcReasonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="cruiseSdcService")
public class CruiseServiceSdcRestStrategy
extends AbstractSdcService
implements CruiseService<IServerType.SDC> {
    public JSONObject getCruiseNo(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        JSONObject result = new JSONObject();
        CruiseListRespond cruiseListRespond = this.list(vcmInfo, req);
        List cruiseTrackList = this.cruiseListRespondToCruiseTrackList(cruiseListRespond);
        if (!CollectionUtils.isEmpty((Collection)cruiseTrackList)) {
            for (CruiseTrack cruiseTrack : cruiseTrackList) {
                if (!req.getName().equals(cruiseTrack.getName())) continue;
                result.put("cruiseNo", (Object)cruiseTrack.getCruiseNo());
            }
        }
        if (result.get((Object)"cruiseNo") == null) {
            CruiseRespond cruiseRespond = this.add(vcmInfo, req);
            result.put("cruiseNo", (Object)cruiseRespond.getCruiseNo());
        }
        return result;
    }

    public CruiseRespond add(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseRespond cruiseRespond = new CruiseRespond();
        JSONObject requestJson = this.buildRequestJson(req);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)SdcMsgType.PTZ_ADD_CRUISE_SDC_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(result);
            return cruiseRespond;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public CruiseRespond upt(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseRespond cruiseRespond = new CruiseRespond();
        JSONObject requestJson = this.buildRequestJson(req);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)SdcMsgType.PTZ_UPT_CRUISE_SDC_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(result);
            return cruiseRespond;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public CruiseRespond del(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseRespond cruiseRespond = new CruiseRespond();
        JSONObject requestJson = this.buildRequestJson(req);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)SdcMsgType.PTZ_DEL_CRUISE_SDC_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(result);
            return cruiseRespond;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public CruiseListRespond list(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseListRespond cruiseListRespond = new CruiseListRespond();
        try {
            String result = (String)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)SdcMsgType.PTZ_LIST_CRUISE_SDC_URI, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmInfo));
            JSONObject resultJson = JSON.parseObject((String)result);
            this.checkJsonRespond(resultJson);
            return cruiseListRespond;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    public CruiseDetailRespond detail(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseDetailRespond cruiseRespond = new CruiseDetailRespond();
        JSONObject requestJson = this.buildRequestJson(req);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)SdcMsgType.PTZ_DEL_CRUISE_SDC_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(result);
            cruiseRespond.setCruiseInfo(result);
            return cruiseRespond;
        }
        catch (SDKException e) {
            throw new InvokeException("500", SdcReasonUtil.reasonHelper((SDKException)e));
        }
    }

    private JSONObject buildRequestJson(CruiseRequest cruiseRequest) {
        JSONObject requestJson = new JSONObject();
        JSONArray cruisePointList = new JSONArray();
        List cruisePoints = cruiseRequest.getCruisePoints();
        if (!CollectionUtils.isEmpty((Collection)cruisePoints)) {
            for (CruisePoint point : cruisePoints) {
                JSONObject cruisePointJSon = new JSONObject();
                cruisePointJSon.put("presetId", (Object)point.getPresetIndex());
                cruisePointJSon.put("dwellTime", (Object)point.getDwellTime());
                cruisePointJSon.put("speedLevel", (Object)point.getSpeed());
                cruisePointList.add((Object)cruisePointJSon);
            }
        }
        requestJson.put("id", (Object)cruiseRequest.getCruiseNo());
        requestJson.put("cruiseType", (Object)cruiseRequest.getCruiseType());
        requestJson.put("cruiseName", (Object)cruiseRequest.getName());
        requestJson.put("cruisePointNum", (Object)cruisePointList.size());
        requestJson.put("cruisePointList", (Object)cruisePointList);
        return requestJson;
    }

    private List<CruiseTrack> cruiseListRespondToCruiseTrackList(CruiseListRespond cruiseListRespond) {
        ArrayList<CruiseTrack> trackList = new ArrayList<CruiseTrack>();
        return trackList;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

