/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.help;

import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.FaceBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.GeneralBusinessBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.MetaEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.SituationAnalysisBean;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmCodeTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmLevelEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.MetaTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.ipc.callback.MetadataCallback;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.bean.event.CrosslineEvent;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.bean.event.DensityEvent;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.bean.event.FaceMatchEvent;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.bean.event.MetadataEvent;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.util.DateUtil;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.help.SubscribeInfo;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.help.SubscribeStore;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.sdk.SnapshotServiceSdcSdkStrategy;
import com.zkteco.zkbiosecurity.cuserver.utils.EventNameHelper;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Encoder;

@Component
public class SdcMetaCallback
implements MetadataCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(SdcMetaCallback.class);
    private static final Map<String, Integer> densityMap = new ConcurrentHashMap();
    private final Set<String> faceIds = new HashSet();
    @Autowired
    private SubscribeStore subscribeStore;
    @Autowired
    private WebSocketService webSocketService;
    @Autowired
    private SnapshotServiceSdcSdkStrategy snapshotServiceSdcSdkStrategy;

    public void processMetadata(MetadataEvent metadataEvent) {
        SubscribeInfo subscribeInfo = this.subscribeStore.get(metadataEvent.getSession());
        if (subscribeInfo != null) {
            LOGGER.debug("Received metadata , {}", (Object)metadataEvent.getSession());
            if (metadataEvent.getType() == 2) {
                LOGGER.debug("Received face metadata from session: {}", (Object)metadataEvent.getSession());
                FaceMatchEvent faceMatchEvent = (FaceMatchEvent)metadataEvent.getTarget();
                this.sendFaceMetaData(metadataEvent, faceMatchEvent, subscribeInfo);
            } else if (metadataEvent.getType() == 12) {
                DensityEvent densityEvent = (DensityEvent)metadataEvent.getTarget();
                Integer density = (Integer)densityMap.get(metadataEvent.getSession());
                int crowdDensity = densityEvent.getDensity();
                if (density == null || density != crowdDensity) {
                    AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
                    alarmEventRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_SITUATION_ANALYSIS.toString());
                    alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
                    alarmEventRespond.setChannelCode(subscribeInfo.getSn());
                    alarmEventRespond.setCode("ALARM_CROWD_DENSITY_DETECT");
                    alarmEventRespond.setDomainCode(subscribeInfo.getDomainCode());
                    alarmEventRespond.setFilterName("ALARM_CROWD_DENSITY_DETECT");
                    alarmEventRespond.setId(UUID.randomUUID().toString());
                    alarmEventRespond.setMetaType(MetaTypeEnum.NONE);
                    alarmEventRespond.setMsgId(UUID.randomUUID().toString());
                    alarmEventRespond.setName(EventNameHelper.getEventName((String)alarmEventRespond.getCode()));
                    SituationAnalysisBean situationAnalysisBean = new SituationAnalysisBean();
                    situationAnalysisBean.setLineFlag(false);
                    situationAnalysisBean.setNowInCount(0);
                    situationAnalysisBean.setNowOutCount(0);
                    VcmReqBaseInfo vcmReqBaseInfo = subscribeInfo.getVcmReqBaseInfo();
                    vcmReqBaseInfo.setVcmSession(metadataEvent.getSession());
                    String imgBase64Str = this.snapshotServiceSdcSdkStrategy.createSnapshot(vcmReqBaseInfo, null).getImgBase64Str();
                    situationAnalysisBean.setPanorama(imgBase64Str);
                    situationAnalysisBean.setPeopleCount(densityEvent.getDensity());
                    situationAnalysisBean.setSnapshot(imgBase64Str);
                    situationAnalysisBean.setTotalInCount(0);
                    situationAnalysisBean.setTotalOutCount(0);
                    alarmEventRespond.setSituationAnalysisBean(situationAnalysisBean);
                    alarmEventRespond.setStatus(0);
                    alarmEventRespond.setSuccess(true);
                    alarmEventRespond.setTime(DateUtil.dateToString((Date)new Date(), (String)"yyyyMMddHHmmss"));
                    alarmEventRespond.setType(EventTypeEnum.REALTIME_DATA);
                    this.webSocketService.send((BaseEventRespond)alarmEventRespond);
                    densityMap.put(metadataEvent.getSession(), crowdDensity);
                    return;
                }
                densityMap.put(metadataEvent.getSession(), crowdDensity);
            } else if (metadataEvent.getType() == 15) {
                CrosslineEvent crosslineEvent = (CrosslineEvent)metadataEvent.getTarget();
                AlarmEventRespond alarmEventRespond = this.alarmCommon(subscribeInfo.getDomainCode(), DateUtil.dateToString((Date)new Date(), (String)"yyyyMMddHHmmss"));
                alarmEventRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_SITUATION_ANALYSIS.toString());
                alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
                alarmEventRespond.setChannelCode(subscribeInfo.getSn());
                alarmEventRespond.setCode("ALARM_HUMAN_COUNT");
                alarmEventRespond.setDomainCode(subscribeInfo.getDomainCode());
                alarmEventRespond.setFilterName("ALARM_HUMAN_COUNT");
                alarmEventRespond.setId(UUID.randomUUID().toString());
                alarmEventRespond.setMetaType(MetaTypeEnum.NONE);
                alarmEventRespond.setMsgId(UUID.randomUUID().toString());
                alarmEventRespond.setName(EventNameHelper.getEventName((String)alarmEventRespond.getCode()));
                SituationAnalysisBean situationAnalysisBean = new SituationAnalysisBean();
                situationAnalysisBean.setLineFlag(false);
                situationAnalysisBean.setNowInCount(crosslineEvent.getIncrementIn());
                situationAnalysisBean.setNowOutCount(crosslineEvent.getIncrementOut());
                situationAnalysisBean.setPanorama(null);
                situationAnalysisBean.setPeopleCount(0);
                situationAnalysisBean.setTotalInCount(crosslineEvent.getTotalIn());
                situationAnalysisBean.setTotalOutCount(crosslineEvent.getTotalOut());
                alarmEventRespond.setSituationAnalysisBean(situationAnalysisBean);
                alarmEventRespond.setStatus(0);
                alarmEventRespond.setSuccess(true);
                alarmEventRespond.setTime(DateUtil.dateToString((Date)new Date(), (String)"yyyyMMddHHmmss"));
                this.webSocketService.send((BaseEventRespond)alarmEventRespond);
            }
        }
    }

    private void sendFaceMetaData(MetadataEvent metadataEvent, FaceMatchEvent faceMatchEvent, SubscribeInfo subscribeInfo) {
        FaceBean faceBean = new FaceBean();
        if (this.faceIds.contains(faceMatchEvent.getFaceId())) {
            if (Objects.isNull(faceMatchEvent.getFaceLibRecordId())) {
                return;
            }
        } else {
            if (this.faceIds.size() > 50) {
                this.faceIds.clear();
            }
            this.faceIds.add(faceMatchEvent.getFaceId());
        }
        faceBean.setGenderCode(String.valueOf(faceMatchEvent.getGender()));
        faceBean.setAge(faceMatchEvent.getAge());
        faceBean.setExpression(String.valueOf(faceMatchEvent.getExpression()));
        faceBean.setHair("-1");
        faceBean.setHat("-1");
        faceBean.setGlassType(String.valueOf(faceMatchEvent.getGlasses()));
        faceBean.setMouthMask(String.valueOf(faceMatchEvent.getMouseMask()));
        faceBean.setMustache("-1");
        BASE64Encoder encoder = new BASE64Encoder();
        faceBean.setSnapshot(encoder.encode(faceMatchEvent.getFacePic()));
        faceBean.setPanorama(encoder.encode(faceMatchEvent.getFacePanorama()));
        MetaEventRespond metaEventRespond = new MetaEventRespond();
        metaEventRespond.setType(EventTypeEnum.META_DATA);
        metaEventRespond.setTime(DateUtil.dateToString((Date)new Date(), (String)"yyyyMMddHHmmss"));
        metaEventRespond.setDomainCode(subscribeInfo.getDomainCode());
        metaEventRespond.setChannelCode(subscribeInfo.getSn());
        metaEventRespond.setMetaType(MetaTypeEnum.FACE);
        metaEventRespond.setFaceBean(faceBean);
        LOGGER.debug("Try send face data, {}", (Object)metaEventRespond.toJSON());
        this.webSocketService.send((BaseEventRespond)metaEventRespond);
        AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
        alarmEventRespond.setType(EventTypeEnum.ALARM);
        alarmEventRespond.setTime(DateUtil.dateToString((Date)new Date(), (String)"yyyyMMddHHmmss"));
        alarmEventRespond.setDomainCode(subscribeInfo.getDomainCode());
        alarmEventRespond.setChannelCode(subscribeInfo.getSn());
        alarmEventRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_FACE.toString());
        alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
        faceBean.setTargetName(faceMatchEvent.getName());
        faceBean.setTargetId(faceMatchEvent.getCardId());
        faceBean.setTargetCredentialNumber(faceMatchEvent.getCardId());
        faceBean.setGroupName(faceMatchEvent.getLibName());
        faceBean.setGroupType(String.valueOf(faceMatchEvent.getFaceLibType() + 1));
        faceBean.setSimilarityDegree((double)faceMatchEvent.getFaceMatchRate() * 0.01);
        if (Objects.nonNull(faceMatchEvent.getFacePicInLib())) {
            faceBean.setMatchedImage(encoder.encode(faceMatchEvent.getFacePicInLib()));
        }
        alarmEventRespond.setMetaType(MetaTypeEnum.FACE);
        String type = faceMatchEvent.getFaceMatchRate() == 0 ? "ALARM_FACE_DETECTION" : Ivs1800Utils.getEventCode((String)faceBean.getGroupType());
        GeneralBusinessBean generalBusinessBean = new GeneralBusinessBean();
        generalBusinessBean.setSnapshot(faceBean.getSnapshot());
        generalBusinessBean.setPanorama(faceBean.getPanorama());
        alarmEventRespond.setFaceBean(faceBean);
        alarmEventRespond.setStatus(1);
        alarmEventRespond.setCode(type);
        alarmEventRespond.setName(EventNameHelper.getEventName((String)alarmEventRespond.getCode()));
        alarmEventRespond.setId(UUID.randomUUID().toString());
        this.webSocketService.send((BaseEventRespond)alarmEventRespond);
    }

    public AlarmEventRespond alarmCommon(String domainCode, String time) {
        AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
        alarmEventRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_SITUATION_ANALYSIS.toString());
        alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
        alarmEventRespond.setType(EventTypeEnum.ALARM);
        alarmEventRespond.setTime(time);
        alarmEventRespond.setDomainCode(domainCode);
        alarmEventRespond.setId(UUID.randomUUID().toString());
        alarmEventRespond.setStatus(1);
        alarmEventRespond.setMetaType(MetaTypeEnum.NONE);
        alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
        return alarmEventRespond;
    }

    public static void removeDensityMapBySession(String session) {
        if (densityMap.containsKey(session)) {
            densityMap.remove(session);
        }
    }
}

