/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.help;

import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BehaviorBean;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmCodeTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmLevelEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.MetaTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.ipc.callback.AlarmCallback;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.bean.event.AlarmEvent;
import com.zkteco.zkbiosecurity.cuserver.ipc.enums.AlarmActionType;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.util.DateUtil;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.help.SubscribeInfo;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.help.SubscribeStore;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.strategy.sdk.SnapshotServiceSdcSdkStrategy;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.EventNameHelper;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SdcAlarmCallback
implements AlarmCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(SdcAlarmCallback.class);
    @Autowired
    private SubscribeStore subscribeStore;
    @Autowired
    private WebSocketService webSocketService;
    @Autowired
    private SnapshotServiceSdcSdkStrategy snapshotServiceSdcSdkStrategy;

    public void processAlarm(AlarmEvent alarmEvent) {
        SubscribeInfo subscribeInfo = this.subscribeStore.get(alarmEvent.getSession());
        if (subscribeInfo != null) {
            LOGGER.debug("Received alarm event , {}", (Object)alarmEvent);
            int type = alarmEvent.getType();
            AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
            if (alarmEvent.getAction() == AlarmActionType.HAPPEN) {
                switch (type) {
                    case 4: {
                        alarmEventRespond.setCode("ALARM_MOVE");
                        alarmEventRespond.setFilterName("ALARM_MOVE");
                        break;
                    }
                    case 6: {
                        alarmEventRespond.setCode("SDC_ALARM_SHIELD");
                        alarmEventRespond.setFilterName("SDC_ALARM_SHIELD");
                        break;
                    }
                    case 14: {
                        alarmEventRespond.setCode("ALARM_TRIP_LINE");
                        alarmEventRespond.setFilterName("ALARM_TRIP_LINE");
                        break;
                    }
                    case 15: {
                        alarmEventRespond.setCode("ALARM_BEHAVIOR_ANALYSIS_INVASION");
                        alarmEventRespond.setFilterName("ALARM_BEHAVIOR_ANALYSIS_INVASION");
                        break;
                    }
                    case 16: {
                        alarmEventRespond.setCode("ALARM_BEHAVIOR_ANALYSIS_WANDER");
                        alarmEventRespond.setFilterName("ALARM_BEHAVIOR_ANALYSIS_WANDER");
                        break;
                    }
                    case 17: {
                        alarmEventRespond.setCode("ALARM_OBJECT_ABANDONED");
                        alarmEventRespond.setFilterName("ALARM_OBJECT_ABANDONED");
                        break;
                    }
                    case 18: {
                        alarmEventRespond.setCode("ALARM_OBJECT_REMOVAL");
                        alarmEventRespond.setFilterName("ALARM_OBJECT_REMOVAL");
                        break;
                    }
                    case 102: {
                        alarmEventRespond.setCode("ALARM_BEHAVIOR_ANALYSIS_ENTER");
                        alarmEventRespond.setFilterName("ALARM_BEHAVIOR_ANALYSIS_ENTER");
                        break;
                    }
                    case 103: {
                        alarmEventRespond.setCode("ALARM_BEHAVIOR_ANALYSIS_EXIT");
                        alarmEventRespond.setFilterName("ALARM_BEHAVIOR_ANALYSIS_EXIT");
                        break;
                    }
                    case 104: {
                        alarmEventRespond.setCode("ALARM_BEHAVIOR_ANALYSIS_FASTMOVE");
                        alarmEventRespond.setFilterName("ALARM_BEHAVIOR_ANALYSIS_FASTMOVE");
                        break;
                    }
                    case 107: {
                        alarmEventRespond.setCode("ALARM_SCENE_CHANGE");
                        alarmEventRespond.setFilterName("ALARM_SCENE_CHANGE");
                        break;
                    }
                    case 110: {
                        alarmEventRespond.setCode("ALARM_SDC_CROWD_ANALYSIS");
                        alarmEventRespond.setFilterName("ALARM_SDC_CROWD_ANALYSIS");
                        break;
                    }
                }
                alarmEventRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_BEHAVIOR.toString());
                alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
                BehaviorBean behaviorBean = new BehaviorBean();
                behaviorBean.setLineFlag(false);
                VcmReqBaseInfo vcmReqBaseInfo = subscribeInfo.getVcmReqBaseInfo();
                vcmReqBaseInfo.setVcmSession(alarmEvent.getSession());
                String imgBase64Str = this.snapshotServiceSdcSdkStrategy.createSnapshot(vcmReqBaseInfo, null).getImgBase64Str();
                behaviorBean.setPanorama(imgBase64Str);
                behaviorBean.setSnapshot(imgBase64Str);
                alarmEventRespond.setBehaviorBean(behaviorBean);
                alarmEventRespond.setChannelCode(subscribeInfo.getSn());
                alarmEventRespond.setDomainCode(subscribeInfo.getDomainCode());
                alarmEventRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)alarmEventRespond.getCode()));
                alarmEventRespond.setName(EventNameHelper.getEventName((String)alarmEventRespond.getCode()));
                alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
                alarmEventRespond.setId(UUID.randomUUID().toString());
                alarmEventRespond.setMetaType(MetaTypeEnum.BEHAVIOR);
                alarmEventRespond.setMsgId(UUID.randomUUID().toString());
                alarmEventRespond.setName(EventNameHelper.getEventName((String)alarmEventRespond.getCode()));
                alarmEventRespond.setStatus(0);
                alarmEventRespond.setSuccess(true);
                alarmEventRespond.setTime(DateUtil.dateToString((Date)new Date(), (String)"yyyyMMddHHmmss"));
                alarmEventRespond.setType(EventTypeEnum.ALARM);
                this.webSocketService.send((BaseEventRespond)alarmEventRespond);
            }
        }
    }

    public AlarmEventRespond alarmCommon(String domainCode, String time) {
        AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
        alarmEventRespond.setType(EventTypeEnum.ALARM);
        alarmEventRespond.setTime(time);
        alarmEventRespond.setDomainCode(domainCode);
        alarmEventRespond.setId(UUID.randomUUID().toString());
        alarmEventRespond.setStatus(1);
        alarmEventRespond.setMetaType(MetaTypeEnum.NONE);
        alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
        return alarmEventRespond;
    }
}

