/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config;

import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.session.SdcSessionStoreService;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
class SessionCheckAspect {
    private static final Logger log = LoggerFactory.getLogger(SessionCheckAspect.class);
    @Autowired
    private SdcSessionStoreService sdcSessionStoreService;

    SessionCheckAspect() {
    }

    @Pointcut(value="@annotation(com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SessionCheck)")
    public void checkPointCut() {
    }

    @Around(value="checkPointCut()")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object[] args = proceedingJoinPoint.getArgs();
        Signature signature = proceedingJoinPoint.getSignature();
        if (!(signature instanceof MethodSignature)) {
            return proceedingJoinPoint.proceed(args);
        }
        for (Object arg : args) {
            if (arg instanceof VcmReqBaseInfo) {
                VcmReqBaseInfo vcmReqBaseInfo = (VcmReqBaseInfo)arg;
                String session = this.sdcSessionStoreService.getByVcmInfo(vcmReqBaseInfo);
                if (StringUtils.isBlank((CharSequence)session)) {
                    throw new InvokeException("500", "no_login");
                }
                vcmReqBaseInfo.setVcmSession(session);
            }
            if (!(arg instanceof ParamBean)) continue;
            ParamBean paramBean = (ParamBean)arg;
            VcmReqBaseInfo vcmInfo = paramBean.getVcmInfo();
            String session = this.sdcSessionStoreService.getByVcmInfo(vcmInfo);
            if (StringUtils.isBlank((CharSequence)session)) {
                throw new InvokeException("500", "no_login");
            }
            vcmInfo.setVcmSession(session);
            paramBean.setVcmInfo(vcmInfo);
        }
        return proceedingJoinPoint.proceed(args);
    }
}

