/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.onvif;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChangePasswordRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.LoginRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.onvif.Device;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.user.LoginRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.UserManageService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.onvif.AbstractOnvifService;
import com.zkteco.zkbiosecurity.cuserver.utils.OnvifUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToXmlMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XmlMsgToObjectConvertor;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="UserManageOnvifServiceImpl")
public class UserManageOnvifServiceImpl
extends AbstractOnvifService
implements UserManageService<IServerType.Onvif> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserManageOnvifServiceImpl.class);

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToXmlMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new XmlMsgToObjectConvertor(cClass);
    }

    public boolean firstLogin(ParamBean<EmptyRequest> obj) {
        return false;
    }

    public String getModel(VcmReqBaseInfo vcmReqBaseInfo) {
        return null;
    }

    public LoginRespond login(ParamBean<LoginRequest> obj) {
        LoginRespond respond = new LoginRespond();
        try {
            VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
            vcmReqBaseInfo.setVcmIp("http://" + vcmReqBaseInfo.getVcmIp() + ":" + vcmReqBaseInfo.getVcmPort() + "/onvif/device_service");
            String ret = OnvifUtils.getPostString((VcmReqBaseInfo)vcmReqBaseInfo, (String)vcmReqBaseInfo.getVcmIp(), (String)"getCapabilities.xml", (String[])new String[0]);
            JSONObject dataObject = OnvifUtils.xml2Json((String)ret).getJSONObject("Body").getJSONObject("GetCapabilitiesResponse").getJSONObject("Capabilities");
            Device device = new Device();
            LOGGER.info("get capabilities data: {}", (Object)dataObject);
            device.setTime(LocalDateTime.now());
            device.setServiceUrl(dataObject.getJSONObject("Device").getJSONObject("XAddr").getString("XAddr"));
            if (Objects.nonNull(dataObject.getJSONObject("Media"))) {
                device.setMediaUrl(dataObject.getJSONObject("Media").getJSONObject("XAddr").getString("XAddr"));
            }
            if (Objects.nonNull(dataObject.getJSONObject("PTZ"))) {
                device.setPtzUrl(dataObject.getJSONObject("PTZ").getJSONObject("XAddr").getString("XAddr"));
            }
            if (Objects.nonNull(dataObject.getJSONObject("Events"))) {
                device.setEventUrl(dataObject.getJSONObject("Events").getJSONObject("XAddr").getString("XAddr"));
                device.setPullEventSupport(dataObject.getJSONObject("Events").getJSONObject("WSPullPointSupport").getBooleanValue("WSPullPointSupport"));
                device.setPushEventSupport(dataObject.getJSONObject("Events").getJSONObject("WSSubscriptionPolicySupport").getBooleanValue("WSSubscriptionPolicySupport"));
            }
            vcmReqBaseInfo.setVcmIp(device.getServiceUrl());
            String deviceInfo = OnvifUtils.getPostString((VcmReqBaseInfo)vcmReqBaseInfo, (String)device.getServiceUrl(), (String)"getDeviceInformation.xml", (String[])new String[0]);
            JSONObject data = OnvifUtils.xml2Json((String)deviceInfo);
            LOGGER.info("get device info data: {}", (Object)data);
            respond.setVmSession(UUID.randomUUID().toString().replaceAll("-", ""));
            JSONObject response = data.getJSONObject("Body").getJSONObject("GetDeviceInformationResponse");
            if (Objects.nonNull(response)) {
                if (Objects.nonNull(response.getJSONObject("FirmwareVersion"))) {
                    respond.setDeviceVersion(response.getJSONObject("FirmwareVersion").getString("FirmwareVersion"));
                }
                if (Objects.nonNull(response.getJSONObject("Model"))) {
                    respond.setModel(response.getJSONObject("Model").getString("Model"));
                }
            }
            OnvifUtils.setDevice((String)respond.getVmSession(), (Device)device);
            return respond;
        }
        catch (Exception e) {
            LOGGER.error("onvif login error", (Throwable)e);
            throw new InvokeException("500", "login_fail");
        }
    }

    public boolean logout(VcmReqBaseInfo vcmReqBaseInfo) {
        OnvifUtils.delDevice((String)vcmReqBaseInfo.getVcmSession());
        return true;
    }

    public boolean keepAlive(ParamBean<EmptyRequest> obj) {
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        Device device = OnvifUtils.getDevice((String)vcmReqBaseInfo.getVcmSession());
        if (device == null) {
            throw new InvokeException("500", "cu_offline_error");
        }
        vcmReqBaseInfo.setVcmIp(device.getServiceUrl());
        String ret = null;
        try {
            ret = OnvifUtils.getPostString((VcmReqBaseInfo)vcmReqBaseInfo, (String)device.getServiceUrl(), (String)"getDeviceInformation.xml", (String[])new String[0]);
        }
        catch (SDKException e) {
            OnvifUtils.delDevice((String)vcmReqBaseInfo.getVcmSession());
            throw new InvokeException("500", e.getMessage());
        }
        device.setTime(LocalDateTime.now());
        OnvifUtils.setDevice((String)vcmReqBaseInfo.getVcmSession(), (Device)device);
        return true;
    }

    public boolean firstChange(ParamBean<ChangePasswordRequest> obj) {
        return false;
    }
}

