/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.onvif;

import com.zkteco.zkbiosecurity.cuserver.contants.OnvifMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.SystemConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.TimeConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.onvif.Device;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.TimeConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.SystemConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SystemConfigService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.onvif.AbstractOnvifService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.OnvifUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToXmlMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XmlMsgToObjectConvertor;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SystemConfigOnvifServiceImpl
extends AbstractOnvifService
implements SystemConfigService<IServerType.Onvif> {
    private static final Logger log = LoggerFactory.getLogger(SystemConfigOnvifServiceImpl.class);

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToXmlMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new XmlMsgToObjectConvertor(cClass);
    }

    public boolean setTimeConfig(ParamBean<TimeConfigRequest> obj) {
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        Device device = OnvifUtils.getDevice((String)vcmReqBaseInfo.getVcmSession());
        if (device == null) {
            throw new InvokeException("500", "cu_offline_error");
        }
        LocalDateTime dateTime = LocalDateTime.parse(((TimeConfigRequest)obj.getRequestBody()).getTime(), DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        vcmReqBaseInfo.setVcmIp(device.getServiceUrl());
        String xml = OnvifUtils.getPostStringByVcmInfo((String)"setSystemDateAndTime.xml", (VcmReqBaseInfo)vcmReqBaseInfo, (String[])new String[]{String.valueOf(dateTime.getYear()), String.valueOf(dateTime.getMonth().getValue()), String.valueOf(dateTime.getDayOfMonth()), String.valueOf(dateTime.getHour()), String.valueOf(dateTime.getMinute()), String.valueOf(dateTime.getSecond())});
        try {
            String string = (String)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)OnvifMsgType.DEVICE_EMPTY, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)xml, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getHeaders(vcmReqBaseInfo));
        }
        catch (SDKException e) {
            log.error("onvif set time config error", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        return true;
    }

    public TimeConfigRespond getDateConfig(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public boolean setSystemConfig(ParamBean<SystemConfigRequest> obj) {
        return false;
    }

    public SystemConfigRespond getSystemConfig(ParamBean<EmptyRequest> obj) {
        return null;
    }
}

