/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.onvif;

import com.zkteco.zkbiosecurity.cuserver.contants.OnvifMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.SnapshotRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.onvif.Device;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.SnapshotRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SnapshotService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.onvif.AbstractOnvifService;
import com.zkteco.zkbiosecurity.cuserver.utils.FileUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.OnvifUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToXmlMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XmlMsgToObjectConvertor;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="snapshotOnvifServiceImpl")
public class SnapshotOnvifServiceImpl
extends AbstractOnvifService
implements SnapshotService<IServerType.Onvif> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotOnvifServiceImpl.class);

    public SnapshotRespond createSnapshot(VcmReqBaseInfo vcmReqBaseInfo, SnapshotRequest req) throws SDKException {
        SnapshotRespond snapshotRespond = new SnapshotRespond();
        Device device = OnvifUtils.getDevice((String)vcmReqBaseInfo.getVcmSession());
        if (device == null) {
            throw new InvokeException("500", "cu_offline_error");
        }
        List<String> tokenList = Arrays.asList(StringUtils.split((String)req.getChannelCode(), (String)"&"));
        String xml = OnvifUtils.getPostString((VcmReqBaseInfo)vcmReqBaseInfo, (String)device.getMediaUrl(), (String)"getSnapshotUri.xml", (String[])new String[]{tokenList.get(0)});
        if (StringUtils.isNotBlank((CharSequence)xml)) {
            String url = this.getSnapshotUri(xml);
            if (OnvifUtils.isImageURL((String)url)) {
                snapshotRespond.setImgBase64Str(OnvifUtils.download((String)url));
            } else {
                URL u = null;
                try {
                    u = new URL(url);
                    String ip = u.getProtocol() + "://" + u.getHost() + ":" + vcmReqBaseInfo.getVcmPort();
                    vcmReqBaseInfo.setVcmIp(ip);
                    List headerList = this.getHeaders(vcmReqBaseInfo);
                    CloseableHttpResponse result = (CloseableHttpResponse)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new OnvifMsgType(HttpMethodEnum.HTTP_METHOD_GET, u.getFile()), (MsgToObjectConvertor)new XmlMsgToObjectConvertor(CloseableHttpResponse.class), (List)headerList);
                    String contentFromInputStream = FileUtil.getContentFromInputStream((InputStream)result.getEntity().getContent(), (CloseableHttpResponse)result);
                    snapshotRespond.setImgBase64Str(contentFromInputStream);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return snapshotRespond;
    }

    private String getSnapshotUri(String xml) {
        return OnvifUtils.xml2Json((String)xml).getJSONObject("Body").getJSONObject("GetSnapshotUriResponse").getJSONObject("MediaUri").getJSONObject("Uri").getString("Uri");
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToXmlMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new XmlMsgToObjectConvertor(cClass);
    }
}

