/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.onvif;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPPlayBackRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPRealPlayRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVideoDownloadRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVoiceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.onvif.Device;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPPlayBackRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPRealPlayRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVideoDownloadRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVoiceRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.RTSPService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.onvif.AbstractOnvifService;
import com.zkteco.zkbiosecurity.cuserver.utils.OnvifUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToXmlMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XmlMsgToObjectConvertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="RTSPOnvifServiceImpl")
public class RTSPOnvifServiceImpl
extends AbstractOnvifService
implements RTSPService<IServerType.Onvif> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RTSPOnvifServiceImpl.class);
    private static final String RTSP_RECORDING_HIKVISION = "rtsp://%s:%s@%s:%s/Streaming/tracks/%s%s/?starttime=%sz&endtime=%sz";
    private static final String RTSP_RECORDING_DHNVR = "rtsp://%s:%s@%s:%s/cam/playback?channel=%s&subtype=%s&starttime=%s&endtime=%s&proto=Onvif";
    private static final String RTSP_RECORDING_ZKNVR = "rtsp://%s:%s@%s/recording?ch=%s&stream=%s&start=%s&stop=%s";
    private static final String RTSP_RECORDING_NVR800 = "rtsp://%s:%s@%s:%s/rtsp/playback?channel=%s&subtype=%s&starttime=%sZ&endtime=%sZ&metadata=true&extensions=true";

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToXmlMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new XmlMsgToObjectConvertor(cClass);
    }

    public RTSPRealPlayRespond realPlay(VcmReqBaseInfo vcmInfo, RTSPRealPlayRequest request) {
        try {
            Device device = OnvifUtils.getDevice((String)vcmInfo.getVcmSession());
            if (device == null) {
                throw new InvokeException("500", "cu_offline_error");
            }
            RTSPRealPlayRespond rtspRealPlayRespond = new RTSPRealPlayRespond();
            ArrayList<JSONObject> rtspUrls = new ArrayList<JSONObject>();
            List<String> tokenList = Arrays.asList(StringUtils.split((String)request.getChannelCode(), (String)"&"));
            vcmInfo.setVcmIp(device.getMediaUrl());
            for (int i = 0; i < tokenList.size(); ++i) {
                JSONObject rtspUrl = new JSONObject();
                String result = OnvifUtils.getPostString((VcmReqBaseInfo)vcmInfo, (String)vcmInfo.getVcmIp(), (String)"getStreamUri.xml", (String[])new String[]{tokenList.get(i)});
                String uri = OnvifUtils.getStreamUri((String)result);
                if (!StringUtils.isNotBlank((CharSequence)uri)) continue;
                rtspUrl.put("rtspUrl", (Object)("rtsp://" + vcmInfo.getSdcUserName() + ":" + vcmInfo.getSdcPassword() + "@" + uri.split("//")[1]));
                rtspUrl.put("type", (Object)(i == 0 ? 1 : 2));
                rtspUrls.add(rtspUrl);
            }
            rtspRealPlayRespond.setRtspUrls(rtspUrls);
            return rtspRealPlayRespond;
        }
        catch (Exception e) {
            LOGGER.error("onvif login error", (Throwable)e);
            if (e instanceof SDKException) {
                JSONObject result = OnvifUtils.xml2Json((String)e.getMessage());
                throw new InvokeException("500", result.getJSONObject("Body").getJSONObject("Fault").getJSONObject("Reason").getJSONObject("Text").getString("Text"));
            }
            throw new InvokeException("500", e.getMessage());
        }
    }

    public RTSPPlayBackRespond playBack(VcmReqBaseInfo vcmInfo, RTSPPlayBackRequest request) {
        String rtspUrl = null;
        String[] channelCodes = request.getChannelCode().split("&");
        switch (request.getVendor()) {
            case "0": {
                break;
            }
            case "2": {
                rtspUrl = String.format(RTSP_RECORDING_NVR800, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), "443", Integer.valueOf(channelCodes[0].split("_")[1]) + 1, request.getType() == 1 ? 0 : 1, request.getStartDate().replaceAll(" ", "T"), request.getEndDate().replaceAll(" ", "T"));
                break;
            }
            case "7": {
                rtspUrl = String.format(RTSP_RECORDING_ZKNVR, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), Integer.valueOf(channelCodes[0].substring(2)), request.getType() == 1 ? 0 : 1, request.getStartDate().replaceAll("-", "").replaceAll(":", "").replaceAll(" ", ""), request.getEndDate().replaceAll("-", "").replaceAll(":", "").replaceAll(" ", ""));
                break;
            }
            case "10": {
                rtspUrl = String.format(RTSP_RECORDING_HIKVISION, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), "554", Integer.valueOf(channelCodes[0].substring(12)), "01", request.getStartDate().replaceAll("-", "").replaceAll(":", "").replaceAll(" ", "t"), request.getEndDate().replaceAll("-", "").replaceAll(":", "").replaceAll(" ", "t"));
                break;
            }
            case "14": {
                rtspUrl = String.format(RTSP_RECORDING_DHNVR, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), "554", Integer.valueOf(channelCodes[0].substring(12, 15)) + 1, request.getType() == 1 ? 0 : 1, request.getStartDate().replaceAll("-", "_").replaceAll(":", "_").replaceAll(" ", "_"), request.getEndDate().replaceAll("-", "_").replaceAll(":", "_").replaceAll(" ", "_"));
                break;
            }
        }
        RTSPPlayBackRespond rtspPlayBackRespond = new RTSPPlayBackRespond();
        ArrayList<JSONObject> playBackRtspUrls = new ArrayList<JSONObject>();
        JSONObject playBackRtspUrl = new JSONObject();
        playBackRtspUrl.put("type", (Object)request.getType());
        playBackRtspUrl.put("rtspUrl", rtspUrl);
        playBackRtspUrls.add(playBackRtspUrl);
        rtspPlayBackRespond.setRtspUrls(playBackRtspUrls);
        return rtspPlayBackRespond;
    }

    public RTSPVoiceRespond voice(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        return null;
    }

    public RTSPVoiceRespond broadcast(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        return null;
    }

    public RTSPVideoDownloadRespond videoDownload(VcmReqBaseInfo vcmInfo, RTSPVideoDownloadRequest request) {
        return null;
    }
}

