/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.onvif;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.OnvifMsgType;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrConstants;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.SnapshotRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.onvif.Device;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.SnapshotRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmCodeTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmLevelEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.MetaTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.util.DateUtil;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.SnapshotZKNvrServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.EventNameHelper;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.OnvifUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToXmlMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XmlMsgToObjectConvertor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvenOnvifGetThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvenOnvifGetThread.class);
    private final String domainCode;
    private String url;
    private Integer sequence;
    private Integer lapNumber;
    private final WebSocketService webSocketService;
    private final SubscriptionHelp subscriptionHelp;
    private final SnapshotZKNvrServiceImpl snapshotZKNvrService;

    public EvenOnvifGetThread(String domainCode, String ip, String url) {
        super("ONVIF-" + ip + "-eventThread");
        this.domainCode = domainCode;
        this.webSocketService = (WebSocketService)SpringContextUtil.getBean((String)"webSocketService");
        this.subscriptionHelp = (SubscriptionHelp)SpringContextUtil.getBean((String)"subscriptionHelp");
        this.snapshotZKNvrService = (SnapshotZKNvrServiceImpl)SpringContextUtil.getBean((String)"snapshotZKNvrServiceImpl");
        this.url = url;
    }

    @Override
    public void run() {
        int errorCount = 0;
        while (this.subscriptionHelp.get(this.domainCode) != null) {
            boolean getFail = false;
            VcmReqBaseInfo vcmReqBaseInfo = this.subscriptionHelp.get(this.domainCode);
            Device device = OnvifUtils.getDevice((String)vcmReqBaseInfo.getVcmSession());
            vcmReqBaseInfo.setVcmIp(this.url);
            if (StringUtils.isBlank((CharSequence)vcmReqBaseInfo.getSdcUserName()) || StringUtils.isBlank((CharSequence)vcmReqBaseInfo.getSdcPassword())) {
                LOGGER.error("onvif re-subscription failed :" + vcmReqBaseInfo.getVcmIp() + " please manually open");
                return;
            }
            Object rsp = null;
            String ret = null;
            try {
                String xml = OnvifUtils.getPostStringByVcmInfo((String)"getPullSecondEvent.xml", (VcmReqBaseInfo)vcmReqBaseInfo, (String[])new String[]{this.url, this.url});
                ret = (String)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)OnvifMsgType.DEVICE_EMPTY, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)xml, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getHeaders(vcmReqBaseInfo));
            }
            catch (Exception e) {
                LOGGER.error("onvif get event fail,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
                this.sequence = null;
                this.lapNumber = null;
                getFail = true;
                try {
                    if (errorCount < 300) {
                        ++errorCount;
                    }
                    Thread.sleep(1000 * errorCount);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.error("sleep error", (Throwable)interruptedException);
                }
            }
            if (getFail) continue;
            errorCount = 0;
            if (StringUtils.isNotBlank((CharSequence)ret)) {
                try {
                    JSONObject alarmData = OnvifUtils.xml2Json((String)ret);
                    LOGGER.info("onvif get alarm data: {}", (Object)alarmData);
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    LOGGER.error("deal data error", (Throwable)e);
                }
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.error("sleep error", (Throwable)interruptedException);
            }
        }
        this.subscriptionHelp.remove(this.domainCode);
        LOGGER.info("Event check exit,domainCode:{}", (Object)this.domainCode);
    }

    private void dealData(JSONObject data) {
        if (!data.containsKey((Object)"AlarmInfo")) {
            return;
        }
        JSONArray alarmListJson = data.getJSONArray("AlarmInfo");
        for (int i = 0; i < alarmListJson.size(); ++i) {
            JSONObject alarmJson = alarmListJson.getJSONObject(i);
            String minorType = (String)ZKNvrConstants.ZK_NVR_ALARM_CODE_MAP.get(alarmJson.getInteger("MinorType"));
            if (!DeviceUtil.GENERAL_ALARM_CODE_LIST.contains(minorType) && !DeviceUtil.SYSTEM_ALARM_CODE_LIST.contains(minorType)) continue;
            AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
            alarmEventRespond.setType(EventTypeEnum.ALARM);
            alarmEventRespond.setTime(DateUtil.dateToString((Date)new Date(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
            alarmEventRespond.setDomainCode(this.domainCode);
            alarmEventRespond.setMetaType(MetaTypeEnum.NONE);
            alarmEventRespond.setCode(minorType);
            alarmEventRespond.setName(EventNameHelper.getEventName((String)minorType));
            alarmEventRespond.setId(UUID.randomUUID().toString());
            if (DeviceUtil.SYSTEM_ALARM_CODE_LIST.contains(minorType)) {
                alarmEventRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_OPERATIONS.toString());
                alarmEventRespond.setAlarmLevel(AlarmLevelEnum.IMPORTANT);
            } else {
                alarmEventRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_GENERAL_BUSINESS.toString());
                alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
                alarmEventRespond.setChannelCode("CH" + alarmJson.getString("Source"));
            }
            alarmEventRespond.setStatus(0);
            alarmEventRespond.setDeviceSubType(String.valueOf(DeviceTypeEnum.ZKNVR.val()));
            this.webSocketService.send((BaseEventRespond)alarmEventRespond);
        }
    }

    private String snapShot(String channelCode) {
        try {
            SnapshotRequest snapshotRequest = new SnapshotRequest();
            snapshotRequest.setChannelCode(channelCode);
            SnapshotRespond snapshotRespond = this.snapshotZKNvrService.createSnapshot(this.subscriptionHelp.get(this.domainCode), snapshotRequest);
            return snapshotRespond.getImgBase64Str();
        }
        catch (Exception e) {
            LOGGER.error("Snapshot fail", (Throwable)e);
            return "";
        }
    }

    List<Header> getHeaders(VcmReqBaseInfo vcmInfo) {
        ArrayList<Header> headers = new ArrayList<Header>();
        this.addOtherHeaders(vcmInfo, headers);
        return headers;
    }

    void addOtherHeaders(VcmReqBaseInfo vcmInfo, List<Header> headers) {
        if (null != vcmInfo.getHeaders() && !vcmInfo.getHeaders().isEmpty()) {
            for (VcmReqBaseInfo.Header header : vcmInfo.getHeaders()) {
                headers.add((Header)new BasicHeader(header.getKey(), (Object)header.getValue()));
            }
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToXmlMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new XmlMsgToObjectConvertor(cClass);
    }
}

