/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.onvif;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraAddRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRebootRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRemoveRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.MasterDeviceSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.PasswordUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.onvif.MediaProfile;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraAddRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.MasterDeviceRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.ChannelStatusEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceManageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.DeviceManageNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.onvif.AbstractOnvifService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.DeviceManageZKNvrServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.OnvifUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToXmlMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XmlMsgToObjectConvertor;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="DeviceManageOnvifServiceImpl")
public class DeviceManageOnvifServiceImpl
extends AbstractOnvifService
implements DeviceManageService<IServerType.Onvif> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManageOnvifServiceImpl.class);
    private Pattern pattern = Pattern.compile("\\d+");
    public static final Predicate<InetAddress> FILTER_IPV4 = addr -> addr instanceof Inet4Address;
    public static final Predicate<InetAddress> FILTER_NOT_LINK_LOCAL = addr -> !addr.isLinkLocalAddress();
    private static byte[][] invalidMacs = new byte[][]{{0, 5, 105}, {0, 28, 20}, {0, 12, 41}, {0, 80, 86}, {8, 0, 39}, {10, 0, 39}, {0, 3, -1}, {0, 21, 93}};

    public List<CameraRespond> listCamera(VcmReqBaseInfo vcmReqBaseInfo) {
        ArrayList<CameraRespond> respondList = new ArrayList<CameraRespond>();
        try {
            List mediaProfiles = OnvifUtils.getMediaProfiles((VcmReqBaseInfo)vcmReqBaseInfo);
            Map<String, List<MediaProfile>> map = mediaProfiles.stream().collect(Collectors.groupingBy(MediaProfile::getVideoSourceToken));
            Map sortMap = map.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
            if (!CollectionUtils.isEmpty((Collection)mediaProfiles)) {
                int channel = 0;
                for (Map.Entry entry : sortMap.entrySet()) {
                    entry.getValue();
                    CameraRespond cameraRespond = new CameraRespond();
                    String[] token = new String[4];
                    for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                        MediaProfile mediaProfile = (MediaProfile)((List)entry.getValue()).get(i);
                        token[i] = mediaProfile.getToken();
                    }
                    cameraRespond.setCameraCode(token[0] + "&" + token[1]);
                    cameraRespond.setCameraName("CH" + ++channel);
                    cameraRespond.setStatus(ChannelStatusEnum.ONLINE);
                    cameraRespond.setCameraType("FIX");
                    respondList.add(cameraRespond);
                }
            }
        }
        catch (SDKException e) {
            throw new InvokeException("500", e.getMessage());
        }
        return respondList;
    }

    public List<ChannelRespond> listChannel(VcmReqBaseInfo vcmReqBaseInfo) {
        ArrayList<ChannelRespond> respondList = new ArrayList<ChannelRespond>();
        try {
            List mediaProfiles = OnvifUtils.getMediaProfiles((VcmReqBaseInfo)vcmReqBaseInfo);
            Map<String, List<MediaProfile>> map = mediaProfiles.stream().collect(Collectors.groupingBy(MediaProfile::getVideoSourceToken));
            Map sortMap = map.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
            if (!CollectionUtils.isEmpty((Collection)mediaProfiles)) {
                int channel = 0;
                for (Map.Entry entry : sortMap.entrySet()) {
                    entry.getValue();
                    ChannelRespond channelRespond = new ChannelRespond();
                    String[] token = new String[4];
                    for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                        MediaProfile mediaProfile = (MediaProfile)((List)entry.getValue()).get(i);
                        token[i] = mediaProfile.getToken();
                    }
                    channelRespond.setChannelCode(token[0] + "&" + token[1]);
                    channelRespond.setCameraName("CH" + ++channel);
                    channelRespond.setChannel(channel);
                    channelRespond.setStatus(ChannelStatusEnum.ONLINE);
                    channelRespond.setCameraType("FIX");
                    respondList.add(channelRespond);
                }
            }
        }
        catch (SDKException e) {
            throw new InvokeException("500", e.getMessage());
        }
        return respondList;
    }

    public ChannelRespond getChannel(ParamBean<ChannelRequest> obj) {
        return null;
    }

    public List<String> getEmptyChannel(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public boolean updateChannel(ParamBean<ChannelUpdateRequest> obj) {
        return false;
    }

    public List<ChannelRespond> listChannelsByCamera(VcmReqBaseInfo vcmReqBaseInfo, String cameraCode) {
        return null;
    }

    public CameraAddRespond addCamera(ParamBean<CameraAddRequest> obj) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MasterDeviceRespond> searchMasterDevice(MasterDeviceSearchRequest request) {
        ArrayList<MasterDeviceRespond> respondList = new ArrayList<MasterDeviceRespond>();
        ArrayList<String> ipList = new ArrayList<String>();
        DatagramSocket ds = null;
        try {
            try {
                InetAddress group = InetAddress.getByName("239.255.255.250");
                String str = OnvifUtils.getPostStringByFileName((String)"probe.xml", (String[])new String[0]);
                byte[] sendData = str.getBytes();
                for (NetworkInterface nic : DeviceManageOnvifServiceImpl.getNICs((Predicate[])new Predicate[]{DeviceManageZKNvrServiceImpl.Filter.UP, DeviceManageZKNvrServiceImpl.Filter.PHYICAL_ONLY})) {
                    DeviceManageOnvifServiceImpl.sendMulticast((InetAddress)group, (int)3702, (byte[])sendData, (NetworkInterface)nic);
                }
                ds = new DatagramSocket(3702);
                ds.setSoTimeout(10000);
                ds.setBroadcast(true);
                while (true) {
                    byte[] buffer = new byte[0x100000];
                    DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
                    ds.receive(dp);
                    String ip = dp.getAddress().getHostAddress();
                    String text = new String(dp.getData(), 0, dp.getLength());
                    if (!StringUtils.isNotBlank((CharSequence)text) || ipList.contains(ip)) continue;
                    try {
                        MasterDeviceRespond masterDeviceRespond = new MasterDeviceRespond();
                        JSONObject data = OnvifUtils.xml2Json((String)text);
                        LOGGER.info(" onvif json data: {}", (Object)data);
                        String scopes = data.getJSONObject("Body").getJSONObject("ProbeMatches").getJSONObject("ProbeMatch").toJSONString();
                        if (StringUtils.contains((CharSequence)scopes, (CharSequence)"NVR")) {
                            masterDeviceRespond.setDeviceType("NVR");
                        } else {
                            masterDeviceRespond.setDeviceType("IPC");
                        }
                        String url = data.getJSONObject("Body").getJSONObject("ProbeMatches").getJSONObject("ProbeMatch").getJSONObject("XAddrs").getString("XAddrs");
                        LOGGER.info("url data: {}", (Object)url);
                        masterDeviceRespond.setIp(ip);
                        String port = String.valueOf(new URL(url).getPort());
                        if (StringUtils.equals((CharSequence)"-1", (CharSequence)port)) {
                            port = url.startsWith("https://") ? "443" : "80";
                        }
                        masterDeviceRespond.setType(String.valueOf(DeviceTypeEnum.ONVIFNVR.val()));
                        masterDeviceRespond.setPort(port);
                        LOGGER.info("onvif==************=: ip:{}, port:{}, type: {}", new Object[]{ip, masterDeviceRespond.getPort(), masterDeviceRespond.getDeviceType()});
                        respondList.add(masterDeviceRespond);
                        ipList.add(ip);
                    }
                    catch (Exception e) {
                        LOGGER.info("text raw data: {}", (Object)text);
                        LOGGER.info("text raw length: {}", (Object)dp.getLength());
                        LOGGER.error("parse raw xml data error", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Onvif search master device error", (Throwable)e);
                if (ds != null) {
                    ds.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (ds != null) {
                ds.close();
            }
            throw throwable;
        }
        LOGGER.info("onvif has search device list: {}", (Object)StringUtils.join(ipList, (String)","));
        return respondList;
    }

    public boolean removeCamera(ParamBean<CameraRemoveRequest> obj) {
        return false;
    }

    public boolean updatePassword(ParamBean<PasswordUpdateRequest> obj) {
        return false;
    }

    public boolean rebootCamera(ParamBean<CameraRebootRequest> obj) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMulticast(InetAddress group, int port, byte[] message, NetworkInterface nic) {
        UnmodifiableIterator nifAddresses = Iterators.filter((Iterator)Iterators.forEnumeration(nic.getInetAddresses()), (Predicate)Predicates.and((Predicate)FILTER_IPV4, (Predicate)FILTER_NOT_LINK_LOCAL));
        if (!nifAddresses.hasNext()) {
            LOGGER.info("onvif address is error");
            return;
        }
        InetSocketAddress inetAddr = new InetSocketAddress((InetAddress)nifAddresses.next(), port);
        try (DatagramSocket socket = null;){
            LOGGER.info("port: {}, ip:{}", (Object)port, (Object)inetAddr.getAddress());
            socket = new DatagramSocket(inetAddr);
            socket.setBroadcast(true);
            socket.send(new DatagramPacket(message, message.length, group, port));
        }
    }

    public static byte[] hexStr2ByteArray(String hexString) {
        if (StringUtils.isEmpty((CharSequence)hexString)) {
            throw new IllegalArgumentException("this hexString must not be empty");
        }
        hexString = hexString.toLowerCase();
        byte[] byteArray = new byte[hexString.length() / 2];
        int k = 0;
        for (int i = 0; i < byteArray.length; ++i) {
            byte high = (byte)(Character.digit(hexString.charAt(k), 16) & 0xFF);
            byte low = (byte)(Character.digit(hexString.charAt(k + 1), 16) & 0xFF);
            byteArray[i] = (byte)(high << 4 | low);
            k += 2;
        }
        return byteArray;
    }

    private MasterDeviceRespond buildUDPTextToBean(String ip, Integer port, String text) throws DocumentException {
        MasterDeviceRespond masterDeviceRespond = new MasterDeviceRespond();
        masterDeviceRespond.setIp(ip);
        masterDeviceRespond.setWebPort("8081");
        Document document = DocumentHelper.parseText((String)text);
        Element message = document.getRootElement();
        List messageChild = message.elements();
        if (messageChild.size() == 3) {
            List parametersChild;
            Element parameters = (Element)messageChild.get(2);
            if (Objects.nonNull(parameters) && (parametersChild = parameters.elements()).size() == 16) {
                List eth0Child;
                masterDeviceRespond.setVersion(((Element)parametersChild.get(14)).getStringValue());
                Element eth0 = (Element)parametersChild.get(10);
                if (Objects.nonNull(eth0) && (eth0Child = eth0.elements()).size() == 6) {
                    masterDeviceRespond.setMacAddress(((Element)eth0Child.get(0)).getStringValue());
                }
            }
            masterDeviceRespond.setType(String.valueOf(DeviceTypeEnum.ZKNVR.val()));
        }
        return masterDeviceRespond;
    }

    @SafeVarargs
    public static Set<NetworkInterface> getNICs(Predicate<NetworkInterface> ... filters) {
        if (null == filters) {
            filters = new Predicate[]{DeviceManageNvr800ServiceImpl.Filter.ALL};
        }
        try {
            UnmodifiableIterator filtered = Iterators.filter((Iterator)Iterators.forEnumeration(NetworkInterface.getNetworkInterfaces()), (Predicate)Predicates.and(filters));
            return ImmutableSet.copyOf((Iterator)filtered);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isVMMac(byte[] mac) {
        if (null == mac) {
            return false;
        }
        for (byte[] invalid : invalidMacs) {
            if (invalid[0] != mac[0] || invalid[1] != mac[1] || invalid[2] != mac[2]) continue;
            return true;
        }
        return false;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToXmlMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new XmlMsgToObjectConvertor(cClass);
    }

    static /* synthetic */ boolean access$000(byte[] x0) {
        return DeviceManageOnvifServiceImpl.isVMMac((byte[])x0);
    }
}

