/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.onvif;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.OnvifMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.AlarmDealRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.AlarmSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.onvif.Device;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.PageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmSearch.AlarmSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.websocket.SubscriptionRequest;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.AlarmService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.impl.onvif.AbstractOnvifService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.onvif.EvenOnvifGetThread;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.OnvifUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToXmlMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XmlMsgToObjectConvertor;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlarmOnvifServiceImpl
extends AbstractOnvifService
implements AlarmService<IServerType.Onvif> {
    private static final Logger log = LoggerFactory.getLogger(AlarmOnvifServiceImpl.class);
    @Autowired
    private SubscriptionHelp subscriptionHelp;

    public boolean subscribe(ParamBean<SubscriptionRequest> obj) {
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        Device device = OnvifUtils.getDevice((String)vcmReqBaseInfo.getVcmSession());
        if (Objects.isNull(device)) {
            throw new InvokeException("500", "cu_offline_error");
        }
        vcmReqBaseInfo.setVcmIp(device.getEventUrl());
        try {
            if (this.subscriptionHelp.get(obj.getVcmInfo().getDomainCode()) == null) {
                String xml = OnvifUtils.getPostStringByVcmInfo((String)"getPullFirstEvent.xml", (VcmReqBaseInfo)obj.getVcmInfo(), (String[])new String[]{device.getEventUrl(), device.getEventUrl()});
                String ret = (String)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)OnvifMsgType.DEVICE_EMPTY, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)xml, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getHeaders(vcmReqBaseInfo));
                JSONObject data = OnvifUtils.xml2Json((String)ret);
                String url = data.getJSONObject("Body").getJSONObject("CreatePullPointSubscriptionResponse").getJSONObject("SubscriptionReference").getJSONObject("Address").getString("Address");
                log.info("event pull data: {}", (Object)data);
                EvenOnvifGetThread evenOnvifGetThread = new EvenOnvifGetThread(obj.getVcmInfo().getDomainCode(), obj.getVcmInfo().getVcmIp(), url);
                evenOnvifGetThread.start();
                this.subscriptionHelp.add(obj.getVcmInfo().getDomainCode(), vcmReqBaseInfo, null);
            } else {
                this.subscriptionHelp.add(obj.getVcmInfo().getDomainCode(), vcmReqBaseInfo, null);
            }
        }
        catch (SDKException e) {
            log.error("onvif subscribe error", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        return false;
    }

    public boolean delSubscribe(ParamBean<SubscriptionRequest> obj) {
        return false;
    }

    public boolean confirm(ParamBean<AlarmDealRequest> obj) {
        return false;
    }

    public boolean cancel(ParamBean<AlarmDealRequest> obj) {
        return false;
    }

    public PageRespond<AlarmSearchRespond> search(ParamBean<AlarmSearchRequest> obj) {
        return null;
    }

    public boolean register(VcmReqBaseInfo vcmReqBaseInfo, String url) {
        return false;
    }

    public String getRegisterUrlList(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToXmlMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new XmlMsgToObjectConvertor(cClass);
    }
}

