/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.suspecttask.TaskTime;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.videoProgram.VideoProgramRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.device.ChannelRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.videoProgram.VideoProgramRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.PerimeterZoneGetRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.VideoProgramService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VideoProgramNvr800ServiceImpl
extends AbstractNvr800Service
implements VideoProgramService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VideoProgramNvr800ServiceImpl.class);

    public VideoProgramRespond getVideoPlan(ParamBean<VideoProgramRequest> obj) {
        VideoProgramRespond videoProgramRespond = new VideoProgramRespond();
        try {
            JSONArray channlArray = new JSONArray();
            channlArray.add((Object)((VideoProgramRequest)obj.getRequestBody()).getCameracode());
            JSONObject requestNvr800 = new JSONObject();
            requestNvr800.put("channel", (Object)channlArray);
            JSONObject dataObject = new JSONObject();
            dataObject.put("data", (Object)requestNvr800);
            PerimeterZoneGetRespondNvr800 respondNvr800 = (PerimeterZoneGetRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.RECORD_SCHEDULE_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PerimeterZoneGetRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            ParamBean objVideo = new ParamBean();
            VideoProgramRequest videoProgram = new VideoProgramRequest();
            videoProgram.setCameracode(((VideoProgramRequest)obj.getRequestBody()).getCameracode());
            objVideo.setRequestBody((Object)videoProgram);
            objVideo.setVcmInfo(obj.getVcmInfo());
            VideoProgramRespond temporalStrategy = this.getTemporalStrategy(objVideo);
            videoProgramRespond.setRecordSwitch(temporalStrategy.getRecordPolicy().getRecordSwitch());
            if (respondNvr800.getData() != null && respondNvr800.getData().getJSONObject("channel_info") != null) {
                JSONObject channelInfo = respondNvr800.getData().getJSONObject("channel_info").getJSONObject(((VideoProgramRequest)obj.getRequestBody()).getCameracode());
                ArrayList<VideoProgramRespond.Category> categoryList = new ArrayList<VideoProgramRespond.Category>();
                for (int i = 0; i < channelInfo.getJSONArray("category").size(); ++i) {
                    JSONArray weekArray = channelInfo.getJSONArray("category").getJSONObject(i).getJSONArray("week");
                    VideoProgramRespond.Category category = new VideoProgramRespond.Category();
                    category.setScheduleType(channelInfo.getJSONArray("category").getJSONObject(i).getString("schedule_type"));
                    category.setTimeList(this.taskTimeConvert(weekArray));
                    categoryList.add(category);
                }
                videoProgramRespond.setCategory(categoryList);
                return videoProgramRespond;
            }
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("get VideoPlan error" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public List<TaskTime> taskTimeConvert(JSONArray weekArray) {
        ArrayList<TaskTime> timeList = new ArrayList<TaskTime>();
        for (int i = 0; i < weekArray.size(); ++i) {
            int startIndex = 99;
            int endIndex = 99;
            JSONArray weekIScheduleStrArray = weekArray.getJSONObject(i).getJSONArray("time");
            for (int k = 0; k < weekIScheduleStrArray.size(); ++k) {
                if ("1".equals(weekIScheduleStrArray.get(k).toString()) && startIndex == 99) {
                    startIndex = k;
                }
                if ("1".equals(weekIScheduleStrArray.get(k).toString())) {
                    endIndex = k;
                }
                if (!"0".equals(weekIScheduleStrArray.get(k).toString()) && k != weekIScheduleStrArray.size() - 1 || startIndex == 99) continue;
                TaskTime taskTime = new TaskTime();
                taskTime.setDay(this.weekDayConvert(weekArray.getJSONObject(i).getString("day")));
                String start = String.valueOf(startIndex / 2);
                String end = String.valueOf(endIndex / 2);
                if (start.length() < 2) {
                    start = "0" + start;
                }
                if (end.length() < 2) {
                    end = "0" + end;
                }
                if (startIndex % 2 == 1) {
                    taskTime.setStartTime(start + ":30:00");
                } else {
                    taskTime.setStartTime(start + ":00:00");
                }
                if (endIndex % 2 == 0) {
                    taskTime.setEndTime(end + ":30:00");
                } else if (k == 47 && "1".equals(weekIScheduleStrArray.get(47).toString())) {
                    taskTime.setEndTime(end + ":59:59");
                } else {
                    String endIn = String.valueOf(Integer.parseInt(end) + 1);
                    if (endIn.length() < 2) {
                        endIn = "0" + endIn;
                    }
                    taskTime.setEndTime(endIn + ":00:00");
                }
                timeList.add(taskTime);
                startIndex = 99;
            }
        }
        return timeList;
    }

    private int weekDayConvert(String day) {
        switch (day) {
            case "Sun": {
                return 0;
            }
            case "Mon": {
                return 1;
            }
            case "Tue": {
                return 2;
            }
            case "Wed": {
                return 3;
            }
            case "Thu": {
                return 4;
            }
            case "Fri": {
                return 5;
            }
            case "Sat": {
                return 6;
            }
        }
        return -1;
    }

    public VideoProgramRespond addVideoPlan(ParamBean<VideoProgramRequest> obj) {
        return null;
    }

    public VideoProgramRespond updateVideoPlan(ParamBean<VideoProgramRequest> obj) {
        VideoProgramRequest requestBody = (VideoProgramRequest)obj.getRequestBody();
        JSONArray weekArray = this.weekScheduleConvert(requestBody.getTimeList(), requestBody.getScheduleType());
        JSONObject cateObject = new JSONObject();
        cateObject.put("category", (Object)weekArray);
        List cameraCodes = requestBody.getCameraCodeList().getCameraCode();
        JSONObject channelInfo = new JSONObject();
        for (int i = 0; i < cameraCodes.size(); ++i) {
            channelInfo.put((String)cameraCodes.get(i), (Object)cateObject);
            ParamBean objVideo = new ParamBean();
            VideoProgramRequest videoProgram = new VideoProgramRequest();
            videoProgram.setCameracode((String)cameraCodes.get(i));
            videoProgram.setRecordSwitch(requestBody.isRecordSwitch());
            objVideo.setRequestBody((Object)videoProgram);
            objVideo.setVcmInfo(obj.getVcmInfo());
            this.updateTemporalStrategy(objVideo);
        }
        JSONObject channelObject = new JSONObject();
        channelObject.put("channel_info", (Object)channelInfo);
        JSONObject dataObject = new JSONObject();
        dataObject.put("data", (Object)channelObject);
        try {
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.RECORD_SCHEDULE_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("update VideoPlan error" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONArray weekScheduleConvert(List<TaskTime> timeList, String scheduleType) {
        int[][] weekSchedule = new int[7][48];
        timeList.forEach(taskTime -> {
            int day = taskTime.getDay();
            int start = taskTime.getStartTime().contains(":30:00") ? Integer.parseInt(taskTime.getStartTime().substring(0, 2)) * 2 + 1 : Integer.parseInt(taskTime.getStartTime().substring(0, 2)) * 2;
            int end = taskTime.getEndTime().contains(":30:00") ? (Integer.parseInt(taskTime.getEndTime().substring(0, 2)) + 1) * 2 + 1 : (taskTime.getEndTime().contains("23:59:59") ? (Integer.parseInt(taskTime.getEndTime().substring(0, 2)) + 1) * 2 : (Integer.parseInt(taskTime.getEndTime().substring(0, 2)) + 1) * 2 - 2);
            for (int i = start; i < end; ++i) {
                weekSchedule[day][i] = 1;
            }
        });
        System.out.println("weekSchedule[day] = " + JSON.toJSON((Object)weekSchedule));
        JSONArray category = new JSONArray();
        JSONArray week = new JSONArray();
        for (int i = 0; i < weekSchedule.length; ++i) {
            JSONObject dayTime = new JSONObject();
            dayTime.put("day", (Object)this.intsDayConvert(i));
            dayTime.put("time", (Object)weekSchedule[i]);
            week.add((Object)dayTime);
        }
        JSONObject categoryObject = new JSONObject();
        categoryObject.put("week", (Object)week);
        categoryObject.put("schedule_type", (Object)scheduleType);
        category.add((Object)categoryObject);
        return category;
    }

    private String intsDayConvert(int day) {
        switch (day) {
            case 0: {
                return "Sun";
            }
            case 1: {
                return "Mon";
            }
            case 2: {
                return "Tue";
            }
            case 3: {
                return "Wed";
            }
            case 4: {
                return "Thu";
            }
            case 5: {
                return "Fri";
            }
            case 6: {
                return "Sat";
            }
        }
        return "-1";
    }

    public VideoProgramRespond deleteVideoPlan(ParamBean<VideoProgramRequest> obj) {
        return null;
    }

    public VideoProgramRespond getTemporalStrategy(ParamBean<VideoProgramRequest> obj) {
        String channelCode = ((VideoProgramRequest)obj.getRequestBody()).getCameracode();
        try {
            ChannelRequestNvr800 requestNvr800 = new ChannelRequestNvr800(channelCode);
            CommonRespondNvr800 commonRespondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.VIDEO_CONFIG_GET_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)commonRespondNvr800);
            JSONObject jsonObject = commonRespondNvr800.getData().getJSONObject("channel_info").getJSONObject(channelCode);
            VideoProgramRespond configRespond = new VideoProgramRespond();
            VideoProgramRespond.RecordPolicy recordPolicy = new VideoProgramRespond.RecordPolicy();
            recordPolicy.setRecordSwitch(jsonObject.getBoolean("record_switch"));
            if ("Mainstream".equals(jsonObject.getString("stream_mode"))) {
                recordPolicy.setPlanStreamType(Integer.valueOf(1));
            } else if ("DualStream".equals(jsonObject.getString("stream_mode"))) {
                recordPolicy.setPlanStreamType(Integer.valueOf(4));
            }
            recordPolicy.setPreRecord(Integer.valueOf(jsonObject.getBoolean("prerecord") != false ? 1 : 0));
            configRespond.setRecordPolicy(recordPolicy);
            return configRespond;
        }
        catch (SDKException e) {
            LOGGER.error("getTemporalStrategy error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public VideoProgramRespond updateTemporalStrategy(ParamBean<VideoProgramRequest> obj) {
        try {
            VideoProgramRequest requestBody = (VideoProgramRequest)obj.getRequestBody();
            JSONObject channelInfo = new JSONObject();
            channelInfo.put(requestBody.getCameracode(), (Object)new JSONObject());
            JSONObject data = new JSONObject();
            data.put("channel_info", (Object)channelInfo);
            if (Objects.nonNull(requestBody.getRecordPolicy())) {
                if (requestBody.getRecordPolicy().getPlanStreamType() == 1) {
                    channelInfo.getJSONObject(requestBody.getCameracode()).put("stream_mode", (Object)"Mainstream");
                } else if (requestBody.getRecordPolicy().getPlanStreamType() == 4) {
                    channelInfo.getJSONObject(requestBody.getCameracode()).put("stream_mode", (Object)"DualStream");
                }
                channelInfo.getJSONObject(requestBody.getCameracode()).put("prerecord", (Object)(requestBody.getRecordPolicy().getPreRecord() == 1 ? 1 : 0));
            } else {
                channelInfo.getJSONObject(requestBody.getCameracode()).put("record_switch", (Object)requestBody.isRecordSwitch());
            }
            JSONObject dataObject = new JSONObject();
            dataObject.put("data", (Object)data);
            CommonRespondNvr800 commonRespondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.VIDEO_CONFIG_SET_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)commonRespondNvr800);
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("update TemporalStrategy error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

