/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RecordConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.EventRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.RecordConfigRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.VideoBookMarkRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.VideoListRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.VideoLockRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.VideoStartRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.VideoStopRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.device.ChannelRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.VideoItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordStatusRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoBookMarkRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoListRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.EventRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.VideoBookMarkListRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.VideoListRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.VideoLockInfoRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.VideoRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.enums.RecordTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.VideoService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="videoNvr800Service")
public class VideoNvr800ServiceImpl
extends AbstractNvr800Service
implements VideoService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VideoNvr800ServiceImpl.class);

    public VideoRespond videoList(VcmReqBaseInfo vcmInfo, VideoListRequest req) {
        String domainCode = vcmInfo.getDomainCode();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        VideoListRequestNvr800 videoListRequestIvs1800 = this.requestToNvr800(req);
        try {
            LocalDateTime startTime = LocalDateTime.parse(req.getStartTime(), formatter);
            if (startTime.getYear() < 2000) {
                return new VideoRespond();
            }
            VideoListRespondNvr800 videoListRespondNvr800 = (VideoListRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.VIDEO_LIST_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoListRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoListRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)videoListRespondNvr800);
            return this.nvr800ToResult(videoListRespondNvr800, req.getTypeList(), domainCode, req.getChannelCode());
        }
        catch (SDKException e) {
            LOGGER.error("videoList error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public Boolean videoStart(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        VideoStartRequestNvr800 videoStartRequestNvr800 = this.requestStartToNvr800(req);
        try {
            VideoRespondNvr800 videoRespondNvr800 = (VideoRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.VIDEO_START_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoStartRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)videoRespondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("video start error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public Boolean videoStop(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        VideoStopRequestNvr800 videoStopRequestNvr800 = this.requestStopToNvr800(req);
        try {
            VideoRespondNvr800 videoRespondNvr800 = (VideoRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.VIDEO_STOP_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoStopRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)videoRespondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("video stop error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public List<VideoBookMarkRespond> getVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkSearchRequest req) {
        VideoBookMarkRequestNvr800 videoBookMarkRequestNvr800 = this.bookMarkListToNvr800(req);
        try {
            int startYear = Integer.parseInt(req.getFromTime().substring(0, 4));
            if (startYear < 2000) {
                return new ArrayList<VideoBookMarkRespond>();
            }
            VideoBookMarkListRespondNvr800 videoBookMarkListRespondNvr800 = (VideoBookMarkListRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.VIDEO_BOOKMARK_LIST_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoBookMarkRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoBookMarkListRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)videoBookMarkListRespondNvr800);
            JSONObject data = videoBookMarkListRespondNvr800.getData();
            JSONArray labelList = data.getJSONArray("label_list");
            ArrayList<VideoBookMarkRespond> respondList = new ArrayList<VideoBookMarkRespond>();
            for (int i = 0; i < labelList.size(); ++i) {
                JSONObject itemJson = labelList.getJSONObject(i);
                if (!req.getChannelCode().equals(itemJson.getString("channel"))) continue;
                VideoBookMarkRespond respond = new VideoBookMarkRespond();
                respond.setId(itemJson.getLongValue("label_id"));
                respond.setLabelId(itemJson.getLongValue("label_id"));
                respond.setRecordId(itemJson.getIntValue("record_id"));
                respond.setTime(this.getTime(itemJson));
                respond.setName(itemJson.getString("name"));
                respond.setCameraCode(req.getChannelCode());
                respondList.add(respond);
            }
            return respondList;
        }
        catch (SDKException e) {
            LOGGER.error("get video book mark error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public String createVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        VideoBookMarkRequestNvr800 videoBookMarkRequestNvr800 = this.bookMarkCreateToNvr800(req);
        try {
            VideoBookMarkListRespondNvr800 respondNvr800 = (VideoBookMarkListRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.VIDEO_BOOKMARK_OPERATE_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoBookMarkRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoBookMarkListRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            VideoBookMarkSearchRequest searchRequest = new VideoBookMarkSearchRequest();
            searchRequest.setChannelCode(req.getChannelCode());
            searchRequest.setFromTime(req.getTime());
            searchRequest.setToTime(req.getTime());
            List list = this.getVideoBookmark(vcmInfo, searchRequest);
            if (list == null || list.size() == 0) {
                return "0#0";
            }
            VideoBookMarkRespond bookMarkRespond = (VideoBookMarkRespond)list.get(list.size() - 1);
            return bookMarkRespond.getId() + "#" + bookMarkRespond.getLabelId();
        }
        catch (SDKException e) {
            LOGGER.error("create video bookmark error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean uptVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        VideoBookMarkRequestNvr800 videoBookMarkRequestNvr800 = this.bookMarkUptToNvr800(req, "Modify");
        try {
            VideoBookMarkListRespondNvr800 videoBookMarkListRespondNvr800 = (VideoBookMarkListRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.VIDEO_BOOKMARK_OPERATE_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoBookMarkRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoBookMarkListRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)videoBookMarkListRespondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("update video bookmark error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean delVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        VideoBookMarkRequestNvr800 videoBookMarkRequestNvr800 = this.bookMarkUptToNvr800(req, "Delete");
        try {
            VideoBookMarkListRespondNvr800 videoBookMarkListRespondNvr800 = (VideoBookMarkListRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.VIDEO_BOOKMARK_OPERATE_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoBookMarkRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoBookMarkListRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)videoBookMarkListRespondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("del video bookmark error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public VideoLockInfoListRespond getVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoListRequest req) {
        return null;
    }

    public VideoLockInfoRespond createVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        VideoLockInfoRespond videoLockInfoRespond = new VideoLockInfoRespond();
        VideoLockRequestNvr800 videoLockRequestNvr800 = this.requestLockToNvr800(req);
        try {
            VideoLockInfoRespondNvr800 videoLockInfoRespondNvr800 = (VideoLockInfoRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.VIDEO_LOCK_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoLockRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoLockInfoRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)videoLockInfoRespondNvr800);
            return videoLockInfoRespond;
        }
        catch (SDKException e) {
            LOGGER.error("create video lock info error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public VideoLockInfoRespond delVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        VideoLockInfoRespond videoLockInfoRespond = new VideoLockInfoRespond();
        VideoLockRequestNvr800 videoLockRequestNvr800 = this.requestUnLockToNvr800(req);
        try {
            VideoLockInfoRespondNvr800 videoLockInfoRespondNvr800 = (VideoLockInfoRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.VIDEO_LOCK_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoLockRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoLockInfoRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)videoLockInfoRespondNvr800);
            return videoLockInfoRespond;
        }
        catch (SDKException e) {
            LOGGER.error("del video lock info error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public VideoLockInfoRespond uptVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public List<RecordStatusRespond> getRecordStatus(ParamBean<ChannelListRequest> obj) {
        ArrayList<RecordStatusRespond> recordStatusRespondList = new ArrayList<RecordStatusRespond>();
        for (String channelCode : ((ChannelListRequest)obj.getRequestBody()).getChannelCode()) {
            RecordStatusRespond recordStatusRespond = new RecordStatusRespond();
            recordStatusRespond.setChannelCode(channelCode);
            try {
                EventRespondNvr800 eventRespondNvr800 = (EventRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.EVENT_CHECK_URI, (ObjectToMsgConvertor)new ObjectToJSONMsgConvertor((Object)new EventRequestNvr800()), (MsgToObjectConvertor)new JSONMsgToObjectConvertor(EventRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
                JSONObject recordFlagJson = this.getRecordFlag(channelCode, eventRespondNvr800);
                if (recordFlagJson == null) {
                    recordStatusRespondList.add(recordStatusRespond);
                    continue;
                }
                TreeSet<RecordTypeEnum> recordTypeSet = new TreeSet<RecordTypeEnum>();
                if (recordFlagJson.containsKey((Object)"m") && "R".equals(recordFlagJson.getString("m"))) {
                    recordTypeSet.add(RecordTypeEnum.ALARM);
                }
                if (recordFlagJson.containsKey((Object)"i") && "R".equals(recordFlagJson.getString("i"))) {
                    recordTypeSet.add(RecordTypeEnum.ALARM);
                }
                if (recordFlagJson.containsKey((Object)"r")) {
                    if ("MR".equals(recordFlagJson.getString("r"))) {
                        recordTypeSet.add(RecordTypeEnum.MANUAL);
                    } else if ("SR".equals(recordFlagJson.getString("r"))) {
                        recordTypeSet.add(RecordTypeEnum.PLAN);
                    }
                }
                if (recordFlagJson.containsKey((Object)"p") && "R".equals(recordFlagJson.getString("p"))) {
                    recordTypeSet.add(RecordTypeEnum.ALARM);
                }
                if (recordFlagJson.containsKey((Object)"s") && "R".equals(recordFlagJson.getString("s"))) {
                    recordTypeSet.add(RecordTypeEnum.ALARM);
                }
                recordStatusRespond.setType(recordTypeSet);
                recordStatusRespondList.add(recordStatusRespond);
                recordStatusRespondList.add(recordStatusRespond);
            }
            catch (SDKException e) {
                LOGGER.error("get record status error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
                throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
            }
        }
        return recordStatusRespondList;
    }

    public RecordConfigRespond getConfig(ParamBean<ChannelRequest> obj) {
        String channelCode = ((ChannelRequest)obj.getRequestBody()).getChannelCode();
        try {
            ChannelRequestNvr800 requestNvr800 = new ChannelRequestNvr800(channelCode);
            CommonRespondNvr800 commonRespondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.VIDEO_CONFIG_GET_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)commonRespondNvr800);
            JSONObject jsonObject = commonRespondNvr800.getData().getJSONObject("channel_info").getJSONObject(channelCode);
            RecordConfigRespond configRespond = new RecordConfigRespond();
            configRespond.setRecordSwitch(jsonObject.getBoolean("record_switch").booleanValue());
            configRespond.setPrerecord(jsonObject.getBoolean("prerecord").booleanValue());
            configRespond.setStreamMode(jsonObject.getString("stream_mode"));
            return configRespond;
        }
        catch (SDKException e) {
            LOGGER.error("get config error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setConfig(ParamBean<RecordConfigRequest> obj) {
        try {
            RecordConfigRequestNvr800 requestNvr800 = new RecordConfigRequestNvr800((RecordConfigRequest)obj.getRequestBody());
            CommonRespondNvr800 commonRespondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.VIDEO_CONFIG_SET_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)commonRespondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set config error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private JSONObject getRecordFlag(String channelCode, EventRespondNvr800 eventRespondNvr800) {
        int i;
        JSONArray alarmListJson = eventRespondNvr800.getData().getJSONArray("alarm_list");
        if (alarmListJson == null) {
            return null;
        }
        JSONArray channelAlarmArray = null;
        for (i = 0; i < alarmListJson.size(); ++i) {
            JSONObject jsonObject = alarmListJson.getJSONObject(i);
            if (!jsonObject.containsKey((Object)"channel_alarm")) continue;
            channelAlarmArray = jsonObject.getJSONArray("channel_alarm");
            break;
        }
        if (channelAlarmArray == null) {
            return null;
        }
        for (i = 0; i < channelAlarmArray.size(); ++i) {
            JSONObject alarmJson = channelAlarmArray.getJSONObject(i);
            if (!channelCode.equals(alarmJson.getString("channel"))) continue;
            return alarmJson.getJSONObject("record_flag");
        }
        return null;
    }

    private VideoListRequestNvr800 requestToNvr800(VideoListRequest req) {
        VideoListRequestNvr800 videoListRequestNvr800 = new VideoListRequestNvr800();
        Map timeMap = this.timeWorker(req.getStartTime(), req.getEndTime());
        JSONArray channel = new JSONArray();
        channel.add((Object)req.getChannelCode());
        videoListRequestNvr800.getData().put("channel", (Object)channel);
        videoListRequestNvr800.getData().put("start_date", timeMap.get("start_date"));
        videoListRequestNvr800.getData().put("start_time", timeMap.get("start_time"));
        videoListRequestNvr800.getData().put("end_date", timeMap.get("end_date"));
        videoListRequestNvr800.getData().put("end_time", timeMap.get("end_time"));
        long type = 0L;
        if (req.getTypeList().contains(RecordTypeEnum.PLAN)) {
            ++type;
        }
        if (req.getTypeList().contains(RecordTypeEnum.MANUAL)) {
            type += 262144L;
        }
        if (req.getTypeList().contains(RecordTypeEnum.ALARM)) {
            type += 0x7FFFFFFEL;
        }
        videoListRequestNvr800.getData().put("record_type", (Object)type);
        return videoListRequestNvr800;
    }

    private VideoStartRequestNvr800 requestStartToNvr800(VideoRequest req) {
        VideoStartRequestNvr800 videoStartRequestNvr800 = new VideoStartRequestNvr800();
        JSONArray channelInfo = new JSONArray();
        channelInfo.add((Object)req.getChannelCode());
        videoStartRequestNvr800.getData().put("channel_info", (Object)channelInfo);
        return videoStartRequestNvr800;
    }

    private VideoStopRequestNvr800 requestStopToNvr800(VideoRequest req) {
        VideoStopRequestNvr800 videoStopRequestNvr800 = new VideoStopRequestNvr800();
        JSONArray channelInfo = new JSONArray();
        channelInfo.add((Object)req.getChannelCode());
        videoStopRequestNvr800.getData().put("channel_info", (Object)channelInfo);
        return videoStopRequestNvr800;
    }

    private VideoLockRequestNvr800 requestLockToNvr800(VideoLockInfoRequest req) {
        VideoLockRequestNvr800 requestNvr800 = new VideoLockRequestNvr800();
        JSONObject data = new JSONObject();
        data.put("lock", (Object)true);
        data.put("event_id", (Object)req.getEventId());
        requestNvr800.setData(data);
        return requestNvr800;
    }

    private VideoLockRequestNvr800 requestUnLockToNvr800(VideoLockInfoRequest req) {
        VideoLockRequestNvr800 requestNvr800 = new VideoLockRequestNvr800();
        JSONObject data = new JSONObject();
        data.put("lock", (Object)false);
        data.put("event_id", (Object)req.getEventId());
        requestNvr800.setData(data);
        return requestNvr800;
    }

    private VideoBookMarkRequestNvr800 bookMarkListToNvr800(VideoBookMarkSearchRequest req) {
        VideoBookMarkRequestNvr800 requestNvr800 = new VideoBookMarkRequestNvr800();
        JSONObject data = new JSONObject();
        String startDateTime = req.getFromTime();
        String endDateTime = req.getToTime();
        data.put("start_date", (Object)this.dateHelper(startDateTime));
        data.put("end_date", (Object)this.dateHelper(endDateTime));
        data.put("start_time", (Object)this.timeHelper(startDateTime));
        data.put("end_time", (Object)this.timeHelper(endDateTime));
        requestNvr800.setData(data);
        return requestNvr800;
    }

    private VideoBookMarkRequestNvr800 bookMarkCreateToNvr800(VideoBookMarkRequest req) {
        VideoBookMarkRequestNvr800 requestNvr800 = new VideoBookMarkRequestNvr800();
        JSONObject data = new JSONObject();
        String bookmarkTime = req.getTime();
        data.put("operate", (Object)"Add");
        data.put("name", (Object)req.getName());
        data.put("channel", (Object)req.getChannelCode());
        data.put("date", (Object)this.dateHelper(bookmarkTime));
        data.put("time", (Object)this.timeHelper(bookmarkTime));
        requestNvr800.setData(data);
        return requestNvr800;
    }

    private VideoBookMarkRequestNvr800 bookMarkUptToNvr800(VideoBookMarkRequest req, String operation) {
        VideoBookMarkRequestNvr800 requestNvr800 = new VideoBookMarkRequestNvr800();
        JSONObject data = new JSONObject();
        data.put("operate", (Object)operation);
        data.put("name", (Object)req.getName());
        data.put("channel", (Object)req.getChannelCode());
        data.put("label_id", (Object)req.getId());
        data.put("record_id", (Object)req.getRecordId());
        requestNvr800.setData(data);
        return requestNvr800;
    }

    private String getTime(JSONObject itemJson) {
        StringBuilder sb = new StringBuilder();
        String date = itemJson.getString("date");
        String[] dateArray = date.split("/");
        String time = itemJson.getString("time");
        String[] timeArray = time.split(":");
        sb.append(dateArray[2]).append(dateArray[0]).append(dateArray[1]).append(timeArray[0]).append(timeArray[1]).append(timeArray[2]);
        return sb.toString();
    }

    private String dateHelper(String dateTime) {
        return dateTime.substring(4, 6) + "/" + dateTime.substring(6, 8) + "/" + dateTime.substring(0, 4);
    }

    private String timeHelper(String dateTime) {
        return dateTime.substring(8, 10) + ":" + dateTime.substring(10, 12) + ":" + dateTime.substring(12, 14);
    }

    private VideoRespond nvr800ToResult(VideoListRespondNvr800 videoListRespondNvr800, List<RecordTypeEnum> targetList, String domainCode, String channelCode) {
        VideoRespond videoRespond = new VideoRespond();
        if (videoListRespondNvr800.getData().getJSONArray("record").size() == 0) {
            return videoRespond;
        }
        JSONArray recordInfoList = videoListRespondNvr800.getData().getJSONArray("record").getJSONArray(0);
        if (null == recordInfoList || recordInfoList.size() == 0) {
            return videoRespond;
        }
        LOGGER.info("video result:{}", (Object)JsonUtil.convertBeanToJSON((Object)videoListRespondNvr800.getData()));
        ArrayList<VideoItem> videoItemList = new ArrayList<VideoItem>();
        for (int i = 0; i < recordInfoList.size(); ++i) {
            JSONObject jsonObject = recordInfoList.getJSONObject(i);
            List typeList = this.getVideoTypeList(jsonObject.getLongValue("record_type"));
            for (RecordTypeEnum type : typeList) {
                if (!targetList.contains(type)) continue;
                VideoItem videoItem = new VideoItem();
                videoItem.setRecordFileName(jsonObject.getString("record_id"));
                videoItem.setLock((Boolean)jsonObject.get((Object)"locked"));
                videoItem.setEventId((Integer)jsonObject.get((Object)"event_id"));
                String[] startArr = jsonObject.get((Object)"start_date").toString().split("/");
                String startStr = startArr[2] + "-" + startArr[0] + "-" + startArr[1] + " " + jsonObject.get((Object)"start_time");
                videoItem.setStartTime(startStr);
                String[] endArr = jsonObject.get((Object)"end_date").toString().split("/");
                String endStr = endArr[2] + "-" + endArr[0] + "-" + endArr[1] + " " + jsonObject.get((Object)"end_time");
                videoItem.setEndTime(endStr);
                videoItem.setType(type);
                videoItem.setDomainCode(domainCode);
                videoItem.setChannelCode(channelCode);
                videoItemList.add(videoItem);
            }
        }
        videoRespond.setVideoItemList(videoItemList);
        return videoRespond;
    }

    private List<RecordTypeEnum> getVideoTypeList(long typeValue) {
        ArrayList<RecordTypeEnum> typeList = new ArrayList<RecordTypeEnum>();
        if (typeValue == 1L) {
            typeList.add(RecordTypeEnum.PLAN);
        } else if (typeValue == 262144L) {
            typeList.add(RecordTypeEnum.MANUAL);
        } else if (typeValue == 0xFFFFFFFFL) {
            typeList.add(RecordTypeEnum.PLAN);
            typeList.add(RecordTypeEnum.MANUAL);
            typeList.add(RecordTypeEnum.ALARM);
        } else {
            typeList.add(RecordTypeEnum.ALARM);
        }
        return typeList;
    }

    private Map<String, String> timeWorker(String startTime, String endTime) {
        HashMap<String, String> map = new HashMap<String, String>();
        String startTimeStr = this.formatDate(startTime);
        String endTimeStr = this.formatDate(endTime);
        map.put("start_date", startTimeStr.split(" ")[0]);
        map.put("start_time", startTimeStr.split(" ")[1]);
        map.put("end_date", endTimeStr.split(" ")[0]);
        map.put("end_time", endTimeStr.split(" ")[1]);
        return map;
    }

    private String formatDate(String strDate) {
        Date date;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = sdf.parse(strDate);
        }
        catch (ParseException e) {
            LOGGER.info("Date[{}] format is wrong", (Object)strDate);
            throw new InvokeException("500", "cu_param_convert_error");
        }
        SimpleDateFormat sdfOut = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return sdfOut.format(date);
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

