/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.RestResult;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.vehicleRepository.VehicleRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleRepositoryAddRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleRepositoryDelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.VehicleRepositoryManagementService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class VehicleRepositoryNvr800ServiceImpl
extends AbstractNvr800Service
implements VehicleRepositoryManagementService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VehicleRepositoryNvr800ServiceImpl.class);

    public VehicleRepositorySearchRespond search(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        return null;
    }

    public VehicleRepositoryAddRespond addVehicleListLibrary(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        return null;
    }

    public VehicleRepositoryDelRespond delVehicleListLibrary(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        return null;
    }

    public RestResult updateVehicleListLibrary(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        return null;
    }

    public VehicleRepositoryAddRespond addVehicleInformation(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        return null;
    }

    public VehicleRepositoryDelRespond delVehicleInformation(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        return null;
    }

    public JSONObject updateVehicleInformation(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        return null;
    }

    public VehicleRepositorySearchRespond searchVehicleInformation(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        return null;
    }

    public VehicleRepositorySearchRespond vehicleDynamicRetrieval(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        JSONObject countInfo = this.vehicleSearchCount(vcmReqBaseInfo, vehicleRepositoryRequest);
        int count = countInfo.getIntValue("Count");
        VehicleRepositorySearchRespond vehicleSearchRespond = new VehicleRepositorySearchRespond();
        if (count > 0 && vehicleRepositoryRequest.getSearchCount() > 0 && !CollectionUtils.isEmpty((Collection)(vehicleSearchRespond = this.vehicleSearchInfo(vcmReqBaseInfo, vehicleRepositoryRequest, vehicleRepositoryRequest.getSearchCount(), vehicleRepositoryRequest.getStartIndex())).getVehicleList())) {
            vehicleSearchRespond.getVehicleList().forEach(vehicleList -> vehicleList.setDomainCode(vcmReqBaseInfo.getDomainCode()));
        }
        return vehicleSearchRespond;
    }

    public static String dateToStamp(String s) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(Long.parseLong(String.valueOf(s))));
    }

    public JSONObject vehicleSearchCount(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest request) {
        Integer integer;
        Integer integer2;
        String cameraCode;
        String[] str;
        JSONObject data = new JSONObject();
        JSONArray chn = new JSONArray();
        if (!StringUtils.isEmpty((CharSequence)request.getCondition().getCameraCode()) && CollectionUtils.isNotEmpty(Arrays.asList(str = (cameraCode = request.getCondition().getCameraCode()).split(";")))) {
            for (String a : str) {
                chn.add((Object)(Integer.parseInt(a.substring(a.indexOf("CH") + 2, a.indexOf("#"))) - 1));
            }
        }
        data.put("Chn", (Object)chn);
        data.put("StartTime", (Object)VehicleRepositoryNvr800ServiceImpl.dateToStamp((String)request.getCondition().getStartTime()));
        data.put("EndTime", (Object)VehicleRepositoryNvr800ServiceImpl.dateToStamp((String)request.getCondition().getEndTime()));
        if (Objects.nonNull(request.getPage())) {
            if ("desc".equals(request.getPage().getString("sortOrder")) || "desc".equals(request.getPage().getString("sort"))) {
                data.put("SortType", (Object)1);
            } else {
                data.put("SortType", (Object)0);
            }
        }
        data.put("Type", (Object)request.getCondition().getType());
        data.put("Engine", (Object)0);
        if (StringUtils.isNotEmpty((CharSequence)request.getCondition().getPnr())) {
            if ("-unknown-".equals(request.getCondition().getPnr())) {
                data.put("LicensePlate", (Object)"Unknown");
            } else {
                data.put("LicensePlate", (Object)request.getCondition().getPnr());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getCondition().getVehiclebrand()) && (integer2 = Integer.valueOf(request.getCondition().getVehiclebrand())) != -1) {
            data.put("VehicleBrand", (Object)integer2);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getCondition().getVehicleSub())) {
            Integer carType = Integer.valueOf(request.getCondition().getCartype());
            Integer carSubType = Integer.valueOf(request.getCondition().getCarSubType());
            Integer specialVehicleTypeIdx = Integer.valueOf(request.getCondition().getSpecialVehicleTypeIdx());
            data.put("VehicleType", (Object)this.vehicleTypeTo800(carType, carSubType, specialVehicleTypeIdx));
        }
        List colorList = request.getCondition().getColorList();
        for (Integer a : colorList) {
            data.put("VehicleColor", (Object)this.vehicleColorTo800(a));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getCondition().getPtype())) {
            integer = Integer.valueOf(request.getCondition().getPtype());
            data.put("PlateType", (Object)this.plateTypeTo800(integer));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getCondition().getPcolor())) {
            integer = Integer.valueOf(request.getCondition().getPcolor());
            data.put("PlateColor", (Object)this.conversionColor(integer));
        }
        JSONObject countReq = new JSONObject();
        countReq.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.VEHICLE_SEARCH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)countReq, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)120);
            this.checkJsonRespond((JSONObject)JSONObject.toJSON((Object)rsp));
            return rsp.getData();
        }
        catch (SDKException e) {
            LOGGER.error("vehicleSearchCount happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public VehicleRepositorySearchRespond vehicleSearchInfo(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest req, int searchCount, int startIndex) {
        JSONObject data = new JSONObject();
        data.put("Engine", (Object)0);
        data.put("SimpleInfo", (Object)0);
        data.put("WithObjectImage", (Object)0);
        data.put("WithBackgroud", (Object)0);
        data.put("StartIndex", (Object)Math.max(startIndex, 0));
        data.put("Count", (Object)searchCount);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.VEHICLE_SEARCH_PAGINATION, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)120);
            this.checkJsonRespond((JSONObject)JSONObject.toJSON((Object)rsp));
            return this.vehicleSearchRspConvert(rsp.getData());
        }
        catch (SDKException e) {
            LOGGER.error("vehicleSearchInfo happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public VehicleRepositorySearchRespond vehicleSearchRspConvert(JSONObject object) {
        VehicleRepositorySearchRespond vehicleSearchRespond = new VehicleRepositorySearchRespond();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("totalCount", (Object)String.valueOf(object.getIntValue("Count")));
        vehicleSearchRespond.setPage(jsonObject);
        JSONArray vehicleInfosJson = object.getJSONArray("SnapedObjInfo");
        ArrayList<VehicleRepositorySearchRespond.VehicleList> vehicleList = new ArrayList<VehicleRepositorySearchRespond.VehicleList>();
        for (int i = 0; i < vehicleInfosJson.size(); ++i) {
            Date parse;
            VehicleRepositorySearchRespond.VehicleList vehicleObject = new VehicleRepositorySearchRespond.VehicleList();
            vehicleObject.setPicfileID(vehicleInfosJson.getJSONObject(i).getString("UUId").replaceAll("/", "_"));
            vehicleObject.setBackground(vehicleInfosJson.getJSONObject(i).getString("Background"));
            vehicleObject.setObjectImage(vehicleInfosJson.getJSONObject(i).getString("ObjectImage"));
            vehicleObject.setCameraCode("CH" + (vehicleInfosJson.getJSONObject(i).getIntValue("Chn") + 1));
            String startTime = vehicleInfosJson.getJSONObject(i).getString("StartTime");
            try {
                parse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(startTime);
            }
            catch (ParseException e) {
                LOGGER.error("Date parse happen exception", (Throwable)e);
                throw new InvokeException("500", "param_error");
            }
            Long time1 = parse.getTime();
            vehicleObject.setImageTimestamp(String.valueOf(time1));
            vehicleObject.setSnapId(vehicleInfosJson.getJSONObject(i).getIntValue("SnapId"));
            VehicleRepositorySearchRespond.VehicleList.LprInfo lprInfo = new VehicleRepositorySearchRespond.VehicleList.LprInfo();
            lprInfo.setPlateNumber(vehicleInfosJson.getJSONObject(i).getString("LicensePlate"));
            lprInfo.setPlateColor(this.colorConversion(vehicleInfosJson.getJSONObject(i).getString("PlateColor")));
            lprInfo.setCarColor(this.vehicleColorTo1800(vehicleInfosJson.getJSONObject(i).getString("CarColor")));
            lprInfo.setPlateType(this.plateTypeTo1800(vehicleInfosJson.getJSONObject(i).getString("PlateType")));
            vehicleObject.setVehiclebrand(vehicleInfosJson.getJSONObject(i).getString("CarPreBrandId"));
            vehicleObject.setVehicleSub(vehicleInfosJson.getJSONObject(i).getString("CarSubBrandId"));
            vehicleObject.setYear(vehicleInfosJson.getJSONObject(i).getString("CarYearBrand"));
            vehicleObject.setCarType(vehicleInfosJson.getJSONObject(i).getString("CarType"));
            ArrayList<VehicleRepositorySearchRespond.VehicleList.ObjInResult> objInResultList = new ArrayList<VehicleRepositorySearchRespond.VehicleList.ObjInResult>();
            VehicleRepositorySearchRespond.VehicleList.ObjInResult ObjInResult2 = new VehicleRepositorySearchRespond.VehicleList.ObjInResult();
            VehicleRepositorySearchRespond.VehicleList.ObjInResult.Coords objCoords = new VehicleRepositorySearchRespond.VehicleList.ObjInResult.Coords();
            JSONObject objPos = vehicleInfosJson.getJSONObject(i).getJSONObject("ObjPos");
            if (Objects.nonNull(objPos)) {
                objCoords.setLeft(String.valueOf(objPos.getInteger("X")));
                objCoords.setTop(String.valueOf(objPos.getInteger("Y")));
                objCoords.setRight(String.valueOf(objPos.getInteger("X") + objPos.getInteger("Width")));
                objCoords.setBottom(String.valueOf(objPos.getInteger("Y") + objPos.getInteger("Height")));
            }
            VehicleRepositorySearchRespond.VehicleList.ObjInResult.HumanBgPos humanBgPos = new VehicleRepositorySearchRespond.VehicleList.ObjInResult.HumanBgPos();
            JSONObject humanBgPos1 = vehicleInfosJson.getJSONObject(i).getJSONObject("HumanBgPos");
            if (Objects.nonNull(humanBgPos1)) {
                humanBgPos.setLeft(String.valueOf(humanBgPos1.getInteger("X")));
                humanBgPos.setTop(String.valueOf(humanBgPos1.getInteger("Y")));
                humanBgPos.setRight(String.valueOf(humanBgPos1.getInteger("X") + humanBgPos1.getInteger("Width")));
                humanBgPos.setBottom(String.valueOf(humanBgPos1.getInteger("Y") + humanBgPos1.getInteger("Height")));
            }
            VehicleRepositorySearchRespond.VehicleList.ObjInResult.HumanImagePos humanImagePos = new VehicleRepositorySearchRespond.VehicleList.ObjInResult.HumanImagePos();
            JSONObject humanImagePos1 = vehicleInfosJson.getJSONObject(i).getJSONObject("HumanImagePos");
            if (Objects.nonNull(humanImagePos1)) {
                humanImagePos.setLeft(String.valueOf(humanImagePos1.getInteger("X")));
                humanImagePos.setTop(String.valueOf(humanImagePos1.getInteger("Y")));
                humanImagePos.setRight(String.valueOf(humanImagePos1.getInteger("X") + humanImagePos1.getInteger("Width")));
                humanImagePos.setBottom(String.valueOf(humanImagePos1.getInteger("Y") + humanImagePos1.getInteger("Height")));
            }
            VehicleRepositorySearchRespond.VehicleList.ObjInResult.NonVehicleBgPos nonVehicleBgPos = new VehicleRepositorySearchRespond.VehicleList.ObjInResult.NonVehicleBgPos();
            JSONObject nonVehicleBgPos1 = vehicleInfosJson.getJSONObject(i).getJSONObject("NonVehicleBgPos");
            if (Objects.nonNull(nonVehicleBgPos1)) {
                nonVehicleBgPos.setLeft(String.valueOf(nonVehicleBgPos1.getInteger("X")));
                nonVehicleBgPos.setTop(String.valueOf(nonVehicleBgPos1.getInteger("Y")));
                nonVehicleBgPos.setRight(String.valueOf(nonVehicleBgPos1.getInteger("X") + nonVehicleBgPos1.getInteger("Width")));
                nonVehicleBgPos.setBottom(String.valueOf(nonVehicleBgPos1.getInteger("Y") + nonVehicleBgPos1.getInteger("Height")));
            }
            ObjInResult2.setHumanBgPos(humanBgPos);
            ObjInResult2.setHumanImagePos(humanImagePos);
            ObjInResult2.setNonVehicleBgPos(nonVehicleBgPos);
            ObjInResult2.setCoords(objCoords);
            objInResultList.add(ObjInResult2);
            VehicleRepositorySearchRespond.VehicleList.LprInfo.Coords lpnCoords = new VehicleRepositorySearchRespond.VehicleList.LprInfo.Coords();
            JSONObject platePos = vehicleInfosJson.getJSONObject(i).getJSONObject("PlatePos");
            if (Objects.nonNull(platePos)) {
                lpnCoords.setLeft(String.valueOf(platePos.getInteger("X")));
                lpnCoords.setTop(String.valueOf(platePos.getInteger("Y")));
                lpnCoords.setRight(String.valueOf(platePos.getInteger("X") + platePos.getInteger("Width")));
                lpnCoords.setBottom(String.valueOf(platePos.getInteger("Y") + platePos.getInteger("Height")));
            }
            lprInfo.setCoords(lpnCoords);
            vehicleObject.setObjInResult(objInResultList);
            vehicleObject.setLprInfo(lprInfo);
            vehicleList.add(vehicleObject);
            vehicleSearchRespond.setVehicleList(vehicleList);
        }
        return vehicleSearchRespond;
    }

    public JSONArray vehicleTypeTo800(Integer carType, Integer carSubType, Integer specialVehicleTypeIdx) {
        JSONArray vehicleTypeArray = new JSONArray();
        if (carType != -1) {
            if (carType == 1) {
                if (carSubType == -1) {
                    vehicleTypeArray.add((Object)1);
                } else if (carSubType == 0) {
                    vehicleTypeArray.add((Object)14);
                } else if (carSubType == 1) {
                    vehicleTypeArray.add((Object)15);
                } else if (carSubType == 2) {
                    vehicleTypeArray.add((Object)16);
                } else if (carSubType == 3) {
                    vehicleTypeArray.add((Object)17);
                } else if (carSubType == 4) {
                    vehicleTypeArray.add((Object)18);
                }
            } else if (carType == 6) {
                if (carSubType == -1) {
                    vehicleTypeArray.add((Object)6);
                } else if (carSubType == 5) {
                    vehicleTypeArray.add((Object)20);
                } else if (carSubType == 6) {
                    vehicleTypeArray.add((Object)21);
                } else if (carSubType == 7) {
                    vehicleTypeArray.add((Object)22);
                } else if (carSubType == 8) {
                    vehicleTypeArray.add((Object)23);
                } else if (carSubType == 9) {
                    vehicleTypeArray.add((Object)24);
                }
            } else if (carType == 9) {
                vehicleTypeArray.add((Object)0);
            } else if (carType == 10) {
                vehicleTypeArray.add((Object)0);
            } else if (carType == 11) {
                vehicleTypeArray.add((Object)26);
            } else if (carType == 12) {
                vehicleTypeArray.add((Object)0);
            } else if (carType == 13) {
                if (carSubType == -1) {
                    vehicleTypeArray.add((Object)28);
                    vehicleTypeArray.add((Object)29);
                    vehicleTypeArray.add((Object)30);
                    vehicleTypeArray.add((Object)31);
                    vehicleTypeArray.add((Object)32);
                } else if (carSubType == 10) {
                    vehicleTypeArray.add((Object)28);
                } else if (carSubType == 11) {
                    vehicleTypeArray.add((Object)29);
                } else if (carSubType == 12) {
                    vehicleTypeArray.add((Object)30);
                } else if (carSubType == 13) {
                    vehicleTypeArray.add((Object)31);
                } else if (carSubType == 14) {
                    vehicleTypeArray.add((Object)32);
                }
            } else if (carType == 14) {
                vehicleTypeArray.add((Object)0);
            } else if (carType == 15) {
                vehicleTypeArray.add((Object)0);
            } else if (carType == 16) {
                vehicleTypeArray.add((Object)34);
            } else if (carType == 17) {
                vehicleTypeArray.add((Object)35);
            } else if (carType == 18) {
                vehicleTypeArray.add((Object)0);
            } else if (carType == 19) {
                vehicleTypeArray.add((Object)8);
            } else if (carType == 20) {
                vehicleTypeArray.add((Object)0);
            } else if (carType == 21) {
                vehicleTypeArray.add((Object)27);
            } else if (carType == 22) {
                vehicleTypeArray.add((Object)9);
            } else if (carType == 23) {
                vehicleTypeArray.add((Object)13);
            } else if (carType == 24) {
                vehicleTypeArray.add((Object)33);
            } else if (carType == 25) {
                vehicleTypeArray.add((Object)36);
            } else {
                vehicleTypeArray.add((Object)carType);
            }
        }
        if (specialVehicleTypeIdx == 1) {
            vehicleTypeArray.add((Object)10);
        } else if (specialVehicleTypeIdx == 2) {
            vehicleTypeArray.add((Object)11);
        } else if (specialVehicleTypeIdx == 3) {
            vehicleTypeArray.add((Object)12);
        }
        return vehicleTypeArray;
    }

    public JSONArray plateTypeTo800(Integer integer) {
        JSONArray plateTypeArray = new JSONArray();
        if (integer == 0) {
            plateTypeArray.add((Object)0);
        } else if (integer == 1) {
            plateTypeArray.add((Object)1);
        } else if (integer == 2) {
            plateTypeArray.add((Object)2);
        } else if (integer == 3) {
            plateTypeArray.add((Object)3);
        } else if (integer == 4) {
            plateTypeArray.add((Object)4);
        } else if (integer == 5) {
            plateTypeArray.add((Object)5);
        } else if (integer == 6) {
            plateTypeArray.add((Object)6);
        } else if (integer == 7) {
            plateTypeArray.add((Object)16);
        } else if (integer == 8) {
            plateTypeArray.add((Object)8);
        } else if (integer == 9) {
            plateTypeArray.add((Object)9);
        } else if (integer == 10) {
            plateTypeArray.add((Object)10);
        } else if (integer == 11) {
            plateTypeArray.add((Object)12);
        } else if (integer == 12) {
            plateTypeArray.add((Object)14);
        } else if (integer == 13) {
            plateTypeArray.add((Object)13);
        } else if (integer == 14) {
            plateTypeArray.add((Object)15);
        } else if (integer == 15) {
            plateTypeArray.add((Object)7);
        } else if (integer == 16) {
            plateTypeArray.add((Object)18);
        } else if (integer == 17) {
            plateTypeArray.add((Object)17);
        } else if (integer == 18) {
            plateTypeArray.add((Object)19);
        } else if (integer == 20) {
            plateTypeArray.add((Object)20);
        }
        return plateTypeArray;
    }

    public String plateTypeTo1800(String plateType) {
        String rs = null;
        if ("0".equals(plateType)) {
            rs = "0";
        } else if ("1".equals(plateType)) {
            rs = "1";
        } else if ("2".equals(plateType)) {
            rs = "2";
        } else if ("3".equals(plateType)) {
            rs = "3";
        } else if ("4".equals(plateType)) {
            rs = "4";
        } else if ("5".equals(plateType)) {
            rs = "5";
        } else if ("6".equals(plateType)) {
            rs = "6";
        } else if ("16".equals(plateType)) {
            rs = "7";
        } else if ("8".equals(plateType)) {
            rs = "8";
        } else if ("9".equals(plateType)) {
            rs = "9";
        } else if ("10".equals(plateType)) {
            rs = "10";
        } else if ("12".equals(plateType)) {
            rs = "11";
        } else if ("14".equals(plateType)) {
            rs = "12";
        } else if ("13".equals(plateType)) {
            rs = "13";
        } else if ("15".equals(plateType)) {
            rs = "14";
        } else if ("7".equals(plateType)) {
            rs = "15";
        } else if ("18".equals(plateType)) {
            rs = "16";
        } else if ("17".equals(plateType)) {
            rs = "17";
        } else if ("19".equals(plateType)) {
            rs = "18";
        } else if ("20".equals(plateType)) {
            rs = "20";
        }
        return rs;
    }

    public JSONArray vehicleColorTo800(Integer integer) {
        JSONArray vehicleColorArray = new JSONArray();
        if (integer == 0) {
            vehicleColorArray.add((Object)1);
        } else if (integer == 1) {
            vehicleColorArray.add((Object)2);
        } else if (integer == 2) {
            vehicleColorArray.add((Object)3);
        } else if (integer == 3) {
            vehicleColorArray.add((Object)4);
        } else if (integer == 4) {
            vehicleColorArray.add((Object)5);
        } else if (integer == 5) {
            vehicleColorArray.add((Object)6);
        } else if (integer == 6) {
            vehicleColorArray.add((Object)7);
        } else if (integer == 7) {
            vehicleColorArray.add((Object)8);
        } else if (integer == 8) {
            vehicleColorArray.add((Object)9);
        } else if (integer == 9) {
            vehicleColorArray.add((Object)0);
        } else if (integer == 10) {
            vehicleColorArray.add((Object)10);
        } else if (integer == 11) {
            vehicleColorArray.add((Object)11);
        } else if (integer == 12) {
            vehicleColorArray.add((Object)14);
        } else if (integer == 13) {
            vehicleColorArray.add((Object)12);
        } else if (integer == 14) {
            vehicleColorArray.add((Object)13);
        }
        return vehicleColorArray;
    }

    public String vehicleColorTo1800(String carColor) {
        String rs = null;
        if ("1".equals(carColor)) {
            rs = "0";
        } else if ("2".equals(carColor)) {
            rs = "1";
        } else if ("3".equals(carColor)) {
            rs = "2";
        } else if ("4".equals(carColor)) {
            rs = "3";
        } else if ("5".equals(carColor)) {
            rs = "4";
        } else if ("6".equals(carColor)) {
            rs = "5";
        } else if ("7".equals(carColor)) {
            rs = "6";
        } else if ("8".equals(carColor)) {
            rs = "7";
        } else if ("9".equals(carColor)) {
            rs = "8";
        } else if ("0".equals(carColor)) {
            rs = "9";
        } else if ("10".equals(carColor)) {
            rs = "10";
        } else if ("11".equals(carColor)) {
            rs = "11";
        } else if ("14".equals(carColor)) {
            rs = "12";
        } else if ("12".equals(carColor)) {
            rs = "13";
        } else if ("13".equals(carColor)) {
            rs = "14";
        }
        return rs;
    }

    public JSONArray conversionColor(Integer integer) {
        JSONArray plateColorArray = new JSONArray();
        if (integer == 0) {
            plateColorArray.add((Object)3);
        } else if (integer == 2) {
            plateColorArray.add((Object)2);
        } else if (integer == 5) {
            plateColorArray.add((Object)5);
        } else if (integer == 6) {
            plateColorArray.add((Object)1);
        } else if (integer == 8) {
            plateColorArray.add((Object)4);
        } else if (integer == 9) {
            plateColorArray.add((Object)0);
        } else if (integer == 10) {
            plateColorArray.add((Object)6);
        } else if (integer == 11) {
            plateColorArray.add((Object)7);
        } else if (integer == 17) {
            plateColorArray.add((Object)9);
        } else if (integer == 18) {
            plateColorArray.add((Object)11);
        } else if (integer == 19) {
            plateColorArray.add((Object)12);
        } else if (integer == 20) {
            plateColorArray.add((Object)13);
        } else if (integer == 21) {
            plateColorArray.add((Object)14);
        } else if (integer == 22) {
            plateColorArray.add((Object)8);
        } else if (integer == 23) {
            plateColorArray.add((Object)10);
        } else if (integer == 24) {
            plateColorArray.add((Object)15);
        }
        return plateColorArray;
    }

    public String colorConversion(String plateColor) {
        if ("3".equals(plateColor)) {
            return "0";
        }
        if ("2".equals(plateColor)) {
            return "2";
        }
        if ("5".equals(plateColor)) {
            return "5";
        }
        if ("1".equals(plateColor)) {
            return "6";
        }
        if ("4".equals(plateColor)) {
            return "8";
        }
        if ("0".equals(plateColor)) {
            return "9";
        }
        if ("6".equals(plateColor)) {
            return "10";
        }
        if ("7".equals(plateColor)) {
            return "11";
        }
        if ("9".equals(plateColor)) {
            return "17";
        }
        if ("11".equals(plateColor)) {
            return "18";
        }
        if ("12".equals(plateColor)) {
            return "19";
        }
        if ("13".equals(plateColor)) {
            return "20";
        }
        if ("14".equals(plateColor)) {
            return "21";
        }
        if ("8".equals(plateColor)) {
            return "22";
        }
        if ("10".equals(plateColor)) {
            return "23";
        }
        if ("15".equals(plateColor)) {
            return "24";
        }
        return null;
    }

    public JSONObject dynamicLibraryPictureDownload(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        return null;
    }

    public Boolean batchChangePlateList(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        return null;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

