/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.EncPasswordBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChangePasswordRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.LoginRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.UserTokenRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.KeepAliveRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.GeneralBusinessBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.user.LoginRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.user.UserRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.LoginRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmLevelEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.MetaTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.UserManageService;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.DeviceManageNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.PasswordServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.HttpRequestUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userManageNvr800Service")
public class UserManageNvr800ServiceImpl
extends AbstractNvr800Service
implements UserManageService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserManageNvr800ServiceImpl.class);
    @Autowired
    private PasswordServiceImpl passwordService;
    @Autowired
    private DeviceManageNvr800ServiceImpl deviceManageNvr800Service;
    @Autowired
    WebSocketService webSocketService;

    public boolean firstLogin(ParamBean<EmptyRequest> obj) {
        try {
            HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SYSTEM_DATE_TIME_GET, (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            return false;
        }
        catch (SDKException e) {
            if ("first_login".equals(Nvr800Utils.reasonHelper((SDKException)e))) {
                return true;
            }
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public String getModel(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.FIRST_LOGIN_URI, (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class));
            LOGGER.debug("First login check from sdk is end.");
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return respondNvr800.getData().getString("site_version");
        }
        catch (SDKException e) {
            LOGGER.error("Get model fail", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public LoginRespond login(ParamBean<LoginRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        LoginRespond loginRespond = this.loginDevice(obj);
        vcmInfo.setVcmSession(loginRespond.getVmSession());
        ArrayList<VcmReqBaseInfo.Header> headerList = new ArrayList<VcmReqBaseInfo.Header>();
        VcmReqBaseInfo.Header header = new VcmReqBaseInfo.Header();
        header.setKey("X-csrftoken");
        header.setValue(loginRespond.getCsrfToken());
        headerList.add(header);
        vcmInfo.setHeaders(headerList);
        try {
            DeviceInfoRespond respond = this.deviceManageNvr800Service.getDeviceInfo(vcmInfo);
            loginRespond.setModel(respond.getModel());
            loginRespond.setMaxChannelNumber(respond.getMaxChannelNumber());
            loginRespond.setDeviceVersion(respond.getDeviceVersion());
        }
        catch (Exception e) {
            LOGGER.error("NVR 800 login get device info error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
        }
        return loginRespond;
    }

    private LoginRespond loginDevice(ParamBean<LoginRequest> obj) {
        LoginRequest loginRequest;
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        String nvr800WebLoginUrl = String.format(Locale.ROOT, "https://%s:%s/API/Web/Login", vcmInfo.getVcmIp(), vcmInfo.getVcmPort());
        LoginRespondNvr800 loginRespondNvr800 = HttpRequestUtils.httpsSendByGigestForNvr800((String)nvr800WebLoginUrl, (String)(loginRequest = (LoginRequest)obj.getRequestBody()).getUserName(), (String)loginRequest.getPassword());
        if (null == loginRespondNvr800) {
            throw new InvokeException("500", "cu_device_not_return");
        }
        if (!"success".equals(loginRespondNvr800.getResult())) {
            throw new InvokeException("500", loginRespondNvr800.getErrorCode());
        }
        LoginRespond loginRespond = new LoginRespond();
        loginRespond.setVmSession(loginRespondNvr800.getVmSession());
        loginRespond.setCsrfToken(loginRespondNvr800.getCsrfToken());
        return loginRespond;
    }

    public boolean logout(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            BaseRespondNvr800 respondNvr800 = (BaseRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.LOGOUT_URI, (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondNvr800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            LOGGER.debug("Logout from sdk is end.");
            this.checkRespond(respondNvr800);
            LOGGER.debug("Logout end.");
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("Logout fail", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean keepAlive(ParamBean<EmptyRequest> obj) {
        int retryCount = 0;
        while (true) {
            try {
                return this.sendKeepAlive(obj);
            }
            catch (SDKException | StackOverflowError e) {
                LOGGER.error("keep alive fail", e);
                if (++retryCount > 2) {
                    this.sendDeviceOffLine(obj.getVcmInfo().getDomainCode());
                    if (e instanceof SDKException) {
                        throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)((SDKException)e)));
                    }
                    throw new InvokeException("500", "unknown_error");
                }
                try {
                    Thread.sleep(1000 * retryCount);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.error("sleep fail", (Throwable)interruptedException);
                    continue;
                }
            }
            break;
        }
    }

    private boolean sendKeepAlive(ParamBean<EmptyRequest> obj) throws SDKException {
        try {
            BaseRespondNvr800 respondNvr800 = (BaseRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.HEART_BEAT_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)new KeepAliveRequestNvr800(), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            LOGGER.debug("Heart beat from sdk is end.");
            this.checkRespond(respondNvr800);
            LOGGER.debug("Heart beat end.");
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("Heart beat fail", (Throwable)e);
            if ("503".equals(e.getErrorCode())) {
                return true;
            }
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Heart beat request fail:{}", (Object)e.getMessage());
            this.sendDeviceOffLine(obj.getVcmInfo().getDomainCode());
            throw e;
        }
    }

    private void sendDeviceOffLine(String domainCode) {
        AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
        GeneralBusinessBean generalBusinessBean = new GeneralBusinessBean();
        generalBusinessBean.setSnapshot("");
        generalBusinessBean.setPanorama("");
        alarmEventRespond.setType(EventTypeEnum.ALARM);
        alarmEventRespond.setTime(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        alarmEventRespond.setDomainCode(domainCode);
        alarmEventRespond.setMetaType(MetaTypeEnum.NONE);
        alarmEventRespond.setStatus(1);
        alarmEventRespond.setGeneralBusinessBean(generalBusinessBean);
        alarmEventRespond.setCode("ALARM_DEVICE_OFFLINE");
        alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
        alarmEventRespond.setId(UUID.randomUUID().toString());
        alarmEventRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)alarmEventRespond.getCode()));
        alarmEventRespond.setFilterName(alarmEventRespond.getCode());
        this.webSocketService.send((BaseEventRespond)alarmEventRespond);
    }

    public boolean firstChange(ParamBean<ChangePasswordRequest> obj) {
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setPassword(((ChangePasswordRequest)obj.getRequestBody()).getOldPassword());
        loginRequest.setUserName(((ChangePasswordRequest)obj.getRequestBody()).getUserName());
        ParamBean paramBean = new ParamBean();
        paramBean.setRequestBody((Object)loginRequest);
        paramBean.setVcmInfo(vcmReqBaseInfo);
        LoginRespond loginRespond = this.loginDevice(paramBean);
        vcmReqBaseInfo.setVcmSession(loginRespond.getVmSession());
        ArrayList<VcmReqBaseInfo.Header> headerList = new ArrayList<VcmReqBaseInfo.Header>();
        VcmReqBaseInfo.Header header = new VcmReqBaseInfo.Header();
        header.setKey("X-csrftoken");
        header.setValue(loginRespond.getCsrfToken());
        headerList.add(header);
        vcmReqBaseInfo.setHeaders(headerList);
        String username = ((ChangePasswordRequest)obj.getRequestBody()).getUserName();
        EncPasswordBean passwordBean = this.passwordService.firstGet(vcmReqBaseInfo, ((ChangePasswordRequest)obj.getRequestBody()).getNewPassword(), username);
        try {
            JSONObject paramObject = new JSONObject();
            JSONObject passwordObject = new JSONObject();
            passwordObject.put("cipher", (Object)passwordBean.getCipher());
            passwordObject.put("seq", (Object)passwordBean.getSeq());
            paramObject.put("enc_password", (Object)passwordObject);
            JSONObject dataObject = new JSONObject();
            dataObject.put("data", (Object)paramObject);
            Nvr800MsgType nvr800MsgType = "admin".equalsIgnoreCase(username) ? Nvr800MsgType.USER_ADMIN_SET_PASSWORD : Nvr800MsgType.USER_COMMON_SET_PASSWORD;
            BaseRespondNvr800 respondNvr800 = (BaseRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)nvr800MsgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondNvr800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkRespond(respondNvr800);
            this.asyncLogout(vcmReqBaseInfo);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("set password error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            this.asyncLogout(vcmReqBaseInfo);
            if (e instanceof SDKException) {
                throw new InvokeException("500", (Object)e.getMessage(), Nvr800Utils.reasonHelper((SDKException)((SDKException)((Object)e))));
            }
            return false;
        }
    }

    public UserRespond getToken(ParamBean<UserTokenRequest> obj) {
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        UserRespond respond = new UserRespond();
        JSONObject paramObject = new JSONObject();
        paramObject.put("limit_ip", (Object)false);
        JSONObject dataObject = new JSONObject();
        dataObject.put("data", (Object)paramObject);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.USER_GET_TOKEN, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (Objects.isNull(rsp) || !rsp.containsKey((Object)"login_token")) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            respond.setToken(rsp.getString("login_token"));
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("NVR 800 get token error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private void asyncLogout(VcmReqBaseInfo vcmReqBaseInfo) {
        CompletableFuture.runAsync(() -> {
            try {
                this.logout(vcmReqBaseInfo);
            }
            catch (Exception e) {
                LOGGER.error("change password logout error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            }
        });
    }

    public UserRespond getSDCWebToken(ParamBean<ChannelRequest> obj) {
        JSONObject channelData = new JSONObject();
        JSONObject requestData = new JSONObject();
        channelData.put("request_url", (Object)"GET /SDCAPI/V1.0/AuthIaas/WebToken");
        channelData.put("request_data", (Object)requestData.toJSONString());
        JSONObject channel = new JSONObject();
        channel.put(((ChannelRequest)obj.getRequestBody()).getChannelCode().split("\\#")[0], (Object)channelData);
        JSONObject channelInfo = new JSONObject();
        channelInfo.put("channel_info", (Object)channel);
        JSONObject data = new JSONObject();
        data.put("data", (Object)channelInfo);
        UserRespond respond = new UserRespond();
        try {
            String respondData;
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.DEVICE_SDC_PASS, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)data, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            if ("success".equalsIgnoreCase(result.getString("result")) && JSON.parseObject((String)(respondData = result.getJSONObject("data").getJSONObject("channel_info").getJSONObject(((ChannelRequest)obj.getRequestBody()).getChannelCode().split("\\#")[0]).getString("respond_data"))).containsKey((Object)"WebToken")) {
                respond.setToken(JSON.parseObject((String)respondData).getString("WebToken"));
            }
        }
        catch (SDKException e) {
            LOGGER.error("NVR 800 get SDCWebToken error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return respond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

