/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.EncPasswordBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.upgrade.CheckRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.upgrade.UpgradeRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.upgrade.CheckRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.upgrade.UpgradeRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.UpgradeService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.PasswordServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="UpgradeNvr800ServiceImpl")
public class UpgradeNvr800ServiceImpl
extends AbstractNvr800Service
implements UpgradeService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeNvr800ServiceImpl.class);
    @Autowired
    private PasswordServiceImpl passwordService;

    public CheckRespond getUpgradeToken(VcmReqBaseInfo vcmReqBaseInfo, CheckRequest request) {
        CheckRespond respond = new CheckRespond();
        EncPasswordBean passwordBean = this.passwordService.getByType(vcmReqBaseInfo, request.getPassword(), "Salt");
        JSONObject passwordObject = new JSONObject();
        passwordObject.put("cipher", (Object)passwordBean.getCipher());
        passwordObject.put("seq", (Object)passwordBean.getSeq());
        JSONObject checkObject = new JSONObject();
        checkObject.put("secondary_authentication", (Object)passwordObject);
        checkObject.put("file_name", (Object)request.getFileName());
        checkObject.put("file_size", (Object)Integer.parseInt(request.getFileSize()));
        checkObject.put("upgrade_head", (Object)request.getUpgradeHead());
        JSONObject dataObject = new JSONObject();
        dataObject.put("data", (Object)checkObject);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.UPGRADE_GET_TOKEN, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)60);
            this.checkJsonRespond(rsp);
            respond.setResultCode("0");
            respond.setToken(rsp.getJSONObject("data").getString("upgrade_token"));
        }
        catch (SDKException e) {
            LOGGER.error("NVR 800 check upgrade package error, IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            respond.setResultCode(Nvr800Utils.reasonHelper((SDKException)e));
        }
        catch (InvokeException e) {
            respond.setResultCode(e.getMessage());
        }
        return respond;
    }

    public UpgradeRespond upgradeNvr800(VcmReqBaseInfo vcmReqBaseInfo, UpgradeRequest request) {
        UpgradeRespond respond = new UpgradeRespond();
        respond.setResultCode("0");
        respond.setDomainCode(vcmReqBaseInfo.getDomainCode());
        respond.setParentDeviceId(vcmReqBaseInfo.getParentDeviceId());
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        try {
            File file = new File(request.getFilePath());
            builder.addPart("file", (ContentBody)new FileBody(file));
            String rsp = (String)HttpRequestUtil.requestForm((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.UPGRADE_UPLOAD_PACKAGE, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getFormHead(vcmReqBaseInfo), (HttpEntity)builder.build(), (int)70);
            if (StringUtils.isBlank((CharSequence)rsp)) {
                return respond;
            }
            JSONObject result = JSONObject.parseObject((String)rsp);
            this.checkJsonRespond(result);
        }
        catch (SDKException e) {
            LOGGER.error("NVR 800 upload upgrade package error, IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        catch (Exception e) {
            LOGGER.error("NVR 800 upload upgrade unknown error, IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", "unknown_error");
        }
        return respond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

