/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.SystemConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.TimeConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.NtpConfigRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.SystemConfigRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.TimeConfigRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.TimeConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.SystemConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SystemConfigService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="systemConfigNvr800Service")
public class SystemConfigNvr800ServiceImpl
extends AbstractNvr800Service
implements SystemConfigService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemConfigNvr800ServiceImpl.class);

    public boolean setTimeConfig(ParamBean<TimeConfigRequest> obj) {
        try {
            NtpConfigRequestNvr800 ntpRequestNvr800 = new NtpConfigRequestNvr800((TimeConfigRequest)obj.getRequestBody());
            CommonRespondNvr800 ntpRespondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SYSTEM_CONFIG_NTP_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)ntpRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)ntpRespondNvr800);
            TimeConfigRequestNvr800 requestNvr800 = new TimeConfigRequestNvr800((TimeConfigRequest)obj.getRequestBody());
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SYSTEM_CONFIG_TIME_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("get ability happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public TimeConfigRespond getDateConfig(ParamBean<EmptyRequest> obj) {
        try {
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SYSTEM_CONFIG_TIME_GET, (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            TimeConfigRespond timeConfigRespond = new TimeConfigRespond();
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(respondNvr800.getData().getString("date_format"));
                SimpleDateFormat sdf2 = new SimpleDateFormat("yyyyMMdd");
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern(respondNvr800.getData().getString("date_format").replace("DD", "dd").replace("YYYY", "yyyy"));
                LocalDate localDate = LocalDate.parse(respondNvr800.getData().getString("date"), dtf);
                timeConfigRespond.setTime(localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")) + respondNvr800.getData().getString("time").replace(":", ""));
                timeConfigRespond.setCurrentTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            }
            catch (Exception e) {
                LOGGER.error("NVR 800 format date error", (Throwable)e);
                throw new InvokeException("500", "unknown_error");
            }
            timeConfigRespond.setTimezone(respondNvr800.getData().getString("time_zone"));
            return timeConfigRespond;
        }
        catch (SDKException e) {
            LOGGER.error("get date config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setSystemConfig(ParamBean<SystemConfigRequest> obj) {
        try {
            SystemConfigRequestNvr800 requestNvr800 = new SystemConfigRequestNvr800();
            requestNvr800.setAiSwitch(((SystemConfigRequest)obj.getRequestBody()).getAiSwitch().booleanValue());
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SYSTEM_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("get date config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public SystemConfigRespond getSystemConfig(ParamBean<EmptyRequest> obj) {
        try {
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SYSTEM_CONFIG_GET, (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            SystemConfigRespond respond = new SystemConfigRespond();
            respond.setAiSwitch(respondNvr800.getData().getBoolean("ai_switch"));
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("get date config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public TimeConfigRespond getNtpConfig(ParamBean<EmptyRequest> obj) {
        try {
            CommonRespondNvr800 ntpRespondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SYSTEM_CONFIG_NTP_GET, (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)ntpRespondNvr800);
            TimeConfigRespond timeConfigRespond = new TimeConfigRespond();
            timeConfigRespond.setEnableNTP(ntpRespondNvr800.getData().getBoolean("ntp_enable").booleanValue());
            timeConfigRespond.setNtpServer(ntpRespondNvr800.getData().getString("custom_server"));
            return timeConfigRespond;
        }
        catch (SDKException e) {
            LOGGER.error("NVR 800 get NTP config error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

