/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.suspecttask.SuspectTaskRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.suspecttask.TaskTime;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepository;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.suspecttask.SuspectTaskInfo;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.FaceRepositoryManagementService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SuspectTaskService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="suspectTaskNvr800Service")
public class SuspectTaskServiceNvr800Impl
extends AbstractNvr800Service
implements SuspectTaskService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuspectTaskServiceNvr800Impl.class);
    @Autowired
    private FaceRepositoryManagementService<IServerType.NVR800> faceRepositoryManagementNvr800Service;

    public boolean add(VcmReqBaseInfo vcmReqBaseInfo, SuspectTaskRequest suspectTaskRequest) {
        try {
            FaceRepositoryRequest faceRepositoryRequest = new FaceRepositoryRequest();
            faceRepositoryRequest.setName(suspectTaskRequest.getRepositoryInfo().getName());
            faceRepositoryRequest.setType(suspectTaskRequest.getRepositoryInfo().getType());
            FaceRepositorySearchRespond res = this.faceRepositoryManagementNvr800Service.search(vcmReqBaseInfo, faceRepositoryRequest);
            if (CollectionUtils.isEmpty((Collection)res.getRepositories())) {
                throw new InvokeException("500", DeviceUtil.CU_FACE_REPOSITORY_NOT_EXIST);
            }
            JSONObject groupInfo = new JSONObject();
            groupInfo.put("Id", (Object)Integer.parseInt(((FaceRepository)res.getRepositories().get(0)).getGroupId()));
            groupInfo.put("AlarmEnabled", (Object)1);
            if (StringUtils.isNotBlank((CharSequence)suspectTaskRequest.getConfidenceThreshold())) {
                groupInfo.put("Similarity", (Object)Integer.parseInt(suspectTaskRequest.getConfidenceThreshold()));
            }
            ArrayList<Integer> cameraCodes = new ArrayList<Integer>();
            suspectTaskRequest.getCameraCodes().forEach(code -> cameraCodes.add(Integer.parseInt(code.substring(2)) - 1));
            cameraCodes.sort(Comparator.comparingInt(code -> code));
            int[] enableChnAlarm = new int[4];
            cameraCodes.forEach(code -> {
                int n = code / 8;
                enableChnAlarm[n] = enableChnAlarm[n] + (int)Math.pow(2.0, code % 8);
            });
            groupInfo.put("EnableChnAlarm", (Object)enableChnAlarm);
            JSONArray alarmSchedule = this.weekSchedule(suspectTaskRequest.getTimeList(), cameraCodes);
            groupInfo.put("AlarmSchedule", (Object)alarmSchedule);
            JSONArray updateArray = new JSONArray();
            updateArray.add((Object)groupInfo);
            JSONObject updateData = new JSONObject();
            updateData.put("Group", (Object)updateArray);
            JSONObject updateRequest = new JSONObject();
            updateRequest.put("data", (Object)updateData);
            JSONObject updateRsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.UPDATE_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)updateRequest, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(updateRsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error(" addSuspectTask happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean update(VcmReqBaseInfo vcmReqBaseInfo, SuspectTaskRequest suspectTaskRequest) {
        return this.add(vcmReqBaseInfo, suspectTaskRequest);
    }

    public boolean delete(VcmReqBaseInfo vcmReqBaseInfo, SuspectTaskRequest suspectTaskRequest) {
        try {
            return this.commonOperate(vcmReqBaseInfo, suspectTaskRequest, false);
        }
        catch (SDKException e) {
            LOGGER.error("deleteSuspectTask happen exception ", (Throwable)e);
            return false;
        }
    }

    public boolean enable(VcmReqBaseInfo vcmReqBaseInfo, SuspectTaskRequest suspectTaskRequest) {
        try {
            return this.commonOperate(vcmReqBaseInfo, suspectTaskRequest, suspectTaskRequest.getEnable().booleanValue());
        }
        catch (SDKException e) {
            if (suspectTaskRequest.getEnable().booleanValue()) {
                LOGGER.error("startSuspectTask happen exception ", (Throwable)e);
            } else {
                LOGGER.error("stopSuspectTask happen exception ", (Throwable)e);
            }
            return false;
        }
    }

    public List<SuspectTaskInfo> search(VcmReqBaseInfo vcmReqBaseInfo, SuspectTaskRequest suspectTaskRequest) {
        List groupJsons = this.searchRepository(vcmReqBaseInfo, suspectTaskRequest == null ? null : suspectTaskRequest.getRepositoryInfo());
        return this.taskConvert(groupJsons);
    }

    public boolean commonOperate(VcmReqBaseInfo vcmReqBaseInfo, SuspectTaskRequest suspectTaskRequest, boolean alarmFlag) throws SDKException {
        FaceRepositoryRequest faceRepositoryRequest = new FaceRepositoryRequest();
        faceRepositoryRequest.setName(suspectTaskRequest.getRepositoryInfo().getName());
        faceRepositoryRequest.setType(suspectTaskRequest.getRepositoryInfo().getType());
        FaceRepositorySearchRespond res = this.faceRepositoryManagementNvr800Service.search(vcmReqBaseInfo, faceRepositoryRequest);
        JSONObject groupInfo = new JSONObject();
        groupInfo.put("Id", (Object)Integer.parseInt(((FaceRepository)res.getRepositories().get(0)).getGroupId()));
        groupInfo.put("AlarmEnabled", (Object)(alarmFlag ? 1 : 0));
        JSONArray updateArray = new JSONArray();
        updateArray.add((Object)groupInfo);
        JSONObject updateData = new JSONObject();
        updateData.put("Group", (Object)updateArray);
        JSONObject updateRequest = new JSONObject();
        updateRequest.put("data", (Object)updateData);
        JSONObject updateRsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.UPDATE_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)updateRequest, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        if (updateRsp != null) {
            int updateCode = (Integer)updateRsp.getJSONObject("data").getJSONArray("Result").get(0);
            return "0".equals(String.valueOf(updateCode));
        }
        return false;
    }

    public JSONArray weekSchedule(List<TaskTime> timeList, List<Integer> cameraCodes) {
        int[][] weekSchedule = new int[7][48];
        timeList.forEach(taskTime -> {
            int day = taskTime.getDay();
            int start = Integer.parseInt(taskTime.getStartTime().substring(0, 2)) * 2;
            int end = (Integer.parseInt(taskTime.getEndTime().substring(0, 2)) + 1) * 2;
            for (int i = start; i < end; ++i) {
                weekSchedule[day][i] = 1;
            }
        });
        JSONArray weekAlarmSchedule = new JSONArray();
        for (int i = 0; i < weekSchedule.length; ++i) {
            int[] dayArray = new int[6];
            int[] dayValues = weekSchedule[i];
            for (int j = 0; j < dayValues.length; ++j) {
                int n = j / 8;
                dayArray[n] = dayArray[n] + dayValues[j] * (int)Math.pow(2.0, j % 8);
            }
            weekAlarmSchedule.add((Object)dayArray);
        }
        JSONArray alarmSchedule = new JSONArray();
        int[][] emptyAlarmSchedule = new int[7][6];
        for (int i = 0; i < cameraCodes.get(cameraCodes.size() - 1) + 1; ++i) {
            if (cameraCodes.contains(i)) {
                alarmSchedule.add((Object)weekAlarmSchedule);
                continue;
            }
            alarmSchedule.add((Object)emptyAlarmSchedule);
        }
        return alarmSchedule;
    }

    public List<JSONObject> searchRepository(VcmReqBaseInfo vcmReqBaseInfo, FaceRepository faceRepository) {
        ArrayList<JSONObject> groups = new ArrayList<JSONObject>();
        try {
            JSONObject data = new JSONObject();
            data.put("DefaultVal", (Object)0);
            data.put("WithInternal", (Object)0);
            data.put("SimpleInfo", (Object)0);
            if (faceRepository != null && !StringUtils.isEmpty((CharSequence)faceRepository.getName())) {
                data.put("Name", (Object)faceRepository.getName());
            }
            JSONObject request = new JSONObject();
            request.put("data", (Object)data);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.SEARCH_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            if (!CollectionUtils.isEmpty((Collection)rsp.getJSONObject("data").getJSONArray("Group"))) {
                JSONArray array = rsp.getJSONObject("data").getJSONArray("Group");
                array.stream().filter(obj -> {
                    if (faceRepository != null && !StringUtils.isEmpty((CharSequence)faceRepository.getName())) {
                        return ((JSONObject)obj).getIntValue("Id") > 4 && faceRepository.getName().equals(((JSONObject)obj).getString("Name"));
                    }
                    return ((JSONObject)obj).getIntValue("Id") > 4;
                }).filter(obj -> {
                    if (faceRepository != null && !StringUtils.isEmpty((CharSequence)faceRepository.getType())) {
                        if ("2".equals(faceRepository.getType())) {
                            return ((JSONObject)obj).getIntValue("Policy") == 1;
                        }
                        if ("3".equals(faceRepository.getType())) {
                            return ((JSONObject)obj).getIntValue("Policy") == 0;
                        }
                    }
                    return true;
                }).forEach(obj -> groups.add((JSONObject)obj));
            }
        }
        catch (SDKException e) {
            LOGGER.error("searchGroup happen exception ", (Throwable)e);
        }
        return groups;
    }

    public List<SuspectTaskInfo> taskConvert(List<JSONObject> groupJsons) {
        ArrayList<SuspectTaskInfo> suspectTaskInfos = new ArrayList<SuspectTaskInfo>();
        if (!CollectionUtils.isEmpty(groupJsons)) {
            for (JSONObject groupJson : groupJsons) {
                SuspectTaskInfo taskInfo = new SuspectTaskInfo();
                taskInfo.setEnable(Boolean.valueOf(groupJson.getIntValue("AlarmEnabled") == 1));
                taskInfo.setConfidenceThreshold(groupJson.getIntValue("Similarity"));
                ArrayList<String> cameraCodes = new ArrayList<String>();
                if (groupJson.getIntValue("AlarmEnabled") == 1) {
                    JSONArray enableChnAlarm = groupJson.getJSONArray("EnableChnAlarm");
                    for (int i = 0; i < enableChnAlarm.size(); ++i) {
                        int alarmIntValue = enableChnAlarm.getIntValue(i);
                        String alarmInfo = Integer.toBinaryString(alarmIntValue);
                        String alarmInfoReverse = new StringBuffer(alarmInfo).reverse().toString();
                        String[] alarmInfoSplit = alarmInfoReverse.split("");
                        for (int j = 0; j < alarmInfoSplit.length; ++j) {
                            if (!"1".equals(alarmInfoSplit[j])) continue;
                            cameraCodes.add("CH" + (8 * i + j + 1));
                        }
                    }
                }
                taskInfo.setCameraCodes(cameraCodes);
                if (!CollectionUtils.isEmpty(cameraCodes)) {
                    String channelCode = (String)cameraCodes.get(0);
                    JSONArray alarmSchedule = groupJson.getJSONArray("AlarmSchedule").getJSONArray(Integer.parseInt(channelCode.substring(2)) - 1);
                    taskInfo.setTimeList(this.taskTimeConvert(alarmSchedule));
                } else {
                    taskInfo.setTimeList(new ArrayList());
                }
                FaceRepository faceRepository = new FaceRepository();
                faceRepository.setName(groupJson.getString("Name"));
                faceRepository.setType(groupJson.getIntValue("Policy") == 0 ? "3" : "2");
                faceRepository.setGroupId(groupJson.getString("Id"));
                taskInfo.setRepositoryInfo(faceRepository);
                suspectTaskInfos.add(taskInfo);
            }
        }
        return suspectTaskInfos;
    }

    public List<TaskTime> taskTimeConvert(JSONArray alarmSchedule) {
        ArrayList<TaskTime> timeList = new ArrayList<TaskTime>();
        for (int i = 0; i < alarmSchedule.size(); ++i) {
            JSONArray weekISchedule = alarmSchedule.getJSONArray(i);
            StringBuilder weekIScheduleStr = new StringBuilder();
            for (int j = 0; j < weekISchedule.size(); ++j) {
                int scheduleJ = weekISchedule.getIntValue(j);
                String scheduleJStr = Integer.toBinaryString(scheduleJ);
                StringBuilder scheduleJStrReverse = new StringBuilder(scheduleJStr).reverse();
                while (scheduleJStrReverse.length() < 8) {
                    scheduleJStrReverse.append("0");
                }
                weekIScheduleStr.append((CharSequence)scheduleJStrReverse);
            }
            String[] weekIScheduleStrArray = weekIScheduleStr.toString().split("");
            int startIndex = 99;
            int endIndex = 99;
            for (int k = 0; k < weekIScheduleStrArray.length; ++k) {
                if ("1".equals(weekIScheduleStrArray[k]) && startIndex == 99) {
                    startIndex = k;
                }
                if ("1".equals(weekIScheduleStrArray[k])) {
                    endIndex = k;
                }
                if (!"0".equals(weekIScheduleStrArray[k]) && k != weekIScheduleStrArray.length - 1 || startIndex == 99) continue;
                TaskTime taskTime = new TaskTime();
                taskTime.setDay(i);
                String start = String.valueOf(startIndex / 2);
                String end = String.valueOf(endIndex / 2);
                if (start.length() < 2) {
                    start = "0" + start;
                }
                if (end.length() < 2) {
                    end = "0" + end;
                }
                taskTime.setStartTime(start + ":00:00");
                taskTime.setEndTime(end + ":59:59");
                timeList.add(taskTime);
                startIndex = 99;
            }
        }
        return timeList;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

