/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.SnapshotRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.HeatMapRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligentAnalysis.CcStatisticsRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.HeatMapStatisticsRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.intelligent.CcStatisticsRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.SnapshotRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SnapshotService;
import com.zkteco.zkbiosecurity.cuserver.service.StatisticsService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="statisticsNvr800Service")
public class StatisticsNvr800ServiceImpl
extends AbstractNvr800Service
implements StatisticsService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsNvr800ServiceImpl.class);
    @Autowired
    private SnapshotService<IServerType.NVR800> nvr800SnapshotService;

    public JSONObject getCc(VcmReqBaseInfo vcmInfo, CcStatisticsRequest ccStatisticsRequest) {
        CcStatisticsRequestNvr800 ccStatisticsRequestNvr800 = new CcStatisticsRequestNvr800(ccStatisticsRequest);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.CC_STATISTICS_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)ccStatisticsRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(result);
            if (result.getJSONObject("data") != null) {
                return result.getJSONObject("data");
            }
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONObject getHeatMap(VcmReqBaseInfo vcmInfo, HeatMapRequest heatMapRequest) {
        HeatMapStatisticsRequestNvr800 heatMapStatisticsRequestNvr800 = new HeatMapStatisticsRequestNvr800(heatMapRequest);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.HEAT_MAP_STATISTICS_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)heatMapStatisticsRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo), (int)20);
            this.checkJsonRespond(result);
            if (result.getJSONObject("data") != null) {
                JSONObject jsonObject = result.getJSONObject("data");
                if (heatMapRequest.getGetSpaceMap() == 1 && StringUtils.isNotBlank((CharSequence)jsonObject.getString("Image"))) {
                    SnapshotRequest snapshotRequest = new SnapshotRequest();
                    snapshotRequest.setChannelCode("CH" + heatMapRequest.getChn().toString());
                    SnapshotRespond snapshotRespond = this.nvr800SnapshotService.createSnapshot(vcmInfo, snapshotRequest);
                    jsonObject.put("backgroundImage", (Object)snapshotRespond.getImgBase64Str());
                }
                return jsonObject;
            }
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("get heat map error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

