/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.SnapshotRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.SnapshotRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.SnapshotRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SnapshotService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="snapshotNvr800Service")
public class SnapshotNvr800ServiceImpl
implements SnapshotService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotNvr800ServiceImpl.class);

    public SnapshotRespond createSnapshot(VcmReqBaseInfo vcmInfo, SnapshotRequest req) {
        JSONObject result;
        SnapshotRequestNvr800 snapshotRequestNvr800 = this.requestToNvr800(req);
        try {
            result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.SNAPSHOT_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)snapshotRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        String imgBase64 = (String)result.getJSONObject("data").get((Object)"img_data");
        SnapshotRespond snapshotRespond = new SnapshotRespond();
        snapshotRespond.setImgBase64Str(imgBase64);
        return snapshotRespond;
    }

    private SnapshotRequestNvr800 requestToNvr800(SnapshotRequest req) {
        SnapshotRequestNvr800 snapshotRequestNvr800 = new SnapshotRequestNvr800();
        snapshotRequestNvr800.getData().put("channel", (Object)req.getChannelCode());
        return snapshotRequestNvr800;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

