/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.ScheduleSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.ScheduleSetRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.device.ChannelRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.PerimeterZoneGetRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.ScheduleService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="scheduleNvr800Service")
public class ScheduleNvr800ServiceImpl
extends AbstractNvr800Service
implements ScheduleService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduleNvr800ServiceImpl.class);

    private JSONObject getSchedule(ParamBean<ChannelRequest> obj, Nvr800MsgType msgType) {
        String channelCode = ((ChannelRequest)obj.getRequestBody()).getChannelCode();
        ChannelRequestNvr800 requestNvr800 = new ChannelRequestNvr800(channelCode);
        try {
            PerimeterZoneGetRespondNvr800 respondNvr800 = (PerimeterZoneGetRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)msgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PerimeterZoneGetRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            if (respondNvr800.getData() != null && respondNvr800.getData().getJSONObject("channel_info") != null) {
                return respondNvr800.getData().getJSONObject("channel_info").getJSONObject(channelCode);
            }
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private boolean setSchedule(ParamBean<ScheduleSetRequest> obj, Nvr800MsgType msgType) {
        String channelCode = ((ScheduleSetRequest)obj.getRequestBody()).getChannelCode();
        ScheduleSetRequestNvr800 requestNvr800 = new ScheduleSetRequestNvr800(channelCode, ((ScheduleSetRequest)obj.getRequestBody()).getData());
        try {
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)msgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setRecordSchedule(ParamBean<ScheduleSetRequest> obj) {
        return this.setSchedule(obj, Nvr800MsgType.RECORD_SCHEDULE_SET);
    }

    public boolean setAlarmSchedule(ParamBean<ScheduleSetRequest> obj) {
        return this.setSchedule(obj, Nvr800MsgType.ALARM_SCHEDULE_SET);
    }

    public boolean setEmailSchedule(ParamBean<ScheduleSetRequest> obj) {
        return this.setSchedule(obj, Nvr800MsgType.EMAIL_SCHEDULE_SET);
    }

    public JSONObject getRecordSchedule(ParamBean<ChannelRequest> obj) {
        return this.getSchedule(obj, Nvr800MsgType.RECORD_SCHEDULE_GET);
    }

    public JSONObject getAlarmSchedule(ParamBean<ChannelRequest> obj) {
        return this.getSchedule(obj, Nvr800MsgType.ALARM_SCHEDULE_GET);
    }

    public JSONObject getEmailSchedule(ParamBean<ChannelRequest> obj) {
        return this.getSchedule(obj, Nvr800MsgType.EMAIL_SCHEDULE_GET);
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

