/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPPlayBackRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPRealPlayRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVideoDownloadRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVoiceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.RTSPPlayBackRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.RTSPRealPlayRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPPlayBackRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPRealPlayRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVideoDownloadRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVoiceRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.RTSPPlayBackRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.RTSPRealPlayRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.RTSPService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="rtspNVR800Service")
public class RTSPNVR800ServiceImpl
extends AbstractNvr800Service
implements RTSPService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RTSPNVR800ServiceImpl.class);

    public RTSPRealPlayRespond realPlay(VcmReqBaseInfo vcmInfo, RTSPRealPlayRequest request) {
        boolean extenxion = Objects.nonNull(request.getExtenxion()) ? request.getExtenxion() : false;
        RTSPRealPlayRequestNvr800 rtspRealPlayRequestNvr800 = this.requestRealPlayToNvr800(request.getChannelCode(), false, false, extenxion);
        try {
            RTSPRealPlayRespondNvr800 rtspRealPlayRespondNvr800 = (RTSPRealPlayRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.REAL_PLAY_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)rtspRealPlayRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, RTSPRealPlayRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)rtspRealPlayRespondNvr800);
            JSONObject channelInfo = rtspRealPlayRespondNvr800.getData().getJSONArray("channel_info").getJSONObject(0);
            if (!channelInfo.containsKey((Object)"mainstream")) {
                throw new InvokeException("500", "cu_offline_error");
            }
            return this.toRealPlayResult(channelInfo);
        }
        catch (SDKException e) {
            LOGGER.error("IVS1800 real play error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public RTSPPlayBackRespond playBack(VcmReqBaseInfo vcmInfo, RTSPPlayBackRequest request) {
        RTSPPlayBackRequestNvr800 rtspPlayBackRequestNvr800 = this.requestPlayBackToNvr800(request);
        try {
            RTSPPlayBackRespondNvr800 rtspPlayBackRespondNvr800 = (RTSPPlayBackRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.PLAY_BACK_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)rtspPlayBackRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, RTSPPlayBackRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)rtspPlayBackRespondNvr800);
            return this.toPlayBackResult(rtspPlayBackRespondNvr800, request);
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 rtsp play back error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public RTSPVoiceRespond voice(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        RTSPRealPlayRequestNvr800 rtspRealPlayRequestNvr800 = this.requestRealPlayToNvr800(request.getChannelCode(), false, true, false);
        try {
            RTSPRealPlayRespondNvr800 rtspRealPlayRespondNvr800 = (RTSPRealPlayRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.REAL_PLAY_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)rtspRealPlayRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, RTSPRealPlayRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)rtspRealPlayRespondNvr800);
            JSONObject channelInfo = rtspRealPlayRespondNvr800.getData().getJSONArray("channel_info").getJSONObject(0);
            if (!channelInfo.containsKey((Object)"dualtalk")) {
                throw new InvokeException("500", "cu_offline_error");
            }
            RTSPVoiceRespond rtspRealPlayRespond = new RTSPVoiceRespond();
            rtspRealPlayRespond.setRtspUrl(channelInfo.get((Object)"dualtalk").toString());
            rtspRealPlayRespond.setType(Integer.valueOf(1));
            return rtspRealPlayRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 voice error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public RTSPVoiceRespond broadcast(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        RTSPRealPlayRequestNvr800 rtspRealPlayRequestNvr800 = this.requestRealPlayToNvr800(request.getChannelCode(), true, true, false);
        try {
            RTSPRealPlayRespondNvr800 rtspRealPlayRespondNvr800 = (RTSPRealPlayRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.REAL_PLAY_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)rtspRealPlayRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, RTSPRealPlayRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)rtspRealPlayRespondNvr800);
            JSONObject data = rtspRealPlayRespondNvr800.getData();
            if (!data.containsKey((Object)"dualtalk")) {
                throw new InvokeException("500", "cu_offline_error");
            }
            RTSPVoiceRespond rtspRealPlayRespond = new RTSPVoiceRespond();
            rtspRealPlayRespond.setRtspUrl(data.get((Object)"dualtalk").toString());
            rtspRealPlayRespond.setType(Integer.valueOf(1));
            return rtspRealPlayRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 broadcast error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public RTSPVideoDownloadRespond videoDownload(VcmReqBaseInfo vcmInfo, RTSPVideoDownloadRequest request) {
        return null;
    }

    private RTSPRealPlayRequestNvr800 requestRealPlayToNvr800(String channelCode, boolean isBroadcast, boolean isVoice, boolean isExtenxion) {
        RTSPRealPlayRequestNvr800 rtspRealPlayRequestNvr800 = new RTSPRealPlayRequestNvr800();
        JSONArray channel = new JSONArray();
        channel.add((Object)channelCode);
        rtspRealPlayRequestNvr800.getData().put("channel", (Object)channel);
        if (isExtenxion) {
            rtspRealPlayRequestNvr800.getData().put("is_extenxion", (Object)true);
        }
        if (isBroadcast) {
            rtspRealPlayRequestNvr800.getData().put("is_device", (Object)true);
        }
        if (isVoice) {
            rtspRealPlayRequestNvr800.getData().put("is_dualtalk", (Object)true);
        }
        return rtspRealPlayRequestNvr800;
    }

    private RTSPPlayBackRequestNvr800 requestPlayBackToNvr800(RTSPPlayBackRequest req) {
        RTSPPlayBackRequestNvr800 rtspPlayBackRequestNvr800 = new RTSPPlayBackRequestNvr800();
        Map timeMap = this.timeWorker(req);
        rtspPlayBackRequestNvr800.getData().put("channel", (Object)req.getChannelCode());
        rtspPlayBackRequestNvr800.getData().put("start_date", timeMap.get("start_date"));
        rtspPlayBackRequestNvr800.getData().put("end_date", timeMap.get("end_date"));
        rtspPlayBackRequestNvr800.getData().put("start_time", timeMap.get("start_time"));
        rtspPlayBackRequestNvr800.getData().put("end_time", timeMap.get("end_time"));
        if (Objects.nonNull(req.getNeedMetadata())) {
            rtspPlayBackRequestNvr800.getData().put("is_metadata", (Object)req.getNeedMetadata());
        }
        if (Objects.nonNull(req.getNeedExtenxion())) {
            rtspPlayBackRequestNvr800.getData().put("is_extenxion", (Object)req.getNeedExtenxion());
        }
        return rtspPlayBackRequestNvr800;
    }

    private Map<String, String> timeWorker(RTSPPlayBackRequest req) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] startArr = req.getStartDate().split(" ");
        map.put("start_date", startArr[0]);
        map.put("start_time", startArr[1]);
        String[] endArr = req.getEndDate().split(" ");
        map.put("end_date", endArr[0]);
        map.put("end_time", endArr[1]);
        return map;
    }

    private RTSPRealPlayRespond toRealPlayResult(JSONObject channelInfo) {
        RTSPRealPlayRespond rtspRealPlayRespond = new RTSPRealPlayRespond();
        JSONObject mainStream = new JSONObject();
        mainStream.put("type", (Object)1);
        mainStream.put("rtspUrl", (Object)channelInfo.get((Object)"mainstream").toString());
        JSONObject subStream = new JSONObject();
        subStream.put("type", (Object)2);
        subStream.put("rtspUrl", (Object)channelInfo.get((Object)"substream").toString());
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        result.add(mainStream);
        result.add(subStream);
        rtspRealPlayRespond.setRtspUrls(result);
        return rtspRealPlayRespond;
    }

    private RTSPPlayBackRespond toPlayBackResult(RTSPPlayBackRespondNvr800 rtspPlayBackRespondNvr800, RTSPPlayBackRequest request) {
        RTSPPlayBackRespond rtspPlayBackRespond = new RTSPPlayBackRespond();
        String url = (String)rtspPlayBackRespondNvr800.getData().get((Object)"playback_url");
        JSONObject urlObj = new JSONObject();
        urlObj.put("type", (Object)request.getType());
        urlObj.put("rtspUrl", (Object)url);
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        result.add(urlObj);
        rtspPlayBackRespond.setRtspUrls(result);
        return rtspPlayBackRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

