/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.SnapObjectDetailRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.SnapObjectRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.FaceImageSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.FaceSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.HumanSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.PicturePlaybackRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.vehicleRepository.VehicleDynamicRetrievalRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.vehicleRepository.VehicleRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.PageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.FaceSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.HumanSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.PicturePlaybackRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.SnapObjectRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.PictureSearchService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.VehicleRepositoryNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PictureSearchNVR800ServiceImpl
extends AbstractNvr800Service
implements PictureSearchService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PictureSearchNVR800ServiceImpl.class);
    @Autowired
    private VehicleRepositoryNvr800ServiceImpl vehicleRepositoryNvr800Service;

    public PicturePlaybackRespond picturePlayback(ParamBean<PicturePlaybackRequest> obj) {
        CommonRespondNvr800 commonPicturePlayback = this.getCommonPicturePlayback(obj);
        return this.picturePlaybackRspConvert(obj.getVcmInfo(), commonPicturePlayback.getData(), ((PicturePlaybackRequest)obj.getRequestBody()).getPicInfoKey());
    }

    public JSONObject picturePlaybackInfo(ParamBean<PicturePlaybackRequest> obj) {
        JSONObject jsonObject = new JSONObject();
        CommonRespondNvr800 commonPicturePlayback = this.getCommonPicturePlayback(obj);
        boolean isHaveThirdObj = commonPicturePlayback.getData().getJSONObject("picture").containsKey((Object)"third_object");
        if (isHaveThirdObj) {
            String thirdAlgorithmName = commonPicturePlayback.getData().getJSONObject("picture").getJSONObject("third_object").getString("alog_name");
            jsonObject.put("thirdAlgorithmName", (Object)thirdAlgorithmName);
        }
        return jsonObject;
    }

    private CommonRespondNvr800 getCommonPicturePlayback(ParamBean<PicturePlaybackRequest> obj) {
        JSONObject request = this.picturePlaybackReq((PicturePlaybackRequest)obj.getRequestBody());
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.PICTURE_PLAY_BACK_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("get picture playback happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public FaceSearchRespond faceSearch(ParamBean<FaceSearchRequest> obj) {
        JSONObject countInfo = this.faceSearchCount(obj, -1);
        int count = countInfo.getIntValue("Count");
        FaceSearchRespond faceSearchRespond = new FaceSearchRespond();
        if (count > 0 && ((FaceSearchRequest)obj.getRequestBody()).getSearchCount() > 0) {
            faceSearchRespond = this.faceSearchInfo(obj, ((FaceSearchRequest)obj.getRequestBody()).getSearchCount(), ((FaceSearchRequest)obj.getRequestBody()).getStartIndex());
        }
        return faceSearchRespond;
    }

    public FaceSearchRespond faceImageSearch(ParamBean<FaceImageSearchRequest> obj) {
        JSONObject data = new JSONObject();
        data.put("Engine", (Object)0);
        data.put("WithFaceImage", (Object)1);
        data.put("WithBackgroud", (Object)1);
        data.put("WithFeature", (Object)0);
        data.put("UUIds", (Object)((FaceImageSearchRequest)obj.getRequestBody()).getFileIds());
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.FACE_IMAGE_SEARCH_INFO, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            return this.faceSearchRspConvert(obj.getVcmInfo(), rsp.getData());
        }
        catch (SDKException e) {
            LOGGER.error("search face image info happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public FaceSearchRespond faceSearchByImage(ParamBean<FaceSearchRequest> obj) {
        int faceID = this.addToDeviceGetId(obj);
        JSONObject countInfo = this.faceSearchCount(obj, faceID);
        int count = countInfo.getIntValue("Count");
        FaceSearchRespond faceSearchRespond = new FaceSearchRespond();
        if (count > 0 && ((FaceSearchRequest)obj.getRequestBody()).getSearchCount() > 0) {
            faceSearchRespond = this.faceSearchInfo(obj, ((FaceSearchRequest)obj.getRequestBody()).getSearchCount(), ((FaceSearchRequest)obj.getRequestBody()).getStartIndex());
        }
        return faceSearchRespond;
    }

    public JSONArray getReturnFace(ParamBean<FaceSearchRequest> obj) {
        JSONArray matchAddedFacesAry;
        JSONArray filterSnapedFacesAry;
        JSONArray uuIdsAry;
        JSONObject countInfo = this.faceSearchCount(obj, -1);
        int count = countInfo.getIntValue("Count");
        JSONArray result = new JSONArray();
        if (!(count <= 0 || CollectionUtils.isEmpty((Collection)(uuIdsAry = this.getSnapedFeaturesIdUUIdsAry(obj, count))) || CollectionUtils.isEmpty((Collection)(filterSnapedFacesAry = this.getFilterSnapedFacesAry(obj, uuIdsAry))) || CollectionUtils.isEmpty((Collection)(matchAddedFacesAry = this.getMatchAddedFacesAry(obj, filterSnapedFacesAry))))) {
            JSONObject data = new JSONObject();
            data.put("WithFaceImage", (Object)1);
            data.put("WithBackgroud", (Object)1);
            data.put("WithFeature", (Object)0);
            for (int i = 0; i < matchAddedFacesAry.size(); ++i) {
                data.put("UUIds", matchAddedFacesAry.get(i));
                FaceSearchRespond snapedFacesById = this.getSnapedFacesById(obj, data);
                result.add((Object)snapedFacesById);
            }
        }
        return result;
    }

    public JSONArray getFaceSearchCount(ParamBean<FaceSearchRequest> obj) {
        ((FaceSearchRequest)obj.getRequestBody()).setSortType("0");
        JSONObject countInfo = this.faceSearchCount(obj, -1);
        int count = countInfo.getIntValue("Count");
        JSONArray result = new JSONArray();
        if (count > 0) {
            JSONArray uuIdsAry = this.getSnapedFeaturesIdUUIdsAry(obj, count);
            return uuIdsAry;
        }
        return result;
    }

    public JSONArray getFilterSnapedFace(ParamBean<FaceSearchRequest> obj) {
        JSONArray matchAddedFacesAry;
        JSONArray result = new JSONArray();
        JSONArray uuIdsAry = this.getSnapedFeaturesIdUUIdsAry(obj, ((FaceSearchRequest)obj.getRequestBody()).getCount().intValue());
        if (uuIdsAry.size() > 0 && (matchAddedFacesAry = this.getFilterSnapedFacesAry2(obj, uuIdsAry)).size() > 0) {
            JSONObject data = new JSONObject();
            data.put("WithFaceImage", (Object)1);
            data.put("WithBackgroud", (Object)1);
            data.put("WithFeature", (Object)0);
            for (int i = 0; i < matchAddedFacesAry.size(); ++i) {
                JSONArray jsonArray = new JSONArray();
                JSONArray dataList = (JSONArray)matchAddedFacesAry.get(i);
                jsonArray.add(dataList.get(0));
                data.put("UUIds", (Object)jsonArray);
                FaceSearchRespond snapedFacesById = this.getSnapedFacesById(obj, data);
                snapedFacesById.setCount(dataList.size());
                snapedFacesById.setUuidArray(dataList);
                result.add((Object)snapedFacesById);
            }
        }
        return result;
    }

    public JSONArray getSnapedFacesById(ParamBean<FaceSearchRequest> obj) {
        JSONArray result = new JSONArray();
        JSONObject data = new JSONObject();
        data.put("WithFaceImage", (Object)1);
        data.put("WithBackgroud", (Object)1);
        data.put("WithFeature", (Object)0);
        data.put("UUIds", (Object)((FaceSearchRequest)obj.getRequestBody()).getUuIdsAry());
        FaceSearchRespond snapedFacesById = this.getSnapedFacesById(obj, data);
        result.add((Object)snapedFacesById);
        return result;
    }

    public FaceSearchRespond getSnapedFacesById(ParamBean<FaceSearchRequest> obj, JSONObject data) {
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        CommonRespondNvr800 rsp = null;
        try {
            rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.FACE_IMAGE_SEARCH_INFO, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            int resultCode = rsp.getData().getIntValue("Result");
            if (rsp.getData() != null) {
                return this.faceSearchRspConvert(obj.getVcmInfo(), rsp.getData());
            }
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONArray getMatchAddedFacesAry(ParamBean<FaceSearchRequest> obj, JSONArray filterSnapedFacesAry) {
        JSONArray resultArr = new JSONArray();
        JSONObject matchAddedFacesJson = new JSONObject();
        matchAddedFacesJson.put("MsgId", (Object)((FaceSearchRequest)obj.getRequestBody()).getMsgId());
        matchAddedFacesJson.put("Engine", (Object)((FaceSearchRequest)obj.getRequestBody()).getEngine());
        matchAddedFacesJson.put("Similarity", (Object)((FaceSearchRequest)obj.getRequestBody()).getSimilarity());
        matchAddedFacesJson.put("GrpIds", (Object)((FaceSearchRequest)obj.getRequestBody()).getGroupIds());
        for (int i = 0; i < filterSnapedFacesAry.size(); ++i) {
            JSONArray faceIdsArr = new JSONArray();
            JSONArray faceUUidArr = filterSnapedFacesAry.getJSONArray(i);
            matchAddedFacesJson.put("UUIds", (Object)faceUUidArr);
            JSONObject matchAddedFacesReq = new JSONObject();
            matchAddedFacesReq.put("data", (Object)matchAddedFacesJson);
            try {
                CommonRespondNvr800 matchAddedFacesRsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.MATCH_ADDED_FACES_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)matchAddedFacesReq, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
                this.checkRespond((BaseRespondNvr800)matchAddedFacesRsp);
                JSONArray faceIds = matchAddedFacesRsp.getData().getJSONArray("FaceIds");
                for (int j = 0; j < faceIds.size(); ++j) {
                    if ("-1".equals(faceIds.get(j))) continue;
                    faceIdsArr.add(faceUUidArr.get(j));
                }
                resultArr.add((Object)faceIdsArr);
                continue;
            }
            catch (SDKException e) {
                LOGGER.error("error", (Throwable)e);
                throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
            }
        }
        return resultArr;
    }

    public JSONArray getFilterSnapedFacesAry(ParamBean<FaceSearchRequest> obj, JSONArray uuIdsAry) {
        JSONObject filterSnapedFacesJson = new JSONObject();
        filterSnapedFacesJson.put("Engine", (Object)((FaceSearchRequest)obj.getRequestBody()).getEngine());
        filterSnapedFacesJson.put("MsgId", (Object)((FaceSearchRequest)obj.getRequestBody()).getMsgId());
        filterSnapedFacesJson.put("MinInterval", (Object)((FaceSearchRequest)obj.getRequestBody()).getMinInterval());
        filterSnapedFacesJson.put("Similarity", (Object)((FaceSearchRequest)obj.getRequestBody()).getSimilarity());
        List uuIdsList = uuIdsAry.toJavaList(String.class);
        JSONArray resultArr = new JSONArray();
        JSONArray countingAry = new JSONArray();
        filterSnapedFacesJson.put("Filter", uuIdsList.get(0));
        filterSnapedFacesJson.put("UUIdSet", (Object)uuIdsList);
        JSONObject filterSnapedFacesReq = new JSONObject();
        filterSnapedFacesReq.put("data", (Object)filterSnapedFacesJson);
        try {
            CommonRespondNvr800 filterSnapedFacesRsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.FILTER_SNAPED_FACES_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)filterSnapedFacesReq, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)filterSnapedFacesRsp);
            JSONArray matchedUUIds = filterSnapedFacesRsp.getData().getJSONArray("MatchedIds");
            JSONArray counting = filterSnapedFacesRsp.getData().getJSONArray("Counting");
            if (matchedUUIds != null && matchedUUIds.size() > 0) {
                for (int j = 0; j < counting.size(); ++j) {
                    if (1 != counting.getIntValue(j)) continue;
                    countingAry.add(matchedUUIds.get(j));
                }
                resultArr.add((Object)countingAry);
            }
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return resultArr;
    }

    public JSONArray getFilterSnapedFacesAry2(ParamBean<FaceSearchRequest> obj, JSONArray uuIdsAry) {
        JSONObject filterSnapedFacesJson = new JSONObject();
        filterSnapedFacesJson.put("Engine", (Object)((FaceSearchRequest)obj.getRequestBody()).getEngine());
        filterSnapedFacesJson.put("MsgId", (Object)((FaceSearchRequest)obj.getRequestBody()).getMsgId());
        filterSnapedFacesJson.put("MinInterval", (Object)((FaceSearchRequest)obj.getRequestBody()).getMinInterval());
        filterSnapedFacesJson.put("Similarity", (Object)((FaceSearchRequest)obj.getRequestBody()).getSimilarity());
        List uuIdsList = uuIdsAry.toJavaList(String.class);
        JSONArray resultArr = new JSONArray();
        JSONArray countingAry = new JSONArray();
        filterSnapedFacesJson.put("Filter", (Object)((FaceSearchRequest)obj.getRequestBody()).getFilterStr());
        filterSnapedFacesJson.put("UUIdSet", (Object)uuIdsList);
        JSONObject filterSnapedFacesReq = new JSONObject();
        filterSnapedFacesReq.put("data", (Object)filterSnapedFacesJson);
        try {
            CommonRespondNvr800 filterSnapedFacesRsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.FILTER_SNAPED_FACES_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)filterSnapedFacesReq, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            int resultCode = filterSnapedFacesRsp.getData().getIntValue("Result");
            if (!"0".equals(String.valueOf(resultCode))) {
                throw new InvokeException("500", Nvr800Utils.get((int)resultCode));
            }
            JSONArray matchedUUIds = filterSnapedFacesRsp.getData().getJSONArray("MatchedIds");
            JSONArray counting = filterSnapedFacesRsp.getData().getJSONArray("Counting");
            if (matchedUUIds != null && matchedUUIds.size() > 0) {
                for (int j = 0; j < counting.size(); ++j) {
                    if (1 != counting.getIntValue(j)) continue;
                    countingAry.add(matchedUUIds.get(j));
                }
                resultArr.add((Object)countingAry);
            }
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return resultArr;
    }

    public JSONArray getSnapedFeaturesIdUUIdsAry(ParamBean<FaceSearchRequest> obj, int count) {
        JSONObject snapedFeaturesIdJson = new JSONObject();
        snapedFeaturesIdJson.put("Engine", (Object)((FaceSearchRequest)obj.getRequestBody()).getEngine());
        snapedFeaturesIdJson.put("MsgId", (Object)((FaceSearchRequest)obj.getRequestBody()).getMsgId());
        snapedFeaturesIdJson.put("Count", (Object)count);
        snapedFeaturesIdJson.put("StartIndex", (Object)((FaceSearchRequest)obj.getRequestBody()).getStartIndex());
        JSONObject snapedFeaturesIdReq = new JSONObject();
        snapedFeaturesIdReq.put("data", (Object)snapedFeaturesIdJson);
        try {
            CommonRespondNvr800 snapedFeaturesIdRsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SNAPED_FEATURES_ID_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)snapedFeaturesIdReq, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            int resultCode = snapedFeaturesIdRsp.getData().getIntValue("Result");
            if (!"0".equals(String.valueOf(resultCode))) {
                throw new InvokeException("500", Nvr800Utils.get((int)resultCode));
            }
            return snapedFeaturesIdRsp.getData().getJSONArray("UUIds");
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public int addToDeviceGetId(ParamBean<FaceSearchRequest> obj) {
        JSONObject data = new JSONObject();
        data.put("Count", (Object)1);
        data.put("WithImage", (Object)1);
        data.put("WithFeature", (Object)0);
        JSONObject faceInfo = new JSONObject();
        faceInfo.put("Image", (Object)((FaceSearchRequest)obj.getRequestBody()).getImageBase64());
        JSONArray faceInfos = new JSONArray();
        faceInfos.add((Object)faceInfo);
        data.put("FaceInfo", (Object)faceInfos);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.FACE_SEARCH_BY_IMAGE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return rsp.getData().getJSONArray("FaceInfo").getJSONObject(0).getIntValue("Id");
        }
        catch (SDKException e) {
            LOGGER.error("search face image info happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public FaceSearchRespond faceSearchInfo(ParamBean<FaceSearchRequest> obj, int searchCount, int startIndex) {
        JSONObject data = new JSONObject();
        data.put("Engine", (Object)0);
        data.put("SimpleInfo", (Object)0);
        data.put("WithFaceImage", (Object)0);
        data.put("WithBackgroud", (Object)0);
        data.put("StartIndex", (Object)Math.max(startIndex, 0));
        data.put("Count", (Object)searchCount);
        data.put("MatchedFaces", (Object)1);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.FACE_SEARCH_INFO, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()), (int)120);
            this.checkJsonRespond((JSONObject)JSONObject.toJSON((Object)rsp));
            return this.faceSearchRspConvert(obj.getVcmInfo(), rsp.getData());
        }
        catch (SDKException e) {
            LOGGER.error("search face info happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONObject faceSearchCount(ParamBean<FaceSearchRequest> obj, int faceId) {
        FaceSearchRequest request = (FaceSearchRequest)obj.getRequestBody();
        JSONObject data = new JSONObject();
        if (!CollectionUtils.isEmpty((Collection)request.getChannelCodes())) {
            JSONArray chn = new JSONArray();
            request.getChannelCodes().forEach(code -> chn.add((Object)(Integer.parseInt(code.substring(2)) - 1)));
            data.put("Chn", (Object)chn);
        }
        data.put("StartTime", (Object)request.getStartTime());
        data.put("EndTime", (Object)request.getEndTime());
        data.put("AlarmGroup", (Object)request.getGroupIds());
        data.put("SortType", (Object)(StringUtils.isBlank((CharSequence)request.getSortType()) ? 1 : Integer.parseInt(request.getSortType())));
        if (faceId > -1) {
            data.put("Similarity", (Object)((FaceSearchRequest)obj.getRequestBody()).getSimilarity());
            JSONObject faceInfo = new JSONObject();
            faceInfo.put("Id", (Object)faceId);
            JSONArray faceInfos = new JSONArray();
            faceInfos.add((Object)faceInfo);
            data.put("FaceInfo", (Object)faceInfos);
        } else {
            if (!CollectionUtils.isEmpty((Collection)request.getSex())) {
                data.put("Sex", (Object)request.getSex());
            }
            if (!CollectionUtils.isEmpty((Collection)request.getAge())) {
                data.put("Age", (Object)request.getAge());
            }
            if (!CollectionUtils.isEmpty((Collection)request.getMouthMaskType())) {
                data.put("MouthMaskType", (Object)request.getMouthMaskType());
            }
            if (!CollectionUtils.isEmpty((Collection)request.getHairType())) {
                data.put("HairType", (Object)request.getHairType());
            }
            if (!CollectionUtils.isEmpty((Collection)request.getGlassType())) {
                data.put("GlassesType", (Object)request.getGlassType());
            }
            if (!CollectionUtils.isEmpty((Collection)request.getHatType())) {
                data.put("HatType", (Object)request.getHatType());
            }
            if (!CollectionUtils.isEmpty((Collection)request.getGroupIds())) {
                data.put("AlarmGroup", (Object)request.getGroupIds());
            }
        }
        JSONObject countReq = new JSONObject();
        countReq.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.FACE_SEARCH_COUNT, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)countReq, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()), (int)120);
            return rsp.getData();
        }
        catch (SDKException e) {
            LOGGER.error("search face count happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public FaceSearchRespond faceSearchRspConvert(VcmReqBaseInfo vcmInfo, JSONObject object) {
        FaceSearchRespond faceSearchRespond = new FaceSearchRespond();
        faceSearchRespond.setTotalCount(object.getIntValue("TotalCount"));
        faceSearchRespond.setCount(object.getIntValue("Count"));
        faceSearchRespond.setCount(object.getIntValue("Count"));
        JSONArray faceInfosJson = object.getJSONArray("SnapedFaceInfo");
        for (int i = 0; i < faceInfosJson.size(); ++i) {
            FaceSearchRespond.FaceInfo faceInfo = new FaceSearchRespond.FaceInfo();
            faceInfo.setFileId(faceInfosJson.getJSONObject(i).getString("UUId"));
            faceInfo.setChannelCode("CH" + (faceInfosJson.getJSONObject(i).getIntValue("Chn") + 1));
            faceInfo.setStartTime(faceInfosJson.getJSONObject(i).getString("StartTime"));
            faceInfo.setEndTime(faceInfosJson.getJSONObject(i).getString("EndTime"));
            faceInfo.setGender(faceInfosJson.getJSONObject(i).getIntValue("Gender"));
            faceInfo.setAge(faceInfosJson.getJSONObject(i).getIntValue("Age"));
            faceInfo.setHat(faceInfosJson.getJSONObject(i).getIntValue("Hat"));
            faceInfo.setHair(faceInfosJson.getJSONObject(i).getIntValue("Hair"));
            faceInfo.setSimilarity(faceInfosJson.getJSONObject(i).getDoubleValue("Similarity"));
            faceInfo.setGlassType(faceInfosJson.getJSONObject(i).getIntValue("GlassType"));
            faceInfo.setMouthMask(faceInfosJson.getJSONObject(i).getIntValue("MouthMask"));
            faceInfo.setFaceImage(faceInfosJson.getJSONObject(i).getString("FaceImage"));
            faceInfo.setAlias(vcmInfo.getVcmIp() + "_" + faceInfo.getChannelCode());
            faceInfo.setBackground(faceInfosJson.getJSONObject(i).getString("Background"));
            faceInfo.setSnapId(faceInfosJson.getJSONObject(i).getString("SnapId"));
            faceInfo.setPersonId(faceInfosJson.getJSONObject(i).getString("MatchedFaceId"));
            faceInfo.setAppearCount(faceInfosJson.getJSONObject(i).getString("AppearCnt"));
            faceInfo.setLeftTopX(faceInfosJson.getJSONObject(i).getJSONObject("FaceRect").getIntValue("X"));
            faceInfo.setLeftTopY(faceInfosJson.getJSONObject(i).getJSONObject("FaceRect").getIntValue("Y"));
            faceInfo.setRightBtmX(faceInfo.getLeftTopX() + faceInfosJson.getJSONObject(i).getJSONObject("FaceRect").getIntValue("Width"));
            faceInfo.setRightBtmY(faceInfo.getLeftTopY() + faceInfosJson.getJSONObject(i).getJSONObject("FaceRect").getIntValue("Height"));
            faceSearchRespond.getFaceInfos().add(faceInfo);
        }
        return faceSearchRespond;
    }

    private JSONObject picturePlaybackReq(PicturePlaybackRequest cuRequest) {
        JSONObject req = new JSONObject();
        JSONObject data = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)cuRequest.getPicInfoKey())) {
            data.put("pic_info", (Object)cuRequest.getPicInfoKey());
        } else {
            JSONArray channel = new JSONArray();
            channel.add((Object)cuRequest.getChannelCode());
            data.put("channel", (Object)channel);
            data.put("start_date", (Object)cuRequest.getStartDate());
            data.put("start_time", (Object)cuRequest.getStartTime());
            data.put("end_date", (Object)cuRequest.getEndDate());
            data.put("end_time", (Object)cuRequest.getEndTime());
            if (cuRequest.getRecordType() == 0) {
                data.put("record_type", (Object)524287);
            } else if (cuRequest.getRecordType() == 1) {
                data.put("record_type", (Object)7);
            } else {
                data.put("record_type", (Object)262144);
            }
            data.put("pic_sort", (Object)cuRequest.getSort());
        }
        req.put("data", (Object)data);
        return req;
    }

    public PicturePlaybackRespond picturePlaybackRspConvert(VcmReqBaseInfo vcmInfo, JSONObject obj, String infoKey) {
        PicturePlaybackRespond picturePlaybackRespond = new PicturePlaybackRespond();
        if (StringUtils.isNotBlank((CharSequence)infoKey)) {
            JSONObject picture = obj.getJSONObject("picture");
            picturePlaybackRespond.getPicture().setImage(picture.getString("image"));
            picturePlaybackRespond.getPicture().setPicInfoKey(infoKey);
            picturePlaybackRespond.getPicture().setChannelCode(picture.getString("channel"));
            picturePlaybackRespond.getPicture().setTime(picture.getString("time"));
            picturePlaybackRespond.getPicture().setAlias(vcmInfo.getVcmIp() + "_" + picture.getString("channel"));
            picturePlaybackRespond.getPicture().setSize(picture.getString("size"));
            int recordType = picture.getIntValue("record_type");
            if (recordType == 262144) {
                picturePlaybackRespond.getPicture().setRecordType(2);
            } else {
                picturePlaybackRespond.getPicture().setRecordType(1);
            }
        } else {
            picturePlaybackRespond.setOverLoad(obj.getBoolean("overload"));
            picturePlaybackRespond.setPicNum(obj.getIntValue("all_pic_num"));
            List picInfos = picturePlaybackRespond.getPicInfos();
            JSONArray picArray = obj.getJSONArray("all_pic_info");
            for (int i = 0; i < picArray.size(); ++i) {
                PicturePlaybackRespond.Picture picture = new PicturePlaybackRespond.Picture();
                picture.setPicInfoKey(picArray.getJSONObject(i).getString("pic_info"));
                picture.setChannelCode(picArray.getJSONObject(i).getString("channel"));
                picture.setTime(picArray.getJSONObject(i).getString("time"));
                picture.setAlias(vcmInfo.getVcmIp() + "_" + picture.getChannelCode());
                picture.setSize(picArray.getJSONObject(i).getString("size"));
                int recordType = picArray.getJSONObject(i).getIntValue("record_type");
                if (recordType == 262144) {
                    picture.setRecordType(2);
                } else {
                    picture.setRecordType(1);
                }
                picInfos.add(picture);
            }
        }
        return picturePlaybackRespond;
    }

    public SnapObjectRespond getSnapObjectDetailById(VcmReqBaseInfo vcmInfo, SnapObjectDetailRequest request) {
        JSONObject paramObject = new JSONObject();
        SnapObjectRespond respond = new SnapObjectRespond();
        paramObject.put("WithObjectImage", (Object)request.getWithObjectImage());
        paramObject.put("WithBackgroud", (Object)request.getWithBackGround());
        paramObject.put("UUIds", (Object)request.getUuids());
        JSONObject dataObject = new JSONObject();
        dataObject.put("data", (Object)paramObject);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.VEHICLE_SEARCH_PAGINATION_FOR_UUID, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            JSONArray snapArray = rsp.getJSONObject("data").getJSONArray("SnapedObjInfo");
            if (!CollectionUtils.isEmpty((Collection)snapArray)) {
                JSONObject snapObject = snapArray.getJSONObject(0);
                respond.setChannelCode(snapObject.getString("Chn"));
                respond.setType(snapObject.getInteger("Type"));
                respond.setStartTime(snapObject.getString("StartTime"));
                respond.setEndTime(snapObject.getString("EndTime"));
                respond.setPlateNo(snapObject.getString("LicensePlate"));
                respond.setCarBrand(snapObject.getString("CarPreBrandId"));
                respond.setCarSubBrand(snapObject.getString("CarSubBrandId"));
                respond.setCarType(snapObject.getString("CarType"));
                respond.setCarColor(snapObject.getString("CarColor"));
                JSONObject positionObject = respond.getType() == 1 ? snapObject.getJSONObject("HumanBgPos") : (respond.getType() == 2 ? snapObject.getJSONObject("ObjPos") : (respond.getType() == 7 ? snapObject.getJSONObject("NonVehicleBgPos") : new JSONObject()));
                respond.setLeftTopX(positionObject.getIntValue("X"));
                respond.setLeftTopY(positionObject.getIntValue("Y"));
                respond.setRightBtmX(respond.getLeftTopX() + positionObject.getIntValue("Width"));
                respond.setRightBtmY(respond.getLeftTopY() + positionObject.getIntValue("Height"));
                respond.setImageId(snapObject.getString("UUId"));
                respond.setChannelCode(snapObject.getString("Chn"));
                respond.setObjectImage(snapObject.getString("ObjectImage"));
                respond.setBackgroundImage(snapObject.getString("Background"));
            }
        }
        catch (SDKException e) {
            LOGGER.error("get snap object detail by id error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return respond;
    }

    public HumanSearchRespond humanDynamicRetrieval(ParamBean<HumanSearchRequest> obj) {
        VehicleRepositoryRequest searchRespond = new VehicleRepositoryRequest();
        VehicleDynamicRetrievalRequest retrievalRequest = new VehicleDynamicRetrievalRequest();
        retrievalRequest.setCameraCode(((HumanSearchRequest)obj.getRequestBody()).getCameraList().toString().replaceAll(",", ";"));
        retrievalRequest.setStartTime(((HumanSearchRequest)obj.getRequestBody()).getStartTime());
        retrievalRequest.setEndTime(((HumanSearchRequest)obj.getRequestBody()).getEndTime());
        retrievalRequest.setType(((HumanSearchRequest)obj.getRequestBody()).getType());
        searchRespond.setCondition(retrievalRequest);
        searchRespond.setSearchCount(((HumanSearchRequest)obj.getRequestBody()).getSearchCount());
        searchRespond.setStartIndex(((HumanSearchRequest)obj.getRequestBody()).getStartIndex());
        searchRespond.setPage(((HumanSearchRequest)obj.getRequestBody()).getPage());
        VehicleRepositorySearchRespond respond = this.vehicleRepositoryNvr800Service.vehicleDynamicRetrieval(obj.getVcmInfo(), searchRespond);
        HumanSearchRespond rps = new HumanSearchRespond();
        ArrayList peoplePassInfo2 = new ArrayList();
        respond.getVehicleList().forEach(a -> {
            HumanSearchRespond.peoplePassInfo result = new HumanSearchRespond.peoplePassInfo();
            result.setRecordTime(a.getImageTimestamp());
            result.setCameraCode(a.getCameraCode());
            result.setPicfileId(a.getPicfileID());
            result.setDomainCode(obj.getVcmInfo().getDomainCode());
            List objInResult = a.getObjInResult();
            for (VehicleRepositorySearchRespond.VehicleList.ObjInResult item : objInResult) {
                result.setHumanBgPos(item.getHumanBgPos());
                result.setHumanImagePos(item.getHumanImagePos());
                result.setNonVehicleBgPos(item.getNonVehicleBgPos());
                peoplePassInfo2.add(result);
            }
        });
        if (Objects.nonNull(respond.getPage())) {
            rps.setTotal(Integer.valueOf(respond.getPage().getString("totalCount")));
        }
        rps.setPeoplepass(peoplePassInfo2);
        return rps;
    }

    public PageRespond<SnapObjectRespond> getSnapObject(VcmReqBaseInfo vcmInfo, SnapObjectRequest request) {
        PageRespond pageRespond = new PageRespond();
        ArrayList<SnapObjectRespond> respondList = new ArrayList<SnapObjectRespond>();
        JSONObject paramObject = new JSONObject();
        paramObject.put("StartTime", (Object)request.getStartTime());
        paramObject.put("EndTime", (Object)request.getEndTime());
        paramObject.put("SortType", (Object)1);
        paramObject.put("Type", (Object)request.getTypes());
        if (!CollectionUtils.isEmpty((Collection)request.getChannelCodes())) {
            paramObject.put("Chn", (Object)request.getChannelCodes());
        }
        JSONObject dataObject = new JSONObject();
        dataObject.put("data", (Object)paramObject);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.VEHICLE_SEARCH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo), (int)120);
            this.checkJsonRespond((JSONObject)JSONObject.toJSON((Object)rsp));
            if (rsp.getData().getIntValue("Count") > 0) {
                paramObject = new JSONObject();
                paramObject.put("StartIndex", (Object)request.getStartIndex());
                paramObject.put("Count", (Object)request.getCount());
                paramObject.put("SimpleInfo", (Object)0);
                dataObject = new JSONObject();
                dataObject.put("data", (Object)paramObject);
                JSONObject rspObject = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.VEHICLE_SEARCH_PAGINATION, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
                this.checkJsonRespond(rspObject);
                JSONArray snapArray = rspObject.getJSONObject("data").getJSONArray("SnapedObjInfo");
                if (!CollectionUtils.isEmpty((Collection)snapArray)) {
                    for (int i = 0; i < snapArray.size(); ++i) {
                        JSONObject snapObject = snapArray.getJSONObject(i);
                        SnapObjectRespond respond = new SnapObjectRespond();
                        respond.setChannelCode(snapObject.getString("Chn"));
                        respond.setType(snapObject.getInteger("Type"));
                        respond.setStartTime(snapObject.getString("StartTime"));
                        respond.setEndTime(snapObject.getString("EndTime"));
                        respond.setPlateNo(snapObject.getString("LicensePlate"));
                        respond.setCarBrand(snapObject.getString("CarPreBrandId"));
                        respond.setCarSubBrand(snapObject.getString("CarSubBrandId"));
                        respond.setCarType(snapObject.getString("CarType"));
                        respond.setCarColor(snapObject.getString("CarColor"));
                        JSONObject positionObject = respond.getType() == 1 ? snapObject.getJSONObject("HumanBgPos") : (respond.getType() == 2 ? snapObject.getJSONObject("ObjPos") : (respond.getType() == 7 ? snapObject.getJSONObject("NonVehicleBgPos") : new JSONObject()));
                        respond.setLeftTopX(positionObject.getIntValue("X"));
                        respond.setLeftTopY(positionObject.getIntValue("Y"));
                        respond.setRightBtmX(respond.getLeftTopX() + positionObject.getIntValue("Width"));
                        respond.setRightBtmY(respond.getLeftTopY() + positionObject.getIntValue("Height"));
                        respond.setImageId(snapObject.getString("UUId"));
                        respond.setChannelCode("CH" + (snapObject.getInteger("Chn") + 1));
                        respondList.add(respond);
                    }
                }
            }
            pageRespond.setData(respondList);
            pageRespond.setTotal(rsp.getData().getIntValue("Count"));
            return pageRespond;
        }
        catch (SDKException e) {
            LOGGER.error("vehicleSearchCount happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

