/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.EncPasswordBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.KeyRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.PubKeyRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.IService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.PKCS1ToSubjectPublicKeyInfo;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.MGF1ParameterSpec;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PSource;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PasswordServiceImpl
extends AbstractNvr800Service
implements IService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordServiceImpl.class);

    public EncPasswordBean get(VcmReqBaseInfo vcmReqBaseInfo, String password) {
        PubKeyRespondNvr800 pubKeyRespondNvr800 = this.getKey(vcmReqBaseInfo);
        return this.getEncPassword(pubKeyRespondNvr800, password);
    }

    public EncPasswordBean getByType(VcmReqBaseInfo vcmReqBaseInfo, String password, String type) {
        PubKeyRespondNvr800 pubKeyRespondNvr800 = this.getKeyByType(vcmReqBaseInfo, type);
        return this.getEncPasswordByType(pubKeyRespondNvr800, password, type);
    }

    public EncPasswordBean getEncPasswordByType(PubKeyRespondNvr800 pubKeyRespondNvr800, String password, String type) {
        String cipher;
        JSONObject pubkeyObj = pubKeyRespondNvr800.getPubkeyByType(type);
        if (pubkeyObj == null) {
            throw new InvokeException("500", "\u83b7\u53d6\u516c\u94a5\u5931\u8d25");
        }
        int seq = pubkeyObj.getInteger("seq");
        String pubKey = pubkeyObj.getString("key");
        try {
            cipher = "salt".equalsIgnoreCase(type) ? this.getCipherBySalt(password, pubKey, pubkeyObj.getInteger("iter")) : this.getCipher(password, pubKey);
        }
        catch (Exception e) {
            LOGGER.error("Get cipher fail", (Throwable)e);
            throw new InvokeException("500", "\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
        }
        EncPasswordBean passwordBean = new EncPasswordBean();
        passwordBean.setCipher(cipher);
        passwordBean.setSeq(seq);
        return passwordBean;
    }

    private String getCipherBySalt(String password, String salt, Integer iter) throws Exception {
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), this.fromHex(salt), iter, 256);
        SecretKeyFactory f = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        return this.toHex(f.generateSecret(spec).getEncoded());
    }

    private byte[] fromHex(String hex) {
        byte[] binary = new byte[hex.length() / 2];
        for (int i = 0; i < binary.length; ++i) {
            binary[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return binary;
    }

    private String toHex(byte[] array) {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        }
        return hex;
    }

    public EncPasswordBean getEncPassword(PubKeyRespondNvr800 pubKeyRespondNvr800, String password) {
        String cipher;
        JSONObject pubkeyObj = pubKeyRespondNvr800.getPubkey();
        if (pubkeyObj == null) {
            throw new InvokeException("500", "\u83b7\u53d6\u516c\u94a5\u5931\u8d25");
        }
        int seq = pubkeyObj.getInteger("seq");
        String pubKey = pubkeyObj.getString("key");
        try {
            cipher = this.getCipher(password, pubKey);
        }
        catch (Exception e) {
            LOGGER.error("Get cipher fail", (Throwable)e);
            throw new InvokeException("500", "\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
        }
        EncPasswordBean passwordBean = new EncPasswordBean();
        passwordBean.setCipher(cipher);
        passwordBean.setSeq(seq);
        return passwordBean;
    }

    public EncPasswordBean firstGet(VcmReqBaseInfo vcmReqBaseInfo, String password, String username) {
        String cipher;
        JSONObject pubkeyObj = this.getFirstPublicKey(vcmReqBaseInfo, username);
        if (pubkeyObj == null) {
            throw new InvokeException("500", "\u83b7\u53d6\u516c\u94a5\u5931\u8d25");
        }
        int seq = pubkeyObj.getInteger("seq");
        String pubKey = pubkeyObj.getString("key");
        try {
            cipher = this.getCipher(password, pubKey);
        }
        catch (Exception e) {
            LOGGER.error("Get cipher fail", (Throwable)e);
            throw new InvokeException("500", "\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
        }
        EncPasswordBean passwordBean = new EncPasswordBean();
        passwordBean.setCipher(cipher);
        passwordBean.setSeq(seq);
        return passwordBean;
    }

    private JSONObject getFirstPublicKey(VcmReqBaseInfo vcmReqBaseInfo, String username) {
        JSONObject respond;
        block3: {
            respond = null;
            try {
                JSONObject requestParam = new JSONObject();
                JSONArray typeArray = new JSONArray();
                typeArray.add((Object)"Pubkey");
                requestParam.put("type", (Object)typeArray);
                JSONObject dataObject = new JSONObject();
                dataObject.put("data", (Object)requestParam);
                respond = "admin".equalsIgnoreCase(username) ? (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.USER_ADMIN_LOGIN_GET_KEY, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo)) : (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.USER_COMMON_LOGIN_GET_KEY, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            }
            catch (Exception e) {
                LOGGER.error("get password public key error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
                if (!(e instanceof SDKException)) break block3;
                throw new InvokeException("500", (Object)e.getMessage(), Nvr800Utils.reasonHelper((SDKException)((SDKException)((Object)e))));
            }
        }
        this.checkJsonRespond(respond);
        JSONArray keyArray = respond.getJSONObject("data").getJSONArray("Key_lists");
        if (Objects.isNull(keyArray) || keyArray.size() <= 0) {
            throw new InvokeException("500", (Object)respond.toJSONString(), "cu_device_not_return");
        }
        return keyArray.getJSONObject(0);
    }

    public PubKeyRespondNvr800 getKey(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            PubKeyRespondNvr800 respondNvr800 = (PubKeyRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.REQUEST_PUB_KEY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)new KeyRequestNvr800(), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PubKeyRespondNvr800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return respondNvr800;
        }
        catch (SDKException e) {
            LOGGER.error("Request pubkey fail", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public PubKeyRespondNvr800 getKeyByType(VcmReqBaseInfo vcmReqBaseInfo, String type) {
        try {
            PubKeyRespondNvr800 respondNvr800 = (PubKeyRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.REQUEST_PUB_KEY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)new KeyRequestNvr800(type), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PubKeyRespondNvr800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return respondNvr800;
        }
        catch (SDKException e) {
            LOGGER.error("Request pubkey fail", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private String getCipher(String password, String pubKey) throws Exception {
        pubKey = pubKey.replace("-----BEGIN RSA PUBLIC KEY-----\n", "").replace("-----END RSA PUBLIC KEY-----\n", "").replace("\n", "");
        byte[] pkcs1PublicKeyEncoding = Base64.getDecoder().decode(pubKey);
        RSAPublicKey publicKey = PKCS1ToSubjectPublicKeyInfo.decodePKCS1PublicKey((byte[])pkcs1PublicKeyEncoding);
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher encryptionCipher = Cipher.getInstance("RSA/NONE/OAEPWithSHA-1AndMGF1Padding");
        OAEPParameterSpec oaepParameterSpec = new OAEPParameterSpec("SHA-1", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
        encryptionCipher.init(1, (Key)publicKey, oaepParameterSpec);
        return PasswordServiceImpl.toHexString((byte[])encryptionCipher.doFinal(password.getBytes(StandardCharsets.UTF_8)));
    }

    public String encrypt(String password, String pubKey, String random) throws Exception {
        pubKey = pubKey.replace("-----BEGIN RSA PUBLIC KEY-----\n", "").replace("-----END RSA PUBLIC KEY-----\n", "").replace("\n", "");
        byte[] pkcs1PublicKeyEncoding = Base64.getDecoder().decode(pubKey);
        RSAPublicKey publicKey = PKCS1ToSubjectPublicKeyInfo.decodePKCS1PublicKey((byte[])pkcs1PublicKeyEncoding);
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher encryptionCipher = Cipher.getInstance("RSA/NONE/OAEPWithSHA-1AndMGF1Padding");
        OAEPParameterSpec oaepParameterSpec = new OAEPParameterSpec("SHA-1", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
        encryptionCipher.init(1, (Key)publicKey, oaepParameterSpec);
        return Base64.getEncoder().encodeToString(encryptionCipher.doFinal((random + "@" + password).getBytes(StandardCharsets.UTF_8)));
    }

    private static String toHexString(byte[] byteArray) {
        StringBuilder hexString = new StringBuilder("");
        if (byteArray == null || byteArray.length <= 0) {
            return null;
        }
        for (int i = 0; i < byteArray.length; ++i) {
            int v = byteArray[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                hexString.append(0);
            }
            hexString.append(hv);
        }
        return hexString.toString().toLowerCase(Locale.ROOT);
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

