/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.contants.SdcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.IntelligentConfigBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorAreaItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.HeatMapConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.HeatMapConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.MotionConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.NormalIntelligentRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.OcclusionConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.QueueDetectionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.RepeatVisitorRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.SoundDetectionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.TargetRecognitionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.VideoCoverRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.QueueDetectionGetRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.QueueDetectionSetRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.SoundDetectionGetRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.SoundDetectionSetRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.intelligent.BehaviorRangeGetRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.intelligent.RepeatVisitorSetRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraModeRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepository;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.BehaviorAlarmPlanItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.FaceCaptureRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.FaceGroupInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.MaskAlarmItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.MotionChannelConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.MotionConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.OcclusionChannelConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.OcclusionConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.Point;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.Rect;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.RepeatVisitorGetRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.SituationalConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.SoundDetectionConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.VideoCoverRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.ZoneInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.NormalIntelligentService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbilityNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.BehaviorAnalysisNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.DeviceManageNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.FaceRepositoryServiceNvr800Impl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NormalIntelligentNVR800ServiceImpl
extends AbstractNvr800Service
implements NormalIntelligentService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NormalIntelligentNVR800ServiceImpl.class);
    @Autowired
    private DeviceManageNvr800ServiceImpl deviceManageNvr800Service;
    @Autowired
    private AbilityNvr800ServiceImpl abilityNvr800Service;
    @Autowired
    private BehaviorAnalysisNvr800ServiceImpl behaviorAnalysisServiceImpl;
    @Autowired
    private FaceRepositoryServiceNvr800Impl faceRepositoryServiceNvr800;

    public MotionConfigRespond getMotionConfig(ParamBean<MotionConfigRequest> obj) {
        JSONArray channel = new JSONArray();
        channel.add((Object)((MotionConfigRequest)obj.getRequestBody()).getChannelCode());
        JSONObject data = new JSONObject();
        data.put("channel", (Object)channel);
        data.put("page_type", (Object)((MotionConfigRequest)obj.getRequestBody()).getPageType());
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            MotionConfigRespond motionConfigRespond;
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.MOTION_CONFIG_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            if ("ChannelConfig".equals(((MotionConfigRequest)obj.getRequestBody()).getPageType())) {
                motionConfigRespond = new MotionConfigRespond();
                motionConfigRespond.setChannelCode(((MotionConfigRequest)obj.getRequestBody()).getChannelCode());
                motionConfigRespond.setPageType(((MotionConfigRequest)obj.getRequestBody()).getPageType());
                MotionChannelConfig motionChannelConfig = this.motionChannelConfigConvert(rsp.getData(), ((MotionConfigRequest)obj.getRequestBody()).getChannelCode());
                data.put("page_type", (Object)"AlarmConfig");
                request.put("data", (Object)data);
                CommonRespondNvr800 alarmPlan = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.MOTION_CONFIG_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
                JSONObject alarmData = alarmPlan.getData();
                motionChannelConfig.setAlarmPlanList(this.motionAlarmConvert(alarmData, ((MotionConfigRequest)obj.getRequestBody()).getChannelCode()));
                motionConfigRespond.setChannelConfig(motionChannelConfig);
            } else {
                String json = rsp.getData().getJSONObject("channel_info").getJSONObject(((MotionConfigRequest)obj.getRequestBody()).getChannelCode()).toJSONString();
                motionConfigRespond = (MotionConfigRespond)JsonUtil.convertJsonToBean((String)json, MotionConfigRespond.class).get();
                motionConfigRespond.setChannelCode(((MotionConfigRequest)obj.getRequestBody()).getChannelCode());
                motionConfigRespond.setPageType(((MotionConfigRequest)obj.getRequestBody()).getPageType());
                motionConfigRespond.setRange(this.getRange(obj.getVcmInfo(), ((MotionConfigRequest)obj.getRequestBody()).getPageType(), ((MotionConfigRequest)obj.getRequestBody()).getChannelCode(), Nvr800MsgType.MOTION_CONFIG_RANGE));
            }
            return motionConfigRespond;
        }
        catch (SDKException e) {
            LOGGER.error("get motion config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setMotionConfig(ParamBean<MotionConfigRequest> obj) {
        JSONObject request;
        if ("ChannelConfig".equals(((MotionConfigRequest)obj.getRequestBody()).getPageType())) {
            request = this.motionChannelConfigRequest(obj);
            this.updateMotionAlarmConfig(obj);
        } else {
            request = this.motionAlarmConfigRequest(obj);
        }
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.MOTION_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("get motion config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private void updateMotionAlarmConfig(ParamBean<MotionConfigRequest> obj) {
        List alarmPlans = ((MotionConfigRequest)obj.getRequestBody()).getChannelConfig().getAlarmPlanList();
        ParamBean motionConfig = new ParamBean();
        motionConfig.setVcmInfo(obj.getVcmInfo());
        MotionConfigRequest requestBody = (MotionConfigRequest)obj.getRequestBody();
        requestBody.setChannelCode(((MotionConfigRequest)obj.getRequestBody()).getChannelCode());
        requestBody.setPageType("AlarmConfig");
        motionConfig.setRequestBody((Object)requestBody);
        MotionConfigRespond motionConfigRange = this.getMotionConfig(motionConfig);
        motionConfigRange.setAlarmPlanList(alarmPlans);
        String channelInfo = JsonUtil.convertBeanToJSON((Object)motionConfigRange);
        JSONObject channel = new JSONObject();
        channel.put(((MotionConfigRequest)obj.getRequestBody()).getChannelCode(), JSONObject.parse((String)channelInfo));
        JSONObject data = new JSONObject();
        data.put("channel_info", (Object)channel);
        data.put("page_type", (Object)"AlarmConfig");
        JSONObject req = new JSONObject();
        req.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.MOTION_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)req, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
        }
        catch (SDKException e) {
            LOGGER.error("set motion alarm config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public VideoCoverRespond getVideoCoverConfig(ParamBean<VideoCoverRequest> obj) {
        VideoCoverRespond respond;
        JSONArray channel = new JSONArray();
        channel.add((Object)((VideoCoverRequest)obj.getRequestBody()).getChannelCode());
        JSONObject data = new JSONObject();
        data.put("channel", (Object)channel);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.VIDEO_COVER_CONFIG_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            respond = this.videoCoverConfigRespondConvert(obj, rsp.getData());
        }
        catch (SDKException e) {
            LOGGER.error("get video cover config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        try {
            JSONObject channelData = new JSONObject();
            channelData.put("request_url", (Object)("GET " + SdcMsgType.CNS_PAAS_GET.getUri()));
            JSONObject requestData = new JSONObject();
            requestData.put(((VideoCoverRequest)obj.getRequestBody()).getChannelCode(), (Object)channelData);
            JSONObject channelInfo = new JSONObject();
            channelInfo.put("channel_info", (Object)requestData);
            data = new JSONObject();
            data.put("data", (Object)channelInfo);
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.DEVICE_SDC_PASS, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)data, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            if ("success".equalsIgnoreCase(result.getString("result"))) {
                JSONObject uuid = JSONObject.parseObject((String)result.getJSONObject("data").getJSONObject("channel_info").getJSONObject(((VideoCoverRequest)obj.getRequestBody()).getChannelCode()).getString("respond_data"));
                channelData.put("request_url", (Object)("GET " + SdcMsgType.CHANNEL_GET_REGION.getUri() + "?UUID=" + uuid.getJSONArray("CnsChnParam").getJSONObject(0).getString("uuid")));
                requestData.put(((VideoCoverRequest)obj.getRequestBody()).getChannelCode(), (Object)channelData);
                channelInfo.put("channel_info", (Object)requestData);
                data = new JSONObject();
                data.put("data", (Object)channelInfo);
                result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.DEVICE_SDC_PASS, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)data, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
                JSONObject ret = JSONObject.parseObject((String)result.getJSONObject("data").getJSONObject("channel_info").getJSONObject(((VideoCoverRequest)obj.getRequestBody()).getChannelCode()).getString("respond_data"));
                if ("success".equalsIgnoreCase(result.getString("result")) && ret.getJSONArray("regionIaasCapability").getJSONObject(0).getJSONObject("privacy").containsKey((Object)"polygon")) {
                    respond.setPolygon(Boolean.valueOf(ret.getJSONArray("regionIaasCapability").getJSONObject(0).getJSONObject("privacy").getBooleanValue("polygon")));
                } else {
                    respond.setPolygon(Boolean.valueOf(true));
                }
            } else {
                respond.setPolygon(Boolean.valueOf(true));
            }
        }
        catch (Exception e) {
            LOGGER.error("NVR800 get RegionIaas error, IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            respond.setPolygon(Boolean.valueOf(true));
        }
        return respond;
    }

    public boolean setVideoCoverConfig(ParamBean<VideoCoverRequest> obj) {
        JSONObject request = this.videoCoverRequest(obj);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.VIDEO_COVER_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set video cover config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private JSONObject getRange(VcmReqBaseInfo vcmReqBaseInfo, String pageType, String code, Nvr800MsgType rangeNvr800MsgType) {
        JSONObject resultJson = new JSONObject();
        BehaviorRangeGetRequestNvr800 requestNvr800 = new BehaviorRangeGetRequestNvr800(pageType);
        try {
            String respondNvr800 = (String)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)rangeNvr800MsgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            JSONObject originalConfig = JSONObject.parseObject((String)respondNvr800);
            JSONObject items = originalConfig.getJSONObject("data").getJSONObject("channel_info").getJSONObject("items");
            for (String key : items.keySet()) {
                if (!key.equals(code)) continue;
                JSONObject itemJson = items.getJSONObject(key).getJSONObject("items");
                String channelCode = this.getChannelCode(key);
                if (channelCode == null || resultJson.containsKey((Object)channelCode)) continue;
                IntelligentConfigBean configBean = new IntelligentConfigBean();
                if (itemJson.getJSONObject("buzzer") != null) {
                    configBean.setBuzzer(itemJson.getJSONObject("buzzer").getJSONArray("items").toJavaList(Integer.class));
                }
                if (itemJson.getJSONObject("alarm_out") != null) {
                    configBean.setAlarmOut(itemJson.getJSONObject("alarm_out").getJSONObject("items").getJSONArray("items").toJavaList(String.class));
                }
                if (itemJson.getJSONObject("alarm_out") != null) {
                    configBean.setLatchTime(itemJson.getJSONObject("latch_time").getJSONArray("items").toJavaList(Integer.class));
                }
                if (itemJson.getJSONObject("record_channel") != null) {
                    configBean.setRecordChannel(itemJson.getJSONObject("record_channel").getJSONObject("items").getJSONArray("items").toJavaList(String.class));
                }
                if (itemJson.getJSONObject("post_recording") != null) {
                    configBean.setPostRecording(itemJson.getJSONObject("post_recording").getJSONArray("items").toJavaList(Integer.class));
                }
                resultJson.put(key, JSONObject.parse((String)JsonUtil.convertBeanToJSON((Object)configBean)));
                break;
            }
            return resultJson;
        }
        catch (SDKException e) {
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private String getChannelCode(String key) {
        Pattern pattern = Pattern.compile("CH(\\d)*");
        Matcher matcher = pattern.matcher(key);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public OcclusionConfigRespond getOcclusionConfig(ParamBean<OcclusionConfigRequest> obj) {
        JSONArray channel = new JSONArray();
        channel.add((Object)((OcclusionConfigRequest)obj.getRequestBody()).getChannelCode());
        JSONObject data = new JSONObject();
        data.put("channel", (Object)channel);
        data.put("page_type", (Object)((OcclusionConfigRequest)obj.getRequestBody()).getPageType());
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            OcclusionConfigRespond occlusionConfigRespond;
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.OCCLUSION_CONFIG_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            String config = rsp.getData().getJSONObject("channel_info").getString(((OcclusionConfigRequest)obj.getRequestBody()).getChannelCode());
            if ("ChannelConfig".equals(((OcclusionConfigRequest)obj.getRequestBody()).getPageType())) {
                occlusionConfigRespond = new OcclusionConfigRespond();
                occlusionConfigRespond.setChannelCode(((OcclusionConfigRequest)obj.getRequestBody()).getChannelCode());
                occlusionConfigRespond.setPageType(((OcclusionConfigRequest)obj.getRequestBody()).getPageType());
                OcclusionChannelConfig occlusionChannelConfig = (OcclusionChannelConfig)JsonUtil.convertJsonToBean((String)config, OcclusionChannelConfig.class).get();
                occlusionConfigRespond.setChannelConfig(occlusionChannelConfig);
            } else {
                occlusionConfigRespond = (OcclusionConfigRespond)JsonUtil.convertJsonToBean((String)config, OcclusionConfigRespond.class).get();
                occlusionConfigRespond.setChannelCode(((OcclusionConfigRequest)obj.getRequestBody()).getChannelCode());
                occlusionConfigRespond.setPageType(((OcclusionConfigRequest)obj.getRequestBody()).getPageType());
            }
            occlusionConfigRespond.setRange(this.getRange(obj.getVcmInfo(), ((OcclusionConfigRequest)obj.getRequestBody()).getPageType(), ((OcclusionConfigRequest)obj.getRequestBody()).getChannelCode(), Nvr800MsgType.OCCLUSION_CONFIG_RANGE));
            return occlusionConfigRespond;
        }
        catch (SDKException e) {
            LOGGER.error("get occlusion config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setOcclusionConfig(ParamBean<OcclusionConfigRequest> obj) {
        String channelInfo = "ChannelConfig".equals(((OcclusionConfigRequest)obj.getRequestBody()).getPageType()) ? JsonUtil.convertBeanToJSON((Object)((OcclusionConfigRequest)obj.getRequestBody()).getChannelConfig()) : JsonUtil.convertBeanToJSON((Object)obj.getRequestBody());
        JSONObject channel = new JSONObject();
        channel.put(((OcclusionConfigRequest)obj.getRequestBody()).getChannelCode(), JSONObject.parse((String)channelInfo));
        JSONObject data = new JSONObject();
        data.put("channel_info", (Object)channel);
        data.put("page_type", (Object)((OcclusionConfigRequest)obj.getRequestBody()).getPageType());
        JSONObject req = new JSONObject();
        req.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.OCCLUSION_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)req, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set occlusion config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public FaceCaptureRespond getPerimeterFaceConfig(ParamBean<NormalIntelligentRequest> obj) {
        JSONArray channel = new JSONArray();
        channel.add((Object)((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode());
        JSONObject data = new JSONObject();
        data.put("channel", (Object)channel);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.PERIMETER_FACE_CONFIG_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            JSONObject configRsp = new JSONObject();
            JSONObject config = rsp.getData().getJSONObject("channel_info").getJSONObject(((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode());
            if (StringUtils.isEmpty((CharSequence)config.getString("reason"))) {
                configRsp.put("range", (Object)this.getParamRange(obj, Nvr800MsgType.PERIMETER_FACE_CONFIG_RANGE_GET));
            }
            configRsp.put("config", (Object)config);
            Optional respondNvr800 = JsonUtil.convertJsonToBean((String)configRsp.toJSONString(), FaceCaptureRespond.class);
            if (!respondNvr800.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            FaceCaptureRespond faceCaptureRespond = (FaceCaptureRespond)respondNvr800.get();
            return faceCaptureRespond;
        }
        catch (SDKException e) {
            LOGGER.error("get perimeter face config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONObject setPerimeterFaceConfig(ParamBean<NormalIntelligentRequest> obj) {
        JSONObject channelInfo = new JSONObject();
        channelInfo.put(((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode(), (Object)((NormalIntelligentRequest)obj.getRequestBody()).getConfig());
        JSONObject data = new JSONObject();
        data.put("channel_info", (Object)channelInfo);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            Iterator iterator;
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.PERIMETER_FACE_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            JSONObject dataObject = rsp.getData();
            JSONObject response = new JSONObject();
            response.put("success", (Object)true);
            if (Objects.nonNull(dataObject) && !dataObject.isEmpty() && (iterator = dataObject.keySet().iterator()).hasNext()) {
                String key = (String)iterator.next();
                response.put("tipCode", (Object)key);
            }
            response.put("origin", (Object)dataObject);
            return response;
        }
        catch (SDKException e) {
            LOGGER.error("set perimeter face config happen exception ", (Throwable)e);
            throw new InvokeException("500", (Object)e.getErrorCode(), Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public CameraModeRespond getCameraModeConfig(ParamBean<NormalIntelligentRequest> obj) {
        JSONArray channel = new JSONArray();
        channel.add((Object)((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode());
        JSONObject data = new JSONObject();
        data.put("channel", (Object)channel);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.CAMERA_MODE_CONFIG_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            CameraModeRespond cameraModeRespond = new CameraModeRespond();
            JSONObject config = rsp.getData().getJSONObject("channel_info").getJSONObject(((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode());
            if (StringUtils.isEmpty((CharSequence)config.getString("reason"))) {
                JSONObject paramRange = this.getParamRange(obj, Nvr800MsgType.CAMERA_MODE_CONFIG_RANGE_GET);
                JSONArray jsonArray = paramRange.getJSONObject("camera_mode").getJSONArray("items");
                List list = JSONObject.parseArray((String)jsonArray.toJSONString(), String.class);
                cameraModeRespond.setCameraModeList(list);
            }
            cameraModeRespond.setConfig(config);
            return cameraModeRespond;
        }
        catch (SDKException e) {
            LOGGER.error("get camera mode config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setCameraModeConfig(ParamBean<NormalIntelligentRequest> obj) {
        JSONObject channelInfo = new JSONObject();
        channelInfo.put(((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode(), (Object)((NormalIntelligentRequest)obj.getRequestBody()).getConfig());
        JSONObject data = new JSONObject();
        data.put("channel_info", (Object)channelInfo);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.CAMERA_MODE_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set camera mode config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public MaskAlarmItemRespond getMaskAlarmConfig(ParamBean<NormalIntelligentRequest> obj) {
        JSONArray channel = new JSONArray();
        channel.add((Object)((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode());
        JSONObject data = new JSONObject();
        data.put("channel", (Object)channel);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.MASK_ALARM_CONFIG_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            JSONObject config = rsp.getData().getJSONObject("channel_info").getJSONObject(((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode());
            Optional optional = JsonUtil.convertJsonToBean((String)config.toJSONString(), MaskAlarmItemRespond.class);
            MaskAlarmItemRespond maskAlarmItemRespond = (MaskAlarmItemRespond)optional.get();
            if (StringUtils.isEmpty((CharSequence)config.getString("reason"))) {
                maskAlarmItemRespond.setRange(this.getRange(obj.getVcmInfo(), ((NormalIntelligentRequest)obj.getRequestBody()).getPageType(), ((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode(), Nvr800MsgType.MASK_ALARM_CONFIG_RANGE_GET));
            }
            MaskAlarmItemRespond.MaskAlarmItem alarmItem = (MaskAlarmItemRespond.MaskAlarmItem)JsonUtil.convertJsonToBean((String)config.toJSONString(), MaskAlarmItemRespond.MaskAlarmItem.class).get();
            maskAlarmItemRespond.setConfig(alarmItem);
            return maskAlarmItemRespond;
        }
        catch (SDKException e) {
            LOGGER.error("get mask alarm config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setMaskAlarmConfig(ParamBean<NormalIntelligentRequest> obj) {
        JSONObject channelInfo = new JSONObject();
        channelInfo.put(((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode(), (Object)((NormalIntelligentRequest)obj.getRequestBody()).getConfig());
        if (!"ChannelConfig".equals(((NormalIntelligentRequest)obj.getRequestBody()).getPageType())) {
            channelInfo.put(((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode(), JSONObject.parse((String)JsonUtil.convertBeanToJSON((Object)obj.getRequestBody())));
        } else {
            channelInfo.put(((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode(), (Object)((NormalIntelligentRequest)obj.getRequestBody()).getConfig());
        }
        JSONObject data = new JSONObject();
        data.put("channel_info", (Object)channelInfo);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.MASK_ALARM_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set mask alarm config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONObject getFaceRecognitionConfig(ParamBean<NormalIntelligentRequest> obj) {
        JSONArray channel = new JSONArray();
        channel.add((Object)((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode());
        JSONObject data = new JSONObject();
        data.put("channel", (Object)channel);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.FACE_RECOGNITION_CONFIG_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            JSONObject configRsp = new JSONObject();
            JSONObject config = rsp.getData().getJSONObject("channel_info").getJSONObject(((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode());
            config.put("current_module_version", (Object)rsp.getData().getLongValue("current_module_version"));
            configRsp.put("config", (Object)config);
            return configRsp;
        }
        catch (SDKException e) {
            LOGGER.error("get face recognition config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setFaceRecognitionConfig(ParamBean<NormalIntelligentRequest> obj) {
        JSONObject data = new JSONObject();
        data.put("current_module_version", (Object)((NormalIntelligentRequest)obj.getRequestBody()).getConfig().getLongValue("current_module_version"));
        JSONObject config = new JSONObject();
        config.put("switch", (Object)((NormalIntelligentRequest)obj.getRequestBody()).getConfig().getBooleanValue("switch"));
        if (((NormalIntelligentRequest)obj.getRequestBody()).getConfig().getBoolean("is_support_synergy").booleanValue()) {
            config.put("feature_usage_mode", (Object)((NormalIntelligentRequest)obj.getRequestBody()).getConfig().getInteger("feature_usage_mode"));
        }
        JSONObject channelInfo = new JSONObject();
        channelInfo.put(((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode(), (Object)config);
        data.put("channel_info", (Object)channelInfo);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.FACE_RECOGNITION_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()), (int)40);
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            JSONObject message = JSONObject.parseObject((String)e.getMessage());
            if (message.containsKey((Object)"ch_error_code")) {
                JSONArray jsonArray = message.getJSONArray("ch_error_code");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = (JSONObject)jsonArray.get(i);
                    if (!jsonObject.get((Object)"channel").equals(((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode())) continue;
                    LOGGER.error("set face recognition config happen exception ", (Throwable)e);
                    throw new InvokeException("500", jsonObject.getString("error_code"));
                }
            }
            return false;
        }
    }

    public SoundDetectionConfig get(VcmReqBaseInfo vcmInfo, SoundDetectionRequest soundDetectionRequest) {
        SoundDetectionGetRequestNvr800 soundDetectionNvr800 = new SoundDetectionGetRequestNvr800(soundDetectionRequest);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.SOUND_DETECTION_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)soundDetectionNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            if (result.getJSONObject("data") != null && result.getJSONObject("data").get((Object)"channel_info") != null) {
                JSONObject configRsp = ((JSONObject)result.getJSONObject("data").get((Object)"channel_info")).getJSONObject(soundDetectionRequest.getChannelCode());
                Optional operateBean = JsonUtil.convertJsonToBean((String)configRsp.toJSONString(), SoundDetectionConfig.class);
                SoundDetectionConfig soundConfigRespon = (SoundDetectionConfig)operateBean.get();
                soundConfigRespon.setRange(this.getRange(vcmInfo, soundDetectionRequest.getPageType(), soundDetectionRequest.getChannelCode(), Nvr800MsgType.SOUND_DETECTION_RANGE));
                return soundConfigRespon;
            }
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public Boolean set(ParamBean<SoundDetectionRequest> obj) {
        SoundDetectionSetRequestNvr800 soundDetectionSetRequestNvr800 = new SoundDetectionSetRequestNvr800((SoundDetectionRequest)obj.getRequestBody());
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SOUND_DETECTION_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)soundDetectionSetRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public SituationalConfigRespond getQueueDetect(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        QueueDetectionGetRequestNvr800 queueDetectionGetRequestNvr800 = new QueueDetectionGetRequestNvr800(queueDetectionRequest);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.QUEUE_DETECTION_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)queueDetectionGetRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            if (result.getJSONObject("data") != null && result.getJSONObject("data").get((Object)"channel_info") != null) {
                JSONObject configRsp = ((JSONObject)result.getJSONObject("data").get((Object)"channel_info")).getJSONObject(queueDetectionRequest.getChannelCode());
                Optional optional = JsonUtil.convertJsonToBean((String)configRsp.toJSONString(), SituationalConfigRespond.class);
                SituationalConfigRespond queueDetectRespond = (SituationalConfigRespond)optional.get();
                queueDetectRespond.setRange(this.getRange(vcmInfo, queueDetectionRequest.getPageType(), queueDetectionRequest.getChannelCode(), Nvr800MsgType.QUEUE_DETECTION_RANGE));
                return queueDetectRespond;
            }
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public Boolean setQueueDetect(ParamBean<QueueDetectionRequest> obj) {
        QueueDetectionSetRequestNvr800 queueDetectionSetRequestNvr800 = new QueueDetectionSetRequestNvr800((QueueDetectionRequest)obj.getRequestBody());
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.QUEUE_DETECTION_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)queueDetectionSetRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public SituationalConfigRespond getCrowdDensity(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        QueueDetectionGetRequestNvr800 queueDetectionSetRequestNvr800 = new QueueDetectionGetRequestNvr800(queueDetectionRequest);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.CROWD_DENSITY_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)queueDetectionSetRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            if (result.getJSONObject("data") != null && result.getJSONObject("data").get((Object)"channel_info") != null) {
                JSONObject configRsp = ((JSONObject)result.getJSONObject("data").get((Object)"channel_info")).getJSONObject(queueDetectionRequest.getChannelCode());
                Optional operateBean = JsonUtil.convertJsonToBean((String)configRsp.toJSONString(), SituationalConfigRespond.class);
                SituationalConfigRespond crossCountingConfigRespond = (SituationalConfigRespond)operateBean.get();
                crossCountingConfigRespond.setRange(this.getRange(vcmInfo, queueDetectionRequest.getPageType(), queueDetectionRequest.getChannelCode(), Nvr800MsgType.CROWD_SITUATION_CROSS_COUNTING_RANGE));
                return crossCountingConfigRespond;
            }
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("get cross counting error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public Boolean setCrowdDensity(ParamBean<QueueDetectionRequest> obj) {
        QueueDetectionSetRequestNvr800 queueDetectionSetRequestNvr800 = new QueueDetectionSetRequestNvr800((QueueDetectionRequest)obj.getRequestBody());
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.CROWD_DENSITY_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)queueDetectionSetRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set crowdDensity error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONObject getThirdPartyAlgorithm(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        QueueDetectionGetRequestNvr800 queueDetectionSetRequestNvr800 = new QueueDetectionGetRequestNvr800(queueDetectionRequest);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.THIRD_PARTY_ALGORITHM_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)queueDetectionSetRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            if (result.getJSONObject("data") != null && result.getJSONObject("data").get((Object)"channel_info") != null) {
                JSONObject configRsp = ((JSONObject)result.getJSONObject("data").get((Object)"channel_info")).getJSONObject(queueDetectionRequest.getChannelCode());
                configRsp.put("range", (Object)this.getRange(vcmInfo, queueDetectionRequest.getPageType(), queueDetectionRequest.getChannelCode(), Nvr800MsgType.THIRD_PARTY_ALGORITHM_RANGE));
                return configRsp;
            }
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("get third party algorithm error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public Boolean setThirdPartyAlgorithm(ParamBean<QueueDetectionRequest> obj) {
        QueueDetectionSetRequestNvr800 queueDetectionSetRequestNvr800 = new QueueDetectionSetRequestNvr800((QueueDetectionRequest)obj.getRequestBody());
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.THIRD_PARTY_ALGORITHM_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)queueDetectionSetRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set third party algorithm error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public SituationalConfigRespond getCrossCounting(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        QueueDetectionGetRequestNvr800 queueDetectionSetRequestNvr800 = new QueueDetectionGetRequestNvr800(queueDetectionRequest);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.CROWD_SITUATION_CROSS_COUNTING_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)queueDetectionSetRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            if (result.getJSONObject("data") != null && result.getJSONObject("data").get((Object)"channel_info") != null) {
                JSONObject configRsp = ((JSONObject)result.getJSONObject("data").get((Object)"channel_info")).getJSONObject(queueDetectionRequest.getChannelCode());
                Optional operateBean = JsonUtil.convertJsonToBean((String)configRsp.toJSONString(), SituationalConfigRespond.class);
                SituationalConfigRespond crossCountingConfigRespond = (SituationalConfigRespond)operateBean.get();
                crossCountingConfigRespond.setRange(this.getRange(vcmInfo, queueDetectionRequest.getPageType(), queueDetectionRequest.getChannelCode(), Nvr800MsgType.CROWD_SITUATION_CROSS_COUNTING_RANGE));
                return crossCountingConfigRespond;
            }
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("get cross counting error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public Boolean setCrossCounting(ParamBean<QueueDetectionRequest> obj) {
        QueueDetectionSetRequestNvr800 queueDetectionSetRequestNvr800 = new QueueDetectionSetRequestNvr800((QueueDetectionRequest)obj.getRequestBody());
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.CROWD_SITUATION_CROSS_COUNTING_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)queueDetectionSetRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set cross counting error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONObject clearCrossCounting(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        QueueDetectionGetRequestNvr800 queueDetectionSetRequestNvr800 = new QueueDetectionGetRequestNvr800(queueDetectionRequest);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.CROWD_SITUATION_CROSS_COUNTING_CLEAR, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)queueDetectionSetRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            return result;
        }
        catch (SDKException e) {
            LOGGER.error("clear cross counting error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public HeatMapConfigRespond getHeatMapConfig(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        QueueDetectionGetRequestNvr800 queueDetectionSetRequestNvr800 = new QueueDetectionGetRequestNvr800(queueDetectionRequest);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.HEAT_MAP_CONFIG_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)queueDetectionSetRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            if (result.getJSONObject("data") != null && result.getJSONObject("data").get((Object)"channel_info") != null) {
                JSONObject configRsp = ((JSONObject)result.getJSONObject("data").get((Object)"channel_info")).getJSONObject(queueDetectionRequest.getChannelCode());
                Optional operateBean = JsonUtil.convertJsonToBean((String)configRsp.toJSONString(), HeatMapConfigRespond.class);
                HeatMapConfigRespond heatMapConfigRespond = (HeatMapConfigRespond)operateBean.get();
                heatMapConfigRespond.setRange(this.getRange(vcmInfo, queueDetectionRequest.getPageType(), queueDetectionRequest.getChannelCode(), Nvr800MsgType.HEAT_MAP_CONFIG_RANGE));
                return heatMapConfigRespond;
            }
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("get heat map config error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public Boolean setHeatMapConfig(ParamBean<HeatMapConfigRequest> obj) {
        HeatMapConfigRequest requestBody = (HeatMapConfigRequest)obj.getRequestBody();
        JSONObject requestJson = new JSONObject();
        JSONObject channelInfo = new JSONObject();
        requestBody.getConfig().setDetectTimesNum(null);
        if (!"ChannelConfig".equals(requestBody.getPageType())) {
            channelInfo.put(requestBody.getChannelCode(), JSONObject.parse((String)JsonUtil.convertBeanToJSON((Object)requestBody)));
        } else {
            channelInfo.put(requestBody.getChannelCode(), (Object)requestBody.getConfig());
        }
        JSONObject data = new JSONObject();
        data.put("channel_info", (Object)channelInfo);
        data.put("page_type", (Object)requestBody.getPageType());
        requestJson.put("data", (Object)data);
        requestJson.put("version", (Object)"1.0");
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.HEAT_MAP_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set heat map config error,IP:error" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public RepeatVisitorGetRespond getRepeatVisitor(ParamBean<RepeatVisitorRequest> obj) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.INTELLIGENT_REPEAT_VISITOR_GET, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional respondNvr800 = JsonUtil.convertJsonToBean((String)rsp.getJSONObject("data").toJSONString(), RepeatVisitorGetRespond.class);
            if (!respondNvr800.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            JSONObject range = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.INTELLIGENT_REPEAT_VISITOR_RANGE, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(range);
            RepeatVisitorGetRespond respond = (RepeatVisitorGetRespond)respondNvr800.get();
            respond.setRange(range.getJSONObject("data"));
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("get repeat visitor error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public Boolean setRepeatVisitor(ParamBean<RepeatVisitorRequest> obj) {
        try {
            RepeatVisitorRequest request = (RepeatVisitorRequest)obj.getRequestBody();
            if (CollectionUtils.isEmpty((Collection)request.getGroupInfoList())) {
                FaceRepositorySearchRespond searchRespond = this.faceRepositoryServiceNvr800.searchAll(obj.getVcmInfo(), new FaceRepositoryRequest());
                FaceRepository faceRepository = null;
                for (FaceRepository repository : searchRespond.getRepositories()) {
                    if (!"\u964c\u751f\u4eba".equals(repository.getName()) && !"Stranger".equalsIgnoreCase(repository.getName())) continue;
                    faceRepository = repository;
                    break;
                }
                if (Objects.nonNull(faceRepository)) {
                    JSONObject repository = new JSONObject();
                    repository.put("name", (Object)faceRepository.getName());
                    repository.put("group_id", (Object)Integer.parseInt(faceRepository.getGroupId()));
                    repository.put("is_selected", (Object)true);
                    JSONArray repositoryArray = new JSONArray();
                    repositoryArray.add((Object)repository);
                    request.setRepository(repositoryArray);
                }
            } else {
                JSONArray repositoryArray = new JSONArray();
                for (FaceGroupInfo groupInfo : request.getGroupInfoList()) {
                    JSONObject repository = new JSONObject();
                    repository.put("name", (Object)groupInfo.getName());
                    repository.put("group_id", (Object)Integer.parseInt(groupInfo.getGroupId()));
                    repository.put("is_selected", (Object)groupInfo.isSelect());
                    repositoryArray.add((Object)repository);
                }
                request.setRepository(repositoryArray);
            }
            RepeatVisitorSetRequestNvr800 requestNvr800 = new RepeatVisitorSetRequestNvr800(request);
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.INTELLIGENT_REPEAT_VISITOR_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set repeat visitor error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONObject getSmartOverlay(ParamBean<ChannelListRequest> obj) {
        List channelCodeList = ((ChannelListRequest)obj.getRequestBody()).getChannelCode();
        if (CollectionUtils.isEmpty((Collection)channelCodeList)) {
            List channelRespondList = this.deviceManageNvr800Service.listChannel(obj.getVcmInfo());
            channelCodeList = channelRespondList.stream().map(ChannelRespond::getChannelCode).collect(Collectors.toList());
        }
        ParamBean paramBean = new ParamBean();
        paramBean.setVcmInfo(obj.getVcmInfo());
        ChannelListRequest channelListRequest = new ChannelListRequest();
        channelListRequest.setChannelCode(channelCodeList);
        paramBean.setRequestBody((Object)channelListRequest);
        Map abilityMap = this.abilityNvr800Service.getAbilities(paramBean);
        List<String> nameList = Arrays.asList("CrossCounting", "QueueDetect", "CrowdDensity", "HeatMap");
        List<Nvr800MsgType> configUrlList = Arrays.asList(Nvr800MsgType.CROWD_SITUATION_CROSS_COUNTING_GET, Nvr800MsgType.QUEUE_DETECTION_GET, Nvr800MsgType.CROWD_DENSITY_GET, Nvr800MsgType.HEAT_MAP_CONFIG_GET);
        JSONObject data = new JSONObject();
        JSONObject igtAlarmConfig = new JSONObject();
        for (int i = 0; i < nameList.size(); ++i) {
            JSONObject ability = new JSONObject();
            List codeList = this.getChannelCodeList(abilityMap, nameList.get(i));
            if (CollectionUtils.isEmpty((Collection)codeList)) {
                channelCodeList.parallelStream().forEach(channelCode -> {
                    JSONObject config = new JSONObject();
                    config.put("switch", (Object)false);
                    ability.put(channelCode, (Object)config);
                });
            } else {
                JSONObject configJson = this.behaviorAnalysisServiceImpl.getIntelligentConfig(obj.getVcmInfo(), codeList, configUrlList.get(i), "ChannelConfig");
                channelCodeList.parallelStream().forEach(channelCode -> {
                    JSONObject config = new JSONObject();
                    if (Objects.nonNull(configJson.getJSONObject(channelCode))) {
                        config.put("switch", (Object)configJson.getJSONObject(channelCode).getBooleanValue("switch"));
                    } else {
                        config.put("switch", (Object)false);
                    }
                    ability.put(channelCode, (Object)config);
                });
            }
            data.put(nameList.get(i), (Object)ability);
        }
        JSONObject igtAlarm = this.behaviorAnalysisServiceImpl.getIntelligentConfig(obj.getVcmInfo(), channelCodeList, Nvr800MsgType.IGT_ALARM_CONFIG_GET_URI, "ChannelConfig");
        channelCodeList.parallelStream().forEach(channelCode -> {
            JSONObject config = new JSONObject();
            if (Objects.nonNull(igtAlarm.getJSONObject(channelCode))) {
                config.put("switch", (Object)igtAlarm.getJSONObject(channelCode).getBooleanValue("switch"));
            } else {
                config.put("switch", (Object)false);
            }
            igtAlarmConfig.put(channelCode, (Object)config);
        });
        data.put("IGTAlarmConfig", (Object)igtAlarmConfig);
        return data;
    }

    public JSONObject asyncGetSmartOverlay(ParamBean<ChannelListRequest> obj) {
        List channelCodeList = ((ChannelListRequest)obj.getRequestBody()).getChannelCode();
        if (CollectionUtils.isEmpty((Collection)channelCodeList)) {
            List channelRespondList = this.deviceManageNvr800Service.listChannel(obj.getVcmInfo());
            channelCodeList = channelRespondList.stream().map(ChannelRespond::getChannelCode).collect(Collectors.toList());
        }
        ParamBean paramBean = new ParamBean();
        paramBean.setVcmInfo(obj.getVcmInfo());
        ChannelListRequest channelListRequest = new ChannelListRequest();
        channelListRequest.setChannelCode(channelCodeList);
        paramBean.setRequestBody((Object)channelListRequest);
        JSONObject data = new JSONObject();
        List finalChannelCodeList = channelCodeList;
        CompletableFuture<JSONObject> crossCountingFuture = CompletableFuture.supplyAsync(() -> {
            JSONObject igtAlarmConfig = new JSONObject();
            JSONObject igtAlarm = this.behaviorAnalysisServiceImpl.getIntelligentConfig(obj.getVcmInfo(), finalChannelCodeList, Nvr800MsgType.CROWD_SITUATION_CROSS_COUNTING_GET, "ChannelConfig");
            finalChannelCodeList.parallelStream().forEach(channelCode -> {
                JSONObject config = new JSONObject();
                if (Objects.nonNull(igtAlarm.getJSONObject(channelCode))) {
                    config.put("switch", (Object)igtAlarm.getJSONObject(channelCode).getBooleanValue("switch"));
                } else {
                    config.put("switch", (Object)false);
                }
                igtAlarmConfig.put(channelCode, (Object)config);
            });
            data.put("CrossCounting", (Object)igtAlarmConfig);
            return data;
        });
        CompletableFuture<JSONObject> detectFuture = CompletableFuture.supplyAsync(() -> {
            JSONObject igtAlarmConfig = new JSONObject();
            JSONObject igtAlarm = this.behaviorAnalysisServiceImpl.getIntelligentConfig(obj.getVcmInfo(), finalChannelCodeList, Nvr800MsgType.QUEUE_DETECTION_GET, "ChannelConfig");
            finalChannelCodeList.parallelStream().forEach(channelCode -> {
                JSONObject config = new JSONObject();
                if (Objects.nonNull(igtAlarm.getJSONObject(channelCode))) {
                    config.put("switch", (Object)igtAlarm.getJSONObject(channelCode).getBooleanValue("switch"));
                } else {
                    config.put("switch", (Object)false);
                }
                igtAlarmConfig.put(channelCode, (Object)config);
            });
            data.put("QueueDetect", (Object)igtAlarmConfig);
            return data;
        });
        CompletableFuture<JSONObject> crowdFuture = CompletableFuture.supplyAsync(() -> {
            JSONObject igtAlarmConfig = new JSONObject();
            JSONObject igtAlarm = this.behaviorAnalysisServiceImpl.getIntelligentConfig(obj.getVcmInfo(), finalChannelCodeList, Nvr800MsgType.CROWD_DENSITY_GET, "ChannelConfig");
            finalChannelCodeList.parallelStream().forEach(channelCode -> {
                JSONObject config = new JSONObject();
                if (Objects.nonNull(igtAlarm.getJSONObject(channelCode))) {
                    config.put("switch", (Object)igtAlarm.getJSONObject(channelCode).getBooleanValue("switch"));
                } else {
                    config.put("switch", (Object)false);
                }
                igtAlarmConfig.put(channelCode, (Object)config);
            });
            data.put("CrowdDensity", (Object)igtAlarmConfig);
            return data;
        });
        CompletableFuture<JSONObject> heatMapFuture = CompletableFuture.supplyAsync(() -> {
            JSONObject igtAlarmConfig = new JSONObject();
            JSONObject igtAlarm = this.behaviorAnalysisServiceImpl.getIntelligentConfig(obj.getVcmInfo(), finalChannelCodeList, Nvr800MsgType.CROWD_DENSITY_GET, "ChannelConfig");
            finalChannelCodeList.parallelStream().forEach(channelCode -> {
                JSONObject config = new JSONObject();
                if (Objects.nonNull(igtAlarm.getJSONObject(channelCode))) {
                    config.put("switch", (Object)igtAlarm.getJSONObject(channelCode).getBooleanValue("switch"));
                } else {
                    config.put("switch", (Object)false);
                }
                igtAlarmConfig.put(channelCode, (Object)config);
            });
            data.put("HeatMap", (Object)igtAlarmConfig);
            return data;
        });
        CompletableFuture<JSONObject> igtAlarmFuture = CompletableFuture.supplyAsync(() -> {
            JSONObject igtAlarmConfig = new JSONObject();
            JSONObject igtAlarm = this.behaviorAnalysisServiceImpl.getIntelligentConfig(obj.getVcmInfo(), finalChannelCodeList, Nvr800MsgType.IGT_ALARM_CONFIG_GET_URI, "ChannelConfig");
            finalChannelCodeList.parallelStream().forEach(channelCode -> {
                JSONObject config = new JSONObject();
                if (Objects.nonNull(igtAlarm.getJSONObject(channelCode))) {
                    config.put("switch", (Object)igtAlarm.getJSONObject(channelCode).getBooleanValue("switch"));
                } else {
                    config.put("switch", (Object)false);
                }
                igtAlarmConfig.put(channelCode, (Object)config);
            });
            data.put("IGTAlarmConfig", (Object)igtAlarmConfig);
            return data;
        });
        CompletableFuture.allOf(crossCountingFuture, detectFuture, crowdFuture, heatMapFuture, igtAlarmFuture).join();
        return data;
    }

    private List<String> getChannelCodeList(Map<String, List<String>> abilityMap, String abilityName) {
        ArrayList<String> channelCodeList = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : abilityMap.entrySet()) {
            if (!entry.getValue().contains(abilityName)) continue;
            channelCodeList.add(entry.getKey());
        }
        return channelCodeList;
    }

    private JSONObject getParamRange(ParamBean<NormalIntelligentRequest> obj, Nvr800MsgType msgType) {
        try {
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)msgType, (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return respondNvr800.getData().getJSONObject("channel_info").getJSONObject("items").getJSONObject(((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode()).getJSONObject("items");
        }
        catch (SDKException e) {
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private JSONObject videoCoverRequest(ParamBean<VideoCoverRequest> obj) {
        JSONObject channel = new JSONObject();
        channel.put("privacy_zone_enable", (Object)((VideoCoverRequest)obj.getRequestBody()).getConfig().getEnable());
        channel.put("curnum", (Object)((VideoCoverRequest)obj.getRequestBody()).getConfig().getZones().size());
        JSONArray zones = new JSONArray();
        List zones1 = ((VideoCoverRequest)obj.getRequestBody()).getConfig().getZones();
        ArrayList<Point> points = new ArrayList<Point>();
        Point point = new Point();
        point.setTop(0);
        point.setLeft(0);
        for (int j = 0; j < 4; ++j) {
            points.add(point);
        }
        for (int i = 0; i < 8; ++i) {
            JSONObject zoneJson = new JSONObject();
            zoneJson.put("zone_no", (Object)(i + 1));
            if (i < zones1.size()) {
                zoneJson.put("color", (Object)((ZoneInfo)zones1.get(i)).getColor());
                zoneJson.put("point", (Object)((ZoneInfo)zones1.get(i)).getPoints());
            } else {
                zoneJson.put("color", (Object)0);
                zoneJson.put("point", points);
            }
            zones.add((Object)zoneJson);
        }
        channel.put("zone_info_p", (Object)zones);
        JSONObject channelInfo = new JSONObject();
        channelInfo.put(((VideoCoverRequest)obj.getRequestBody()).getChannelCode(), (Object)channel);
        JSONObject data = new JSONObject();
        data.put("channel_info", (Object)channelInfo);
        JSONObject req = new JSONObject();
        req.put("data", (Object)data);
        return req;
    }

    private JSONObject motionAlarmConfigRequest(ParamBean<MotionConfigRequest> obj) {
        String channelInfo = JsonUtil.convertBeanToJSON((Object)obj.getRequestBody());
        JSONObject channel = new JSONObject();
        channel.put(((MotionConfigRequest)obj.getRequestBody()).getChannelCode(), JSONObject.parse((String)channelInfo));
        JSONObject data = new JSONObject();
        data.put("channel_info", (Object)channel);
        data.put("page_type", (Object)((MotionConfigRequest)obj.getRequestBody()).getPageType());
        JSONObject req = new JSONObject();
        req.put("data", (Object)data);
        return req;
    }

    private JSONObject motionChannelConfigRequest(ParamBean<MotionConfigRequest> obj) {
        MotionChannelConfig channelConfig = ((MotionConfigRequest)obj.getRequestBody()).getChannelConfig();
        JSONObject channelInfo = new JSONObject();
        channelInfo.put("switch", (Object)channelConfig.getEnable());
        channelInfo.put("sensitivity", (Object)channelConfig.getSensitivity());
        channelInfo.put("intervals", (Object)channelConfig.getIntervals());
        JSONArray rects = new JSONArray();
        channelConfig.getRects().forEach(rect -> {
            JSONObject rectInfo = new JSONObject();
            rectInfo.put("left", (Object)rect.getLeft());
            rectInfo.put("top", (Object)rect.getTop());
            rectInfo.put("width", (Object)rect.getWidth());
            rectInfo.put("height", (Object)rect.getHeight());
            rects.add((Object)rectInfo);
        });
        channelInfo.put("audio_enable", (Object)channelConfig.getAudioEnable());
        channelInfo.put("audio_file", (Object)channelConfig.getAudioFile());
        channelInfo.put("audio_playback_times", (Object)channelConfig.getAudioPlaybackTimes());
        channelInfo.put("white_light_illuminator_enable", (Object)channelConfig.getWhiteLightIllumEnable());
        channelInfo.put("flash_duration", (Object)channelConfig.getFlashDuration());
        channelInfo.put("white_light_illuminator", (Object)channelConfig.getWhiteLightIlluminator());
        channelInfo.put("rect", (Object)rects);
        JSONObject channel = new JSONObject();
        channel.put(((MotionConfigRequest)obj.getRequestBody()).getChannelCode(), (Object)channelInfo);
        JSONObject data = new JSONObject();
        data.put("channel_info", (Object)channel);
        data.put("page_type", (Object)((MotionConfigRequest)obj.getRequestBody()).getPageType());
        JSONObject req = new JSONObject();
        req.put("data", (Object)data);
        return req;
    }

    public MotionChannelConfig motionChannelConfigConvert(JSONObject obj, String channelCode) {
        MotionChannelConfig config = new MotionChannelConfig();
        JSONObject channelConfig = obj.getJSONObject("channel_info").getJSONObject(channelCode);
        config.setEnable(channelConfig.getBoolean("switch"));
        config.setSensitivity(channelConfig.getIntValue("sensitivity"));
        config.setIntervals(channelConfig.getIntValue("intervals"));
        config.setMaxRect(channelConfig.getIntValue("maxrect"));
        config.setAudioEnable(channelConfig.getBoolean("audio_enable"));
        config.setAudioFile(channelConfig.getString("audio_file"));
        config.setAudioPlaybackTimes(channelConfig.getInteger("audio_playback_times"));
        config.setWhiteLightIllumEnable(channelConfig.getBoolean("white_light_illuminator_enable"));
        config.setWhiteLightIlluminator(channelConfig.getString("white_light_illuminator"));
        config.setFlashDuration(channelConfig.getInteger("flash_duration"));
        if (channelConfig.getJSONArray("rect") != null) {
            ArrayList<Rect> rects = new ArrayList<Rect>();
            JSONArray rectJson = channelConfig.getJSONArray("rect");
            for (int i = 0; i < rectJson.size(); ++i) {
                if (rectJson.getJSONObject(i).getIntValue("width") == 0) continue;
                Rect rect = new Rect();
                rect.setLeft(rectJson.getJSONObject(i).getIntValue("left"));
                rect.setTop(rectJson.getJSONObject(i).getIntValue("top"));
                rect.setWidth(rectJson.getJSONObject(i).getIntValue("width"));
                rect.setHeight(rectJson.getJSONObject(i).getIntValue("height"));
                rects.add(rect);
            }
            config.setRects(rects);
        }
        return config;
    }

    private List<BehaviorAlarmPlanItemRespond> motionAlarmConvert(JSONObject obj, String channelCode) {
        JSONArray alarmPlan = obj.getJSONObject("channel_info").getJSONObject(channelCode).getJSONArray("alarm_plan_list");
        List<Object> list = new ArrayList<BehaviorAlarmPlanItemRespond>();
        if (!CollectionUtils.isEmpty((Collection)alarmPlan)) {
            list = JSONObject.parseArray((String)alarmPlan.toJSONString(), BehaviorAlarmPlanItemRespond.class);
        }
        return list;
    }

    public VideoCoverRespond videoCoverConfigRespondConvert(ParamBean<VideoCoverRequest> obj, JSONObject data) {
        VideoCoverRespond rsp = new VideoCoverRespond();
        JSONObject channelInfo = data.getJSONObject("channel_info").getJSONObject(((VideoCoverRequest)obj.getRequestBody()).getChannelCode());
        rsp.setEnable(channelInfo.getBoolean("privacy_zone_enable"));
        rsp.setMaxNum(channelInfo.getIntValue("maxnum"));
        rsp.setCurNum(channelInfo.getIntValue("curnum"));
        ArrayList<ZoneInfo> zoneInfos = new ArrayList<ZoneInfo>();
        JSONArray zoneInfoJSons = channelInfo.getJSONArray("zone_info_p");
        for (int i = 0; i < zoneInfoJSons.size(); ++i) {
            JSONObject zoneInfo = zoneInfoJSons.getJSONObject(i);
            ZoneInfo zo = new ZoneInfo();
            zo.setNo(zoneInfo.getIntValue("zone_no"));
            zo.setColor(zoneInfo.getIntValue("color"));
            ArrayList<Point> points = new ArrayList<Point>();
            JSONArray pointsJson = zoneInfo.getJSONArray("point");
            for (int j = 0; j < pointsJson.size(); ++j) {
                Point point = new Point();
                point.setLeft(pointsJson.getJSONObject(j).getIntValue("left"));
                point.setTop(pointsJson.getJSONObject(j).getIntValue("top"));
                points.add(point);
            }
            zo.setPoints(points);
            zoneInfos.add(zo);
        }
        rsp.setZones(zoneInfos);
        return rsp;
    }

    public SituationalConfigRespond getLeaveDetect(VcmReqBaseInfo vcmInfo, QueueDetectionRequest requestBody) {
        QueueDetectionGetRequestNvr800 queueDetectionSetRequestNvr800 = new QueueDetectionGetRequestNvr800(requestBody);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.PERSON_LEAVE_DETECT_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)queueDetectionSetRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            if (result.getJSONObject("data") != null && result.getJSONObject("data").get((Object)"channel_info") != null) {
                JSONObject configRsp = ((JSONObject)result.getJSONObject("data").get((Object)"channel_info")).getJSONObject(requestBody.getChannelCode());
                Optional operateBean = JsonUtil.convertJsonToBean((String)configRsp.toJSONString(), SituationalConfigRespond.class);
                SituationalConfigRespond crossCountingConfigRespond = (SituationalConfigRespond)operateBean.get();
                crossCountingConfigRespond.setRange(this.getRange(vcmInfo, requestBody.getPageType(), requestBody.getChannelCode(), Nvr800MsgType.CROWD_SITUATION_CROSS_COUNTING_RANGE));
                if (!CollectionUtils.isEmpty((Collection)crossCountingConfigRespond.getAreaList()) && ((BehaviorAreaItemRespond)crossCountingConfigRespond.getAreaList().get(0)).getPointList().size() == 0) {
                    crossCountingConfigRespond.setAreaList(new ArrayList());
                }
                return crossCountingConfigRespond;
            }
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("get person leave detect error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public Boolean setLeaveDetect(ParamBean<QueueDetectionRequest> obj) {
        QueueDetectionRequest requestBody = (QueueDetectionRequest)obj.getRequestBody();
        QueueDetectionSetRequestNvr800 requestJson = new QueueDetectionSetRequestNvr800(requestBody);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.PERSON_LEAVE_DETECT_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()), (int)20);
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set person leave detect error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONObject getTargetAuth(ParamBean<ChannelListRequest> obj) {
        try {
            JSONObject dataObject = new JSONObject();
            if (Objects.nonNull(obj.getRequestBody()) && !CollectionUtils.isEmpty((Collection)((ChannelListRequest)obj.getRequestBody()).getChannelCode())) {
                JSONObject channelObject = new JSONObject();
                channelObject.put("channel", (Object)((ChannelListRequest)obj.getRequestBody()).getChannelCode());
                dataObject.put("data", (Object)channelObject);
            }
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.FACE_RECOGNITION_CONFIG_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            JSONObject channelInfo = rsp.getData().getJSONObject("channel_info");
            JSONObject channelObject = new JSONObject();
            for (String s : channelInfo.keySet()) {
                if (channelInfo.getJSONObject(s).containsKey((Object)"ai_auth_switch")) {
                    channelObject.put(s, (Object)channelInfo.getJSONObject(s).getBoolean("ai_auth_switch"));
                    continue;
                }
                channelObject.put(s, null);
            }
            return channelObject;
        }
        catch (SDKException e) {
            LOGGER.error("get targetAuth error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONArray setTargetAuth(ParamBean<TargetRecognitionRequest> obj) {
        JSONArray respond = new JSONArray();
        try {
            String s;
            JSONObject dataObject = new JSONObject();
            if (Objects.nonNull(obj.getRequestBody()) && !CollectionUtils.isEmpty((Collection)((TargetRecognitionRequest)obj.getRequestBody()).getChannelCode())) {
                JSONObject channelObject = new JSONObject();
                JSONObject chnObject = new JSONObject();
                for (int i = 0; i < ((TargetRecognitionRequest)obj.getRequestBody()).getChannelCode().size(); ++i) {
                    s = (String)((TargetRecognitionRequest)obj.getRequestBody()).getChannelCode().get(i);
                    JSONObject ability = new JSONObject();
                    ability.put("ai_auth_switch", (Object)((TargetRecognitionRequest)obj.getRequestBody()).getTargetAbility());
                    chnObject.put(s, (Object)ability);
                    channelObject.put("channel_info", (Object)chnObject);
                }
                dataObject.put("data", (Object)channelObject);
            }
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.FACE_RECOGNITION_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            for (int i = 0; i < ((TargetRecognitionRequest)obj.getRequestBody()).getChannelCode().size(); ++i) {
                JSONObject sucObject = new JSONObject();
                s = (String)((TargetRecognitionRequest)obj.getRequestBody()).getChannelCode().get(i);
                sucObject.put("result", (Object)true);
                sucObject.put("channelCode", (Object)s);
                respond.add((Object)sucObject);
            }
            return respond;
        }
        catch (SDKException e) {
            if ("400".equals(e.getErrorCode()) && e.getMessage().contains("ch_error_code") && e.getMessage().contains("no_support")) {
                JSONObject mesObject = JSONObject.parseObject((String)e.getMessage());
                JSONArray chErrorCode = mesObject.getJSONArray("ch_error_code");
                for (int i = 0; i < ((TargetRecognitionRequest)obj.getRequestBody()).getChannelCode().size(); ++i) {
                    String s = (String)((TargetRecognitionRequest)obj.getRequestBody()).getChannelCode().get(i);
                    boolean a = false;
                    JSONObject errorObject = new JSONObject();
                    for (int j = 0; j < chErrorCode.size(); ++j) {
                        JSONObject chErrorObject = chErrorCode.getJSONObject(j);
                        if (!s.equals(chErrorObject.getString("channel"))) continue;
                        a = true;
                        errorObject.put("channelCode", (Object)s);
                        errorObject.put("result", (Object)false);
                        errorObject.put("reason", (Object)chErrorObject.getString("error_code"));
                        respond.add((Object)errorObject);
                        break;
                    }
                    if (a) continue;
                    errorObject.put("result", (Object)true);
                    errorObject.put("channelCode", (Object)s);
                    respond.add((Object)errorObject);
                }
                return respond;
            }
            LOGGER.error("set targetAuth error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

