/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.EncPasswordBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.multiAircraft.MultiAircraftMutualAidRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.multiAircraft.MultiAircraftMutualAidRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.MultiAircraftMutualAidService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.PasswordServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MultiAircraftNvr800ServiceImpl
extends AbstractNvr800Service
implements MultiAircraftMutualAidService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiAircraftNvr800ServiceImpl.class);
    @Autowired
    PasswordServiceImpl passwordService;

    public List<MultiAircraftMutualAidRespond> getMultiAircraft(ParamBean<MultiAircraftMutualAidRequest> obj) {
        ArrayList<MultiAircraftMutualAidRespond> respond;
        block4: {
            respond = new ArrayList<MultiAircraftMutualAidRespond>();
            try {
                CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.MULTI_AIRCRAFT_MUTUAL_AID_GET, (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
                this.checkRespond((BaseRespondNvr800)rsp);
                JSONObject channelInfo = rsp.getData().getJSONObject("channel_info");
                if (Objects.nonNull(channelInfo)) {
                    for (String s : channelInfo.keySet()) {
                        if (!Objects.nonNull(channelInfo.getJSONObject(s)) || !channelInfo.getJSONObject(s).containsKey((Object)"subordination")) continue;
                        channelInfo.getJSONObject(s).put("channelCode", (Object)s);
                        Optional operateBean = JsonUtil.convertJsonToBean((String)channelInfo.getJSONObject(s).toJSONString(), MultiAircraftMutualAidRespond.class);
                        respond.add((MultiAircraftMutualAidRespond)operateBean.get());
                    }
                    break block4;
                }
                throw new InvokeException("500", "cu_device_not_return");
            }
            catch (SDKException e) {
                LOGGER.error("get MultiAircraft happen exception ", (Throwable)e);
                throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
            }
        }
        return respond;
    }

    public Boolean setMultiAircraft(ParamBean<MultiAircraftMutualAidRequest> obj) {
        try {
            MultiAircraftMutualAidRequest requestBody = (MultiAircraftMutualAidRequest)obj.getRequestBody();
            JSONObject dataObject = new JSONObject();
            JSONObject chnObject = new JSONObject();
            JSONObject channelObject = new JSONObject();
            if ("enable".equals(requestBody.getOperation())) {
                JSONObject statusObject = new JSONObject();
                statusObject.put("on_state", (Object)requestBody.isOnState());
                channelObject.put(requestBody.getChannelCode(), (Object)statusObject);
                chnObject.put("operation", (Object)"enable");
                chnObject.put("channel_info", (Object)channelObject);
            } else if ("unbind".equals(requestBody.getOperation())) {
                JSONObject unbindObject = new JSONObject();
                channelObject.put(requestBody.getChannelCode(), (Object)unbindObject);
                chnObject.put("operation", (Object)"unbind");
                chnObject.put("channel_info", (Object)channelObject);
            } else if ("bind".equals(requestBody.getOperation())) {
                JSONObject bindObject = new JSONObject();
                JSONObject passWordObject = new JSONObject();
                EncPasswordBean encPasswordBean = this.passwordService.get(obj.getVcmInfo(), requestBody.getEncPassword());
                passWordObject.put("cipher", (Object)encPasswordBean.getCipher());
                passWordObject.put("seq", (Object)encPasswordBean.getSeq());
                bindObject.put("bonded_device", (Object)requestBody.getBondedDevice());
                bindObject.put("onvif_user", (Object)requestBody.getOnvifUser());
                bindObject.put("enc_password", (Object)passWordObject);
                channelObject.put(requestBody.getChannelCode(), (Object)bindObject);
                chnObject.put("operation", (Object)"bind");
                chnObject.put("channel_info", (Object)channelObject);
            }
            dataObject.put("data", (Object)chnObject);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.MULTI_AIRCRAFT_MUTUAL_AID_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()), (int)30);
            this.checkJsonRespond(rsp);
        }
        catch (SDKException e) {
            LOGGER.error("set MultiAircraft happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return true;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

