/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.Page;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceInfoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.PeopleRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceInfoSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepository;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.People;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.PeopleSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.FaceRepositoryManagementService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="faceRepositoryServiceNvr800")
public class FaceRepositoryServiceNvr800Impl
extends AbstractNvr800Service
implements FaceRepositoryManagementService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaceRepositoryServiceNvr800Impl.class);

    public boolean add(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        try {
            FaceRepositorySearchRespond searchRespond = this.search(vcmReqBaseInfo, faceRepository);
            if (!CollectionUtils.isEmpty((Collection)searchRespond.getRepositories())) {
                return true;
            }
            JSONObject data = new JSONObject();
            JSONObject groupInfo = new JSONObject();
            if ("2".equals(faceRepository.getType())) {
                groupInfo.put("Policy", (Object)1);
            } else {
                groupInfo.put("Policy", (Object)0);
            }
            groupInfo.put("Name", (Object)faceRepository.getName());
            JSONArray groupArray = new JSONArray();
            groupArray.add((Object)groupInfo);
            data.put("Group", (Object)groupArray);
            JSONObject request = new JSONObject();
            request.put("data", (Object)data);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.ADD_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("addGroup happen exception", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean update(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        try {
            FaceRepositorySearchRespond res = this.search(vcmReqBaseInfo, faceRepository);
            if (CollectionUtils.isEmpty((Collection)res.getRepositories())) {
                throw new InvokeException("500", DeviceUtil.CU_FACE_REPOSITORY_NOT_EXIST);
            }
            JSONObject groupInfo = new JSONObject();
            groupInfo.put("Id", (Object)Integer.parseInt(((FaceRepository)res.getRepositories().get(0)).getGroupId()));
            groupInfo.put("Name", (Object)faceRepository.getNewName());
            groupInfo.put("Policy", (Object)0);
            if ("2".equals(((FaceRepository)res.getRepositories().get(0)).getType())) {
                groupInfo.put("Policy", (Object)1);
            }
            JSONArray groupArray = new JSONArray();
            groupArray.add((Object)groupInfo);
            JSONObject data = new JSONObject();
            data.put("Group", (Object)groupArray);
            JSONObject request = new JSONObject();
            request.put("data", (Object)data);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.UPDATE_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("updateGroup happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean delete(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        try {
            FaceRepositorySearchRespond searchRespond = this.search(vcmReqBaseInfo, faceRepository);
            if (CollectionUtils.isEmpty((Collection)searchRespond.getRepositories())) {
                return true;
            }
            JSONObject request = new JSONObject();
            JSONObject data = new JSONObject();
            JSONObject groupInfo = new JSONObject();
            groupInfo.put("Id", (Object)Integer.parseInt(((FaceRepository)searchRespond.getRepositories().get(0)).getGroupId()));
            JSONArray groupArray = new JSONArray();
            groupArray.add((Object)groupInfo);
            data.put("Group", (Object)groupArray);
            request.put("data", (Object)data);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.DELETE_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("deleteGroup happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public FaceRepositorySearchRespond search(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        try {
            JSONObject rsp;
            block8: {
                JSONObject data = new JSONObject();
                data.put("DefaultVal", (Object)0);
                data.put("WithInternal", (Object)0);
                data.put("SimpleInfo", (Object)1);
                if (faceRepository != null && !StringUtils.isEmpty((CharSequence)faceRepository.getName())) {
                    data.put("Name", (Object)faceRepository.getName());
                }
                JSONObject request = new JSONObject();
                request.put("data", (Object)data);
                rsp = new JSONObject();
                try {
                    rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.SEARCH_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
                    if (-9 != rsp.getJSONObject("data").getIntValue("Result")) {
                        this.checkJsonRespond(rsp);
                    }
                }
                catch (SDKException e) {
                    String error = Nvr800Utils.reasonHelper((SDKException)e);
                    if ("AORT_NOT_EXIST".equals(error)) break block8;
                    LOGGER.error("---search repository request error----", (Throwable)e);
                    throw new InvokeException("500", (Object)JsonUtil.convertBeanToJSON((Object)((Object)e)), error);
                }
            }
            FaceRepositorySearchRespond faceRepositorySearchRespond = new FaceRepositorySearchRespond();
            if (Objects.nonNull(rsp.getJSONObject("data")) && !CollectionUtils.isEmpty((Collection)rsp.getJSONObject("data").getJSONArray("Group"))) {
                JSONArray array = rsp.getJSONObject("data").getJSONArray("Group");
                array.stream().filter(obj -> {
                    if (faceRepository != null && !StringUtils.isEmpty((CharSequence)faceRepository.getName())) {
                        return ((JSONObject)obj).getIntValue("Id") > 4 && faceRepository.getName().equals(((JSONObject)obj).getString("Name"));
                    }
                    return ((JSONObject)obj).getIntValue("Id") > 4;
                }).forEach(obj -> {
                    FaceRepository face = new FaceRepository();
                    face.setName(((JSONObject)obj).getString("Name"));
                    face.setType(((JSONObject)obj).getIntValue("Policy") == 0 ? "3" : "2");
                    face.setGroupId(((JSONObject)obj).getString("Id"));
                    faceRepositorySearchRespond.getRepositories().add(face);
                });
                faceRepositorySearchRespond.setTotal(String.valueOf(faceRepositorySearchRespond.getRepositories().size()));
            }
            return faceRepositorySearchRespond;
        }
        catch (Exception e) {
            if (e instanceof InvokeException) {
                throw e;
            }
            LOGGER.error("searchGroup happen exception,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", "unknown_error");
        }
    }

    public FaceRepositorySearchRespond searchAll(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        try {
            JSONObject rsp;
            block8: {
                JSONObject data = new JSONObject();
                data.put("SimpleInfo", (Object)1);
                if (faceRepository != null && !StringUtils.isEmpty((CharSequence)faceRepository.getName())) {
                    data.put("Name", (Object)faceRepository.getName());
                }
                JSONObject request = new JSONObject();
                request.put("data", (Object)data);
                rsp = new JSONObject();
                try {
                    rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.SEARCH_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
                    if (-9 != rsp.getJSONObject("data").getIntValue("Result")) {
                        this.checkJsonRespond(rsp);
                    }
                }
                catch (SDKException e) {
                    String error = Nvr800Utils.reasonHelper((SDKException)e);
                    if ("AORT_NOT_EXIST".equals(error)) break block8;
                    LOGGER.error("---search repository request error----", (Throwable)e);
                    throw new InvokeException("500", (Object)JsonUtil.convertBeanToJSON((Object)((Object)e)), error);
                }
            }
            FaceRepositorySearchRespond faceRepositorySearchRespond = new FaceRepositorySearchRespond();
            if (Objects.nonNull(rsp.getJSONObject("data")) && !CollectionUtils.isEmpty((Collection)rsp.getJSONObject("data").getJSONArray("Group"))) {
                JSONArray array = rsp.getJSONObject("data").getJSONArray("Group");
                array.forEach(obj -> {
                    FaceRepository face = new FaceRepository();
                    face.setName(((JSONObject)obj).getString("Name"));
                    face.setType(((JSONObject)obj).getIntValue("Policy") == 0 ? "3" : "2");
                    face.setGroupId(((JSONObject)obj).getString("Id"));
                    faceRepositorySearchRespond.getRepositories().add(face);
                });
                faceRepositorySearchRespond.setTotal(String.valueOf(faceRepositorySearchRespond.getRepositories().size()));
            }
            return faceRepositorySearchRespond;
        }
        catch (Exception e) {
            if (e instanceof InvokeException) {
                throw e;
            }
            LOGGER.error("searchGroup happen exception,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", "unknown_error");
        }
    }

    public boolean addPeople(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        if (this.checkParam(people)) {
            return false;
        }
        try {
            FaceRepositorySearchRespond res = this.search(vcmReqBaseInfo, new FaceRepositoryRequest());
            if (CollectionUtils.isEmpty((Collection)res.getRepositories())) {
                throw new InvokeException("500", DeviceUtil.CU_FACE_REPOSITORY_NOT_EXIST);
            }
            FaceRepository faceRepository = null;
            for (FaceRepository repository : res.getRepositories()) {
                if (!people.getFaceRepositoryInfo().getName().equals(repository.getName())) continue;
                faceRepository = repository;
                break;
            }
            if (Objects.isNull(faceRepository)) {
                throw new InvokeException("500", DeviceUtil.CU_FACE_REPOSITORY_NOT_EXIST);
            }
            JSONObject faceInfo = new JSONObject();
            faceInfo.put("GrpId", (Object)Integer.parseInt(faceRepository.getGroupId()));
            int sex = Integer.parseInt(people.getGender()) + 1;
            faceInfo.put("Sex", (Object)sex);
            faceInfo.put("Age", (Object)people.getAge());
            faceInfo.put("Image", people.getPictures().get(0));
            if (StringUtils.isNotBlank((CharSequence)people.getName())) {
                faceInfo.put("Name", (Object)people.getName());
            } else {
                faceInfo.put("Name", (Object)people.getId());
            }
            faceInfo.put("IdCode", (Object)people.getCredentialNumber());
            faceInfo.put("Job", (Object)people.getOccupation());
            faceInfo.put("Phone", (Object)people.getMobilePhone());
            faceInfo.put("Email", (Object)people.getEmail());
            faceInfo.put("Remark", (Object)people.getId());
            JSONArray faceArray = new JSONArray();
            faceArray.add((Object)faceInfo);
            JSONObject data = new JSONObject();
            data.put("FaceInfo", (Object)faceArray);
            JSONObject request = new JSONObject();
            request.put("data", (Object)data);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.ADD_PEOPLE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            JSONArray originArray = rsp.getJSONObject("data").getJSONArray("OriginalFaceInfo");
            if (!CollectionUtils.isEmpty((Collection)originArray)) {
                throw new InvokeException("500", "cu_face_repeat");
            }
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("addFace happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean deletePeople(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        JSONArray peopleArray;
        block6: {
            if (this.checkParam(people)) {
                return false;
            }
            peopleArray = new JSONArray();
            try {
                peopleArray = this.searchPeopleCommon(vcmReqBaseInfo, people);
            }
            catch (InvokeException e) {
                if (DeviceUtil.CU_FACE_REPOSITORY_NOT_EXIST.equals(e.getMessage())) break block6;
                throw e;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)peopleArray)) {
            JSONObject oldPeople = peopleArray.getJSONObject(0);
            JSONObject request = new JSONObject();
            JSONObject data = new JSONObject();
            JSONObject faceInfo = new JSONObject();
            faceInfo.put("Id", (Object)oldPeople.getIntValue("Id"));
            JSONArray faceArray = new JSONArray();
            faceArray.add((Object)faceInfo);
            data.put("FaceInfo", (Object)faceArray);
            request.put("data", (Object)data);
            JSONObject rsp = null;
            try {
                rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.DELETE_PEOPLE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            }
            catch (SDKException e) {
                LOGGER.error("deleteFace happen exception ", (Throwable)e);
            }
            this.checkJsonRespond(rsp);
        }
        return true;
    }

    public boolean updatePeople(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        JSONObject rsp;
        if (this.checkParam(people)) {
            return false;
        }
        JSONArray peopleArray = this.searchPeopleCommon(vcmReqBaseInfo, people);
        if (CollectionUtils.isEmpty((Collection)peopleArray)) {
            throw new InvokeException("500", DeviceUtil.CU_FACE_NOT_EXIST);
        }
        JSONObject oldPeople = peopleArray.getJSONObject(0);
        JSONObject faceInfo = new JSONObject();
        faceInfo.put("Id", (Object)oldPeople.getIntValue("Id"));
        faceInfo.put("GrpId", (Object)oldPeople.getIntValue("GrpId"));
        faceInfo.put("Sex", (Object)(Integer.parseInt(people.getGender()) + 1));
        faceInfo.put("Age", (Object)people.getAge());
        faceInfo.put("Image", people.getPictures().get(0));
        if (StringUtils.isNotBlank((CharSequence)people.getName())) {
            faceInfo.put("Name", (Object)people.getName());
        } else {
            faceInfo.put("Name", (Object)people.getId());
        }
        faceInfo.put("IdCode", (Object)people.getCredentialNumber());
        faceInfo.put("Job", (Object)people.getOccupation());
        faceInfo.put("Phone", (Object)people.getMobilePhone());
        faceInfo.put("Email", (Object)people.getEmail());
        faceInfo.put("Remark", (Object)people.getId());
        JSONArray faceArray = new JSONArray();
        faceArray.add((Object)faceInfo);
        JSONObject data = new JSONObject();
        data.put("FaceInfo", (Object)faceArray);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.UPDATE_PEOPLE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        }
        catch (SDKException e) {
            LOGGER.error("updateFace happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        this.checkJsonRespond(rsp);
        return true;
    }

    public boolean repositoryUpdatePeopleBatch(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        JSONObject request = new JSONObject();
        JSONObject data = new JSONObject();
        JSONArray faceArray = new JSONArray();
        PeopleRequest peopleRequest = new PeopleRequest();
        people.getPeopleIds().forEach(id -> {
            peopleRequest.setId(id);
            JSONArray peopleArray = this.searchPeopleCommon(vcmReqBaseInfo, peopleRequest);
            if (!CollectionUtils.isEmpty((Collection)peopleArray)) {
                JSONObject faceInfo = new JSONObject();
                faceInfo.put("Id", (Object)peopleArray.getJSONObject(0).getIntValue("Id"));
                faceArray.add((Object)faceInfo);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)faceArray)) {
            data.put("FaceInfo", (Object)faceArray);
            FaceRepositorySearchRespond newGroup = this.search(vcmReqBaseInfo, people.getNewFaceRepositoryInfo());
            if (CollectionUtils.isEmpty((Collection)newGroup.getRepositories())) {
                throw new InvokeException("500", DeviceUtil.CU_FACE_REPOSITORY_NOT_EXIST);
            }
            data.put("Group", (Object)Integer.parseInt(((FaceRepository)newGroup.getRepositories().get(0)).getGroupId()));
            request.put("data", (Object)data);
            JSONObject rsp = null;
            try {
                rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.PEOPLE_GROUP_CHANGE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            }
            catch (SDKException e) {
                LOGGER.error("faceChangeGroup happen exception ", (Throwable)e);
            }
            this.checkJsonRespond(rsp);
            return true;
        }
        return false;
    }

    public FaceInfoSearchRespond faceReportDataSearch(VcmReqBaseInfo vcmReqBaseInfo, FaceInfoRequest request) {
        FaceInfoSearchRespond faceInfoSearchRespond;
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObject dataObject = new JSONObject();
            jsonObject.put("Engine", (Object)0);
            jsonObject.put("Date", (Object)request.getDate());
            ArrayList chn = new ArrayList();
            request.getChannel().stream().forEach(chnnel -> chn.add(Integer.parseInt(chnnel.replaceAll("CH", "")) - 1));
            jsonObject.put("Chn", chn);
            jsonObject.put("StatisticsType", (Object)request.getStatisticsType());
            dataObject.put("data", (Object)jsonObject);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.FACE_REPORT_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)300);
            this.checkJsonRespond(rsp);
            JSONObject dateObject = (JSONObject)rsp.get((Object)"data");
            faceInfoSearchRespond = new FaceInfoSearchRespond();
            if (Objects.nonNull(dateObject)) {
                faceInfoSearchRespond.setResult(dateObject.getInteger("Result").intValue());
                faceInfoSearchRespond.setResultReason(dateObject.getString("ResultReason"));
                faceInfoSearchRespond.setReason(dateObject.getString("reason"));
                List ageInfo = dateObject.containsKey((Object)"AgeGrpInfo") ? (List)dateObject.get((Object)"AgeGrpInfo") : (List)dateObject.get((Object)"AgeInfo");
                ageInfo.add(0);
                faceInfoSearchRespond.setAgeInfo(ageInfo);
                List genderInfo = (List)dateObject.get((Object)"GenderInfo");
                genderInfo.add(0);
                faceInfoSearchRespond.setGenderInfo((List)dateObject.get((Object)"GenderInfo"));
            }
        }
        catch (SDKException e) {
            LOGGER.error("faceReportDataSearch happen exception ", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return faceInfoSearchRespond;
    }

    public FaceInfoSearchRespond machineInfoSearch(VcmReqBaseInfo vcmReqBaseInfo, FaceInfoRequest request) {
        FaceInfoSearchRespond searchRespond;
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("Engine", (Object)request.getEngine());
            jsonObject.put("Date", (Object)request.getDate());
            List channelList = request.getChannel();
            ArrayList chn = new ArrayList();
            channelList.forEach(channel -> {
                String ch = channel.replaceAll("CH", "");
                int i = Integer.parseInt(ch) - 1;
                chn.add(i);
            });
            jsonObject.put("Chn", chn);
            jsonObject.put("StatisticsType", (Object)request.getStatisticsType());
            JSONObject data = new JSONObject();
            data.put("data", (Object)jsonObject);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.MACHINE_INFO_SEARCH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)data, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)300);
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.getJSONObject("data").toJSONString(), FaceInfoSearchRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (FaceInfoSearchRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("machineInfoSearch happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public FaceInfoSearchRespond faceStatisticalInfoSearch(VcmReqBaseInfo vcmReqBaseInfo, FaceInfoRequest request) {
        JSONObject rsp;
        JSONObject dataObject = new JSONObject();
        JSONObject jsonObject = new JSONObject();
        JSONArray arrays = new JSONArray();
        JSONObject nameObject = new JSONObject();
        FaceRepositorySearchRespond faceRepositorySearchRespond = this.searchAll(vcmReqBaseInfo, null);
        List itemList = faceRepositorySearchRespond.getRepositories();
        for (Object item : itemList) {
            arrays.add((Object)item.getGroupId());
            nameObject.put(item.getGroupId(), (Object)item.getName());
        }
        JSONArray dataArray = new JSONArray();
        for (String key : nameObject.keySet()) {
            request.getGroupName().forEach(e -> {
                if (e.equals(nameObject.getString(key))) {
                    dataArray.add((Object)Integer.parseInt(key));
                }
            });
        }
        jsonObject.put("Engine", (Object)0);
        jsonObject.put("StartTime", (Object)request.getStartTime());
        jsonObject.put("EndTime", (Object)request.getEndTime());
        ArrayList chn = new ArrayList();
        request.getChannel().stream().forEach(chnnel -> chn.add(Integer.parseInt(chnnel.replaceAll("CH", "")) - 1));
        jsonObject.put("Chn", chn);
        jsonObject.put("Group", (Object)dataArray);
        dataObject.put("data", (Object)jsonObject);
        try {
            rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.FACE_STATISTICS, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)120);
        }
        catch (SDKException e2) {
            LOGGER.error(" Face search exception ", (Throwable)e2);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e2));
        }
        this.checkJsonRespond(rsp);
        JSONObject ret = (JSONObject)rsp.get((Object)"data");
        int fre = (Integer)ret.get((Object)"Count") / 20000 + 1;
        fre = fre >= 11 ? 10 : fre;
        JSONObject dateObject = new JSONObject();
        JSONObject freObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        int Count = 20000;
        freObject.put("Engine", (Object)0);
        for (int i = 0; i < fre; ++i) {
            JSONObject rs;
            freObject.put("StartIndex", (Object)(i * Count));
            freObject.put("Count", (Object)20000);
            dateObject.put("data", (Object)freObject);
            try {
                rs = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.FACE_STATISTICS_RESULTS, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dateObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)120);
            }
            catch (SDKException e3) {
                LOGGER.error(" Get face search exception ", (Throwable)e3);
                throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e3));
            }
            JSONObject date = (JSONObject)rs.get((Object)"data");
            JSONArray array = date.getJSONArray("Statistics");
            jsonArray.addAll((Collection)array);
            this.checkJsonRespond(rs);
        }
        JSONArray assembleObject = new JSONArray();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+:08:00"));
        Date now = new Date();
        if (Objects.nonNull(nameObject)) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject finalObject = jsonArray.getJSONObject(i);
                now.setTime(finalObject.getLong("Time") * 1000L);
                String sd = sdf.format(now);
                finalObject.put("Time", (Object)sd);
                for (String key : nameObject.keySet()) {
                    if (!key.equals(finalObject.getString("Group"))) continue;
                    finalObject.put("Group", nameObject.get((Object)key));
                }
                assembleObject.add((Object)finalObject);
            }
        }
        JSONObject next = new JSONObject();
        next.put("group", (Object)assembleObject);
        next.put("total", (Object)jsonArray.size());
        Optional operateBean = JsonUtil.convertJsonToBean((String)next.toJSONString(), FaceInfoSearchRespond.class);
        if (!operateBean.isPresent()) {
            throw new InvokeException("500", "cu_device_not_return");
        }
        FaceInfoSearchRespond faceInfoSearchRespond = (FaceInfoSearchRespond)operateBean.get();
        return faceInfoSearchRespond;
    }

    public PeopleSearchRespond searchPeople(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        PeopleSearchRespond peopleSearchRespond = new PeopleSearchRespond();
        JSONArray peopleArray = this.searchPeopleCommon(vcmReqBaseInfo, people);
        if (!CollectionUtils.isEmpty((Collection)peopleArray)) {
            peopleArray.forEach(obj -> {
                People peo = new People();
                peo.setId(((JSONObject)obj).getString("Remark"));
                peo.setCountry(((JSONObject)obj).getString("Country"));
                peo.setCredentialNumber(((JSONObject)obj).getString("IdCode"));
                peo.setGender(String.valueOf(((JSONObject)obj).getIntValue("Sex") - 1));
                peo.setName(((JSONObject)obj).getString("Name"));
                peo.setAge(((JSONObject)obj).getIntValue("Age"));
                peo.setNationality(((JSONObject)obj).getString("Nation"));
                peo.setOccupation(((JSONObject)obj).getString("Job"));
                peopleSearchRespond.getPeopleList().add(peo);
            });
            peopleSearchRespond.setTotal(String.valueOf(peopleSearchRespond.getPeopleList().size()));
        }
        return peopleSearchRespond;
    }

    public JSONArray searchPeopleCommon(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        try {
            JSONObject data = new JSONObject();
            JSONObject faceInfo = new JSONObject();
            if (!StringUtils.isEmpty((CharSequence)people.getId())) {
                faceInfo.put("Remark", (Object)people.getId());
            }
            if (people.getFaceRepositoryInfo() != null) {
                FaceRepositorySearchRespond res = this.search(vcmReqBaseInfo, people.getFaceRepositoryInfo());
                if (CollectionUtils.isEmpty((Collection)res.getRepositories())) {
                    throw new InvokeException("500", DeviceUtil.CU_FACE_REPOSITORY_NOT_EXIST);
                }
                faceInfo.put("GrpId", (Object)Integer.parseInt(((FaceRepository)res.getRepositories().get(0)).getGroupId()));
            }
            JSONArray faceArray = new JSONArray();
            faceArray.add((Object)faceInfo);
            data.put("FaceInfo", (Object)faceArray);
            JSONObject request = new JSONObject();
            request.put("data", (Object)data);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.SEARCH_PEOPLE_COUNT_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            if (rsp.getJSONObject("data").getIntValue("Count") > 0) {
                JSONObject data1 = new JSONObject();
                if (people.getPage() == null) {
                    Page page = new Page();
                    page.setSize("1000");
                    page.setNo("1");
                    people.setPage(page);
                }
                if ("0".equals(people.getPage().getNo())) {
                    people.getPage().setNo("1");
                }
                data1.put("StartIndex", (Object)(Integer.parseInt(people.getPage().getSize()) * (Integer.parseInt(people.getPage().getNo()) - 1)));
                data1.put("Count", (Object)Integer.parseInt(people.getPage().getSize()));
                JSONObject req = new JSONObject();
                req.put("data", (Object)data1);
                JSONObject rsp1 = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.SEARCH_PEOPLE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)req, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
                this.checkJsonRespond(rsp1);
                if (rsp1.getJSONObject("data").getJSONArray("FaceInfo").size() > 0) {
                    return rsp1.getJSONObject("data").getJSONArray("FaceInfo");
                }
            }
        }
        catch (SDKException e) {
            LOGGER.error("searchPeople happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return new JSONArray();
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    public boolean checkParam(PeopleRequest people) {
        return StringUtils.isEmpty((CharSequence)people.getId()) || people.getFaceRepositoryInfo() == null;
    }
}

