/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.SnapshotRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.EventRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.SnapshotRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BehaviorBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.DetectObjectBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.FaceBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.GeneralBusinessBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.MetaEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.NonVehicleBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.PersonBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.SituationAnalysisBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.ThirdAlgorithmBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.VehicleBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.EventRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmCodeTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmLevelEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.MetaTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.SnapshotNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.EventNameHelper;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.ReflectionUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventGetThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventGetThread.class);
    private final String domainCode;
    private Integer readerId;
    private Integer sequence;
    private Integer lapNumber;
    private final WebSocketService webSocketService;
    private final SubscriptionHelp subscriptionHelp;
    private final SnapshotNvr800ServiceImpl snapshotNvr800Service;

    public EventGetThread(String domainCode, String ip) {
        super("NVR800-" + ip + "-eventThread");
        this.domainCode = domainCode;
        this.webSocketService = (WebSocketService)SpringContextUtil.getBean((String)"webSocketService");
        this.subscriptionHelp = (SubscriptionHelp)SpringContextUtil.getBean((String)"subscriptionHelp");
        this.snapshotNvr800Service = (SnapshotNvr800ServiceImpl)SpringContextUtil.getBean((String)"snapshotNvr800Service");
    }

    @Override
    public void run() {
        while (this.subscriptionHelp.get(this.domainCode) != null) {
            boolean getFail = false;
            EventRequestNvr800 requestNvr800 = new EventRequestNvr800();
            requestNvr800.setReaderId(this.readerId);
            requestNvr800.setSequence(this.sequence);
            requestNvr800.setLapNumber(this.lapNumber);
            VcmReqBaseInfo vcmReqBaseInfo = this.subscriptionHelp.get(this.domainCode);
            EventRespondNvr800 eventRespondNvr800 = null;
            try {
                eventRespondNvr800 = (EventRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.EVENT_CHECK_URI, (ObjectToMsgConvertor)new ObjectToJSONMsgConvertor((Object)requestNvr800), (MsgToObjectConvertor)new JSONMsgToObjectConvertor(EventRespondNvr800.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)10);
            }
            catch (Exception e) {
                LOGGER.error("NVR800 get event fail,IP:" + vcmReqBaseInfo.getVcmIp() + "params" + JSONObject.toJSON((Object)requestNvr800), (Throwable)e);
                this.readerId = null;
                this.sequence = null;
                this.lapNumber = null;
                getFail = true;
            }
            if (getFail) continue;
            if (eventRespondNvr800 != null) {
                this.readerId = eventRespondNvr800.getReaderId();
                this.sequence = eventRespondNvr800.getSequence();
                this.lapNumber = eventRespondNvr800.getLapNumber();
            }
            if (eventRespondNvr800 == null || eventRespondNvr800.getData() == null) continue;
            try {
                this.dealData(eventRespondNvr800.getData(), vcmReqBaseInfo);
            }
            catch (Exception e) {
                LOGGER.error("deal data error", (Throwable)e);
            }
        }
        this.subscriptionHelp.remove(this.domainCode);
        LOGGER.info("Event check exit,domainCode:{}", (Object)this.domainCode);
    }

    private void dealData(JSONObject data, VcmReqBaseInfo vcmReqBaseInfo) {
        if (!data.containsKey((Object)"alarm_list")) {
            return;
        }
        JSONArray alarmListJson = data.getJSONArray("alarm_list");
        for (int i = 0; i < alarmListJson.size(); ++i) {
            JSONObject alarmJson = alarmListJson.getJSONObject(i);
            if (alarmJson.containsKey((Object)"face_alarm")) {
                this.dealFaceAlarm(alarmJson, vcmReqBaseInfo);
                continue;
            }
            if (alarmJson.containsKey((Object)"channel_alarm")) {
                this.dealChannelAlarm(alarmJson, vcmReqBaseInfo);
                continue;
            }
            if (alarmJson.containsKey((Object)"realtime_data_report")) {
                this.dealRealtimeData(alarmJson, vcmReqBaseInfo);
                continue;
            }
            if (alarmJson.containsKey((Object)"behavior_meta_img_report")) {
                this.dealMetaData(alarmJson, vcmReqBaseInfo);
                continue;
            }
            if (!alarmJson.containsKey((Object)"object_alarm")) continue;
            this.dealObjectAlarm(alarmJson, vcmReqBaseInfo);
        }
    }

    private void dealObjectAlarm(JSONObject alarmObject, VcmReqBaseInfo vcmReqBaseInfo) {
        String time = this.getTime(alarmObject.getString("time"));
        for (int i = 0; i < alarmObject.getJSONArray("object_alarm").size(); ++i) {
            JSONArray alarmArray = alarmObject.getJSONArray("object_alarm");
            for (int j = 0; j < alarmArray.size(); ++j) {
                MetaEventRespond metaEventRespond;
                DetectObjectBean detectObject;
                ArrayList<DetectObjectBean> vehicleDetectObject;
                VehicleBean vehicleBean;
                JSONObject alarmJson = alarmArray.getJSONObject(i);
                String channelCode = "CH" + alarmJson.getString("SnapChn");
                AlarmEventRespond alarmEventRespond = this.alarmCommon(alarmJson, time, vcmReqBaseInfo.getParentDeviceId());
                alarmEventRespond.setChannelCode(channelCode);
                alarmEventRespond.setStatus(0);
                alarmEventRespond.setDomainCode(this.domainCode);
                if ("Vehicle".equalsIgnoreCase(alarmJson.getString("ObjectType"))) {
                    vehicleBean = new VehicleBean();
                    vehicleBean.setLeftTopX(alarmJson.getJSONObject("CarRect").getIntValue("X"));
                    vehicleBean.setLeftTopY(alarmJson.getJSONObject("CarRect").getIntValue("Y"));
                    vehicleBean.setRightBtmX(vehicleBean.getLeftTopX() + alarmJson.getJSONObject("CarRect").getIntValue("Width"));
                    vehicleBean.setRightBtmY(vehicleBean.getLeftTopY() + alarmJson.getJSONObject("CarRect").getIntValue("Height"));
                    vehicleDetectObject = new ArrayList<DetectObjectBean>();
                    detectObject = ReflectionUtils.getDetectObject((Object)vehicleBean);
                    vehicleDetectObject.add(detectObject);
                    vehicleBean.setDetectObject(vehicleDetectObject);
                    vehicleBean.setPlateNo(alarmJson.getString("LicensePlate"));
                    vehicleBean.setPanorama(alarmJson.getString("SnapBgImg"));
                    vehicleBean.setSnapshot(alarmJson.getString("SnapObjectImg"));
                    vehicleBean.setPlateNo(alarmJson.getString("LicensePlate"));
                    vehicleBean.setVehicleClass(alarmJson.getString("CarType"));
                    vehicleBean.setVehicleModel(alarmJson.getString("CarSubBrandId"));
                    vehicleBean.setVehicleBrand(alarmJson.getString("CarPreBrandId"));
                    vehicleBean.setPlateColor(alarmJson.getString("PlateColor"));
                    vehicleBean.setPlateClass(alarmJson.getString("PlateType"));
                    vehicleBean.setVehicleColor(Nvr800Utils.vehicleColorConvertToIvs1800((String)alarmJson.getString("CarColor")));
                    vehicleBean.setVehicleStyles(alarmJson.getString("CarYearBrand"));
                    alarmEventRespond.setCode("ALARM_VEHICLE_DETECTION");
                    alarmEventRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_VEHICLE.toString());
                    alarmEventRespond.setVehicleBean(vehicleBean);
                    metaEventRespond = new MetaEventRespond();
                    metaEventRespond.setType(EventTypeEnum.META_DATA);
                    metaEventRespond.setMetaType(MetaTypeEnum.MOTOR_VEHICLE);
                    metaEventRespond.setDomainCode(this.domainCode);
                    metaEventRespond.setChannelCode(channelCode);
                    metaEventRespond.setVehicleBean(vehicleBean);
                    metaEventRespond.setTime(time);
                    metaEventRespond.setMsgId(UUID.randomUUID().toString());
                    this.webSocketService.send((BaseEventRespond)metaEventRespond);
                } else if ("HumanBody".equalsIgnoreCase(alarmJson.getString("ObjectType"))) {
                    FaceBean faceBean = new FaceBean();
                    faceBean.setPanorama(alarmJson.getString("SnapBgImg"));
                    faceBean.setSnapshot(alarmJson.getString("SnapObjectImg"));
                    faceBean.setLeftTopX(alarmJson.getJSONObject("HumanBgRect").getIntValue("X"));
                    faceBean.setLeftTopY(alarmJson.getJSONObject("HumanBgRect").getIntValue("Y"));
                    faceBean.setRightBtmX(faceBean.getLeftTopX() + alarmJson.getJSONObject("HumanBgRect").getIntValue("Width"));
                    faceBean.setRightBtmY(faceBean.getLeftTopY() + alarmJson.getJSONObject("HumanBgRect").getIntValue("Height"));
                    ArrayList<DetectObjectBean> faceDetectObject = new ArrayList<DetectObjectBean>();
                    detectObject = ReflectionUtils.getDetectObject((Object)faceBean);
                    faceDetectObject.add(detectObject);
                    faceBean.setDetectObject(faceDetectObject);
                    alarmEventRespond.setFaceBean(faceBean);
                    alarmEventRespond.setCode("ALARM_PERSON");
                    alarmEventRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_FACE.toString());
                    metaEventRespond = new MetaEventRespond();
                    metaEventRespond.setType(EventTypeEnum.META_DATA);
                    metaEventRespond.setMetaType(MetaTypeEnum.PERSON);
                    metaEventRespond.setDomainCode(this.domainCode);
                    metaEventRespond.setChannelCode(channelCode);
                    PersonBean personBean = new PersonBean();
                    personBean.setPanorama(faceBean.getPanorama());
                    personBean.setSnapshot(faceBean.getSnapshot());
                    personBean.setLeftTopX(faceBean.getLeftTopX());
                    personBean.setLeftTopY(faceBean.getLeftTopY());
                    personBean.setRightBtmX(faceBean.getRightBtmX());
                    personBean.setRightBtmY(faceBean.getRightBtmY());
                    personBean.setDetectObject(faceDetectObject);
                    personBean.setGenderCode(faceBean.getGenderCode());
                    metaEventRespond.setMetaType(MetaTypeEnum.PERSON);
                    metaEventRespond.setTime(time);
                    metaEventRespond.setMsgId(UUID.randomUUID().toString());
                    metaEventRespond.setPersonBean(personBean);
                    this.webSocketService.send((BaseEventRespond)metaEventRespond);
                } else if ("NoneVehicle".equalsIgnoreCase(alarmJson.getString("ObjectType"))) {
                    vehicleBean = new VehicleBean();
                    vehicleBean.setLeftTopX(alarmJson.getJSONObject("NonVehicleBgRect").getIntValue("X"));
                    vehicleBean.setLeftTopY(alarmJson.getJSONObject("NonVehicleBgRect").getIntValue("Y"));
                    vehicleBean.setRightBtmX(vehicleBean.getLeftTopX() + alarmJson.getJSONObject("NonVehicleBgRect").getIntValue("Width"));
                    vehicleBean.setRightBtmY(vehicleBean.getLeftTopY() + alarmJson.getJSONObject("NonVehicleBgRect").getIntValue("Height"));
                    vehicleDetectObject = new ArrayList();
                    detectObject = ReflectionUtils.getDetectObject((Object)vehicleBean);
                    vehicleDetectObject.add(detectObject);
                    vehicleBean.setDetectObject(vehicleDetectObject);
                    vehicleBean.setPlateNo(alarmJson.getString("LicensePlate"));
                    vehicleBean.setPanorama(alarmJson.getString("SnapBgImg"));
                    vehicleBean.setSnapshot(alarmJson.getString("SnapObjectImg"));
                    vehicleBean.setPlateNo("");
                    alarmEventRespond.setCode("ALARM_NON_VEHICLE_DETECTION");
                    alarmEventRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_VEHICLE.toString());
                    alarmEventRespond.setVehicleBean(vehicleBean);
                    NonVehicleBean nonVehicleBean = new NonVehicleBean();
                    nonVehicleBean.setLeftTopX(vehicleBean.getLeftTopX());
                    nonVehicleBean.setLeftTopY(vehicleBean.getLeftTopY());
                    nonVehicleBean.setRightBtmX(vehicleBean.getRightBtmX());
                    nonVehicleBean.setRightBtmY(vehicleBean.getRightBtmY());
                    nonVehicleBean.setDetectObject(vehicleDetectObject);
                    nonVehicleBean.setPlateNo(vehicleBean.getPlateNo());
                    nonVehicleBean.setPanorama(vehicleBean.getPanorama());
                    nonVehicleBean.setSnapshot(vehicleBean.getSnapshot());
                    MetaEventRespond metaEventRespond2 = new MetaEventRespond();
                    metaEventRespond2.setType(EventTypeEnum.META_DATA);
                    metaEventRespond2.setMetaType(MetaTypeEnum.NON_MOTOR_VEHICLE);
                    metaEventRespond2.setDomainCode(this.domainCode);
                    metaEventRespond2.setChannelCode(channelCode);
                    metaEventRespond2.setNonVehicleBean(nonVehicleBean);
                    metaEventRespond2.setTime(time);
                    metaEventRespond2.setMsgId(UUID.randomUUID().toString());
                    this.webSocketService.send((BaseEventRespond)metaEventRespond2);
                }
                alarmEventRespond.setFilterName(alarmEventRespond.getCode());
                this.webSocketService.send((BaseEventRespond)alarmEventRespond);
            }
        }
    }

    private void dealMetaData(JSONObject metaObject, VcmReqBaseInfo vcmReqBaseInfo) {
        String time = this.getTime(metaObject.getString("time"));
        for (int i = 0; i < metaObject.getJSONArray("behavior_meta_img_report").size(); ++i) {
            JSONObject alarmJson = metaObject.getJSONArray("behavior_meta_img_report").getJSONObject(i);
            String channelCode = alarmJson.getString("channel");
            AlarmEventRespond alarmEventRespond = this.alarmCommon(alarmJson, time, vcmReqBaseInfo.getParentDeviceId());
            alarmEventRespond.setChannelCode(channelCode);
            alarmEventRespond.setStatus(0);
            alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
            alarmEventRespond.setCode(Nvr800Utils.getSingleAlarmCode((Integer)alarmJson.getInteger("pic_type")));
            alarmEventRespond.setName(EventNameHelper.getEventName((String)alarmEventRespond.getCode()));
            alarmEventRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)alarmEventRespond.getCode()));
            alarmEventRespond.setFilterName(alarmEventRespond.getCode());
            String panorama = alarmJson.getString("behavior_meta_img");
            if (AlarmCodeTypeEnum.ALARM_THIRD_ALGORITHM.toString().equals(alarmEventRespond.getAlarmCodeType())) {
                ThirdAlgorithmBean thirdAlgorithmBean = new ThirdAlgorithmBean();
                thirdAlgorithmBean.setSnapshot(panorama);
                thirdAlgorithmBean.setPanorama(panorama);
                alarmEventRespond.setThirdAlgorithmBean(thirdAlgorithmBean);
                alarmEventRespond.setCode("unknown");
            } else if (AlarmCodeTypeEnum.ALARM_BEHAVIOR.toString().equals(alarmEventRespond.getAlarmCodeType())) {
                BehaviorBean behaviorBean = new BehaviorBean();
                behaviorBean.setSnapshot(panorama);
                behaviorBean.setPanorama(panorama);
                alarmEventRespond.setBehaviorBean(behaviorBean);
            } else {
                GeneralBusinessBean generalBusinessBean = new GeneralBusinessBean();
                generalBusinessBean.setPanorama(panorama);
                generalBusinessBean.setSnapshot(panorama);
                alarmEventRespond.setGeneralBusinessBean(generalBusinessBean);
            }
            this.webSocketService.send((BaseEventRespond)alarmEventRespond);
        }
    }

    private void dealRealtimeData(JSONObject realtimeDataJson, VcmReqBaseInfo vcmReqBaseInfo) {
        String time = this.getTime(realtimeDataJson.getString("time"));
        for (int i = 0; i < realtimeDataJson.getJSONArray("realtime_data_report").size(); ++i) {
            JSONObject alarmJson = realtimeDataJson.getJSONArray("realtime_data_report").getJSONObject(i);
            String channelCode = alarmJson.getString("channel");
            AlarmEventRespond alarmEventRespond = this.alarmCommon(alarmJson, time, vcmReqBaseInfo.getParentDeviceId());
            alarmEventRespond.setType(EventTypeEnum.REALTIME_DATA);
            alarmEventRespond.setMetaType(MetaTypeEnum.NONE);
            alarmEventRespond.setChannelCode(channelCode);
            String type = alarmJson.getString("realtime_data_type");
            alarmEventRespond.setCode(Nvr800Utils.getAiCode((String)type));
            alarmEventRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)alarmEventRespond.getCode()));
            alarmEventRespond.setFilterName(alarmEventRespond.getCode());
            SituationAnalysisBean situationAnalysisBean = new SituationAnalysisBean();
            if (Nvr800Utils.isSnapshot((String)type)) {
                situationAnalysisBean.setPanorama(this.snapShot(channelCode));
                situationAnalysisBean.setSnapshot(situationAnalysisBean.getPanorama());
            }
            alarmEventRespond.setName(EventNameHelper.getEventName((String)alarmEventRespond.getCode()));
            situationAnalysisBean.setNowInCount(alarmJson.getIntValue("now_in_count"));
            situationAnalysisBean.setNowOutCount(alarmJson.getIntValue("now_out_count"));
            situationAnalysisBean.setTotalInCount(alarmJson.getIntValue("total_in_count"));
            situationAnalysisBean.setTotalOutCount(alarmJson.getIntValue("total_out_count"));
            situationAnalysisBean.setPeopleCount(alarmJson.getIntValue("people_count"));
            alarmEventRespond.setSituationAnalysisBean(situationAnalysisBean);
            alarmEventRespond.setStatus(0);
            alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
            this.webSocketService.send((BaseEventRespond)alarmEventRespond);
        }
    }

    public AlarmEventRespond alarmCommon(JSONObject notificationObject, String time, String parentDeviceId) {
        AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
        alarmEventRespond.setType(EventTypeEnum.ALARM);
        alarmEventRespond.setTime(time);
        alarmEventRespond.setDomainCode(this.domainCode);
        alarmEventRespond.setId(UUID.randomUUID().toString());
        alarmEventRespond.setStatus(1);
        alarmEventRespond.setMetaType(MetaTypeEnum.NONE);
        alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
        alarmEventRespond.setParentDeviceId(parentDeviceId);
        return alarmEventRespond;
    }

    private void dealFaceAlarm(JSONObject faceAlarmJson, VcmReqBaseInfo vcmReqBaseInfo) {
        String time = this.getTime(faceAlarmJson.getString("time"));
        for (int i = 0; i < faceAlarmJson.getJSONArray("face_alarm").size(); ++i) {
            String[] typeArray;
            String alarmType;
            JSONObject alarmJson = faceAlarmJson.getJSONArray("face_alarm").getJSONObject(i);
            int channel = alarmJson.getIntValue("SnapChn");
            String channelCode = "CH" + channel;
            FaceBean faceBean = new FaceBean();
            faceBean.setGenderCode(StringUtils.isNotBlank((CharSequence)alarmJson.getString("Gender")) ? alarmJson.getString("Gender") : "0");
            faceBean.setAge(alarmJson.getIntValue("SnapAge"));
            if (alarmJson.containsKey((Object)"SnapAgeGrp")) {
                faceBean.setAgeGroup(alarmJson.getIntValue("SnapAgeGrp"));
            } else {
                faceBean.setAgeGroup(this.getAgeRange(alarmJson.getIntValue("SnapAge")));
            }
            faceBean.setExpression(String.valueOf(alarmJson.getIntValue("Expression")));
            faceBean.setHair(this.getHair(alarmJson.getIntValue("Hair")));
            faceBean.setHat(this.getHat(alarmJson.getIntValue("Hat")));
            faceBean.setGlassType(this.getGlassInfo(alarmJson.getIntValue("GlassType")));
            faceBean.setMouthMask(Nvr800Utils.getMouthMaskType((int)alarmJson.getIntValue("MouthMask")));
            faceBean.setMustache(this.getMustache(alarmJson.getIntValue("Mustache")));
            faceBean.setSnapshot(alarmJson.getString("SnapFaceImg"));
            faceBean.setPanorama(alarmJson.getString("SnapBgImg"));
            faceBean.setSnapId(alarmJson.getInteger("SnapId"));
            if (alarmJson.containsKey((Object)"FaceRect")) {
                faceBean.setLeftTopX(alarmJson.getJSONObject("FaceRect").getIntValue("X"));
                faceBean.setLeftTopY(alarmJson.getJSONObject("FaceRect").getIntValue("Y"));
                faceBean.setRightBtmX(faceBean.getLeftTopX() + alarmJson.getJSONObject("FaceRect").getIntValue("Width"));
                faceBean.setRightBtmY(faceBean.getLeftTopY() + alarmJson.getJSONObject("FaceRect").getIntValue("Height"));
                ArrayList<DetectObjectBean> faceDetectObject = new ArrayList<DetectObjectBean>();
                DetectObjectBean detectObject = ReflectionUtils.getDetectObject((Object)faceBean);
                faceDetectObject.add(detectObject);
                faceBean.setDetectObject(faceDetectObject);
            }
            faceBean.setAppearCount(alarmJson.getString("AppearCnt"));
            if (alarmJson.getBooleanValue("OverMaxCount")) {
                faceBean.setAppearCount(alarmJson.getString("AppearCnt") + "+");
            }
            MetaEventRespond metaEventRespond = new MetaEventRespond();
            metaEventRespond.setType(EventTypeEnum.META_DATA);
            metaEventRespond.setTime(time);
            metaEventRespond.setDomainCode(this.domainCode);
            metaEventRespond.setParentDeviceId(vcmReqBaseInfo.getParentDeviceId());
            metaEventRespond.setChannelCode(channelCode);
            metaEventRespond.setMetaType(MetaTypeEnum.FACE);
            metaEventRespond.setFaceBean(faceBean);
            this.webSocketService.send((BaseEventRespond)metaEventRespond);
            AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
            alarmEventRespond.setType(EventTypeEnum.ALARM);
            alarmEventRespond.setTime(time);
            alarmEventRespond.setDomainCode(this.domainCode);
            alarmEventRespond.setParentDeviceId(vcmReqBaseInfo.getParentDeviceId());
            alarmEventRespond.setChannelCode(channelCode);
            alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
            alarmEventRespond.setMetaType(MetaTypeEnum.FACE);
            alarmEventRespond.setStatus(0);
            alarmEventRespond.setFaceBean(faceBean);
            alarmEventRespond.setParentDeviceId(vcmReqBaseInfo.getParentDeviceId());
            if (alarmJson.getBoolean("GrpEnableAlarm").booleanValue()) {
                faceBean.setTargetName(alarmJson.getString("Name"));
                faceBean.setTargetId(alarmJson.getString("Remark"));
                faceBean.setTargetCredentialNumber(alarmJson.getString("IdCode"));
                faceBean.setGroupName(alarmJson.getString("GrpName"));
                faceBean.setGroupType(this.getGroupType(alarmJson.getIntValue("Policy")));
                faceBean.setSimilarityDegree(alarmJson.getDoubleValue("Similarity"));
                faceBean.setMatchedImage(alarmJson.getString("MatchedImage"));
                if ("-1".equals(alarmJson.getString("Id"))) {
                    faceBean.setAlarmMatch(2);
                    alarmEventRespond.setCode("ALARM_FACE_DETECTION");
                } else {
                    alarmEventRespond.setCode(Ivs1800Utils.getEventCode((String)faceBean.getGroupType()));
                    faceBean.setAlarmMatch(1);
                }
                if (StringUtils.isEmpty((CharSequence)faceBean.getSnapshot())) {
                    faceBean.setSnapshot(this.snapShot(channelCode));
                }
                alarmEventRespond.setFilterName(alarmEventRespond.getCode());
                alarmEventRespond.setName(EventNameHelper.getEventName((String)alarmEventRespond.getCode()));
                alarmEventRespond.setId(UUID.randomUUID().toString());
                alarmEventRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)alarmEventRespond.getCode()));
                this.webSocketService.send((BaseEventRespond)alarmEventRespond);
            }
            if (!StringUtils.isNotBlank((CharSequence)(alarmType = Nvr800Utils.getAlarmTypeByAlarmFlags((Integer)alarmJson.getInteger("AlarmFlags"))))) continue;
            for (String code : typeArray = alarmType.split(",")) {
                if ("REPEAT_VISITOR".equalsIgnoreCase(code)) {
                    faceBean.setAppearCount(alarmJson.getString("AppearCnt"));
                    if (alarmJson.getBooleanValue("OverMaxCount")) {
                        faceBean.setAppearCount(alarmJson.getString("AppearCnt") + "+");
                    }
                    alarmEventRespond.setFaceBean(faceBean);
                }
                alarmEventRespond.setId(UUID.randomUUID().toString());
                alarmEventRespond.setCode(code);
                alarmEventRespond.setFilterName(alarmEventRespond.getCode());
                alarmEventRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)alarmEventRespond.getCode()));
                this.webSocketService.send((BaseEventRespond)alarmEventRespond);
            }
        }
    }

    private int getAgeRange(int snapAge) {
        int ageRange = 0;
        if (snapAge >= 50) {
            ageRange = 5;
        } else if (snapAge >= 30) {
            ageRange = 4;
        } else if (snapAge >= 18) {
            ageRange = 3;
        } else if (snapAge >= 12) {
            ageRange = 2;
        } else if (snapAge >= 1) {
            ageRange = 1;
        }
        return ageRange;
    }

    private String getGroupType(int type) {
        if (type == 0) {
            return "3";
        }
        if (type == 1) {
            return "2";
        }
        return "";
    }

    private String getMustache(int mustache) {
        if (mustache == 1) {
            return "100";
        }
        if (mustache == -1) {
            return "-1";
        }
        if (mustache == 0) {
            return "0";
        }
        return "99";
    }

    private String getGlassType(int glassType) {
        if (glassType == -1) {
            return "-1";
        }
        if (glassType == 1) {
            return "100";
        }
        if (glassType == 2) {
            return "101";
        }
        if (glassType == 3) {
            return "7";
        }
        if (glassType == 0) {
            return "0";
        }
        return "99";
    }

    private String getGlassInfo(int glassType) {
        if (glassType == -1) {
            return "-1";
        }
        if (glassType == 0) {
            return "0";
        }
        if (glassType == 1) {
            return "2";
        }
        return "1";
    }

    private String getHat(int hat) {
        if (hat == -1) {
            return "-1";
        }
        if (hat == 1) {
            return "100";
        }
        if (hat == 0) {
            return "0";
        }
        return "99";
    }

    private String getHair(int hair) {
        if (hair == -1) {
            return "-1";
        }
        if (hair == 1) {
            return "101";
        }
        if (hair == 2) {
            return "102";
        }
        if (hair == 0) {
            return "0";
        }
        return "99";
    }

    private String getTime(String strTime) {
        SimpleDateFormat sdfCuserver = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            SimpleDateFormat sdfNvr800 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Date date = sdfNvr800.parse(strTime);
            return sdfCuserver.format(date);
        }
        catch (Exception e) {
            LOGGER.error("Can not deal time {}.", (Object)strTime);
            return sdfCuserver.format(new Date());
        }
    }

    private void dealChannelAlarm(JSONObject channelAlarmJson, VcmReqBaseInfo vcmReqBaseInfo) {
        String time = this.getTime(channelAlarmJson.getString("time"));
        for (int i = 0; i < channelAlarmJson.getJSONArray("channel_alarm").size(); ++i) {
            JSONObject channelJson = channelAlarmJson.getJSONArray("channel_alarm").getJSONObject(i);
            if (channelJson.containsKey((Object)"int_alarm")) {
                this.dealIntAlarm(time, channelJson, vcmReqBaseInfo);
            }
            if (channelJson.containsKey((Object)"camera_connect_status")) {
                this.dealCameraConnectStatus(time, channelJson, vcmReqBaseInfo);
            }
            if (channelJson.containsKey((Object)"motion_alarm") && channelJson.getBoolean("motion_alarm").booleanValue()) {
                this.dealMotionAlarm(time, channelJson, vcmReqBaseInfo);
            }
            if (!channelJson.containsKey((Object)"io_alarm") || !channelJson.getBoolean("io_alarm").booleanValue()) continue;
            this.dealIoEventAlarm(time, channelJson, vcmReqBaseInfo);
        }
    }

    private void dealIoEventAlarm(String time, JSONObject channelJson, VcmReqBaseInfo vcmReqBaseInfo) {
        AlarmEventRespond alarmEventRespond = this.generalBusinessCommon(time, channelJson, "ALARM_TYPE_DI", vcmReqBaseInfo.getParentDeviceId());
        alarmEventRespond.setName("\u5f00\u5173\u91cf\u8f93\u51fa");
        alarmEventRespond.setAlarmSourceSecType(1);
        alarmEventRespond.setAlarmInName(channelJson.getString("io_alarm_name"));
        this.webSocketService.send((BaseEventRespond)alarmEventRespond);
    }

    private void dealMotionAlarm(String time, JSONObject channelJson, VcmReqBaseInfo vcmReqBaseInfo) {
        AlarmEventRespond alarmEventRespond = this.generalBusinessCommon(time, channelJson, "ALARM_TYPE_MOVE_DECTION", vcmReqBaseInfo.getParentDeviceId());
        alarmEventRespond.setName("\u79fb\u52a8\u4fa6\u6d4b\u544a\u8b66");
        this.webSocketService.send((BaseEventRespond)alarmEventRespond);
    }

    private AlarmEventRespond generalBusinessCommon(String time, JSONObject channelJson, String alarmCode, String parentDeviceId) {
        AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
        alarmEventRespond.setType(EventTypeEnum.ALARM);
        alarmEventRespond.setTime(time);
        alarmEventRespond.setDomainCode(this.domainCode);
        alarmEventRespond.setParentDeviceId(parentDeviceId);
        alarmEventRespond.setMetaType(MetaTypeEnum.NONE);
        alarmEventRespond.setStatus(0);
        alarmEventRespond.setChannelCode(channelJson.getString("channel"));
        GeneralBusinessBean generalBusinessBean = new GeneralBusinessBean();
        String panorama = channelJson.getString("SnapBgImg");
        if (StringUtils.isEmpty((CharSequence)panorama)) {
            panorama = this.snapShot(channelJson.getString("channel"));
        }
        generalBusinessBean.setPanorama(panorama);
        generalBusinessBean.setSnapshot(panorama);
        alarmEventRespond.setGeneralBusinessBean(generalBusinessBean);
        alarmEventRespond.setId(UUID.randomUUID().toString());
        alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
        alarmEventRespond.setCode(alarmCode);
        alarmEventRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)alarmEventRespond.getCode()));
        alarmEventRespond.setFilterName(alarmEventRespond.getCode());
        return alarmEventRespond;
    }

    private void dealCameraConnectStatus(String time, JSONObject channelJson, VcmReqBaseInfo vcmReqBaseInfo) {
        String channelCode = channelJson.getString("channel");
        JSONObject cameraInfo = channelJson.getJSONObject("camera_connect_status");
        String connectStatu = cameraInfo.getString("connect_status");
        if (!"Offline".equals(connectStatu)) {
            return;
        }
        AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
        alarmEventRespond.setType(EventTypeEnum.ALARM);
        alarmEventRespond.setTime(time);
        alarmEventRespond.setDomainCode(this.domainCode);
        alarmEventRespond.setMetaType(MetaTypeEnum.NONE);
        alarmEventRespond.setStatus(1);
        alarmEventRespond.setChannelCode(channelCode);
        alarmEventRespond.setCode("ALARM_IPC_OFFLINE");
        alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
        alarmEventRespond.setId(UUID.randomUUID().toString());
        alarmEventRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)alarmEventRespond.getCode()));
        alarmEventRespond.setFilterName(alarmEventRespond.getCode());
        alarmEventRespond.setParentDeviceId(vcmReqBaseInfo.getParentDeviceId());
        this.webSocketService.send((BaseEventRespond)alarmEventRespond);
    }

    private void dealIntAlarm(String time, JSONObject channelJson, VcmReqBaseInfo vcmReqBaseInfo) {
        String channelCode = channelJson.getString("channel");
        JSONObject intAlarm = channelJson.getJSONObject("int_alarm");
        if (!intAlarm.getBoolean("alarm_val").booleanValue()) {
            return;
        }
        String type = intAlarm.getString("int_subtype");
        AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
        alarmEventRespond.setType(EventTypeEnum.ALARM);
        alarmEventRespond.setTime(time);
        alarmEventRespond.setDomainCode(this.domainCode);
        alarmEventRespond.setParentDeviceId(vcmReqBaseInfo.getParentDeviceId());
        alarmEventRespond.setMetaType(MetaTypeEnum.NONE);
        alarmEventRespond.setStatus(0);
        alarmEventRespond.setCode(Nvr800Utils.getAiCode((String)type));
        alarmEventRespond.setFilterName(alarmEventRespond.getCode());
        String panorama = channelJson.getString("SnapBgImg");
        if (StringUtils.isEmpty((CharSequence)panorama)) {
            panorama = this.snapShot(channelCode);
        }
        alarmEventRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)alarmEventRespond.getCode()));
        if (Nvr800Utils.isBehavior((String)alarmEventRespond.getCode())) {
            alarmEventRespond.setMetaType(MetaTypeEnum.BEHAVIOR);
            BehaviorBean behaviorBean = new BehaviorBean();
            behaviorBean.setPanorama(panorama);
            behaviorBean.setSnapshot(panorama);
            alarmEventRespond.setBehaviorBean(behaviorBean);
            if ("ALARM_LIFT_ELE_BICYCLE".equals(alarmEventRespond.getCode())) {
                alarmEventRespond.setEleObjId(intAlarm.getString("EleObjId"));
            }
        } else if (AlarmCodeTypeEnum.ALARM_THIRD_ALGORITHM.toString().equals(alarmEventRespond.getAlarmCodeType())) {
            ThirdAlgorithmBean thirdAlgorithmBean = new ThirdAlgorithmBean();
            thirdAlgorithmBean.setThirdAlgorithmName(channelJson.getJSONObject("int_alarm").getString("alog_name"));
            thirdAlgorithmBean.setSnapshot(panorama);
            thirdAlgorithmBean.setPanorama(panorama);
            alarmEventRespond.setThirdAlgorithmBean(thirdAlgorithmBean);
            alarmEventRespond.setFilterName(channelJson.getJSONObject("int_alarm").getString("alog_name"));
        } else if (AlarmCodeTypeEnum.ALARM_SITUATION_ANALYSIS.toString().equals(alarmEventRespond.getAlarmCodeType())) {
            SituationAnalysisBean situationAnalysisBean = new SituationAnalysisBean();
            situationAnalysisBean.setPanorama(panorama);
            situationAnalysisBean.setSnapshot(panorama);
            alarmEventRespond.setSituationAnalysisBean(situationAnalysisBean);
        } else if (AlarmCodeTypeEnum.ALARM_VEHICLE.toString().equals(alarmEventRespond.getAlarmCodeType())) {
            VehicleBean vehicleBean = new VehicleBean();
            vehicleBean.setPanorama(panorama);
            vehicleBean.setSnapshot(panorama);
            alarmEventRespond.setVehicleBean(vehicleBean);
        } else if (AlarmCodeTypeEnum.ALARM_FACE.toString().equals(alarmEventRespond.getAlarmCodeType())) {
            FaceBean faceBean = new FaceBean();
            faceBean.setSnapshot(panorama);
            faceBean.setPanorama(panorama);
            alarmEventRespond.setFaceBean(faceBean);
        } else {
            GeneralBusinessBean generalBusinessBean = new GeneralBusinessBean();
            generalBusinessBean.setPanorama(panorama);
            generalBusinessBean.setSnapshot(panorama);
            alarmEventRespond.setGeneralBusinessBean(generalBusinessBean);
        }
        alarmEventRespond.setChannelCode(channelCode);
        alarmEventRespond.setName(EventNameHelper.getEventName((String)alarmEventRespond.getCode()));
        alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
        alarmEventRespond.setId(UUID.randomUUID().toString());
        this.webSocketService.send((BaseEventRespond)alarmEventRespond);
    }

    private String snapShot(String channelCode) {
        try {
            SnapshotRequest snapshotRequest = new SnapshotRequest();
            snapshotRequest.setChannelCode(channelCode);
            SnapshotRespond snapshotRespond = this.snapshotNvr800Service.createSnapshot(this.subscriptionHelp.get(this.domainCode), snapshotRequest);
            return snapshotRespond.getImgBase64Str();
        }
        catch (Exception e) {
            LOGGER.error("Snapshot fail", (Throwable)e);
            return "";
        }
    }

    private List<Header> getJSONHeaders(VcmReqBaseInfo vcmInfo) {
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add((Header)new BasicHeader("Content-Type", (Object)"application/json"));
        if (null != vcmInfo.getHeaders() && !vcmInfo.getHeaders().isEmpty()) {
            for (VcmReqBaseInfo.Header header : vcmInfo.getHeaders()) {
                headers.add((Header)new BasicHeader(header.getKey(), (Object)header.getValue()));
            }
        }
        return headers;
    }
}

