/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.EncPasswordBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.AlarmSourceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraAddRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRebootRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRemoveRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraValidRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.MasterDeviceSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.PasswordUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.EmptyRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.device.CameraAddRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.device.CameraRebootRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.device.CameraRemoveRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.device.CameraUpdatePasswordNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.device.CameraUpdateRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.device.SearchMasterDeviceNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.AlarmSourceRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraAddRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraAndChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraThirdAlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceRouteRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.MasterDeviceRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.device.SearchMasterDeviceResponseNvr800;
import com.zkteco.zkbiosecurity.cuserver.enums.ChannelStatusEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceManageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.DeviceManageNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.PasswordServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DeviceManageNvr800ServiceImpl
extends AbstractNvr800Service
implements DeviceManageService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManageNvr800ServiceImpl.class);
    @Autowired
    private PasswordServiceImpl passwordService;
    @Autowired
    private WebSocketService webSocketService;
    public static final Predicate<InetAddress> FILTER_IPV4 = addr -> addr instanceof Inet4Address;
    public static final Predicate<InetAddress> FILTER_NOT_LINK_LOCAL = addr -> !addr.isLinkLocalAddress();
    private static byte[][] invalidMacs = new byte[][]{{0, 5, 105}, {0, 28, 20}, {0, 12, 41}, {0, 80, 86}, {8, 0, 39}, {10, 0, 39}, {0, 3, -1}, {0, 21, 93}};
    public static String DEVICE_3RD_INFO = "";

    public CameraAndChannelRespond listCamerasAndChannels(VcmReqBaseInfo vcmInfo) {
        CameraAndChannelRespond cameraAndChannelRespond = new CameraAndChannelRespond();
        cameraAndChannelRespond.setIp(vcmInfo.getVcmIp());
        cameraAndChannelRespond.setType(vcmInfo.getVcmType());
        List cameraResponds = this.listCamera(vcmInfo);
        List channelResponds = this.listChannel(vcmInfo);
        cameraResponds.forEach(cameraRespond -> cameraRespond.setChannelResponds(channelResponds.stream().collect(Collectors.groupingBy(ChannelRespond::getParentCode)).get(cameraRespond.getCameraCode())));
        cameraAndChannelRespond.setCameras(cameraResponds);
        return cameraAndChannelRespond;
    }

    public List<CameraRespond> listCamera(VcmReqBaseInfo vcmReqBaseInfo) {
        ArrayList<CameraRespond> cameraRespondList = new ArrayList<CameraRespond>();
        JSONArray channelArray = this.getChannelArray(vcmReqBaseInfo);
        Map ipcMap = this.getIpcInfo(vcmReqBaseInfo);
        for (int i = 0; i < channelArray.size(); ++i) {
            JSONObject channelObj = channelArray.getJSONObject(i);
            CameraRespond cameraRespond = new CameraRespond();
            cameraRespond.setCameraCode(channelObj.getString("channel"));
            cameraRespond.setCameraName(StringUtils.isNotEmpty((CharSequence)channelObj.getString("channel_name")) ? channelObj.getString("channel_name") : channelObj.getString("channel_alias"));
            cameraRespond.setStatus(this.getStatus(channelObj));
            cameraRespond.setAlarmInNum(channelObj.getIntValue("alarm_in_num"));
            cameraRespond.setAlarmOutNum(channelObj.getIntValue("alarm_out_num"));
            String offlineReason = channelObj.getString("offline_reason");
            cameraRespond.setOfflineReason("Online".equals(offlineReason) ? "0" : offlineReason);
            if (ipcMap.containsKey(cameraRespond.getCameraCode())) {
                JSONObject channelInfo = (JSONObject)ipcMap.get(cameraRespond.getCameraCode());
                cameraRespond.setProtocolType(channelInfo.getString("protocol"));
                if (channelInfo.containsKey((Object)"manufacturer")) {
                    String vendor = channelInfo.getString("manufacturer").toUpperCase();
                    cameraRespond.setVendor("HUAWEI".equalsIgnoreCase(vendor) ? "HW" : vendor);
                }
                cameraRespond.setIp(channelInfo.getString("ip_address"));
                cameraRespond.setPort(channelInfo.getIntValue("port"));
                cameraRespond.setModel(channelInfo.getString("device_type"));
                cameraRespond.setUserName(channelInfo.getString("username"));
                cameraRespond.setSoftwareVersion(channelInfo.getString("software_version"));
                cameraRespond.setAliasPos(channelInfo.getString("alias_pos"));
                cameraRespond.setUserName(channelInfo.getString("username"));
                cameraRespond.setSwitchMode(channelInfo.getString("switch_mode"));
                cameraRespond.setCameraType(this.getCameraType(channelInfo.getString("camera_type")));
                cameraRespond.setCanModifyPwd(channelInfo.getBoolean("can_modify_pwd"));
                cameraRespond.setModifyAllPwd(channelInfo.getBoolean("modify_all_pwd"));
            }
            if (!ChannelStatusEnum.NOT_CONFIGURED.equals((Object)cameraRespond.getStatus())) {
                cameraRespondList.add(cameraRespond);
                continue;
            }
            if (!channelObj.containsKey((Object)"ipc_init") || channelObj.getBooleanValue("ipc_init")) continue;
            cameraRespondList.add(cameraRespond);
        }
        return cameraRespondList;
    }

    public List<ChannelRespond> listChannel(VcmReqBaseInfo vcmReqBaseInfo) {
        return this.listChannel(vcmReqBaseInfo, false);
    }

    private List<ChannelRespond> listChannel(VcmReqBaseInfo vcmReqBaseInfo, boolean containNotConfigured) {
        ArrayList<ChannelRespond> channelRespondList = new ArrayList<ChannelRespond>();
        JSONArray channelArray = this.getChannelArray(vcmReqBaseInfo);
        Map ipcMap = this.getIpcInfo(vcmReqBaseInfo);
        for (int i = 0; i < channelArray.size(); ++i) {
            JSONObject channelObj = channelArray.getJSONObject(i);
            ChannelRespond channelRespond = new ChannelRespond();
            channelRespond.setCategory(DeviceTypeEnum.NVR800.val());
            channelRespond.setChannelCode(channelObj.getString("channel"));
            channelRespond.setParentCode(channelRespond.getChannelCode());
            channelRespond.setCameraName(StringUtils.isNotEmpty((CharSequence)channelObj.getString("channel_name")) ? channelObj.getString("channel_name") : channelObj.getString("channel_alias"));
            channelRespond.setChannel(i + 1);
            channelRespond.setStatus(this.getStatus(channelObj));
            String channelCode = "CH" + channelRespond.getChannel();
            if (ipcMap.containsKey(channelCode)) {
                JSONObject channelInfo = (JSONObject)ipcMap.get(channelCode);
                channelRespond.setProtocolType(channelInfo.getString("protocol"));
                if (channelInfo.containsKey((Object)"manufacturer")) {
                    String vendor = channelInfo.getString("manufacturer").toUpperCase();
                    channelRespond.setVendor("HUAWEI".equalsIgnoreCase(vendor) ? "HW" : vendor);
                }
                channelRespond.setIp(channelInfo.getString("ip_address"));
                channelRespond.setPort(channelInfo.getIntValue("port"));
                channelRespond.setModel(channelInfo.getString("device_type"));
                channelRespond.setType(this.getType(channelInfo.getString("camera_type")));
                channelRespond.setCameraType(this.getCameraType(channelInfo.getString("camera_type")));
                channelRespond.setUserName(channelInfo.getString("username"));
                channelRespond.setSoftwareVersion(channelInfo.getString("software_version"));
                channelRespond.setAliasPos(channelInfo.getString("alias_pos"));
                channelRespond.setUserName(channelInfo.getString("username"));
                channelRespond.setSwitchMode(channelInfo.getString("switch_mode"));
                if (StringUtils.isBlank((CharSequence)channelRespond.getCameraName())) {
                    channelRespond.setCameraName(channelInfo.getString("alias"));
                }
            }
            if (ChannelStatusEnum.NOT_CONFIGURED.equals((Object)channelRespond.getStatus())) {
                if (!containNotConfigured) continue;
                channelRespondList.add(channelRespond);
                continue;
            }
            channelRespondList.add(channelRespond);
        }
        return channelRespondList;
    }

    private String getCameraType(String type) {
        if ("fixed_bullet".equalsIgnoreCase(type)) {
            return "PTZ";
        }
        if ("bullet".equalsIgnoreCase(type)) {
            return "BULLET";
        }
        if ("ball".equalsIgnoreCase(type)) {
            return "HALFDOME";
        }
        if ("dome".equalsIgnoreCase(type)) {
            return "DOME";
        }
        return "FIX";
    }

    private int getType(String type) {
        if ("fixed_bullet".equalsIgnoreCase(type)) {
            return 1;
        }
        if ("bullet".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("ball".equalsIgnoreCase(type)) {
            return 3;
        }
        if ("dome".equalsIgnoreCase(type)) {
            return 2;
        }
        return 0;
    }

    public ChannelRespond getChannel(ParamBean<ChannelRequest> obj) {
        List channelRespondList = this.listChannel(obj.getVcmInfo(), true);
        for (ChannelRespond channelRespond : channelRespondList) {
            if (!channelRespond.getChannelCode().equals(((ChannelRequest)obj.getRequestBody()).getChannelCode())) continue;
            return channelRespond;
        }
        return null;
    }

    public List<String> getEmptyChannel(ParamBean<EmptyRequest> obj) {
        ArrayList<String> channelCodeList = new ArrayList<String>();
        Map channelMap = this.getIpcInfo(obj.getVcmInfo());
        for (String key : channelMap.keySet()) {
            JSONObject channelObject = (JSONObject)channelMap.get(key);
            if (!"NotConfigured".equalsIgnoreCase(channelObject.getString("state")) || "AutoMode".equalsIgnoreCase(channelObject.getString("switch_mode"))) continue;
            channelCodeList.add(key);
        }
        return channelCodeList;
    }

    public boolean updateChannel(ParamBean<ChannelUpdateRequest> obj) {
        CameraUpdateRequestNvr800 requestNvr800 = new CameraUpdateRequestNvr800(((ChannelUpdateRequest)obj.getRequestBody()).getChannelCode());
        requestNvr800.setName(((ChannelUpdateRequest)obj.getRequestBody()).getName());
        JSONObject data = new JSONObject();
        JSONObject channelInfo = new JSONObject();
        JSONObject text = new JSONObject();
        text.put("text", (Object)((ChannelUpdateRequest)obj.getRequestBody()).getName());
        JSONObject nameObject = new JSONObject();
        nameObject.put("name", (Object)text);
        channelInfo.put(((ChannelUpdateRequest)obj.getRequestBody()).getChannelCode(), (Object)nameObject);
        data.put("channel_info", (Object)channelInfo);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            BaseRespondNvr800 respondNvr800 = (BaseRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.OSD_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond(respondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("Set channel fail", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public List<ChannelRespond> listChannelsByCamera(VcmReqBaseInfo vcmReqBaseInfo, String cameraCode) {
        List allChannelList = this.listChannel(vcmReqBaseInfo, false);
        ArrayList<ChannelRespond> channelRespondList = new ArrayList<ChannelRespond>();
        for (ChannelRespond channelRespond : allChannelList) {
            if (!cameraCode.equals(channelRespond.getChannelCode())) continue;
            channelRespondList.add(channelRespond);
        }
        return channelRespondList;
    }

    public CameraAddRespond addCamera(ParamBean<CameraAddRequest> obj) {
        CameraAddRequest addRequest = (CameraAddRequest)obj.getRequestBody();
        String channelCode = StringUtils.isNotBlank((CharSequence)addRequest.getChannelCode()) ? addRequest.getChannelCode() : this.getEmptyChannel(obj.getVcmInfo());
        EncPasswordBean encPasswordBean = this.passwordService.get(obj.getVcmInfo(), ((CameraAddRequest)obj.getRequestBody()).getDevicePassword());
        CameraAddRequestNvr800 requestNvr800 = new CameraAddRequestNvr800();
        requestNvr800.setSeq(encPasswordBean.getSeq());
        JSONObject channelInfoObj = requestNvr800.channelInfo();
        JSONObject contentObj = new JSONObject();
        contentObj.put("alias", (Object)addRequest.getName());
        contentObj.put("ip_address", (Object)addRequest.getIp());
        contentObj.put("port", (Object)Integer.valueOf(addRequest.getPort()));
        if ("ONVIF".equals(addRequest.getProtocol())) {
            contentObj.put("protocol", (Object)"Onvif");
        } else {
            contentObj.put("protocol", (Object)addRequest.getProtocol());
        }
        contentObj.put("username", (Object)addRequest.getDeviceUser());
        contentObj.put("alias_pos", (Object)"LeftTop");
        contentObj.put("cipher", (Object)encPasswordBean.getCipher());
        channelInfoObj.put(channelCode, (Object)contentObj);
        try {
            BaseRespondNvr800 respondNvr800 = (BaseRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SET_CHANNEL_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond(respondNvr800);
            CameraAddRespond cameraAddRespond = new CameraAddRespond();
            cameraAddRespond.setCameraCode(channelCode);
            return cameraAddRespond;
        }
        catch (SDKException e) {
            LOGGER.error("Set channel fail", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private String getEmptyChannel(VcmReqBaseInfo vcmReqBaseInfo) {
        Map channelMap = this.getIpcInfo(vcmReqBaseInfo);
        for (String key : channelMap.keySet()) {
            JSONObject channelObject = (JSONObject)channelMap.get(key);
            if (!"NotConfigured".equalsIgnoreCase(channelObject.getString("state")) || "AutoMode".equalsIgnoreCase(channelObject.getString("switch_mode"))) continue;
            return key;
        }
        throw new InvokeException("500", "no_empty_channel");
    }

    private Map<String, JSONObject> getIpcInfo(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.IP_CHANNEL_INFO_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)new EmptyRequestNvr800(), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getHeaders(vcmReqBaseInfo));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            HashMap<String, JSONObject> resultMap = new HashMap<String, JSONObject>();
            if (respondNvr800.getData() == null || respondNvr800.getData().getJSONObject("channel_info") == null) {
                return resultMap;
            }
            JSONObject infoJson = respondNvr800.getData().getJSONObject("channel_info");
            for (String key : infoJson.keySet()) {
                resultMap.put(key, infoJson.getJSONObject(key));
            }
            return resultMap;
        }
        catch (SDKException e) {
            LOGGER.error("List IPChannel fail", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean removeCamera(ParamBean<CameraRemoveRequest> obj) {
        CameraRemoveRequestNvr800 removeRequestNvr800 = new CameraRemoveRequestNvr800();
        removeRequestNvr800.addCode(((CameraRemoveRequest)obj.getRequestBody()).getCameraCode());
        try {
            BaseRespondNvr800 respondNvr800 = (BaseRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SET_CHANNEL_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)removeRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond(respondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("remove Camera fail", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean updatePassword(ParamBean<PasswordUpdateRequest> obj) {
        PasswordUpdateRequest updateRequest = (PasswordUpdateRequest)obj.getRequestBody();
        EncPasswordBean encPasswordBean = this.passwordService.get(obj.getVcmInfo(), ((PasswordUpdateRequest)obj.getRequestBody()).getNewPassword());
        CameraUpdatePasswordNvr800 requestNvr800 = new CameraUpdatePasswordNvr800(updateRequest.getCameraCode(), updateRequest.getUserName(), encPasswordBean.getCipher(), encPasswordBean.getSeq(), updateRequest.getModifyAllPwd());
        try {
            BaseRespondNvr800 respondNvr800 = (BaseRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SET_CHANNEL_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond(respondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("Set channel fail", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean updateOfflinePassword(ParamBean<CameraAddRequest> obj) {
        this.addCamera(obj);
        return true;
    }

    public boolean rebootCamera(ParamBean<CameraRebootRequest> obj) {
        try {
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.REBOOT_CAMERA_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)new CameraRebootRequestNvr800(((CameraRebootRequest)obj.getRequestBody()).getCameraCode()), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("List channel fail", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public List<CameraSearchRespond> searchCamera(VcmReqBaseInfo vcmReqBaseInfo, CameraSearchRequest request) {
        CompletableFuture.runAsync(() -> {
            String protocolType = Objects.nonNull(request) && "0".equals(request.getProtocolType()) ? "ONVIF" : "HWSDK";
            DeviceEventRespond deviceEventRespond = new DeviceEventRespond();
            deviceEventRespond.setType(EventTypeEnum.OPERATE_RESULT);
            deviceEventRespond.setDomainCode(request.getDomainCode());
            deviceEventRespond.setPercent("100");
            deviceEventRespond.setSubtype("searchCamera");
            try {
                JSONObject dataObject = new JSONObject();
                dataObject.put("data", (Object)new JSONObject());
                JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.CAMERA_SEARCH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo), (int)30);
                this.checkJsonRespond(rsp);
                JSONArray cameraArray = rsp.getJSONObject("data").getJSONArray("device_info");
                if (!CollectionUtils.isEmpty((Collection)cameraArray)) {
                    for (int i = 0; i < cameraArray.size(); ++i) {
                        JSONObject cameraObject = cameraArray.getJSONObject(i);
                        CameraSearchRespond searchRespond = new CameraSearchRespond();
                        if (protocolType.equalsIgnoreCase(cameraObject.getString("protocol"))) {
                            searchRespond.setCameraType(cameraObject.getString("camera_type"));
                            searchRespond.setIp(cameraObject.getString("ip_address"));
                            searchRespond.setProtocol(cameraObject.getString("protocol"));
                            searchRespond.setWebPort(cameraObject.getString("web_port"));
                            searchRespond.setChannelNumber(cameraObject.getIntValue("channel_num"));
                            searchRespond.setSerialNumber(cameraObject.getString("serial_number"));
                            searchRespond.setSubnetMask(cameraObject.getString("subnet_mask"));
                            searchRespond.setVendor(cameraObject.getString("manufacturer"));
                            searchRespond.setPort(cameraObject.getString("port"));
                            searchRespond.setDeviceType(cameraObject.getString("device_type"));
                            searchRespond.setGateway(cameraObject.getString("gateway"));
                            if ("HUAWEI".equalsIgnoreCase(searchRespond.getVendor())) {
                                searchRespond.setVendor("HW");
                            }
                            deviceEventRespond.getData().getCameras().add(searchRespond);
                            continue;
                        }
                        LOGGER.info("NVR 800 search different protocol,IP:" + cameraObject.getString("ip_address"));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("search error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            }
            LOGGER.info("NVR 800 search camera data:{}", (Object)deviceEventRespond.toJSON());
            this.webSocketService.send((BaseEventRespond)deviceEventRespond);
        });
        return new ArrayList<CameraSearchRespond>();
    }

    public CameraSearchRespond validCamera(VcmReqBaseInfo vcmInfo, CameraValidRequest request) {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public Boolean stopSearch(VcmReqBaseInfo vcmInfo, CameraValidRequest request) {
        return true;
    }

    private JSONArray getChannelArray(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.LIST_CHANNEL_URI, (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getHeaders(vcmReqBaseInfo));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return respondNvr800.getData().getJSONObject("channel_param").getJSONArray("items");
        }
        catch (SDKException e) {
            LOGGER.error("List channel fail", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private ChannelStatusEnum getStatus(JSONObject channelObj) {
        String status = channelObj.getString("connect_status");
        if ("Online".equals(status)) {
            return ChannelStatusEnum.ONLINE;
        }
        if ("Offline".equals(status)) {
            return ChannelStatusEnum.OFFLINE;
        }
        if ("NotConfigured".equals(status)) {
            return ChannelStatusEnum.NOT_CONFIGURED;
        }
        return ChannelStatusEnum.SLEEP;
    }

    public DeviceInfoRespond getDeviceInfo(VcmReqBaseInfo vcmInfo) {
        DeviceInfoRespond respond = new DeviceInfoRespond();
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.DEVICE_GET_INFO, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            JSONObject dataObject = rsp.getJSONObject("data");
            respond.setModel(dataObject.getString("device_type"));
            respond.setDeviceVersion(dataObject.getString("software_version"));
            respond.setProductName(dataObject.getString("device_name"));
            respond.setMaxChannelNumber(dataObject.getInteger("channel_num"));
        }
        catch (SDKException e) {
            LOGGER.error("NVR 800 get device info error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return respond;
    }

    public DeviceRouteRespond getDeviceVersion(VcmReqBaseInfo vcmInfo) {
        DeviceRouteRespond respond = new DeviceRouteRespond();
        DeviceInfoRespond deviceInfo = this.getDeviceInfo(vcmInfo);
        respond.setIp(vcmInfo.getVcmIp());
        respond.setDeviceVersion(deviceInfo.getDeviceVersion());
        respond.setProductName(deviceInfo.getProductName());
        respond.setModel(deviceInfo.getModel());
        return respond;
    }

    public DeviceInfoRespond getLoginDeviceInfo(VcmReqBaseInfo vcmInfo) {
        DeviceInfoRespond respond = new DeviceInfoRespond();
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.DEVICE_INFO_GET_URI, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            JSONObject dataObject = rsp.getJSONObject("data");
            respond.setLocalAlarmOutNum(dataObject.getIntValue("local_alarmout_num"));
        }
        catch (SDKException e) {
            LOGGER.error("NVR 800 get login device info error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return respond;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MasterDeviceRespond> searchMasterDevice(MasterDeviceSearchRequest request) {
        ArrayList<MasterDeviceRespond> respondList = new ArrayList<MasterDeviceRespond>();
        ArrayList<String> filterList = new ArrayList<String>();
        DatagramSocket ds = null;
        try {
            try {
                SearchMasterDeviceNvr800 data = new SearchMasterDeviceNvr800();
                data.setSeq(1);
                data.setMsgType((short)11);
                InetAddress group = InetAddress.getByName("255.255.255.255");
                for (NetworkInterface nic : DeviceManageNvr800ServiceImpl.getNICs((Predicate[])new Predicate[]{Filter.UP, Filter.PHYICAL_ONLY})) {
                    DeviceManageNvr800ServiceImpl.sendMulticast((InetAddress)group, (int)9333, (byte[])data.toByteArray(), (Integer)20, (NetworkInterface)nic);
                }
                byte[] buffer = new byte[0x100000];
                DatagramPacket receivePacket = new DatagramPacket(buffer, buffer.length);
                ds = new DatagramSocket(9333);
                ds.setSoTimeout(10000);
                ds.setBroadcast(true);
                while (true) {
                    ds.receive(receivePacket);
                    SearchMasterDeviceResponseNvr800 responseNvr800 = new SearchMasterDeviceResponseNvr800();
                    responseNvr800.unPacket(receivePacket.getData());
                    LOGGER.info("DatagramPacket receive data IP:{},iePort:{},devVersion:{},macAddress:{}", new Object[]{responseNvr800.getIp(), responseNvr800.getIePort(), responseNvr800.getDevVer(), responseNvr800.getMacAddress()});
                    if (filterList.contains(responseNvr800.getMacAddress())) continue;
                    MasterDeviceRespond deviceRespond = new MasterDeviceRespond();
                    deviceRespond.setIp(responseNvr800.getIp());
                    deviceRespond.setWebPort("443");
                    deviceRespond.setVersion(responseNvr800.getDevVer());
                    deviceRespond.setMacAddress(responseNvr800.getMacAddress());
                    deviceRespond.setType("2");
                    respondList.add(deviceRespond);
                    filterList.add(responseNvr800.getMacAddress());
                }
            }
            catch (Exception e) {
                LOGGER.error("NVR 800 search master device error", (Throwable)e);
                if (ds != null) {
                    ds.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (ds != null) {
                ds.close();
            }
            throw throwable;
        }
        return respondList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMulticast(InetAddress group, int port, byte[] message, Integer ttl, NetworkInterface nic) throws IOException {
        UnmodifiableIterator nifAddresses = Iterators.filter((Iterator)Iterators.forEnumeration(nic.getInetAddresses()), (Predicate)Predicates.and((Predicate)FILTER_IPV4, (Predicate)FILTER_NOT_LINK_LOCAL));
        if (!nifAddresses.hasNext()) {
            return;
        }
        InetSocketAddress inetAddr = new InetSocketAddress((InetAddress)nifAddresses.next(), 9333);
        try (DatagramSocket ds = null;){
            ds = new DatagramSocket(inetAddr);
            ds.setBroadcast(true);
            ds.send(new DatagramPacket(message, message.length, group, port));
        }
    }

    @SafeVarargs
    public static Set<NetworkInterface> getNICs(Predicate<NetworkInterface> ... filters) {
        if (null == filters) {
            filters = new Predicate[]{Filter.ALL};
        }
        try {
            UnmodifiableIterator filtered = Iterators.filter((Iterator)Iterators.forEnumeration(NetworkInterface.getNetworkInterfaces()), (Predicate)Predicates.and(filters));
            return ImmutableSet.copyOf((Iterator)filtered);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isVMMac(byte[] mac) {
        if (null == mac) {
            return false;
        }
        for (byte[] invalid : invalidMacs) {
            if (invalid[0] != mac[0] || invalid[1] != mac[1] || invalid[2] != mac[2]) continue;
            return true;
        }
        return false;
    }

    public List<AlarmSourceRespond> getAlarmSource(ParamBean<AlarmSourceRequest> obj) {
        ArrayList<AlarmSourceRespond> respondList = new ArrayList<AlarmSourceRespond>();
        try {
            JSONObject dataObject = new JSONObject();
            JSONObject alarmObject = new JSONObject();
            dataObject.put("data", (Object)alarmObject);
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestJsonOrder((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.IO_ALARM_PARAMETERS_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            if (rsp.getJSONObject("data").containsKey((Object)"channel_info") && Objects.nonNull(rsp.getJSONObject("data").getJSONObject("channel_info"))) {
                for (String s : rsp.getJSONObject("data").getJSONObject("channel_info").keySet()) {
                    AlarmSourceRespond respond = new AlarmSourceRespond();
                    respond.setDeviceGroupCode("0");
                    respond.setChannelType(Integer.valueOf(0));
                    respond.setAlarmName(s);
                    respond.setAlarmCode(s + "#" + obj.getVcmInfo().getDomainCode());
                    respond.setDomainCode(obj.getVcmInfo().getDomainCode());
                    if (s.contains("Local")) {
                        respond.setParentCode("CH" + s.split("\\-")[1] + "#" + obj.getVcmInfo().getDomainCode());
                    } else if (s.contains("IP_")) {
                        respond.setParentCode(DeviceManageNvr800ServiceImpl.getSubUtilSimple((String)s, (String)"IP_(\\w+)<") + "#" + obj.getVcmInfo().getDomainCode());
                    }
                    respondList.add(respond);
                }
            }
        }
        catch (SDKException e) {
            LOGGER.error("NVR 800 getAlarmSource error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return respondList;
    }

    public static String getSubUtilSimple(String soap, String rgex) {
        Pattern pattern = Pattern.compile(rgex);
        Matcher m = pattern.matcher(soap);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public JSONObject removeCameras(ParamBean<CameraRemoveRequest> obj) {
        try {
            JSONObject devCodes = new JSONObject();
            devCodes.put("remove_ipc", (Object)((CameraRemoveRequest)obj.getRequestBody()).getCameraCodes());
            JSONObject dataObject = new JSONObject();
            dataObject.put("data", (Object)devCodes);
            BaseRespondNvr800 respondNvr800 = (BaseRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SET_CHANNEL_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond(respondNvr800);
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("NVR800 remove Cameras fail", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public DeviceInfoRespond getCameraInfo(ParamBean<CameraRequest> obj) {
        DeviceInfoRespond respond = new DeviceInfoRespond();
        try {
            JSONObject dataObject = new JSONObject();
            JSONArray chnArray = new JSONArray();
            chnArray.add((Object)((CameraRequest)obj.getRequestBody()).getCameraCode());
            JSONObject chnObject = new JSONObject();
            chnObject.put("channel", (Object)chnArray);
            dataObject.put("data", (Object)chnObject);
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.CAMERA_SYSTEM_INFO_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(result);
            LOGGER.info("NVR 800 get camera info, code:{}, data: {}", (Object)((CameraRequest)obj.getRequestBody()).getCameraCode(), (Object)result);
            JSONObject deviceData = result.getJSONObject("data").getJSONObject("channel_info").getJSONObject(((CameraRequest)obj.getRequestBody()).getCameraCode());
            if (deviceData.containsKey((Object)"ipc_info")) {
                JSONObject ipcInfo = deviceData.getJSONObject("ipc_info");
                JSONObject osMemInfo = ipcInfo.getJSONObject("memInfo").getJSONObject("osMemInfo");
                respond.setHardwareId(ipcInfo.getString("drvCode"));
                respond.setFreeMem(osMemInfo.getInteger("freeMem"));
                respond.setTotalMem(osMemInfo.getInteger("totalMem"));
                JSONObject flashInfo = ipcInfo.getJSONObject("flashInfo");
                respond.setFlashFreeMem(flashInfo.getInteger("freeFlashSize"));
                respond.setFlashTotalMem(flashInfo.getInteger("totalFlashSize"));
                respond.setCpuOccupyRate(Integer.valueOf((int)(ipcInfo.getFloat("cpuOccupyRate").floatValue() * 100.0f)));
            } else if (deviceData.containsKey((Object)"reason")) {
                throw new InvokeException("500", deviceData.getString("reason"));
            }
        }
        catch (SDKException e) {
            LOGGER.error("Nvr 800 get camera info error, IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return respond;
    }

    public List<CameraThirdAlgorithmRespond> getCameraThirdAlgorithm(ParamBean<CameraRequest> obj) {
        ArrayList<CameraThirdAlgorithmRespond> respondList = new ArrayList<CameraThirdAlgorithmRespond>();
        try {
            JSONObject dataObject = new JSONObject();
            JSONArray chnArray = new JSONArray();
            chnArray.add((Object)((CameraRequest)obj.getRequestBody()).getCameraCode());
            JSONObject chnObject = new JSONObject();
            chnObject.put("channel", (Object)chnArray);
            dataObject.put("data", (Object)chnObject);
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.DEVICE_INFO_3RD_ALGORITHM_Get, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()), (int)30);
            this.checkJsonRespond(result);
            LOGGER.info("NVR 800 get Camera ThirdAlgorithm data: {}", (Object)result);
            JSONObject channelInfo = result.getJSONObject("data").getJSONObject("channel_info");
            JSONObject channelObject = channelInfo.getJSONObject(((CameraRequest)obj.getRequestBody()).getCameraCode());
            if (channelObject.containsKey((Object)"app_list")) {
                JSONArray appList = channelObject.getJSONArray("app_list");
                for (int i = 0; i < appList.size(); ++i) {
                    JSONObject appDataObject;
                    JSONObject appObject = appList.getJSONObject(i);
                    CameraThirdAlgorithmRespond respond = new CameraThirdAlgorithmRespond();
                    JSONObject chnDetail = this.getCameraThirdAlgorithmDetail(obj, appObject.getString("app_name"));
                    if (Objects.nonNull(chnDetail) && "success".equals(chnDetail.getString("result")) && (appDataObject = chnDetail.getJSONObject("data").getJSONObject("channel_info").getJSONObject(((CameraRequest)obj.getRequestBody()).getCameraCode())).containsKey((Object)"app_data")) {
                        respond.setDesc(appDataObject.getJSONObject("app_data").getString("Description"));
                        respond.setNameEn(appDataObject.getJSONObject("app_data").getString("appName_en"));
                        respond.setImage(appDataObject.getJSONObject("app_data").getString("NormalImage"));
                    }
                    respond.setName(appObject.getString("app_name"));
                    if ("Stop".equals(appObject.getString("app_status"))) {
                        respond.setRunState("stopped");
                    } else if ("Run".equals(appObject.getString("app_status"))) {
                        respond.setRunState("started");
                    }
                    respond.setState("");
                    respond.setVersion(appObject.getString("app_version"));
                    respond.setChannelCode(((CameraRequest)obj.getRequestBody()).getCameraCode());
                    respondList.add(respond);
                }
            }
        }
        catch (SDKException e) {
            LOGGER.error("NVR 800 get camera third algorithm error, IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return respondList;
    }

    private JSONObject getCameraThirdAlgorithmDetail(ParamBean<CameraRequest> obj, String appName) {
        JSONObject result = null;
        try {
            JSONObject dataObject = new JSONObject();
            JSONObject chnObject = new JSONObject();
            chnObject.put("channel", (Object)((CameraRequest)obj.getRequestBody()).getCameraCode());
            chnObject.put("app_name", (Object)appName);
            dataObject.put("data", (Object)chnObject);
            result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.DEVICE_DETAIL_INFO_3RD_ALGORITHM_Get, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()), (int)30);
            LOGGER.info("NVR 800 get Camera ThirdAlgorithm Detail data: {}", (Object)result);
        }
        catch (SDKException e) {
            LOGGER.error("Nvr 800 get Camera Third Algorithm Detail error, IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
        }
        return result;
    }

    public Boolean DeviceReboot(ParamBean<CameraAddRequest> obj) {
        try {
            JSONObject dataObject = new JSONObject();
            JSONObject deviceObject = new JSONObject();
            EncPasswordBean encPasswordBean = this.passwordService.getByType(obj.getVcmInfo(), ((CameraAddRequest)obj.getRequestBody()).getDevicePassword(), "Salt");
            deviceObject.put("secondary_authentication", JSON.toJSON((Object)encPasswordBean));
            dataObject.put("data", (Object)deviceObject);
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.DEVICE_REBOOT, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(result);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("Nvr 800 Device Reboot error, IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public DeviceInfoRespond getLicenseStatus(ParamBean<CameraRequest> obj) {
        JSONObject channelData = new JSONObject();
        JSONObject requestData = new JSONObject();
        requestData.put("Status", (Object)1);
        channelData.put("request_url", (Object)"GET /SDCAPI/V1.0/App/AppList?Image=0");
        channelData.put("request_data", (Object)requestData.toJSONString());
        JSONObject channel = new JSONObject();
        channel.put(((CameraRequest)obj.getRequestBody()).getCameraCode(), (Object)channelData);
        JSONObject channelInfo = new JSONObject();
        channelInfo.put("channel_info", (Object)channel);
        JSONObject data = new JSONObject();
        data.put("data", (Object)channelInfo);
        DeviceInfoRespond respond = new DeviceInfoRespond();
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.DEVICE_SDC_PASS, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)data, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            if ("success".equalsIgnoreCase(result.getString("result"))) {
                String respondData = result.getJSONObject("data").getJSONObject("channel_info").getJSONObject(((CameraRequest)obj.getRequestBody()).getCameraCode()).getString("respond_data");
                JSONObject deviceData = JSON.parseObject((String)respondData);
                ArrayList<DeviceInfoRespond.AppParam> appParam = new ArrayList<DeviceInfoRespond.AppParam>();
                if (StringUtils.isNotBlank((CharSequence)respondData) && deviceData.containsKey((Object)"apps")) {
                    JSONArray apps = deviceData.getJSONArray("apps");
                    for (int i = 0; i < apps.size(); ++i) {
                        DeviceInfoRespond.AppParam appParamObj = new DeviceInfoRespond.AppParam();
                        JSONObject appLicense = apps.getJSONObject(i).getJSONObject("appLicense");
                        appParamObj.setAppName(apps.getJSONObject(i).getString("appName"));
                        appParamObj.setAppVersion(apps.getJSONObject(i).getString("appVersion"));
                        appParamObj.setExpiredDay(appLicense.getString("expiredDay"));
                        appParamObj.setLicenseType(appLicense.getString("licenseType"));
                        appParamObj.setRemainTime(appLicense.getString("remainTime"));
                        appParamObj.setStartDate(appLicense.getString("startDate"));
                        appParam.add(appParamObj);
                    }
                }
                respond.setApps(appParam);
            }
        }
        catch (SDKException e) {
            LOGGER.error("NVR 800 get License Status error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
        }
        return respond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    static /* synthetic */ boolean access$000(byte[] x0) {
        return DeviceManageNvr800ServiceImpl.isVMMac((byte[])x0);
    }
}

