/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.ColorConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.DateTimeRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.OsdConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.ColorConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.DateTimeRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.OsdConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceInfoConfigService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.FaceRepositoryServiceNvr800Impl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="deviceInfoConfigNvr800Service")
public class DeviceInfoConfigNvr800ServiceImpl
extends AbstractNvr800Service
implements DeviceInfoConfigService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaceRepositoryServiceNvr800Impl.class);

    public DateTimeRespond getTimeConfig(ParamBean<EmptyRequest> obj) {
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SYSTEM_DATE_TIME_GET, (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return this.dateTimeConvert(rsp.getData());
        }
        catch (SDKException e) {
            LOGGER.error("get time config happen exception", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setTimeConfig(ParamBean<DateTimeRequest> obj) {
        JSONObject request = this.dateTimeRequestConvert((DateTimeRequest)obj.getRequestBody());
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SYSTEM_DATE_TIME_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set time config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public OsdConfigRespond getOsdConfig(ParamBean<OsdConfigRequest> obj) {
        JSONObject request = new JSONObject();
        JSONObject data = new JSONObject();
        JSONArray channel = new JSONArray();
        channel.add((Object)((OsdConfigRequest)obj.getRequestBody()).getChannelCode());
        data.put("channel", (Object)channel);
        request.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.OSD_CONFIG_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return this.osdConfigConvert(rsp.getData().getJSONObject("channel_info").getJSONObject(((OsdConfigRequest)obj.getRequestBody()).getChannelCode()));
        }
        catch (SDKException e) {
            LOGGER.error("get osd config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setOsdConfig(ParamBean<OsdConfigRequest> obj) {
        JSONObject request = this.osdConfigRequestConvert((OsdConfigRequest)obj.getRequestBody());
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.OSD_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set osd config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public ColorConfigRespond getColorConfig(ParamBean<ColorConfigRequest> obj) {
        JSONObject request = new JSONObject();
        JSONObject data = new JSONObject();
        JSONArray channel = new JSONArray();
        channel.add((Object)((ColorConfigRequest)obj.getRequestBody()).getChannelCode());
        data.put("channel", (Object)channel);
        request.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.IPC_COLOR_CONFIG_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            ColorConfigRespond respond = this.colorConfigConvert(rsp.getData().getJSONObject("channel_info").getJSONObject(((ColorConfigRequest)obj.getRequestBody()).getChannelCode()));
            CommonRespondNvr800 configRsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.IPC_COLOR_CONFIG_RANGE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)configRsp);
            JSONObject configObject = configRsp.getData().getJSONObject("channel_info").getJSONObject("items").getJSONObject(((ColorConfigRequest)obj.getRequestBody()).getChannelCode()).getJSONObject("items");
            ColorConfigRespond.ColorRange colorRange = new ColorConfigRespond.ColorRange();
            if (configObject.containsKey((Object)"hue")) {
                colorRange.setHueMin(configObject.getJSONObject("hue").getIntValue("min"));
                colorRange.setHueMax(configObject.getJSONObject("hue").getIntValue("max"));
            } else {
                respond.setHue(0);
                colorRange.setHueMin(0);
                colorRange.setHueMax(0);
            }
            if (configObject.containsKey((Object)"contrast")) {
                colorRange.setContrastMin(configObject.getJSONObject("contrast").getIntValue("min"));
                colorRange.setContrastMax(configObject.getJSONObject("contrast").getIntValue("max"));
            } else {
                respond.setContrast(0);
                colorRange.setContrastMin(0);
                colorRange.setContrastMax(0);
            }
            if (configObject.containsKey((Object)"bright")) {
                colorRange.setBrightMin(configObject.getJSONObject("bright").getIntValue("min"));
                colorRange.setBrightMax(configObject.getJSONObject("bright").getIntValue("max"));
            } else {
                respond.setBright(0);
                colorRange.setBrightMin(0);
                colorRange.setBrightMax(0);
            }
            if (configObject.containsKey((Object)"saturation")) {
                colorRange.setSaturationMin(configObject.getJSONObject("saturation").getIntValue("min"));
                colorRange.setSaturationMax(configObject.getJSONObject("saturation").getIntValue("max"));
            } else {
                respond.setSaturation(0);
                colorRange.setSaturationMin(0);
                colorRange.setSaturationMax(0);
            }
            if (configObject.containsKey((Object)"sharpness")) {
                colorRange.setSharpnessMin(configObject.getJSONObject("sharpness").getIntValue("min"));
                colorRange.setSharpnessMax(configObject.getJSONObject("sharpness").getIntValue("max"));
            } else {
                respond.setSharpness(0);
                colorRange.setSharpnessMin(0);
                colorRange.setSharpnessMax(0);
            }
            respond.setRange(colorRange);
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("get color config happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setColorConfig(ParamBean<ColorConfigRequest> obj) {
        JSONObject request = this.colorConfigRequestConvert((ColorConfigRequest)obj.getRequestBody());
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.IPC_COLOR_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set color config happen exception", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public DateTimeRespond dateTimeConvert(JSONObject dateTimeJson) {
        DateTimeRespond dateTimeRespond = new DateTimeRespond();
        dateTimeRespond.setDate(dateTimeJson.getString("date"));
        dateTimeRespond.setDateFormat(dateTimeJson.getString("date_format"));
        dateTimeRespond.setTime(dateTimeJson.getString("time"));
        dateTimeRespond.setTimeZone(dateTimeJson.getString("time_zone"));
        return dateTimeRespond;
    }

    public JSONObject dateTimeRequestConvert(DateTimeRequest request) {
        JSONObject jsonReq = new JSONObject();
        JSONObject data = new JSONObject();
        data.put("date", (Object)request.getDate());
        data.put("time", (Object)request.getTime());
        data.put("date_format", (Object)request.getDateFormat());
        data.put("time_zone", (Object)request.getTimeZone());
        jsonReq.put("data", (Object)data);
        return jsonReq;
    }

    public OsdConfigRespond osdConfigConvert(JSONObject osdConfig) {
        OsdConfigRespond rsp = new OsdConfigRespond();
        rsp.setCovert(osdConfig.getBoolean("covert"));
        rsp.getTime().setShow(osdConfig.getJSONObject("datetime").getBoolean("show"));
        rsp.getTime().getPos().setTextX(osdConfig.getJSONObject("datetime").getJSONObject("pos").getString("x"));
        rsp.getTime().getPos().setTextY(osdConfig.getJSONObject("datetime").getJSONObject("pos").getString("y"));
        ArrayList<OsdConfigRespond.OsdName> osdNames = new ArrayList<OsdConfigRespond.OsdName>();
        for (int i = 0; i < 8; ++i) {
            if (i > 0 && osdConfig.getJSONObject("osd" + i) == null) continue;
            OsdConfigRespond.OsdName osdName = new OsdConfigRespond.OsdName();
            if (i == 0) {
                osdName.setShow(osdConfig.getJSONObject("name").getBoolean("show"));
                osdName.setText(osdConfig.getJSONObject("name").getString("text"));
                osdName.getPos().setTextX(osdConfig.getJSONObject("name").getJSONObject("pos").getString("x"));
                osdName.getPos().setTextY(osdConfig.getJSONObject("name").getJSONObject("pos").getString("y"));
            } else {
                osdName.setShow(osdConfig.getJSONObject("osd" + i).getBoolean("show"));
                osdName.setText(osdConfig.getJSONObject("osd" + i).getString("text"));
                osdName.getPos().setTextX(osdConfig.getJSONObject("osd" + i).getJSONObject("pos").getString("x"));
                osdName.getPos().setTextY(osdConfig.getJSONObject("osd" + i).getJSONObject("pos").getString("y"));
            }
            osdNames.add(osdName);
        }
        rsp.setTexts(osdNames);
        return rsp;
    }

    public JSONObject osdConfigRequestConvert(OsdConfigRequest request) {
        String channelCode = request.getChannelCode();
        OsdConfigRespond.OsdTime osdTime = request.getOsdConfig().getTime();
        List texts = request.getOsdConfig().getTexts();
        Boolean covert = request.getOsdConfig().getCovert();
        JSONObject channelOsdInfo = new JSONObject();
        JSONObject datetime = new JSONObject();
        datetime.put("show", (Object)osdTime.getShow());
        datetime.put("date_format", (Object)"YYYY-MM-DD");
        datetime.put("time_format", (Object)24);
        datetime.put("show_week", (Object)false);
        JSONObject timePos = new JSONObject();
        timePos.put("x", (Object)Integer.valueOf(osdTime.getPos().getTextX()));
        timePos.put("y", (Object)Integer.valueOf(osdTime.getPos().getTextY()));
        datetime.put("pos", (Object)timePos);
        channelOsdInfo.put("datetime", (Object)datetime);
        channelOsdInfo.put("covert", (Object)covert);
        int total = texts.size() > 6 ? 5 : texts.size();
        for (int i = 0; i < total; ++i) {
            JSONObject osd = new JSONObject();
            osd.put("show", (Object)((OsdConfigRespond.OsdName)texts.get(i)).getShow());
            osd.put("text", (Object)((OsdConfigRespond.OsdName)texts.get(i)).getText());
            JSONObject pos = new JSONObject();
            pos.put("x", (Object)Integer.valueOf(((OsdConfigRespond.OsdName)texts.get(i)).getPos().getTextX()));
            pos.put("y", (Object)Integer.valueOf(((OsdConfigRespond.OsdName)texts.get(i)).getPos().getTextY()));
            osd.put("pos", (Object)pos);
            if (i == 0) {
                channelOsdInfo.put("name", (Object)osd);
                continue;
            }
            channelOsdInfo.put("osd" + i, (Object)osd);
        }
        JSONObject data = new JSONObject();
        JSONObject channelInfo = new JSONObject();
        channelInfo.put(channelCode, (Object)channelOsdInfo);
        data.put("channel_info", (Object)channelInfo);
        JSONObject jsonReq = new JSONObject();
        jsonReq.put("data", (Object)data);
        return jsonReq;
    }

    public ColorConfigRespond colorConfigConvert(JSONObject colorConfig) {
        ColorConfigRespond rsp = new ColorConfigRespond();
        rsp.setHue(colorConfig.getIntValue("hue"));
        rsp.setBright(colorConfig.getIntValue("bright"));
        rsp.setContrast(colorConfig.getIntValue("contrast"));
        rsp.setSaturation(colorConfig.getIntValue("saturation"));
        rsp.setSharpness(colorConfig.getIntValue("sharpness"));
        rsp.setSupportDefault(colorConfig.getBoolean("support_default"));
        return rsp;
    }

    public JSONObject colorConfigRequestConvert(ColorConfigRequest request) {
        JSONObject channel = new JSONObject();
        channel.put("hue", (Object)request.getColorConfig().getHue());
        channel.put("bright", (Object)request.getColorConfig().getBright());
        channel.put("contrast", (Object)request.getColorConfig().getContrast());
        channel.put("saturation", (Object)request.getColorConfig().getSaturation());
        channel.put("sharpness", (Object)request.getColorConfig().getSharpness());
        JSONObject channelInfo = new JSONObject();
        channelInfo.put(request.getChannelCode(), (Object)channel);
        JSONObject data = new JSONObject();
        data.put("channel_info", (Object)channelInfo);
        JSONObject jsonReq = new JSONObject();
        jsonReq.put("data", (Object)data);
        return jsonReq;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E eTemplate, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(eTemplate);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

