/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.StreamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.StreamConfigRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.device.ChannelRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.request.cu.device.CameraV2Request;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.respond.cu.device.CameraV2Respond;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceConfigManageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.DeviceManageNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.FaceRepositoryServiceNvr800Impl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceConfigManageNvr800ServiceImpl
extends AbstractNvr800Service
implements DeviceConfigManageService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaceRepositoryServiceNvr800Impl.class);
    @Autowired
    private DeviceManageNvr800ServiceImpl deviceManageNvr800Service;

    public CameraV2Respond getBaseConfig(ParamBean<CameraRequest> obj) {
        List respondList = this.deviceManageNvr800Service.listCamera(obj.getVcmInfo());
        CameraV2Respond respond = new CameraV2Respond();
        for (CameraRespond cameraRespond : respondList) {
            if (!((CameraRequest)obj.getRequestBody()).getCameraCode().equals(cameraRespond.getCameraCode())) continue;
            respond.setCameraCode(cameraRespond.getCameraCode());
            respond.setCameraName(cameraRespond.getCameraName());
            respond.setConnectCode(cameraRespond.getConnectCode());
            respond.setDomainCode(cameraRespond.getDomainCode());
            respond.setIp(cameraRespond.getIp());
            respond.setPort(String.valueOf(cameraRespond.getPort()));
            respond.setModel(cameraRespond.getModel());
            respond.setVendor(cameraRespond.getVendor());
            respond.setProtocolType(cameraRespond.getProtocolType());
            respond.setUserName(cameraRespond.getUserName());
            respond.setCategory(Integer.valueOf(DeviceTypeEnum.NVR800.val()));
            respond.setCanModifyPwd(cameraRespond.getCanModifyPwd());
            respond.setModifyAllPwd(cameraRespond.getModifyAllPwd());
            String cameraType = "1";
            if ("DOME".equals(cameraRespond.getCameraType())) {
                cameraType = "2";
            } else if ("HALFDOME".equals(cameraRespond.getCameraType())) {
                cameraType = "3";
            } else if ("BULLET".equals(cameraRespond.getCameraType())) {
                cameraType = "4";
            }
            respond.setCameraType(cameraType);
            return respond;
        }
        throw new InvokeException("500", "object_not_exist");
    }

    public JSONObject getTimeConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public CameraV2Respond getCameraBaseConfig(ParamBean<CameraRequest> obj) {
        List respondList = this.deviceManageNvr800Service.listCamera(obj.getVcmInfo());
        CameraV2Respond respond = new CameraV2Respond();
        for (CameraRespond cameraRespond : respondList) {
            if (!((CameraRequest)obj.getRequestBody()).getCameraCode().equals(cameraRespond.getCameraCode())) continue;
            respond.setCameraCode(cameraRespond.getCameraCode());
            respond.setCameraName(cameraRespond.getCameraName());
            respond.setConnectCode(cameraRespond.getConnectCode());
            respond.setDomainCode(cameraRespond.getDomainCode());
            respond.setIp(cameraRespond.getIp());
            respond.setPort(String.valueOf(cameraRespond.getPort()));
            respond.setModel(cameraRespond.getModel());
            respond.setVendor(cameraRespond.getVendor());
            respond.setProtocolType(cameraRespond.getProtocolType());
            respond.setUserName(cameraRespond.getUserName());
            respond.setCategory(Integer.valueOf(DeviceTypeEnum.NVR800.val()));
            String cameraType = "1";
            if ("DOME".equals(cameraRespond.getCameraType())) {
                cameraType = "2";
            } else if ("HALFDOME".equals(cameraRespond.getCameraType())) {
                cameraType = "3";
            } else if ("BULLET".equals(cameraRespond.getCameraType())) {
                cameraType = "4";
            }
            respond.setCameraType(cameraType);
            return respond;
        }
        throw new InvokeException("500", "object_not_exist");
    }

    public Boolean setCameraBaseConfig(ParamBean<CameraV2Request> obj) {
        CameraV2Request request = (CameraV2Request)obj.getRequestBody();
        JSONObject paramObject = new JSONObject();
        String cameraType = "fixed_bullet";
        if ("2".equals(request.getCameraType())) {
            cameraType = "dome";
        } else if ("3".equals(request.getCameraType())) {
            cameraType = "ball";
        } else if ("4".equals(request.getCameraType())) {
            cameraType = "bullet";
        }
        paramObject.put("camera_type", (Object)cameraType);
        JSONObject channelObject = new JSONObject();
        String code = request.getCameraCode();
        if (code.contains("#")) {
            code = code.split("#")[0];
        }
        channelObject.put(code, (Object)paramObject);
        JSONObject operationObject = new JSONObject();
        operationObject.put("operation_type", (Object)"AddOrEditChannel");
        operationObject.put("channel_info", (Object)channelObject);
        JSONObject dataObject = new JSONObject();
        dataObject.put("data", (Object)operationObject);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SET_CHANNEL_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("NVR 800 set camera base config error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONObject getCameraStreamConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public JSONObject getCameraOSDConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public JSONObject getCameraAudioConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public JSONObject getCameraAlarmInConfig(ParamBean<CameraRequest> obj) {
        JSONObject alarmInConfig = new JSONObject();
        try {
            JSONObject dataObject = new JSONObject();
            JSONObject alarmObject = new JSONObject();
            JSONArray alarmArray = new JSONArray();
            alarmArray.add((Object)((CameraRequest)obj.getRequestBody()).getCameraCode());
            alarmObject.put("alarm_in", (Object)alarmArray);
            dataObject.put("data", (Object)alarmObject);
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestJsonOrder((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.IO_ALARM_PARAMETERS_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            if (rsp.getJSONObject("data").containsKey((Object)"channel_info") && Objects.nonNull(rsp.getJSONObject("data").getJSONObject("channel_info"))) {
                for (String s : rsp.getJSONObject("data").getJSONObject("channel_info").keySet()) {
                    JSONObject channelInfo = rsp.getJSONObject("data").getJSONObject("channel_info").getJSONObject(s);
                    alarmInConfig.put("alarmInName", (Object)s);
                    if ("NormallyClose".equals(channelInfo.getString("alarm_type"))) {
                        alarmInConfig.put("switchType", (Object)0);
                    } else if ("NormallyOpen".equals(channelInfo.getString("alarm_type"))) {
                        alarmInConfig.put("switchType", (Object)1);
                    } else if ("Off".equals(channelInfo.getString("alarm_type"))) {
                        alarmInConfig.put("switchType", (Object)2);
                    }
                    alarmInConfig.put("autoClearAlarmTime", (Object)channelInfo.getInteger("detect_interval"));
                    alarmInConfig.put("alarmPlanList", (Object)channelInfo.getJSONArray("alarm_plan_list"));
                }
            }
        }
        catch (SDKException e) {
            LOGGER.error("NVR 800 getCameraAlarmInConfig error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return alarmInConfig;
    }

    public Boolean setCameraAlarmInConfig(ParamBean<CameraRequest> obj) {
        try {
            CameraRequest.AlarmInConfig alarmInConfig = ((CameraRequest)obj.getRequestBody()).getAlarmInConfig();
            JSONObject alarmIn = new JSONObject();
            alarmIn.put("alarm_plan_list", (Object)alarmInConfig.getAlarmPlanList());
            alarmIn.put("detect_interval", (Object)alarmInConfig.getAutoClearAlarmTime());
            if (alarmInConfig.getSwitchType() == 0) {
                alarmIn.put("alarm_type", (Object)"NormallyClose");
            } else if (alarmInConfig.getSwitchType() == 1) {
                alarmIn.put("alarm_type", (Object)"NormallyOpen");
            } else if (alarmInConfig.getSwitchType() == 2) {
                alarmIn.put("alarm_type", (Object)"Off");
            }
            JSONObject linkageInfo = new JSONObject();
            linkageInfo.put(((CameraRequest)obj.getRequestBody()).getCameraCode(), (Object)alarmIn);
            JSONObject channelInfo = new JSONObject();
            channelInfo.put("channel_info", (Object)linkageInfo);
            JSONObject dataObject = new JSONObject();
            dataObject.put("data", (Object)channelInfo);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.IO_ALARM_PARAMETERS_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
        }
        catch (SDKException e) {
            LOGGER.error("NVR 800 setCameraAlarmInConfig error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return true;
    }

    public JSONObject getCameraAlarmOutConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public Boolean setCameraAlarmOutConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public StreamBean getMainStreamConfig(ParamBean<ChannelRequest> obj) {
        return this.getStreamConfig(obj, Nvr800MsgType.MAIN_STREAM_GET);
    }

    public StreamBean getSubStreamConfig(ParamBean<ChannelRequest> obj) {
        return this.getStreamConfig(obj, Nvr800MsgType.SUB_STREAM_GET);
    }

    private StreamBean getStreamConfig(ParamBean<ChannelRequest> obj, Nvr800MsgType msgType) {
        String channelCode = ((ChannelRequest)obj.getRequestBody()).getChannelCode();
        ChannelRequestNvr800 requestNvr800 = new ChannelRequestNvr800(channelCode);
        try {
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)msgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            JSONObject channelInfo = respondNvr800.getData().getJSONObject("channel_info").getJSONObject(channelCode);
            StreamBean streamBean = (StreamBean)JsonUtil.convertJsonToBean((String)channelInfo.toJSONString(), StreamBean.class).get();
            streamBean.setChannelCode(channelCode);
            if (StringUtils.isEmpty((CharSequence)streamBean.getResolution())) {
                streamBean.setResolution("");
            }
            if (StringUtils.isEmpty((CharSequence)streamBean.getVideoEncodeType())) {
                streamBean.setVideoEncodeType("");
            }
            Nvr800MsgType rangeMsgType = msgType.getUri().contains("MainStream") ? Nvr800MsgType.CHANNEL_MAIN_STREAM_RANGE : Nvr800MsgType.CHANNEL_SUB_STREAM_RANGE;
            CommonRespondNvr800 rangeRespond = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)rangeMsgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rangeRespond);
            JSONObject rangeObject = rangeRespond.getData().getJSONObject("channel_info").getJSONObject("items").getJSONObject(channelCode).getJSONObject("items");
            StreamBean.StreamRange streamRange = new StreamBean.StreamRange();
            ArrayList<Integer> fpsRangeList = new ArrayList<Integer>();
            ArrayList<String> resolutionRangeList = new ArrayList<String>();
            ArrayList<Integer> bitRateRangeList = new ArrayList<Integer>();
            ArrayList<String> videoEncodeTypeRangeList = new ArrayList<String>();
            JSONArray streamArray = rangeObject.getJSONObject("streaminfo").getJSONArray("items");
            if (!CollectionUtils.isEmpty((Collection)streamArray)) {
                int i;
                for (i = 0; i < streamArray.getJSONObject(0).getJSONObject("fps").getJSONArray("ranges").getJSONArray(0).size(); ++i) {
                    fpsRangeList.add(streamArray.getJSONObject(0).getJSONObject("fps").getJSONArray("ranges").getJSONArray(0).getIntValue(i));
                }
                videoEncodeTypeRangeList.add("H.264");
                videoEncodeTypeRangeList.add("H.265");
                for (i = 0; i < streamArray.getJSONObject(0).getJSONObject("bitrate").getJSONArray("ranges").getJSONArray(0).size(); ++i) {
                    bitRateRangeList.add(streamArray.getJSONObject(0).getJSONObject("bitrate").getJSONArray("ranges").getJSONArray(0).getIntValue(i));
                }
                for (i = 0; i < streamArray.size(); ++i) {
                    for (int j = 0; j < streamArray.getJSONObject(i).getJSONObject("resolution").getJSONArray("items").size(); ++j) {
                        if (resolutionRangeList.contains(streamArray.getJSONObject(i).getJSONObject("resolution").getJSONArray("items").getString(j))) continue;
                        resolutionRangeList.add(streamArray.getJSONObject(i).getJSONObject("resolution").getJSONArray("items").getString(j));
                    }
                }
            } else {
                resolutionRangeList.add("720*576");
                resolutionRangeList.add("1280*720");
                resolutionRangeList.add("1920*1080");
                fpsRangeList.add(15);
                fpsRangeList.add(20);
                fpsRangeList.add(25);
                bitRateRangeList.add(512);
                bitRateRangeList.add(1024);
                bitRateRangeList.add(2048);
                videoEncodeTypeRangeList.add("H.264");
                videoEncodeTypeRangeList.add("H.265");
            }
            streamRange.setVideoEncodeTypeRange(videoEncodeTypeRangeList);
            streamBean.setRange(streamRange);
            streamRange.setBitRateRange(bitRateRangeList);
            streamRange.setResolutionRange(resolutionRangeList);
            streamRange.setFpsRange(fpsRangeList);
            return streamBean;
        }
        catch (SDKException e) {
            LOGGER.error("set stream happen exception", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setMainStreamConfig(ParamBean<StreamBean> obj) {
        return this.setStreamConfig(obj, Nvr800MsgType.MAIN_STREAM_SET);
    }

    public boolean setSubStreamConfig(ParamBean<StreamBean> obj) {
        return this.setStreamConfig(obj, Nvr800MsgType.SUB_STREAM_SET);
    }

    private boolean setStreamConfig(ParamBean<StreamBean> obj, Nvr800MsgType msgType) {
        StreamConfigRequestNvr800 requestNvr800 = new StreamConfigRequestNvr800((StreamBean)obj.getRequestBody());
        try {
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)msgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set stream happen exception ", (Throwable)e);
            if (StringUtils.isNotBlank((CharSequence)e.getMessage()) && e.getMessage().contains("ch_error_code")) {
                JSONObject resultObject = JSONObject.parseObject((String)e.getMessage());
                JSONArray errorCodeArray = resultObject.getJSONArray("ch_error_code");
                if (!CollectionUtils.isEmpty((Collection)errorCodeArray)) {
                    for (int i = 0; i < errorCodeArray.size(); ++i) {
                        JSONObject errorCodeObject = errorCodeArray.getJSONObject(i);
                        if (!((StreamBean)obj.getRequestBody()).getChannelCode().equals(errorCodeObject.getString("channel"))) continue;
                        throw new InvokeException("500", errorCodeObject.getString("error_code"));
                    }
                } else {
                    throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
                }
                return true;
            }
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E eTemplate, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(eTemplate);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

