/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.crowdsituation.CrossCountingRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.crowdsituation.HeatMapRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.crowdsituation.CrossCountingRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.device.ChannelListRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.crowdSituation.CrossCountingGetRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.crowdSituation.HeatMapRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.CrowdSituationIntelligentService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="crowdSituationIntelligentNvr800Service")
public class CrowdSituationIntelligentNvr800ServiceImpl
extends AbstractNvr800Service
implements CrowdSituationIntelligentService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrowdSituationIntelligentNvr800ServiceImpl.class);

    public List<HeatMapRespond> getHeatMapConfig(ParamBean<HeatMapRequest> obj) {
        ArrayList<HeatMapRespond> respondList = new ArrayList<HeatMapRespond>();
        JSONObject configJson = this.getHeatMapConfigJson(obj);
        for (String key : configJson.keySet()) {
            JSONObject channelObject = configJson.getJSONObject(key);
            HeatMapRespond heatMapRespond = new HeatMapRespond();
            heatMapRespond.setReason(channelObject.getString("reason"));
            heatMapRespond.setEnableSwitch(channelObject.getBoolean("switch"));
            heatMapRespond.setMetaDataSwitch(channelObject.getBoolean("meta_data_switch"));
            heatMapRespond.setAreaList(channelObject.getJSONArray("area_list"));
            heatMapRespond.setAlarmPlanList(channelObject.getJSONArray("alarm_plan_list"));
            heatMapRespond.setChannelCode(key);
            respondList.add(heatMapRespond);
        }
        return respondList;
    }

    private JSONObject getHeatMapConfigJson(ParamBean<HeatMapRequest> obj) {
        try {
            CommonRespondNvr800 respondNvr800 = Objects.nonNull(obj.getRequestBody()) && Objects.nonNull(((HeatMapRequest)obj.getRequestBody()).getChannelCodeList()) && ((HeatMapRequest)obj.getRequestBody()).getChannelCodeList().size() > 0 ? (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.CROWD_SITUATION_HEAT_MAP_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)new ChannelListRequestNvr800(((HeatMapRequest)obj.getRequestBody()).getChannelCodeList()), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getHeaders(obj.getVcmInfo())) : (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.CROWD_SITUATION_HEAT_MAP_GET, (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return respondNvr800.getData().getJSONObject("channel_info");
        }
        catch (SDKException e) {
            LOGGER.error("get heat map config error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public CrossCountingGetRespond getCrossCounting(ParamBean<CrossCountingRequest> obj) {
        try {
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.CROWD_SITUATION_CROSS_COUNTING_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)new CrossCountingRequestNvr800(((CrossCountingRequest)obj.getRequestBody()).getPageType(), ((CrossCountingRequest)obj.getRequestBody()).getChannelCodeList()), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            CrossCountingGetRespond respond = new CrossCountingGetRespond();
            respond.setChannelInfo(respondNvr800.getData().getJSONObject("channel_info"));
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("get cross counting error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setCrossCounting(ParamBean<CrossCountingRequest> obj) {
        try {
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.CROWD_SITUATION_CROSS_COUNTING_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)new CrossCountingRequestNvr800((CrossCountingRequest)obj.getRequestBody()), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set cross counting error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

