/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.SnapObjectDetailRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.CommonGetImageRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.FaceImageSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.PicturePlaybackRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.CommonGetImageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.People;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.PeopleSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.FaceSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.PicturePlaybackRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.SnapObjectRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.CommonService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.PictureSearchNVR800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.VehicleRepositoryNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.v2.nvr800.impl.FaceRepositoryNvr800V2ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="CommonNvr800ServiceImpl")
public class CommonNvr800ServiceImpl
extends AbstractNvr800Service
implements CommonService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonNvr800ServiceImpl.class);
    @Autowired
    private PictureSearchNVR800ServiceImpl pictureSearchNVR800Service;
    @Autowired
    private VehicleRepositoryNvr800ServiceImpl vehicleRepositoryNvr800Service;
    @Autowired
    private FaceRepositoryNvr800V2ServiceImpl faceRepositoryNvr800V2Service;

    public CommonGetImageRespond getImage(ParamBean<CommonGetImageRequest> obj) {
        CommonGetImageRespond respond = new CommonGetImageRespond();
        CommonGetImageRequest request = (CommonGetImageRequest)obj.getRequestBody();
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        String image = "";
        respond.setImageType(request.getImageType());
        if (StringUtils.isBlank((CharSequence)request.getImageId())) {
            respond.setImage(image);
            return respond;
        }
        if ("historyAlarmBehaviorImage".equals(request.getImageType()) || "historyAlarmEquipmentImage".equals(request.getImageType()) || "historyAlarmSituationAnalysisImage".equals(request.getImageType()) || "historyAlarmThirdAlgorithmImage".equals(request.getImageType())) {
            image = this.getHistoryBehaviorImage(vcmReqBaseInfo, request.getImageId());
        } else if ("historyAlarmFaceImage".equals(request.getImageType())) {
            String[] imageIdArray = request.getImageId().split("#");
            image = imageIdArray.length > 1 ? this.getSnapObjectImage(vcmReqBaseInfo, imageIdArray[0], request.getImageChildType().intValue()) : this.getHistoryFaceImage(vcmReqBaseInfo, imageIdArray[0], request.getImageChildType());
        } else if ("faceGroupImage".equals(request.getImageType())) {
            FaceRequest faceRequest = new FaceRequest();
            faceRequest.getPersonIdList().add(request.getImageId());
            faceRequest.setWithImage(1);
            PeopleSearchRespond searchPeople = this.faceRepositoryNvr800V2Service.searchPeople(vcmReqBaseInfo, faceRequest);
            if (!CollectionUtils.isEmpty((Collection)searchPeople.getPeopleList())) {
                image = ((People)searchPeople.getPeopleList().get(0)).getImage();
            }
        } else if ("historyAlarmVehicleImage".equals(request.getImageType())) {
            String[] imageIdArray = request.getImageId().split("#");
            if (imageIdArray.length > 1) {
                image = this.getSnapObjectImage(vcmReqBaseInfo, imageIdArray[0], request.getImageChildType().intValue());
            } else if (imageIdArray.length == 1) {
                image = this.getHistoryVehicleImage(vcmReqBaseInfo, imageIdArray[0]);
            }
        }
        respond.setImage(image);
        return respond;
    }

    private String getHistoryVehicleImage(VcmReqBaseInfo vcmReqBaseInfo, String s) {
        ParamBean obj = new ParamBean();
        PicturePlaybackRequest playbackRequest = new PicturePlaybackRequest();
        playbackRequest.setPicInfoKey(s);
        obj.setVcmInfo(vcmReqBaseInfo);
        obj.setRequestBody((Object)playbackRequest);
        PicturePlaybackRespond picturePlaybackRespond = this.pictureSearchNVR800Service.picturePlayback(obj);
        return picturePlaybackRespond.getPicture().getImage();
    }

    private String getSnapObjectImage(VcmReqBaseInfo vcmReqBaseInfo, String fileId, int childImageType) {
        SnapObjectDetailRequest request = new SnapObjectDetailRequest();
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(fileId);
        request.setUuids(idList);
        request.setWithBackGround(Integer.valueOf(1));
        request.setWithObjectImage(Integer.valueOf(1));
        SnapObjectRespond respond = this.pictureSearchNVR800Service.getSnapObjectDetailById(vcmReqBaseInfo, request);
        if (childImageType == 1) {
            return respond.getBackgroundImage();
        }
        return respond.getObjectImage();
    }

    private String getHistoryBehaviorImage(VcmReqBaseInfo vcmReqBaseInfo, String fileId) {
        ParamBean requestParamBean = new ParamBean();
        PicturePlaybackRequest request = new PicturePlaybackRequest();
        request.setPicInfoKey(fileId);
        requestParamBean.setVcmInfo(vcmReqBaseInfo);
        requestParamBean.setRequestBody((Object)request);
        PicturePlaybackRespond respond = this.pictureSearchNVR800Service.picturePlayback(requestParamBean);
        String image = respond.getPicture().getImage();
        return StringUtils.isNotEmpty((CharSequence)image) ? image : "";
    }

    private String getHistoryFaceImage(VcmReqBaseInfo vcmReqBaseInfo, String fileId, Integer imageChildType) {
        ParamBean obj = new ParamBean();
        FaceImageSearchRequest request = new FaceImageSearchRequest();
        ArrayList<String> fileIdList = new ArrayList<String>();
        fileIdList.add(fileId);
        request.setFileIds(fileIdList);
        obj.setRequestBody((Object)request);
        obj.setVcmInfo(vcmReqBaseInfo);
        FaceSearchRespond respond = this.pictureSearchNVR800Service.faceImageSearch(obj);
        if (imageChildType == 1) {
            return ((FaceSearchRespond.FaceInfo)respond.getFaceInfos().get(0)).getBackground();
        }
        return ((FaceSearchRespond.FaceInfo)respond.getFaceInfos().get(0)).getFaceImage();
    }

    public CommonGetImageRespond getCaptureByUUId(ParamBean<CommonGetImageRequest> obj) {
        JSONObject data = new JSONObject();
        data.put("Engine", (Object)0);
        data.put("WithObjectImage", (Object)1);
        data.put("WithBackgroud", (Object)1);
        JSONArray UUIdsArray = new JSONArray();
        UUIdsArray.add((Object)((CommonGetImageRequest)obj.getRequestBody()).getFileId());
        data.put("UUIds", (Object)UUIdsArray);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        CommonGetImageRespond result = new CommonGetImageRespond();
        if ("1".equals(((CommonGetImageRequest)obj.getRequestBody()).getImageType()) || "2".equals(((CommonGetImageRequest)obj.getRequestBody()).getImageType())) {
            try {
                CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.VEHICLE_SEARCH_PAGINATION_FOR_UUID, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
                this.checkJsonRespond((JSONObject)JSONObject.toJSON((Object)rsp));
                VehicleRepositorySearchRespond respond = this.vehicleRepositoryNvr800Service.vehicleSearchRspConvert(rsp.getData());
                respond.getVehicleList().forEach(a -> {
                    result.setBackground(a.getBackground());
                    result.setObjectImage(a.getObjectImage());
                });
            }
            catch (SDKException e) {
                LOGGER.error("getCaptureByUUId happen exception ", (Throwable)e);
                throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
            }
        } else if ("0".equals(((CommonGetImageRequest)obj.getRequestBody()).getImageType())) {
            ParamBean rsp = new ParamBean();
            rsp.setVcmInfo(obj.getVcmInfo());
            FaceSearchRespond snapedFacesById = this.pictureSearchNVR800Service.getSnapedFacesById(rsp, data);
            snapedFacesById.getFaceInfos().forEach(a -> {
                result.setBackground(a.getBackground());
                result.setObjectImage(a.getFaceImage());
            });
        }
        return result;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

