/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.IntelligentConfigBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorAreaItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorGetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.IgtAlarmConfigSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.VehicleParameterSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.penetrateRequest.CameraPassThroughInfoIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.penetrateRequest.CameraPassThrouthRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.intelligent.BehaviorGetRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.intelligent.BehaviorRangeGetRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.intelligent.BehaviorSetRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.intelligent.SdcAlarmConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.ThirdAlgorithm;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.ThirdAlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.VehicleParameterRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.BehaviorAlarmPlanItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.BehaviorRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.IgtAlarmConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.penetrateRequest.CameraPassThrouthRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.PerimeterZoneGetRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.BehaviorAnalysisService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="behaviorAnalysisService")
public class BehaviorAnalysisNvr800ServiceImpl
extends AbstractNvr800Service
implements BehaviorAnalysisService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BehaviorAnalysisNvr800ServiceImpl.class);

    public JSONObject getRange(VcmReqBaseInfo vcmReqBaseInfo, Nvr800MsgType nvr800MsgType) {
        JSONObject resultJson = new JSONObject();
        BehaviorRangeGetRequestNvr800 requestNvr800 = new BehaviorRangeGetRequestNvr800("AlarmConfig");
        try {
            String respondNvr800 = (String)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)nvr800MsgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            JSONObject originalConfig = JSONObject.parseObject((String)respondNvr800);
            JSONObject items = originalConfig.getJSONObject("data").getJSONObject("channel_info").getJSONObject("items");
            for (String key : items.keySet()) {
                JSONObject itemJson = items.getJSONObject(key).getJSONObject("items");
                IntelligentConfigBean configBean = new IntelligentConfigBean();
                configBean.setBuzzer(itemJson.getJSONObject("buzzer").getJSONArray("items").toJavaList(Integer.class));
                configBean.setAlarmOut(itemJson.getJSONObject("alarm_out").getJSONObject("items").getJSONArray("items").toJavaList(String.class));
                configBean.setLatchTime(itemJson.getJSONObject("latch_time").getJSONArray("items").toJavaList(Integer.class));
                configBean.setRecordChannel(itemJson.getJSONObject("record_channel").getJSONObject("items").getJSONArray("items").toJavaList(String.class));
                configBean.setPostRecording(itemJson.getJSONObject("post_recording").getJSONArray("items").toJavaList(Integer.class));
                resultJson.put(key, JSONObject.parse((String)JsonUtil.convertBeanToJSON((Object)configBean)));
            }
            return resultJson;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONObject getAlarmConfig(VcmReqBaseInfo vcmReqBaseInfo, List<String> channelCodeList, Nvr800MsgType msgType) {
        BehaviorGetRequestNvr800 requestNvr800 = new BehaviorGetRequestNvr800(channelCodeList, "AlarmConfig");
        try {
            PerimeterZoneGetRespondNvr800 respondNvr800 = (PerimeterZoneGetRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)msgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PerimeterZoneGetRespondNvr800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return respondNvr800.getData().getJSONObject("channel_info");
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONObject getIntelligentConfig(VcmReqBaseInfo vcmReqBaseInfo, List<String> channelCodeList, Nvr800MsgType msgType, String configType) {
        BehaviorGetRequestNvr800 requestNvr800 = new BehaviorGetRequestNvr800(channelCodeList, configType);
        try {
            PerimeterZoneGetRespondNvr800 respondNvr800 = (PerimeterZoneGetRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)msgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PerimeterZoneGetRespondNvr800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return respondNvr800.getData().getJSONObject("channel_info");
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public BehaviorRespond getPerimeterZone(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj, Nvr800MsgType.PERIMETER_ZONE_GET_URI, Nvr800MsgType.PERIMETER_ZONE_RANGE_URI);
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), BehaviorRespond.class);
        return (BehaviorRespond)operateBean.get();
    }

    public BehaviorRespond getPerimeterLine(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj, Nvr800MsgType.PERIMETER_LINE_GET_URI, Nvr800MsgType.PERIMETER_LINE_RANGE_URI);
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), BehaviorRespond.class);
        return (BehaviorRespond)operateBean.get();
    }

    public BehaviorRespond getItemLeave(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj, Nvr800MsgType.PERIMETER_ITEM_LEAVE_GET_URI, Nvr800MsgType.PERIMETER_ITEM_LEAVE_RANGE_URI);
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), BehaviorRespond.class);
        return (BehaviorRespond)operateBean.get();
    }

    public BehaviorRespond getItemMove(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj, Nvr800MsgType.PERIMETER_ITEM_MOVE_GET_URI, Nvr800MsgType.PERIMETER_ITEM_MOVE_RANGE_URI);
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), BehaviorRespond.class);
        return (BehaviorRespond)operateBean.get();
    }

    public boolean setItemLeave(ParamBean<BehaviorSetRequest> obj) {
        return this.setBehavior(obj, Nvr800MsgType.PERIMETER_ITEM_LEAVE_SET_URI);
    }

    public boolean setItemMove(ParamBean<BehaviorSetRequest> obj) {
        return this.setBehavior(obj, Nvr800MsgType.PERIMETER_ITEM_MOVE_SET_URI);
    }

    public boolean setVehicleIllegal(ParamBean<VehicleParameterSetRequest> obj) {
        return this.setVehicleConfigParameter(obj, Nvr800MsgType.PERIMETER_VEHICLE_ILLEGAL_SET_URI, 12);
    }

    public boolean setElectroMobile(ParamBean<BehaviorSetRequest> obj) {
        return this.setBehavior(obj, Nvr800MsgType.PERIMETER_ELECTOR_MOBILE_SET_URI);
    }

    public boolean setVehicleDetect(ParamBean<VehicleParameterSetRequest> obj) {
        return this.setVehicleConfigParameter(obj, Nvr800MsgType.PERIMETER_VEHICLE_DETECT_SET_URI, 60);
    }

    public boolean setVehicleParameter(ParamBean<VehicleParameterSetRequest> obj) {
        return this.setVehicleConfigParameter(obj, Nvr800MsgType.PERIMETER_VEHICLE_PARAMETER_SET_URI, 60);
    }

    public BehaviorRespond getAreaEnter(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj, Nvr800MsgType.AREA_ENTER_GET_URI, Nvr800MsgType.AREA_ENTER_RANGE_URI);
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), BehaviorRespond.class);
        return (BehaviorRespond)operateBean.get();
    }

    public BehaviorRespond getAreaExit(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj, Nvr800MsgType.AREA_EXIT_GET_URI, Nvr800MsgType.AREA_EXIT_RANGE_URI);
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), BehaviorRespond.class);
        return (BehaviorRespond)operateBean.get();
    }

    public BehaviorRespond getLoitering(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj, Nvr800MsgType.LOITERING_GET_URI, Nvr800MsgType.LOITERING_RANGE_URI);
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), BehaviorRespond.class);
        return (BehaviorRespond)operateBean.get();
    }

    public BehaviorRespond getFastMovement(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj, Nvr800MsgType.FAST_MOVEMENT_GET_URI, Nvr800MsgType.FAST_MOVEMENT_RANGE_URI);
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), BehaviorRespond.class);
        return (BehaviorRespond)operateBean.get();
    }

    public IgtAlarmConfigRespond getIgtAlarmConfig(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj, Nvr800MsgType.IGT_ALARM_CONFIG_GET_URI, null);
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), IgtAlarmConfigRespond.class);
        return (IgtAlarmConfigRespond)operateBean.get();
    }

    private JSONObject getBehavior(ParamBean<BehaviorGetRequest> obj, Nvr800MsgType configNvr800MsgType, Nvr800MsgType rangeNvr800MsgType) {
        String channelCode = ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode();
        BehaviorGetRequestNvr800 requestNvr800 = new BehaviorGetRequestNvr800(channelCode, ((BehaviorGetRequest)obj.getRequestBody()).getPageType());
        try {
            PerimeterZoneGetRespondNvr800 respondNvr800 = (PerimeterZoneGetRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)configNvr800MsgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PerimeterZoneGetRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()), (int)20);
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            if (respondNvr800.getData() != null && respondNvr800.getData().getJSONObject("channel_info") != null) {
                JSONObject jsonObject = respondNvr800.getData().getJSONObject("channel_info").getJSONObject(channelCode);
                if (rangeNvr800MsgType != null && "AlarmConfig".equals(((BehaviorGetRequest)obj.getRequestBody()).getPageType())) {
                    jsonObject.put("range", (Object)this.getRange(obj, rangeNvr800MsgType));
                }
                return jsonObject;
            }
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private JSONObject getRange(ParamBean<BehaviorGetRequest> obj, Nvr800MsgType rangeNvr800MsgType) {
        JSONObject resultJson = new JSONObject();
        BehaviorRangeGetRequestNvr800 requestNvr800 = new BehaviorRangeGetRequestNvr800(((BehaviorGetRequest)obj.getRequestBody()).getPageType());
        try {
            String respondNvr800 = (String)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)rangeNvr800MsgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            JSONObject originalConfig = JSONObject.parseObject((String)respondNvr800);
            JSONObject items = originalConfig.getJSONObject("data").getJSONObject("channel_info").getJSONObject("items");
            for (String key : items.keySet()) {
                JSONObject itemJson = items.getJSONObject(key).getJSONObject("items");
                IntelligentConfigBean configBean = new IntelligentConfigBean();
                configBean.setBuzzer(itemJson.getJSONObject("buzzer").getJSONArray("items").toJavaList(Integer.class));
                configBean.setAlarmOut(itemJson.getJSONObject("alarm_out").getJSONObject("items").getJSONArray("items").toJavaList(String.class));
                configBean.setLatchTime(itemJson.getJSONObject("latch_time").getJSONArray("items").toJavaList(Integer.class));
                configBean.setRecordChannel(itemJson.getJSONObject("record_channel").getJSONObject("items").getJSONArray("items").toJavaList(String.class));
                configBean.setPostRecording(itemJson.getJSONObject("post_recording").getJSONArray("items").toJavaList(Integer.class));
                resultJson.put(key, JSONObject.parse((String)JsonUtil.convertBeanToJSON((Object)configBean)));
            }
            return resultJson;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setPerimeterZone(ParamBean<BehaviorSetRequest> obj) {
        return this.setBehavior(obj, Nvr800MsgType.PERIMETER_ZONE_SET_URI);
    }

    public boolean setPerimeterLine(ParamBean<BehaviorSetRequest> obj) {
        return this.setBehavior(obj, Nvr800MsgType.PERIMETER_LINE_SET_URI);
    }

    public boolean setAreaEnter(ParamBean<BehaviorSetRequest> obj) {
        return this.setBehavior(obj, Nvr800MsgType.AREA_ENTER_SET_URI);
    }

    public boolean setAreaExit(ParamBean<BehaviorSetRequest> obj) {
        return this.setBehavior(obj, Nvr800MsgType.AREA_EXIT_SET_URI);
    }

    public boolean setLoitering(ParamBean<BehaviorSetRequest> obj) {
        return this.setBehavior(obj, Nvr800MsgType.LOITERING_SET_URI);
    }

    public boolean setFastMovement(ParamBean<BehaviorSetRequest> obj) {
        return this.setBehavior(obj, Nvr800MsgType.FAST_MOVEMENT_SET_URI);
    }

    public boolean setIgtAlarmConfig(ParamBean<IgtAlarmConfigSetRequest> obj) {
        IgtAlarmConfigSetRequest request = (IgtAlarmConfigSetRequest)obj.getRequestBody();
        BehaviorSetRequestNvr800 requestNvr800 = new BehaviorSetRequestNvr800(request.getChannelCode(), request.getPageType(), JsonUtil.convertBeanToJSON((Object)request));
        try {
            BaseRespondNvr800 respondNvr800 = (BaseRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.IGT_ALARM_CONFIG_SET_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond(respondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private boolean setBehavior(ParamBean<BehaviorSetRequest> obj, Nvr800MsgType nvr800MsgType) {
        BehaviorSetRequest request = (BehaviorSetRequest)obj.getRequestBody();
        BehaviorSetRequestNvr800 requestNvr800 = new BehaviorSetRequestNvr800(request.getChannelCode(), request.getPageType(), JsonUtil.convertBeanToJSON((Object)request));
        try {
            BaseRespondNvr800 respondNvr800 = (BaseRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)nvr800MsgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()), (int)20);
            this.checkRespond(respondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private boolean setVehicleConfigParameter(ParamBean<VehicleParameterSetRequest> obj, Nvr800MsgType nvr800MsgType, int timeOut) {
        VehicleParameterSetRequest request = (VehicleParameterSetRequest)obj.getRequestBody();
        BehaviorSetRequestNvr800 requestNvr800 = new BehaviorSetRequestNvr800(request.getChannelCode(), request.getPageType(), JsonUtil.convertBeanToJSON((Object)request));
        try {
            BaseRespondNvr800 respondNvr800 = (BaseRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)nvr800MsgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()), (int)timeOut);
            this.checkRespond(respondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private JSONObject getBehavior(VcmReqBaseInfo vcmReqBaseInfo, String channelCode, String configSdcType) {
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(channelCode);
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("GET " + configSdcType);
        passThrouthRequestIvs1800.setInfo(infoIvs1800);
        try {
            CameraPassThrouthRespondIvs1800 respondIvs1800 = (CameraPassThrouthRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.DEVICE_REQUEST_PASSTHROUGH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)passThrouthRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraPassThrouthRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            JSONArray jsonArray = JSONObject.parseArray((String)respondIvs1800.getResultInfo());
            if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject returnJson = (JSONObject)jsonArray.get(0);
            if (returnJson.getString("Data").startsWith("[")) {
                return (JSONObject)returnJson.getJSONArray("Data").get(0);
            }
            if (returnJson.getInteger("RspCode") == 0 && !returnJson.getJSONObject("Data").containsKey((Object)"ResponseStatus")) {
                return returnJson.getJSONObject("Data");
            }
            if (returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getInteger("StatusCode") == 3) {
                throw new InvokeException("500", "cu_not_supported_error");
            }
            throw new InvokeException("500", returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getString("StatusString"));
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private List<BehaviorAlarmPlanItemRespond> getBehaviorAlarmPlan(JSONObject alarmPlan) {
        SdcAlarmConfigRespond.SdcAlarmParam sdcAlarmParam;
        ArrayList<BehaviorAlarmPlanItemRespond> behaviorAlarmPlanItemResponds = new ArrayList<BehaviorAlarmPlanItemRespond>();
        SdcAlarmConfigRespond alarmConfigRespond = (SdcAlarmConfigRespond)JsonUtil.convertJsonToBean((String)alarmPlan.toJSONString(), SdcAlarmConfigRespond.class).get();
        List alarmParam = alarmConfigRespond.getAlarmParam();
        if (!CollectionUtils.isEmpty((Collection)alarmParam) && !CollectionUtils.isEmpty((Collection)(sdcAlarmParam = (SdcAlarmConfigRespond.SdcAlarmParam)alarmParam.get(0)).getGuardTime())) {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
            format.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            for (SdcAlarmConfigRespond.SdcAlarmParam.GuardAlarmTime guardAlarmTime : sdcAlarmParam.getGuardTime()) {
                BehaviorAlarmPlanItemRespond behaviorAlarmPlanItem = new BehaviorAlarmPlanItemRespond();
                behaviorAlarmPlanItem.setStartTime(format.format(guardAlarmTime.getStartTime() * 1000));
                behaviorAlarmPlanItem.setEndTime(format.format((guardAlarmTime.getEndTime() == 86400 ? 86399 : guardAlarmTime.getEndTime()) * 1000));
                behaviorAlarmPlanItem.setCycleType(guardAlarmTime.getCycle().intValue());
                Integer newPeriod = this.changePeriod(guardAlarmTime.getPeriod());
                behaviorAlarmPlanItem.setPeriod(newPeriod == null ? 0 : newPeriod);
                behaviorAlarmPlanItem.setStartDate(LocalDate.now() + "");
                behaviorAlarmPlanItemResponds.add(behaviorAlarmPlanItem);
            }
            return behaviorAlarmPlanItemResponds;
        }
        return new ArrayList<BehaviorAlarmPlanItemRespond>();
    }

    private Integer changePeriod(Integer period) {
        Integer newPeriod = null;
        switch (period) {
            case 127: {
                newPeriod = 0;
                break;
            }
            case 1: {
                newPeriod = 1;
                break;
            }
            case 2: {
                newPeriod = 2;
                break;
            }
            case 4: {
                newPeriod = 3;
                break;
            }
            case 8: {
                newPeriod = 4;
                break;
            }
            case 16: {
                newPeriod = 5;
                break;
            }
            case 32: {
                newPeriod = 6;
                break;
            }
            case 64: {
                newPeriod = 7;
            }
        }
        return newPeriod;
    }

    private String changeRecongnizeModeToString(Integer targetRecMode) {
        String recongnizeMode = null;
        switch (targetRecMode) {
            case 0: {
                recongnizeMode = "Center";
                break;
            }
            case 1: {
                recongnizeMode = "Bottom";
                break;
            }
            case 2: {
                recongnizeMode = "Top";
                break;
            }
        }
        return recongnizeMode;
    }

    private List<String> getDetectType(Integer objFilterFlag) {
        String[] detect = new String[]{"Pedestrian", "Vehicle", "NonVehicle"};
        ArrayList<String> detectType = new ArrayList<String>();
        if (objFilterFlag == 1) {
            detectType.add(detect[0]);
        } else if (objFilterFlag == 2) {
            detectType.add(detect[1]);
        } else if (objFilterFlag == 4) {
            detectType.add(detect[2]);
        } else if (objFilterFlag == 3) {
            detectType.add(detect[0]);
            detectType.add(detect[1]);
        } else if (objFilterFlag == 5) {
            detectType.add(detect[0]);
            detectType.add(detect[2]);
        } else if (objFilterFlag == 6) {
            detectType.add(detect[1]);
            detectType.add(detect[2]);
        } else if (objFilterFlag == 7) {
            detectType.add(detect[0]);
            detectType.add(detect[1]);
            detectType.add(detect[2]);
        }
        return detectType;
    }

    public VehicleParameterRespond getVehicleIllegal(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj, Nvr800MsgType.PERIMETER_VEHICLE_ILLEGAL_GET_URI, Nvr800MsgType.PERIMETER_VEHICLE_ILLEGAL_RANGE_URI);
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), VehicleParameterRespond.class);
        return (VehicleParameterRespond)operateBean.get();
    }

    public VehicleParameterRespond getVehicleParameter(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj, Nvr800MsgType.PERIMETER_VEHICLE_PARAMETER_GET_URI, Nvr800MsgType.PERIMETER_VEHICLE_PARAMETER_RANGE_URI);
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), VehicleParameterRespond.class);
        return (VehicleParameterRespond)operateBean.get();
    }

    public BehaviorRespond getElectroMobile(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj, Nvr800MsgType.PERIMETER_ELECTOR_MOBILE_GET_URI, Nvr800MsgType.PERIMETER_ELECTOR_MOBILE_RANGE_URI);
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), BehaviorRespond.class);
        BehaviorRespond behaviorRespond = (BehaviorRespond)operateBean.get();
        if (!CollectionUtils.isEmpty((Collection)behaviorRespond.getAreaList()) && ((BehaviorAreaItemRespond)behaviorRespond.getAreaList().get(0)).getPointList().size() == 0) {
            behaviorRespond.setAreaList(new ArrayList());
        }
        return behaviorRespond;
    }

    public VehicleParameterRespond getVehicleDetect(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj, Nvr800MsgType.PERIMETER_VEHICLE_DETECT_GET_URI, Nvr800MsgType.PERIMETER_VEHICLE_DETECT_RANGE_URI);
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), VehicleParameterRespond.class);
        return (VehicleParameterRespond)operateBean.get();
    }

    public ThirdAlgorithmRespond thirdAlgorithm(VcmReqBaseInfo vcmInfo) {
        return null;
    }

    public ThirdAlgorithmRespond thirdalgorithmParam(VcmReqBaseInfo vcmInfo, ThirdAlgorithm request) {
        return null;
    }

    public Boolean updateThirdalgorithmParam(VcmReqBaseInfo vcmInfo, ThirdAlgorithm request) {
        return null;
    }

    public BehaviorRespond getParkDetect(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj, Nvr800MsgType.PARKING_DETECT_GET, Nvr800MsgType.PARKING_DETECT_RANGE_GET);
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), BehaviorRespond.class);
        BehaviorRespond behaviorRespond = (BehaviorRespond)operateBean.get();
        behaviorRespond.setUlRemainTime(behaviorRespond.getParkingTime());
        behaviorRespond.setToleranceTime(behaviorRespond.getParkingTime());
        if (!CollectionUtils.isEmpty((Collection)behaviorRespond.getAreaList()) && ((BehaviorAreaItemRespond)behaviorRespond.getAreaList().get(0)).getPointList().size() == 0) {
            behaviorRespond.setAreaList(new ArrayList());
        }
        return behaviorRespond;
    }

    public boolean setParkDetect(ParamBean<BehaviorSetRequest> obj) {
        BehaviorSetRequest requestBody = (BehaviorSetRequest)obj.getRequestBody();
        requestBody.setParkingTime(requestBody.getToleranceTime());
        obj.setRequestBody((Object)requestBody);
        return this.setBehavior(obj, Nvr800MsgType.PARKING_DETECT_SET);
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

