/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.AlarmDealRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.AlarmSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.SnapObjectRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.FaceImageSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.FaceSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.PicturePlaybackRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.PageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.DetectObjectBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.GeneralBusinessBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.HisBehaviorBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.HisFaceBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.HisVehicleBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.SituationAnalysisBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.ThirdAlgorithmBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmSearch.AlarmSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepository;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.People;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.PeopleSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.FaceSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.PicturePlaybackRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.SnapObjectRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.websocket.SubscriptionRequest;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmCodeTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmLevelEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.AlarmService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.BehaviorAnalysisNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.EventGetThread;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.FaceRepositoryServiceNvr800Impl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.PictureSearchNVR800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.v2.nvr800.impl.FaceRepositoryNvr800V2ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.EventNameHelper;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.ReflectionUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="SubscriptionNvr800Service")
public class AlarmNvr800ServiceImpl
extends AbstractNvr800Service
implements AlarmService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmNvr800ServiceImpl.class);
    @Autowired
    private SubscriptionHelp subscriptionHelp;
    @Autowired
    private PictureSearchNVR800ServiceImpl pictureSearchNVR800Service;
    @Autowired
    private FaceRepositoryServiceNvr800Impl faceRepositoryServiceNvr800;
    @Autowired
    private FaceRepositoryNvr800V2ServiceImpl faceRepositoryNvr800V2Service;
    @Autowired
    private BehaviorAnalysisNvr800ServiceImpl behaviorAnalysisNvr800Service;

    public boolean subscribe(ParamBean<SubscriptionRequest> obj) {
        if (this.subscriptionHelp.get(((SubscriptionRequest)obj.getRequestBody()).getDomainCode()) == null) {
            this.subscriptionHelp.add(((SubscriptionRequest)obj.getRequestBody()).getDomainCode(), obj.getVcmInfo(), null);
            EventGetThread eventGetThread = new EventGetThread(((SubscriptionRequest)obj.getRequestBody()).getDomainCode(), obj.getVcmInfo().getVcmIp());
            eventGetThread.start();
            SubscriptionHelp.updateThread((String)((SubscriptionRequest)obj.getRequestBody()).getDomainCode(), (EventGetThread)eventGetThread);
        } else {
            this.subscriptionHelp.add(((SubscriptionRequest)obj.getRequestBody()).getDomainCode(), obj.getVcmInfo(), null);
        }
        return true;
    }

    public boolean delSubscribe(ParamBean<SubscriptionRequest> obj) {
        this.subscriptionHelp.remove(((SubscriptionRequest)obj.getRequestBody()).getDomainCode());
        SubscriptionHelp.removeThread((String)((SubscriptionRequest)obj.getRequestBody()).getDomainCode());
        return true;
    }

    public boolean register(VcmReqBaseInfo vcmReqBaseInfo, String url) {
        return false;
    }

    public String getRegisterUrlList(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public boolean confirm(ParamBean<AlarmDealRequest> obj) {
        return true;
    }

    public boolean cancel(ParamBean<AlarmDealRequest> obj) {
        return true;
    }

    public PageRespond<AlarmSearchRespond> search(ParamBean<AlarmSearchRequest> obj) {
        AlarmSearchRequest request = (AlarmSearchRequest)obj.getRequestBody();
        if (CollectionUtils.isEmpty((Collection)request.getAlarmTypeList())) {
            throw new InvokeException("500", "param_error");
        }
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        if (Nvr800Utils.NVR_NOT_SUPPORT_ALARM.contains(request.getAlarmTypeList().get(0))) {
            throw new InvokeException("500", "cu_device_not_support");
        }
        int fromIndex = request.getPage() == 1 ? 0 : (request.getPage() - 1) * request.getPageSize();
        int toIndex = request.getPage() * request.getPageSize();
        if ("0".equals(request.getType())) {
            if ("ALARM_PERSON".equals(request.getAlarmTypeList().get(0))) {
                return this.getSnapObjectAlarm(request, vcmReqBaseInfo, fromIndex, 1);
            }
            if ("ALARM_FACE_MASK".equals(request.getAlarmTypeList().get(0)) || "REPEAT_VISITOR".equals(request.getAlarmTypeList().get(0))) {
                return this.getFaceMaskAlarm(request, vcmReqBaseInfo, fromIndex);
            }
            return this.getFaceHistoryAlarm(request, vcmReqBaseInfo, fromIndex);
        }
        if ("2".equals(request.getType()) || "3".equals(request.getType()) || "4".equals(request.getType()) || "5".equals(request.getType())) {
            return this.getOtherHistoryAlarm(request, vcmReqBaseInfo, fromIndex, toIndex);
        }
        if ("1".equals(request.getType())) {
            if ("ALARM_VEHICLE_DETECTION".equals(request.getAlarmTypeList().get(0))) {
                return this.getSnapObjectAlarm(request, vcmReqBaseInfo, fromIndex, 2);
            }
            if ("ALARM_NON_VEHICLE_DETECTION".equals(request.getAlarmTypeList().get(0))) {
                return this.getSnapObjectAlarm(request, vcmReqBaseInfo, fromIndex, 7);
            }
            if ("ALARM_VE_ILLEGAL_PARKING".equals(request.getAlarmTypeList().get(0))) {
                return this.getOtherHistoryAlarm(request, vcmReqBaseInfo, fromIndex, toIndex);
            }
        }
        return new PageRespond();
    }

    private PageRespond<AlarmSearchRespond> getFaceMaskAlarm(AlarmSearchRequest request, VcmReqBaseInfo vcmReqBaseInfo, int fromIndex) {
        PageRespond respond = new PageRespond();
        ArrayList<AlarmSearchRespond> searchRespondList = new ArrayList<AlarmSearchRespond>();
        HashMap<String, FaceRepository> groupMap = new HashMap<String, FaceRepository>();
        FaceSearchRequest faceSearchRequest = new FaceSearchRequest();
        faceSearchRequest.setSearchCount(request.getPageSize());
        faceSearchRequest.setChannelCodes(request.getChannelCodeList());
        faceSearchRequest.setStartTime(LocalDateTime.parse(request.getStartTime(), DateTimeFormatter.ofPattern("yyyyMMddHHmmss")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        faceSearchRequest.setEndTime(LocalDateTime.parse(request.getEndTime(), DateTimeFormatter.ofPattern("yyyyMMddHHmmss")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        faceSearchRequest.setStartIndex(fromIndex);
        faceSearchRequest.setSortType("1");
        faceSearchRequest.setWithBackGroud(Integer.valueOf(0));
        ArrayList<Integer> eventType = new ArrayList<Integer>();
        if ("REPEAT_VISITOR".equals(request.getAlarmTypeList().get(0))) {
            eventType.add(1);
            eventType.add(2);
        } else if ("ALARM_FACE_MASK".equals(request.getAlarmTypeList().get(0))) {
            eventType.add(4);
        }
        faceSearchRequest.setEventType(eventType);
        ParamBean paramBean = new ParamBean();
        paramBean.setRequestBody((Object)faceSearchRequest);
        paramBean.setVcmInfo(vcmReqBaseInfo);
        FaceSearchRespond faceSearchRespond = this.pictureSearchNVR800Service.faceSearch(paramBean);
        respond.setTotal(faceSearchRespond.getTotalCount());
        if (!CollectionUtils.isEmpty((Collection)faceSearchRespond.getFaceInfos())) {
            FaceRepositorySearchRespond faceRepositorySearchRespond = this.faceRepositoryServiceNvr800.searchAll(vcmReqBaseInfo, new FaceRepositoryRequest());
            for (FaceRepository repository : faceRepositorySearchRespond.getRepositories()) {
                groupMap.put(repository.getGroupId(), repository);
            }
            for (FaceSearchRespond.FaceInfo faceInfo : faceSearchRespond.getFaceInfos()) {
                AlarmSearchRespond searchRespond = new AlarmSearchRespond();
                HisFaceBean faceBean = new HisFaceBean();
                faceBean.setHair(String.valueOf(faceInfo.getHair()));
                faceBean.setAge(faceInfo.getAge());
                faceBean.setMouthMask(Nvr800Utils.getMouthMaskType((int)faceInfo.getMouthMask()));
                faceBean.setHat(String.valueOf(faceInfo.getHat()));
                faceBean.setGlassType(String.valueOf(faceInfo.getGlassType()));
                faceBean.setGenderCode(String.valueOf(faceInfo.getGender()));
                faceBean.setMouthMask(Nvr800Utils.getMouthMaskType((int)faceInfo.getMouthMask()));
                faceBean.setSimilarityDegree(faceInfo.getSimilarity());
                faceBean.setLeftTopX(faceInfo.getLeftTopX());
                faceBean.setLeftTopY(faceInfo.getLeftTopY());
                faceBean.setRightBtmX(faceInfo.getRightBtmX());
                faceBean.setRightBtmY(faceInfo.getRightBtmY());
                ArrayList<DetectObjectBean> faceDetectObject = new ArrayList<DetectObjectBean>();
                DetectObjectBean detectObject = ReflectionUtils.getDetectObject((Object)faceBean);
                faceDetectObject.add(detectObject);
                faceBean.setDetectObject(faceDetectObject);
                faceBean.setAppearCount(faceInfo.getAppearCount());
                People people = this.getPeopleInfo(vcmReqBaseInfo, faceInfo.getPersonId());
                faceBean.setTargetName(people.getName());
                faceBean.setTargetId(faceInfo.getPersonId());
                FaceRepository faceRepository = groupMap.getOrDefault(people.getGroupId(), new FaceRepository());
                faceBean.setGroupName(faceRepository.getName());
                faceBean.setGroupType(faceRepository.getType());
                faceBean.setGroupImageId(people.getDevicePeopleId());
                searchRespond.setTime(this.formatFaceDateTime(faceInfo.getEndTime()));
                searchRespond.setChannelCode(faceInfo.getChannelCode());
                searchRespond.setCode((String)request.getAlarmTypeList().get(0));
                searchRespond.setFaceBean(faceBean);
                searchRespond.setSnapshotFileId(faceInfo.getFileId());
                searchRespond.setPanoramaFileId(faceInfo.getFileId());
                searchRespond.setType(EventTypeEnum.ALARM);
                searchRespond.setName(EventNameHelper.getEventName((String)searchRespond.getCode()));
                searchRespond.setId(UUID.randomUUID().toString());
                searchRespond.setMsgId(searchRespond.getId());
                searchRespond.setAlarmInName(faceInfo.getChannelCode());
                searchRespond.setAlarmLevel(AlarmLevelEnum.IMPORTANT);
                searchRespond.setDomainCode(request.getDomainCode());
                searchRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_FACE.toString());
                searchRespondList.add(searchRespond);
            }
        }
        respond.setData(searchRespondList);
        respond.setPageSize(searchRespondList.size());
        respond.setPageSize(request.getPageSize());
        respond.setPage(request.getPage());
        return respond;
    }

    private String formatFaceDateTime(String datetimeStr) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        return dtf2.format(dtf.parse(datetimeStr));
    }

    private People getPeopleInfo(VcmReqBaseInfo vcmInfo, String personId) {
        if (StringUtils.isBlank((CharSequence)personId) || "-1".equals(personId)) {
            return new People();
        }
        FaceRequest request = new FaceRequest();
        request.getPersonIdList().add(personId);
        try {
            PeopleSearchRespond respond = this.faceRepositoryNvr800V2Service.searchPeople(vcmInfo, request);
            if (!CollectionUtils.isEmpty((Collection)respond.getPeopleList())) {
                return (People)respond.getPeopleList().get(0);
            }
        }
        catch (Exception e) {
            LOGGER.error("NVR 800 get history alarm person detail error", (Throwable)e);
        }
        return new People();
    }

    private PageRespond<AlarmSearchRespond> getSnapObjectAlarm(AlarmSearchRequest request, VcmReqBaseInfo vcmReqBaseInfo, int fromIndex, int type) {
        PageRespond respond = new PageRespond();
        ArrayList<AlarmSearchRespond> searchRespondList = new ArrayList<AlarmSearchRespond>();
        SnapObjectRequest snapObjectRequest = new SnapObjectRequest();
        snapObjectRequest.setStartTime(LocalDateTime.parse(request.getStartTime(), DateTimeFormatter.ofPattern("yyyyMMddHHmmss")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        snapObjectRequest.setEndTime(LocalDateTime.parse(request.getEndTime(), DateTimeFormatter.ofPattern("yyyyMMddHHmmss")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        snapObjectRequest.setStartIndex(fromIndex);
        snapObjectRequest.setCount(request.getPageSize());
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        typeList.add(type);
        snapObjectRequest.setTypes(typeList);
        PageRespond snapObjectRespondPageRespond = this.pictureSearchNVR800Service.getSnapObject(vcmReqBaseInfo, snapObjectRequest);
        List snapObjectRespondList = snapObjectRespondPageRespond.getData();
        respond.setTotal(snapObjectRespondPageRespond.getTotal());
        respond.setPage(request.getPage());
        respond.setPageSize(request.getPageSize());
        if (!CollectionUtils.isEmpty((Collection)snapObjectRespondList)) {
            for (SnapObjectRespond snapObjectRespond : snapObjectRespondList) {
                DetectObjectBean detectObject;
                AlarmSearchRespond searchRespond = new AlarmSearchRespond();
                searchRespond.setDomainCode(request.getDomainCode());
                searchRespond.setChannelCode(snapObjectRespond.getChannelCode());
                searchRespond.setTime(this.formatFaceDateTime(snapObjectRespond.getStartTime()));
                searchRespond.setId(UUID.randomUUID().toString());
                searchRespond.setCode((String)request.getAlarmTypeList().get(0));
                searchRespond.setDomainCode(request.getDomainCode());
                searchRespond.setAlarmLevel(AlarmLevelEnum.IMPORTANT);
                searchRespond.setType(EventTypeEnum.ALARM);
                searchRespond.setMsgId(searchRespond.getId());
                searchRespond.setAlarmInName(searchRespond.getChannelCode());
                if (snapObjectRespond.getType() == 1) {
                    HisFaceBean faceBean = new HisFaceBean();
                    faceBean.setLeftTopX(snapObjectRespond.getLeftTopX());
                    faceBean.setLeftTopY(snapObjectRespond.getLeftTopY());
                    faceBean.setRightBtmY(snapObjectRespond.getRightBtmY());
                    faceBean.setRightBtmX(snapObjectRespond.getRightBtmX());
                    ArrayList<DetectObjectBean> faceDetectObject = new ArrayList<DetectObjectBean>();
                    detectObject = ReflectionUtils.getDetectObject((Object)faceBean);
                    faceDetectObject.add(detectObject);
                    faceBean.setDetectObject(faceDetectObject);
                    searchRespond.setPanoramaFileId(snapObjectRespond.getImageId() + "#PERSON");
                    searchRespond.setSnapshotFileId(snapObjectRespond.getImageId() + "#PERSON");
                    searchRespond.setFaceBean(faceBean);
                    searchRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_FACE.toString());
                } else if (snapObjectRespond.getType() == 2 || snapObjectRespond.getType() == 7) {
                    HisVehicleBean vehicleBean = new HisVehicleBean();
                    vehicleBean.setAlarmMatch(2);
                    vehicleBean.setLeftTopY(snapObjectRespond.getLeftTopY());
                    vehicleBean.setLeftTopX(snapObjectRespond.getLeftTopX());
                    vehicleBean.setRightBtmX(snapObjectRespond.getRightBtmX());
                    vehicleBean.setRightBtmY(snapObjectRespond.getRightBtmY());
                    ArrayList<DetectObjectBean> vehicleDetectObject = new ArrayList<DetectObjectBean>();
                    detectObject = ReflectionUtils.getDetectObject((Object)vehicleBean);
                    vehicleDetectObject.add(detectObject);
                    vehicleBean.setDetectObject(vehicleDetectObject);
                    vehicleBean.setPlateNo(snapObjectRespond.getPlateNo());
                    vehicleBean.setVehicleClass(snapObjectRespond.getCarBrand());
                    vehicleBean.setVehicleBrand(snapObjectRespond.getCarSubBrand());
                    vehicleBean.setVehicleColor(snapObjectRespond.getCarColor());
                    searchRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_VEHICLE.toString());
                    searchRespond.setType(EventTypeEnum.ALARM);
                    searchRespond.setVehicleBean(vehicleBean);
                    searchRespond.setSnapshotFileId(snapObjectRespond.getImageId() + "#VEHICLEDETECTION");
                    searchRespond.setPanoramaFileId(snapObjectRespond.getImageId() + "#VEHICLEDETECTION");
                }
                searchRespondList.add(searchRespond);
            }
        }
        respond.setData(searchRespondList);
        return respond;
    }

    private PageRespond<AlarmSearchRespond> getOtherHistoryAlarm(AlarmSearchRequest request, VcmReqBaseInfo vcmReqBaseInfo, int fromIndex, int toIndex) {
        PageRespond respond = new PageRespond();
        ArrayList<AlarmSearchRespond> searchRespondList = new ArrayList<AlarmSearchRespond>();
        JSONArray alarmArray = this.getBehaviorAlarm(request, vcmReqBaseInfo);
        if (!CollectionUtils.isEmpty((Collection)alarmArray)) {
            respond.setTotal(alarmArray.size());
            if (alarmArray.size() < fromIndex) {
                alarmArray = new JSONArray();
            }
            if (toIndex > alarmArray.size()) {
                toIndex = alarmArray.size();
            }
            for (int i = fromIndex; i < toIndex; ++i) {
                AlarmSearchRespond searchRespond = new AlarmSearchRespond();
                JSONObject alarmObject = alarmArray.getJSONObject(i);
                searchRespond.setChannelCode(alarmObject.getString("channel"));
                searchRespond.setSnapshotFileId(alarmObject.getString("pic_info"));
                searchRespond.setPanoramaFileId(alarmObject.getString("pic_info"));
                searchRespond.setTime(this.formatBehaviorDateTime(alarmObject.getString("time")));
                searchRespond.setCode((String)request.getAlarmTypeList().get(0));
                searchRespond.setType(EventTypeEnum.ALARM);
                searchRespond.setName(EventNameHelper.getEventName((String)searchRespond.getCode()));
                searchRespond.setErrorCode(alarmObject.getString("record_type"));
                searchRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)searchRespond.getCode()));
                searchRespond.setId(UUID.randomUUID().toString());
                searchRespond.setAlarmInName(searchRespond.getChannelCode());
                searchRespond.setDomainCode(request.getDomainCode());
                searchRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
                if (AlarmCodeTypeEnum.ALARM_BEHAVIOR.toString().equals(searchRespond.getAlarmCodeType())) {
                    HisBehaviorBean behaviorBean = new HisBehaviorBean();
                    searchRespond.setBehaviorBean(behaviorBean);
                } else if (AlarmCodeTypeEnum.ALARM_VEHICLE.toString().equals(searchRespond.getAlarmCodeType())) {
                    HisVehicleBean vehicleBean = new HisVehicleBean();
                    searchRespond.setVehicleBean(vehicleBean);
                } else if (AlarmCodeTypeEnum.ALARM_SITUATION_ANALYSIS.toString().equals(searchRespond.getAlarmCodeType())) {
                    SituationAnalysisBean analysisBean = new SituationAnalysisBean();
                    searchRespond.setSituationAnalysisBean(analysisBean);
                } else if (AlarmCodeTypeEnum.ALARM_THIRD_ALGORITHM.toString().equals(searchRespond.getAlarmCodeType())) {
                    ThirdAlgorithmBean thirdAlgorithmBean = new ThirdAlgorithmBean();
                    ParamBean requestParamBean = new ParamBean();
                    PicturePlaybackRequest picture = new PicturePlaybackRequest();
                    picture.setPicInfoKey(searchRespond.getSnapshotFileId());
                    requestParamBean.setVcmInfo(vcmReqBaseInfo);
                    requestParamBean.setRequestBody((Object)picture);
                    JSONObject jsonObject = this.pictureSearchNVR800Service.picturePlaybackInfo(requestParamBean);
                    thirdAlgorithmBean.setThirdAlgorithmName(jsonObject.getString("thirdAlgorithmName"));
                    searchRespond.setThirdAlgorithmBean(thirdAlgorithmBean);
                } else {
                    GeneralBusinessBean generalBusinessBean = new GeneralBusinessBean();
                    searchRespond.setGeneralBusinessBean(generalBusinessBean);
                }
                searchRespondList.add(searchRespond);
            }
        }
        respond.setData(searchRespondList);
        respond.setPageSize(searchRespondList.size());
        respond.setPageSize(request.getPageSize());
        respond.setPage(request.getPage());
        return respond;
    }

    private String formatBehaviorDateTime(String datetimeStr) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
        DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        return dtf2.format(dtf.parse(datetimeStr));
    }

    private PageRespond<AlarmSearchRespond> getFaceHistoryAlarm(AlarmSearchRequest request, VcmReqBaseInfo vcmReqBaseInfo, int fromIndex) {
        JSONArray groupIdArray;
        FaceRepositorySearchRespond faceRepositorySearchRespond;
        PageRespond respond = new PageRespond();
        ArrayList<AlarmSearchRespond> searchRespondList = new ArrayList<AlarmSearchRespond>();
        HashMap<String, FaceRepository> groupMap = new HashMap<String, FaceRepository>();
        FaceSearchRequest faceSearchRequest = new FaceSearchRequest();
        faceSearchRequest.setSearchCount(request.getPageSize());
        faceSearchRequest.setChannelCodes(request.getChannelCodeList());
        faceSearchRequest.setStartTime(LocalDateTime.parse(request.getStartTime(), DateTimeFormatter.ofPattern("yyyyMMddHHmmss")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        faceSearchRequest.setEndTime(LocalDateTime.parse(request.getEndTime(), DateTimeFormatter.ofPattern("yyyyMMddHHmmss")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        faceSearchRequest.setStartIndex(fromIndex);
        faceSearchRequest.setSortType("1");
        if ("ALARM_FACE_RECOGNITION".equals(request.getAlarmTypeList().get(0))) {
            faceRepositorySearchRespond = this.faceRepositoryServiceNvr800.searchAll(vcmReqBaseInfo, new FaceRepositoryRequest());
            groupIdArray = new JSONArray();
            for (FaceRepository repository : faceRepositorySearchRespond.getRepositories()) {
                groupMap.put(repository.getGroupId(), repository);
                if ("\u964c\u751f\u4eba".equals(repository.getName()) || "Stranger".equalsIgnoreCase(repository.getName())) continue;
                groupIdArray.add((Object)Integer.valueOf(repository.getGroupId()));
            }
            faceSearchRequest.setGroupIds(groupIdArray);
        } else if ("ALARM_FACE_DETECTION".equals(request.getAlarmTypeList().get(0))) {
            faceRepositorySearchRespond = this.faceRepositoryServiceNvr800.searchAll(vcmReqBaseInfo, new FaceRepositoryRequest());
            groupIdArray = new JSONArray();
            for (FaceRepository repository : faceRepositorySearchRespond.getRepositories()) {
                groupMap.put(repository.getGroupId(), repository);
                if (!"\u964c\u751f\u4eba".equals(repository.getName()) && !"Stranger".equalsIgnoreCase(repository.getName())) continue;
                groupIdArray.add((Object)Integer.valueOf(repository.getGroupId()));
            }
            faceSearchRequest.setGroupIds(groupIdArray);
        }
        faceSearchRequest.setWithBackGroud(Integer.valueOf(0));
        ParamBean paramBean = new ParamBean();
        paramBean.setRequestBody((Object)faceSearchRequest);
        paramBean.setVcmInfo(vcmReqBaseInfo);
        FaceSearchRespond faceSearchRespond = this.pictureSearchNVR800Service.faceSearch(paramBean);
        respond.setTotal(faceSearchRespond.getTotalCount());
        if (!CollectionUtils.isEmpty((Collection)faceSearchRespond.getFaceInfos())) {
            for (FaceSearchRespond.FaceInfo faceInfo : faceSearchRespond.getFaceInfos()) {
                AlarmSearchRespond searchRespond = new AlarmSearchRespond();
                HisFaceBean faceBean = new HisFaceBean();
                faceBean.setHair(String.valueOf(faceInfo.getHair()));
                faceBean.setAge(faceInfo.getAge());
                faceBean.setMouthMask(Nvr800Utils.getMouthMaskType((int)faceInfo.getMouthMask()));
                faceBean.setHat(String.valueOf(faceInfo.getHat()));
                faceBean.setGlassType(String.valueOf(faceInfo.getGlassType()));
                faceBean.setGenderCode(String.valueOf(faceInfo.getGender()));
                faceBean.setMouthMask(Nvr800Utils.getMouthMaskType((int)faceInfo.getMouthMask()));
                faceBean.setSimilarityDegree(faceInfo.getSimilarity());
                faceBean.setLeftTopX(faceInfo.getLeftTopX());
                faceBean.setLeftTopY(faceInfo.getLeftTopY());
                faceBean.setRightBtmX(faceInfo.getRightBtmX());
                faceBean.setRightBtmY(faceInfo.getRightBtmY());
                ArrayList<DetectObjectBean> faceDetectObject = new ArrayList<DetectObjectBean>();
                DetectObjectBean detectObject = ReflectionUtils.getDetectObject((Object)faceBean);
                faceDetectObject.add(detectObject);
                faceBean.setDetectObject(faceDetectObject);
                People people = this.getPeopleInfo(vcmReqBaseInfo, faceInfo.getPersonId());
                faceBean.setTargetName(people.getName());
                faceBean.setTargetId(faceInfo.getPersonId());
                FaceRepository faceRepository = groupMap.getOrDefault(people.getGroupId(), new FaceRepository());
                faceBean.setGroupName(faceRepository.getName());
                faceBean.setGroupType(faceRepository.getType());
                faceBean.setGroupImageId(people.getDevicePeopleId());
                if ("ALARM_FACE_RECOGNITION".equals(request.getAlarmTypeList().get(0))) {
                    faceBean.setAlarmMatch(1);
                } else {
                    faceBean.setAlarmMatch(2);
                }
                searchRespond.setTime(this.formatFaceDateTime(faceInfo.getEndTime()));
                searchRespond.setChannelCode(faceInfo.getChannelCode());
                searchRespond.setCode((String)request.getAlarmTypeList().get(0));
                searchRespond.setFaceBean(faceBean);
                searchRespond.setSnapshotFileId(faceInfo.getFileId());
                searchRespond.setPanoramaFileId(faceInfo.getFileId());
                searchRespond.setType(EventTypeEnum.ALARM);
                searchRespond.setName(EventNameHelper.getEventName((String)searchRespond.getCode()));
                searchRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)searchRespond.getCode()));
                searchRespond.setId(UUID.randomUUID().toString());
                searchRespond.setMsgId(searchRespond.getId());
                searchRespond.setAlarmInName(faceInfo.getChannelCode());
                searchRespond.setAlarmLevel(AlarmLevelEnum.IMPORTANT);
                searchRespond.setDomainCode(request.getDomainCode());
                searchRespondList.add(searchRespond);
            }
        }
        respond.setData(searchRespondList);
        respond.setPageSize(searchRespondList.size());
        respond.setPageSize(request.getPageSize());
        respond.setPage(request.getPage());
        return respond;
    }

    public PageRespond<AlarmSearchRespond> searchHistory(ParamBean<AlarmSearchRequest> obj) {
        JSONArray alarmArray;
        AlarmSearchRequest request = (AlarmSearchRequest)obj.getRequestBody();
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        PageRespond respond = new PageRespond();
        ArrayList<AlarmSearchRespond> searchRespondList = new ArrayList<AlarmSearchRespond>();
        int fromIndex = request.getPage() == 0 ? 0 : request.getPage() * request.getPageSize() + 1;
        int toIndex = (request.getPage() + 1) * request.getPageSize();
        if ("0".equals(request.getType())) {
            FaceSearchRequest faceSearchRequest = new FaceSearchRequest();
            faceSearchRequest.setSearchCount(request.getPageSize());
            faceSearchRequest.setChannelCodes(request.getChannelCodeList());
            faceSearchRequest.setStartTime(LocalDateTime.parse(request.getStartTime(), DateTimeFormatter.ofPattern("yyyyMMddHHmmss")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            faceSearchRequest.setEndTime(LocalDateTime.parse(request.getEndTime(), DateTimeFormatter.ofPattern("yyyyMMddHHmmss")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            FaceRepositorySearchRespond faceRepositorySearchRespond = this.faceRepositoryServiceNvr800.searchAll(obj.getVcmInfo(), new FaceRepositoryRequest());
            JSONArray groupIdArray = new JSONArray();
            for (FaceRepository repository : faceRepositorySearchRespond.getRepositories()) {
                if ("\u964c\u751f\u4eba".equals(repository.getName()) || "Stranger".equalsIgnoreCase(repository.getName())) continue;
                groupIdArray.add((Object)Integer.valueOf(repository.getGroupId()));
            }
            faceSearchRequest.setGroupIds(groupIdArray);
            faceSearchRequest.setStartIndex(fromIndex);
            ParamBean paramBean = new ParamBean();
            paramBean.setRequestBody((Object)faceSearchRequest);
            paramBean.setVcmInfo(vcmReqBaseInfo);
            FaceSearchRespond faceSearchRespond = this.pictureSearchNVR800Service.faceSearch(paramBean);
            respond.setTotal(faceSearchRespond.getTotalCount());
            if (!CollectionUtils.isEmpty((Collection)faceSearchRespond.getFaceInfos())) {
                for (FaceSearchRespond.FaceInfo faceInfo : faceSearchRespond.getFaceInfos()) {
                    AlarmSearchRespond searchRespond = new AlarmSearchRespond();
                    HisFaceBean faceBean = new HisFaceBean();
                    faceBean.setHair(String.valueOf(faceInfo.getHair()));
                    faceBean.setAge(faceInfo.getAge());
                    faceBean.setMouthMask(String.valueOf(faceInfo.getMouthMask()));
                    faceBean.setHat(String.valueOf(faceInfo.getHat()));
                    faceBean.setGlassType(String.valueOf(faceInfo.getGlassType()));
                    faceBean.setGenderCode(String.valueOf(faceInfo.getGender()));
                    faceBean.setMouthMask(String.valueOf(faceInfo.getMouthMask()));
                    if (request.isNeedImage()) {
                        faceBean.setSnapshot(this.getFaceImage(vcmReqBaseInfo, faceInfo.getFileId()));
                    }
                    searchRespond.setTime(faceInfo.getEndTime());
                    searchRespond.setChannelCode(faceInfo.getChannelCode());
                    searchRespond.setCode("ALARM_FACE_RECOGNITION");
                    searchRespond.setFaceBean(faceBean);
                    searchRespond.setSnapshotFileId(faceInfo.getFileId());
                    searchRespond.setType(EventTypeEnum.ALARM);
                    searchRespond.setName(EventNameHelper.getEventName((String)searchRespond.getCode()));
                    searchRespondList.add(searchRespond);
                }
            }
        } else if ("2".equals(request.getType()) && !CollectionUtils.isEmpty((Collection)(alarmArray = this.getBehaviorAlarm(request, vcmReqBaseInfo)))) {
            int begin;
            respond.setTotal(alarmArray.size());
            if (alarmArray.size() < fromIndex) {
                alarmArray = new JSONArray();
            }
            if (toIndex > alarmArray.size()) {
                toIndex = alarmArray.size();
            }
            for (int i = begin = fromIndex <= 0 ? 0 : fromIndex - 1; i < toIndex; ++i) {
                AlarmSearchRespond searchRespond = new AlarmSearchRespond();
                JSONObject alarmObject = alarmArray.getJSONObject(i);
                searchRespond.setChannelCode(alarmObject.getString("channel"));
                HisBehaviorBean behaviorBean = new HisBehaviorBean();
                if (request.isNeedImage()) {
                    behaviorBean.setSnapshot(this.getBehaviorImage(vcmReqBaseInfo, alarmObject.getString("pic_info")));
                }
                searchRespond.setSnapshotFileId(alarmObject.getString("pic_info"));
                searchRespond.setTime(alarmObject.getString("time"));
                Map recordType = this.getAlarmCode(alarmObject.getInteger("record_type"));
                searchRespond.setCode((String)recordType.get("recordType"));
                searchRespond.setBehaviorBean(behaviorBean);
                searchRespond.setType(EventTypeEnum.ALARM);
                searchRespond.setName((String)recordType.get("typeName"));
                searchRespond.setErrorCode(alarmObject.getString("record_type"));
                searchRespondList.add(searchRespond);
            }
        }
        respond.setData(searchRespondList);
        respond.setPageSize(searchRespondList.size());
        respond.setPageSize(request.getPageSize());
        respond.setPage(request.getPage());
        return respond;
    }

    private String getFaceImage(VcmReqBaseInfo vcmReqBaseInfo, String fileId) {
        ParamBean obj = new ParamBean();
        FaceImageSearchRequest request = new FaceImageSearchRequest();
        ArrayList<String> fileIdList = new ArrayList<String>();
        fileIdList.add(fileId);
        request.setFileIds(fileIdList);
        obj.setRequestBody((Object)request);
        obj.setVcmInfo(vcmReqBaseInfo);
        try {
            FaceSearchRespond respond = this.pictureSearchNVR800Service.faceImageSearch(obj);
            return ((FaceSearchRespond.FaceInfo)respond.getFaceInfos().get(0)).getFaceImage();
        }
        catch (Exception e) {
            LOGGER.error("get face image error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            return "";
        }
    }

    private String getBehaviorImage(VcmReqBaseInfo vcmReqBaseInfo, String fileId) {
        ParamBean requestParamBean = new ParamBean();
        PicturePlaybackRequest request = new PicturePlaybackRequest();
        request.setPicInfoKey(fileId);
        requestParamBean.setVcmInfo(vcmReqBaseInfo);
        requestParamBean.setRequestBody((Object)request);
        String image = "";
        try {
            PicturePlaybackRespond respond = this.pictureSearchNVR800Service.picturePlayback(requestParamBean);
            image = respond.getPicture().getImage();
        }
        catch (Exception e) {
            LOGGER.error("get behavior image error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
        }
        return StringUtils.isNotEmpty((CharSequence)image) ? image : "";
    }

    private JSONArray getBehaviorAlarm(AlarmSearchRequest request, VcmReqBaseInfo vcmReqBaseInfo) {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM/dd/yyyy");
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        LocalDateTime startDatetime = LocalDateTime.parse(request.getStartTime(), DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        LocalDateTime endDatetime = LocalDateTime.parse(request.getEndTime(), DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        JSONObject paramObject = new JSONObject();
        paramObject.put("channel", (Object)request.getChannelCodeList());
        paramObject.put("start_date", (Object)startDatetime.format(dateFormatter));
        paramObject.put("end_date", (Object)endDatetime.format(dateFormatter));
        paramObject.put("start_time", (Object)startDatetime.format(timeFormatter));
        paramObject.put("end_time", (Object)endDatetime.format(timeFormatter));
        paramObject.put("record_type", (Object)this.getRecordType(request.getAlarmTypeList()));
        paramObject.put("pic_sort", (Object)0);
        JSONObject dataObject = new JSONObject();
        dataObject.put("data", (Object)paramObject);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.PICTURE_PLAY_BACK_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkRespond((BaseRespondNvr800)rsp);
            return rsp.getData().getJSONArray("all_pic_info");
        }
        catch (SDKException e) {
            LOGGER.error("NVR 800 search history alarm error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private long getRecordType(List<String> alarmTypeList) {
        StringBuilder type = new StringBuilder();
        type.append(alarmTypeList.contains("ALARM_CAR_DETECTION") ? "1" : "0");
        type.append(alarmTypeList.contains("ALARM_PERSON_LEAVE_DETECT") ? "1" : "0");
        type.append(alarmTypeList.contains("ALARM_ELE_BICYCLE") ? "1" : "0");
        type.append(alarmTypeList.contains("ALARM_OBJECT_REMOVAL") ? "1" : "0");
        type.append(alarmTypeList.contains("ALARM_OBJECT_ABANDONED") ? "1" : "0");
        type.append("0");
        type.append(alarmTypeList.contains("ALARM_VE_ILLEGAL_PARKING") ? "1" : "0");
        type.append(alarmTypeList.contains("ALARM_THIRD_ALGORITHM") ? "1" : "0");
        type.append("0");
        type.append(alarmTypeList.contains("ALARM_CROWD_DENSITY_DETECT") ? "1" : "0");
        type.append(alarmTypeList.contains("ALARM_SHIELD") ? "1" : "0");
        type.append(alarmTypeList.contains("ALARM_QUEUE_DETECT") ? "1" : "0");
        type.append("0");
        type.append(alarmTypeList.contains("ALARM_Sound") ? "1" : "0");
        type.append("0");
        type.append(alarmTypeList.contains("ALARM_OBJECT_WANDER") ? "1" : "0");
        type.append(alarmTypeList.contains("ALARM_FASTMOVE") ? "1" : "0");
        type.append(alarmTypeList.contains("ALARM_EXIT") ? "1" : "0");
        type.append(alarmTypeList.contains("ALARM_ENTER") ? "1" : "0");
        type.append(alarmTypeList.contains("ALARM_HUMAN_COUNT") ? "1" : "0");
        type.append("0");
        type.append(alarmTypeList.contains("ALARM_INTRUSION") || alarmTypeList.contains("ALARM_BEHAVIOR_ANALYSIS_INVASION") ? "1" : "0");
        type.append("0000");
        type.append(alarmTypeList.contains("ALARM_TRIP_LINE") ? "1" : "0");
        type.append(alarmTypeList.contains("ALARM_TYPE_DI") ? "1" : "0");
        type.append(alarmTypeList.contains("ALARM_TYPE_MOVE_DECTION") ? "1" : "0");
        type.append("00");
        LOGGER.info("NVR 800 record type:{}", (Object)type);
        return Integer.parseInt(type.toString(), 2);
    }

    private Map<String, String> getAlarmCode(Integer recordType) {
        HashMap<String, String> typeMap = new HashMap<String, String>();
        String binary = Integer.toBinaryString(recordType);
        binary = String.format("%32s", binary).replaceAll(" ", "0");
        StringBuilder tempRecordType = new StringBuilder();
        StringBuilder type = new StringBuilder(binary).reverse();
        StringBuilder typeName = new StringBuilder();
        if (type.charAt(2) == '1') {
            tempRecordType.append("ALARM_TYPE_MOVE_DECTION").append(",");
            typeName.append(EventNameHelper.getEventName((String)"ALARM_TYPE_MOVE_DECTION")).append(",");
        }
        if (type.charAt(3) == '1') {
            tempRecordType.append("ALARM_TYPE_DI").append(",");
            typeName.append(EventNameHelper.getEventName((String)"ALARM_TYPE_DI")).append(",");
        }
        if (type.charAt(4) == '1') {
            tempRecordType.append("ALARM_TRIP_LINE").append(",");
            typeName.append(EventNameHelper.getEventName((String)"ALARM_TRIP_LINE")).append(",");
        }
        if (type.charAt(9) == '1') {
            tempRecordType.append("ALARM_INTRUSION").append(",");
            typeName.append(EventNameHelper.getEventName((String)"ALARM_INTRUSION")).append(",");
        }
        if (type.charAt(11) == '1') {
            tempRecordType.append("ALARM_HUMAN_COUNT").append(",");
            typeName.append(EventNameHelper.getEventName((String)"ALARM_HUMAN_COUNT")).append(",");
        }
        if (type.charAt(12) == '1') {
            tempRecordType.append("ALARM_ENTER").append(",");
            typeName.append(EventNameHelper.getEventName((String)"ALARM_ENTER")).append(",");
        }
        if (type.charAt(13) == '1') {
            tempRecordType.append("ALARM_EXIT").append(",");
            typeName.append(EventNameHelper.getEventName((String)"ALARM_EXIT")).append(",");
        }
        if (type.charAt(14) == '1') {
            tempRecordType.append("ALARM_FASTMOVE").append(",");
            typeName.append(EventNameHelper.getEventName((String)"ALARM_FASTMOVE")).append(",");
        }
        if (type.charAt(15) == '1') {
            tempRecordType.append("ALARM_OBJECT_WANDER").append(",");
            typeName.append(EventNameHelper.getEventName((String)"ALARM_OBJECT_WANDER")).append(",");
        }
        if (type.charAt(19) == '1') {
            tempRecordType.append("ALARM_QUEUE_DETECT").append(",");
            typeName.append(EventNameHelper.getEventName((String)"ALARM_QUEUE_DETECT")).append(",");
        }
        if (type.charAt(21) == '1') {
            tempRecordType.append("ALARM_CROWD_DENSITY_DETECT").append(",");
            typeName.append(EventNameHelper.getEventName((String)"ALARM_CROWD_DENSITY_DETECT")).append(",");
        }
        if (type.charAt(22) == '1') {
            tempRecordType.append("ALARM_FACE_MASK").append(",");
            typeName.append(EventNameHelper.getEventName((String)"ALARM_FACE_MASK")).append(",");
        }
        if (type.charAt(23) == '1') {
            tempRecordType.append("ALARM_THIRD_ALGORITHM").append(",");
            typeName.append(EventNameHelper.getEventName((String)"ALARM_THIRD_ALGORITHM")).append(",");
        }
        if (type.charAt(24) == '1') {
            tempRecordType.append("ALARM_VE_ILLEGAL_PARKING").append(",");
            typeName.append(EventNameHelper.getEventName((String)"ALARM_VE_ILLEGAL_PARKING")).append(",");
        }
        if (type.charAt(25) == '1') {
            tempRecordType.append("REPEAT_VISITOR").append(",");
            typeName.append(EventNameHelper.getEventName((String)"REPEAT_VISITOR")).append(",");
        }
        if (type.charAt(26) == '1') {
            tempRecordType.append("ALARM_OBJECT_ABANDONED").append(",");
            typeName.append(EventNameHelper.getEventName((String)"ALARM_OBJECT_ABANDONED")).append(",");
        }
        if (type.charAt(28) == '1') {
            tempRecordType.append("ALARM_ELE_BICYCLE").append(",");
            typeName.append(EventNameHelper.getEventName((String)"ALARM_ELE_BICYCLE")).append(",");
        }
        typeMap.put("recordType", StringUtils.isNotEmpty((CharSequence)tempRecordType) ? tempRecordType.substring(0, tempRecordType.length() - 1) : "");
        typeMap.put("typeName", StringUtils.isNotEmpty((CharSequence)typeName) ? typeName.substring(0, typeName.length() - 1) : "");
        return typeMap;
    }

    public boolean alarmCancel(ParamBean<AlarmDealRequest> obj) {
        AlarmDealRequest req = (AlarmDealRequest)obj.getRequestBody();
        JSONObject paramObject = new JSONObject();
        JSONObject channelObject = new JSONObject();
        channelObject.put("glabal_id", (Object)req.getGlobalId());
        channelObject.put("alarm_type", (Object)Integer.parseInt(req.getAlarmType()));
        channelObject.put("alarm_cancel_mode", (Object)req.getAlarmCancelMode());
        channelObject.put("alarm_silent_time", (Object)req.getAlarmSilentTime());
        paramObject.put(req.getChannelCode(), (Object)channelObject);
        JSONObject chnObject = new JSONObject();
        chnObject.put("channel_info", (Object)paramObject);
        JSONObject dataObject = new JSONObject();
        dataObject.put("data", (Object)chnObject);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.ALARM_CANCEL_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("NVR 800 alarm Cancel error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E eTemplate, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(eTemplate);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

